/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.http.rest.worker;

import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.worker.AbstractWorker;
import de.elpro.ewms.core.worker.BackgroundWorkerDescriptor;
import de.elpro.ewms.core.worker.BackgroundWorkerGroup;
import de.elpro.ewms.server.Server;
import de.elpro.ewms.server.http.rest.auth.AuthenticatedRestService;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Secured
@Path(value="background_worker")
public class BackgroundWorkerRestService
extends AuthenticatedRestService {
    @GET
    @Path(value="/get_background_worker_groups")
    @Produces(value={"application/json"})
    public BackgroundWorkerGroup[] getBackgroundWorkerGroups() {
        return (BackgroundWorkerGroup[])Server.getWorkerGroups().toArray(BackgroundWorkerGroup[]::new);
    }

    @GET
    @Path(value="/get_background_workers/group_id={group_id}")
    @Produces(value={"application/json"})
    public BackgroundWorkerDescriptor[] getBackgroundWorkersByGroupId(@PathParam(value="group_id") String groupId) {
        return (BackgroundWorkerDescriptor[])Server.getWorkers((String)groupId).stream().map(aw -> new BackgroundWorkerDescriptor(aw)).toArray(BackgroundWorkerDescriptor[]::new);
    }

    @POST
    @Path(value="/get_background_workers")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public BackgroundWorkerDescriptor[] getBackgroundWorkersByIds(String[] ids) {
        BackgroundWorkerDescriptor[] workers = new BackgroundWorkerDescriptor[ids.length];
        int i = 0;
        while (i < ids.length) {
            AbstractWorker worker = Server.getWorker((String)ids[i]);
            workers[i] = worker != null ? new BackgroundWorkerDescriptor(worker) : null;
            ++i;
        }
        return workers;
    }

    @GET
    @Path(value="/background_worker/start_async/id={id}")
    @Produces(value={"application/json"})
    public OperationResult startAsync(@PathParam(value="id") String id) {
        if (!this.getUser().isAdmin()) {
            return OperationResult.ACCESS_DENIED;
        }
        AbstractWorker worker = Server.getWorker((String)id);
        if (worker == null) {
            return new OperationResult(ResultType.ExpectedError, String.format("Worker with id %s not found", id));
        }
        worker.startAsync();
        return OperationResult.SUCCESS;
    }

    @GET
    @Path(value="/background_worker/stop_async/id={id}")
    @Produces(value={"application/json"})
    public OperationResult stopAsync(@PathParam(value="id") String id) {
        if (!this.getUser().isAdmin()) {
            return OperationResult.ACCESS_DENIED;
        }
        AbstractWorker worker = Server.getWorker((String)id);
        if (worker == null) {
            return new OperationResult(ResultType.ExpectedError, String.format("Worker with id %s not found", id));
        }
        worker.stopAsync();
        return OperationResult.SUCCESS;
    }

    @GET
    @Path(value="/background_worker/pause/id={id}")
    @Produces(value={"application/json"})
    public OperationResult pause(@PathParam(value="id") String id) {
        if (!this.getUser().isAdmin()) {
            return OperationResult.ACCESS_DENIED;
        }
        AbstractWorker worker = Server.getWorker((String)id);
        if (worker == null) {
            return new OperationResult(ResultType.ExpectedError, String.format("Worker with id %s not found", id));
        }
        worker.pause();
        return OperationResult.SUCCESS;
    }

    @GET
    @Path(value="/background_worker/resume/id={id}")
    @Produces(value={"application/json"})
    public OperationResult resume(@PathParam(value="id") String id) {
        if (!this.getUser().isAdmin()) {
            return OperationResult.ACCESS_DENIED;
        }
        AbstractWorker worker = Server.getWorker((String)id);
        if (worker == null) {
            return new OperationResult(ResultType.ExpectedError, String.format("Worker with id %s not found", id));
        }
        worker.resume();
        return OperationResult.SUCCESS;
    }

    @GET
    @Path(value="/background_worker/restart_async/id={id}")
    @Produces(value={"application/json"})
    public OperationResult restart(@PathParam(value="id") String id) {
        if (!this.getUser().isAdmin()) {
            return OperationResult.ACCESS_DENIED;
        }
        AbstractWorker worker = Server.getWorker((String)id);
        if (worker == null) {
            return new OperationResult(ResultType.ExpectedError, String.format("Worker with id %s not found", id));
        }
        try {
            worker.restartAsync();
        }
        catch (Exception exc) {
            return new OperationResult(ResultType.UnexprectedError, exc.getMessage());
        }
        return OperationResult.SUCCESS;
    }

    @GET
    @Path(value="/background_worker/terminate/id={id}")
    @Produces(value={"application/json"})
    public OperationResult terminate(@PathParam(value="id") String id) {
        if (!this.getUser().isAdmin()) {
            return OperationResult.ACCESS_DENIED;
        }
        AbstractWorker worker = Server.getWorker((String)id);
        if (worker == null) {
            return new OperationResult(ResultType.ExpectedError, String.format("Worker with id %s not found", id));
        }
        worker.terminate();
        return OperationResult.SUCCESS;
    }
}

