/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.http;

import de.elpro.ewms.server.Server;
import de.elpro.ewms.server.model.AbstractConfiguration;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class Configuration
extends AbstractConfiguration {
    private boolean enable = true;
    private boolean secure = true;
    private Integer port;
    private String keystoreFile;
    private String keystorePassword;
    private Map<String, String> files = new LinkedHashMap<String, String>();

    Configuration() throws AbstractConfiguration.PreferenceDefinitionException {
        super("http-server.cfg", Configuration.class.getResource("/config/http-server.cfg"));
        String secureStr;
        String enableStr = this.prefNode.getProperty("http.enable", "true");
        if (enableStr != null && enableStr.toLowerCase().equals("false")) {
            this.enable = false;
        }
        if ((secureStr = this.prefNode.getProperty("http.secure", "true")) != null && secureStr.toLowerCase().equals("false")) {
            this.secure = false;
        }
        String restPortStr = this.prefNode.getProperty("http.port", null);
        try {
            if (restPortStr != null && !restPortStr.trim().isEmpty()) {
                this.port = Integer.parseInt(restPortStr);
            }
        }
        catch (Exception exception) {}
        this.keystoreFile = this.prefNode.getProperty("http.keystore_file");
        if (this.keystoreFile == null || this.keystoreFile.trim().isEmpty()) {
            this.keystoreFile = Server.getWorkspaceLocation().append("keystore").append("http-server.jks").makeAbsolute().toString();
        }
        this.keystorePassword = this.prefNode.getProperty("http.keystore_password", "frdHa6ps");
        Enumeration<?> names = this.prefNode.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (!name.startsWith("http.file.")) continue;
            String handlerPath = name.substring("http.file.".length());
            String filePath = this.prefNode.getProperty(name);
            if (filePath == null || filePath.isBlank()) continue;
            this.files.put(handlerPath, filePath.trim());
        }
    }

    public boolean isEnabled() {
        return this.enable;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getKeystoreFile() {
        return this.keystoreFile;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public Set<String> getFileHandlers() {
        return this.files.keySet();
    }

    public String getDocRoot(String fileHandler) {
        return this.files.get(fileHandler);
    }
}

