/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.http.component;

import de.elpro.ewms.server.http.Configuration;
import de.elpro.ewms.server.http.EosHttpServerExceptionMapper;
import de.elpro.ewms.server.http.EosHttpServerResourceConfig;
import de.elpro.ewms.server.http.IEosHttpServerComponent;
import de.elpro.ewms.server.model.IServerComponent;
import de.elpro.ewms.server.model.ServerComponentInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URI;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.Date;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.fx.core.ServiceUtils;
import org.eclipse.fx.core.log.Log;
import org.eclipse.fx.core.log.Logger;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.NetworkListener;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.ssl.SSLContextConfigurator;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.server.ResourceConfig;
import org.osgi.service.component.annotations.Component;

@Component
public class EosHttpServerComponent
implements IServerComponent {
    private static final int CORES_COUNT = Math.max(Runtime.getRuntime().availableProcessors(), 1);
    @Log
    @Inject
    private Logger logger;
    @Inject
    private IEclipseContext workbenchContext;
    private HttpServer restServer;

    public ServerComponentInfo getInfo() {
        return new ServerComponentInfo("com.eos.server.http", "1.0.0");
    }

    public boolean start() throws Exception {
        Configuration config = (Configuration)((Object)ContextInjectionFactory.make(Configuration.class, (IEclipseContext)this.workbenchContext));
        IEclipseContext httpContext = this.workbenchContext.createChild("de.elpro.ewms.server.http.server");
        httpContext.set(Configuration.class, (Object)config);
        if (!config.isEnabled()) {
            return false;
        }
        int port = config.getPort() != null ? config.getPort() : (config.isSecure() ? 443 : 80);
        URI uri = new URI(null, null, "0.0.0.0", port, null, null, null);
        try {
            EosHttpServerResourceConfig resourceConfig = new EosHttpServerResourceConfig();
            resourceConfig.register(EosHttpServerExceptionMapper.class, 1);
            if (config.isSecure()) {
                Serializable keyPair;
                File keyStoreFile = new File(config.getKeystoreFile());
                String keyStorePassword = config.getKeystorePassword();
                if (keyStorePassword == null || keyStorePassword.trim().isEmpty()) {
                    throw new Exception("KeyStore password cannot be empty");
                }
                if (!keyStoreFile.exists()) {
                    keyStoreFile.getParentFile().mkdirs();
                    this.logger.info("Server KeyStore was not found and will be created.");
                    String hostName = InetAddress.getLocalHost().getCanonicalHostName();
                    KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "BC");
                    keyPairGenerator.initialize(2048, new SecureRandom());
                    keyPair = keyPairGenerator.generateKeyPair();
                    X509Certificate selfSignedCertificate = this.generateSelfSignedCertificate((KeyPair)keyPair, String.format("EOS Http Server (%s)", hostName));
                    KeyStore ks = KeyStore.getInstance("JKS");
                    ks.load(null, null);
                    ks.setKeyEntry("eos.server", ((KeyPair)keyPair).getPrivate(), keyStorePassword.toCharArray(), new X509Certificate[]{selfSignedCertificate});
                    ks.setCertificateEntry(hostName, selfSignedCertificate);
                    Throwable throwable = null;
                    Object var14_18 = null;
                    try (FileOutputStream os = new FileOutputStream(keyStoreFile);){
                        ks.store(os, keyStorePassword.toCharArray());
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    this.logger.info("KeyStore with default self signed certificate stored at: " + keyStoreFile.getAbsolutePath());
                }
                this.logger.debug(String.format("REST Server using %s keystore file", config.getKeystoreFile()));
                SSLContextConfigurator sslCon = new SSLContextConfigurator(true);
                sslCon.setKeyStoreFile(keyStoreFile.toString());
                sslCon.setKeyPass(keyStorePassword);
                KeyStore keyStore = KeyStore.getInstance("JKS");
                keyPair = null;
                Object var11_13 = null;
                try (FileInputStream is = new FileInputStream(keyStoreFile);){
                    keyStore.load(is, keyStorePassword.toCharArray());
                }
                catch (Throwable throwable) {
                    if (keyPair == null) {
                        keyPair = throwable;
                    } else if (keyPair != throwable) {
                        ((Throwable)keyPair).addSuppressed(throwable);
                    }
                    throw keyPair;
                }
                SSLEngineConfigurator sslEngineConfigurator = new SSLEngineConfigurator(sslCon);
                sslEngineConfigurator.setClientMode(false);
                sslEngineConfigurator.setNeedClientAuth(false);
                sslEngineConfigurator.setEnabledProtocols(new String[]{"TLSv1.2"});
                this.restServer = GrizzlyHttpServerFactory.createHttpServer((URI)uri, (ResourceConfig)resourceConfig, (boolean)true, (SSLEngineConfigurator)sslEngineConfigurator, (boolean)false);
            } else {
                this.restServer = GrizzlyHttpServerFactory.createHttpServer((URI)uri, (ResourceConfig)resourceConfig, (boolean)false, null, (boolean)false);
            }
            this.restServer.getServerConfiguration().setName("EOS Http Server");
            for (IEosHttpServerComponent httpComponent : ServiceUtils.getServiceList(IEosHttpServerComponent.class)) {
                ContextInjectionFactory.inject((Object)httpComponent, (IEclipseContext)httpContext);
                httpComponent.install(this.restServer);
            }
            for (NetworkListener listener : this.restServer.getListeners()) {
                TCPNIOTransport transport = listener.getTransport();
                ThreadPoolConfig threadPoolConfig = ThreadPoolConfig.defaultConfig().setPoolName("rest-worker-thread-").setCorePoolSize(CORES_COUNT).setMaxPoolSize(CORES_COUNT * 2).setQueueLimit(-1).setKeepAliveTime(30L, TimeUnit.SECONDS);
                transport.setWorkerThreadPoolConfig(threadPoolConfig);
            }
            this.restServer.start();
            for (NetworkListener listener : this.restServer.getListeners()) {
                listener.getSslEngineConfig();
                this.logger.info(String.format("Use URL [%s:%d/rest/application.wadl] to check wsdl definition", listener.getHost(), listener.getPort()));
            }
            return true;
        }
        catch (Exception e) {
            this.logger.error("Error starting Http Server", (Throwable)e);
            return false;
        }
    }

    private X509Certificate generateSelfSignedCertificate(KeyPair keyPair, String caName) throws Exception {
        X500Name dnName = new X500Name(String.format("CN=%s", caName));
        JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(dnName, BigInteger.valueOf(System.currentTimeMillis()), new Date(), Date.from(Instant.now().plusSeconds(946080000L)), dnName, keyPair.getPublic());
        LinkedList<GeneralName> dnsNames = new LinkedList<GeneralName>();
        dnsNames.add(new GeneralName(2, "localhost"));
        dnsNames.add(new GeneralName(2, "127.0.0.1"));
        dnsNames.add(new GeneralName(2, InetAddress.getLocalHost().getHostAddress()));
        dnsNames.add(new GeneralName(2, InetAddress.getLocalHost().getHostName()));
        if (!InetAddress.getLocalHost().getHostName().equals(InetAddress.getLocalHost().getCanonicalHostName())) {
            dnsNames.add(new GeneralName(2, InetAddress.getLocalHost().getCanonicalHostName()));
        }
        DERSequence subjectAlternativeNames = new DERSequence(dnsNames.toArray(new ASN1Encodable[0]));
        builder.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)subjectAlternativeNames);
        JcaX509ExtensionUtils extUtils = new JcaX509ExtensionUtils();
        builder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)extUtils.createSubjectKeyIdentifier(keyPair.getPublic()));
        ContentSigner signer = new JcaContentSignerBuilder("SHA512WithRSAEncryption").setProvider("BC").build(keyPair.getPrivate());
        return new JcaX509CertificateConverter().setProvider("BC").getCertificate(builder.build(signer));
    }

    public void stop() {
        if (this.restServer != null) {
            this.restServer.shutdown();
        }
    }
}

