/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.jni;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Locale;
import java.util.Objects;
import jnr.ffi.LibraryLoader;
import jnr.ffi.Runtime;

public class Library<T> {
    public static final String LIB_EXTRACT_DIR_PROP = "nativelib.extract.dir";
    public static final boolean ARCH_64;
    public static final boolean ARM_64;
    public static final boolean LINUX;
    public static final boolean OSX;
    public static final boolean WINDOWS;
    static final String EXTRACT_DIR;
    final T lib;
    final Runtime runtime;

    static {
        EXTRACT_DIR = System.getProperty(LIB_EXTRACT_DIR_PROP, System.getProperty("java.io.tmpdir"));
        String arch = System.getProperty("os.arch");
        ARCH_64 = "x64".equals(arch) || "amd64".equals(arch) || "x86_64".equals(arch);
        ARM_64 = "aarch64".equals(arch);
        String os = System.getProperty("os.name");
        LINUX = os.toLowerCase(Locale.ENGLISH).startsWith("linux");
        OSX = os.startsWith("Mac OS X");
        WINDOWS = os.startsWith("Windows");
    }

    public static String withPlatform(String name) {
        String suffix;
        if (ARCH_64 && LINUX) {
            suffix = "-linux-x86_64.so";
        } else if (ARCH_64 && OSX) {
            suffix = "-osx-x86_64.dylib";
        } else if (ARCH_64 && WINDOWS) {
            suffix = "-windows-x86_64.dll";
        } else if (ARM_64 && LINUX) {
            suffix = "-linux-aarch64.so";
        } else {
            return name;
        }
        if (name.endsWith(suffix)) {
            return name;
        }
        if (name.lastIndexOf(46) > name.lastIndexOf(47)) {
            return String.valueOf(name.substring(0, name.lastIndexOf(46) - 1)) + suffix;
        }
        return String.valueOf(name) + suffix;
    }

    public Library(URL url, Class<T> nativeInterface, boolean extract) throws IOException {
        String libToLoad = extract ? Library.extract(url) : url.toExternalForm();
        this.lib = LibraryLoader.create(nativeInterface).load(libToLoad);
        this.runtime = Runtime.getRuntime(this.lib);
    }

    public T getNativeLibrary() {
        return this.lib;
    }

    public Runtime getRuntime() {
        return this.runtime;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String extract(URL url) throws IOException {
        String fileName = url.getFile();
        String name = fileName.substring(fileName.lastIndexOf(47) + 1);
        try {
            File dir = new File(EXTRACT_DIR);
            if (!dir.exists() || !dir.isDirectory()) {
                throw new IllegalStateException("Invalid extraction directory " + dir);
            }
            File file = File.createTempFile(name, "", dir);
            file.deleteOnExit();
            boolean isLocalFile = new File(url.getFile()).exists();
            Throwable throwable = null;
            Object var7_9 = null;
            try {
                InputStream in = isLocalFile ? new FileInputStream(new File(url.getFile())) : url.openStream();
                try {
                    try (OutputStream out = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
                        int bytes;
                        Objects.requireNonNull(in, "Classpath resource not found");
                        byte[] buffer = new byte[4096];
                        while (-1 != (bytes = in.read(buffer))) {
                            out.write(buffer, 0, bytes);
                        }
                    }
                    if (in == null) return file.getAbsolutePath();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (in == null) throw throwable;
                    in.close();
                    throw throwable;
                }
                in.close();
                return file.getAbsolutePath();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new IOException("Failed to extract " + name, e);
        }
    }
}

