/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.jni.cache;

import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.core.variable.value.IVarValuesCollection;
import de.elpro.ewms.server.cache.JavaVarValuesCache;
import de.elpro.ewms.server.jni.cache.NativeVarValuesCacheFactory;
import de.elpro.ewms.server.rasterizedvalues.IVarValuesCache;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedList;
import jnr.ffi.Pointer;

public class NativeVarValuesCache
implements IVarValuesCache {
    private static final boolean DEBUG = false;
    private final Pointer pointer;
    private final NativeVarValuesCacheFactory.EosServerCacheLib lib;
    private final Raster raster;
    private boolean alive = true;
    private final JavaVarValuesCache javaCache;

    NativeVarValuesCache(NativeVarValuesCacheFactory.EosServerCacheLib lib, Raster raster, boolean useCompression) {
        this.lib = lib;
        this.raster = raster;
        this.pointer = lib.create_eos_values_cache(raster.toMilli(), useCompression);
        this.javaCache = null;
    }

    public Raster getRaster() {
        return this.raster;
    }

    public void push(VariableInstance instance, String key, IVarValuesCollection collection) {
        if (this.javaCache != null) {
            this.javaCache.push(instance, key, collection);
        }
        NativeVarValuesCacheFactory.ByteBuffer buffer = null;
        try {
            byte[] varValuesData = collection.toByteArray();
            buffer = this.lib.push_eos_values(this.pointer, instance.getId(), key, varValuesData, varValuesData.length);
            byte errorCode = buffer.getErrorCode();
            if (errorCode > 0) {
                byte[] responseData = buffer.getData();
                NativeVarValuesCache.handleRustException(errorCode, responseData);
            }
        }
        catch (Throwable throwable) {
            if (buffer != null) {
                this.lib.free_byte_buffer(buffer);
            }
            throw throwable;
        }
        if (buffer != null) {
            this.lib.free_byte_buffer(buffer);
        }
    }

    public void resetValues(VariableInstance instance, String key, long newEndTs) {
        this.lib.reset_values(this.pointer, instance.getId(), key, newEndTs);
    }

    public IVarValuesCollection get(VariableInstance instance, String key, long fromTs, long toTs) {
        NativeVarValuesCacheFactory.ByteBuffer buffer = null;
        try {
            buffer = this.lib.get_eos_values(this.pointer, instance.getId(), key, fromTs, toTs);
            byte errorCode = buffer.getErrorCode();
            byte[] responseData = buffer.getData();
            NativeVarValuesCache.handleRustException(errorCode, responseData);
            IVarValuesCollection collection = IVarValuesCollection.create((byte[])responseData);
            if (this.javaCache != null) {
                IVarValue[] nativeArray = collection.toArray();
                IVarValue[] javaArray = this.javaCache.get(instance, key, fromTs, toTs).toArray();
                int i = 0;
                while (i < nativeArray.length) {
                    if (!nativeArray[i].equals(javaArray[i])) {
                        IVarValue nativeVal = nativeArray[i];
                        IVarValue javaVal = javaArray[i];
                        throw new RuntimeException(String.format("Not equal values at pos %d. %s != %s", i, nativeVal, javaVal));
                    }
                    ++i;
                }
            }
            IVarValuesCollection iVarValuesCollection = collection;
            if (buffer != null) {
                this.lib.free_byte_buffer(buffer);
            }
            return iVarValuesCollection;
        }
        catch (Throwable throwable) {
            if (buffer != null) {
                this.lib.free_byte_buffer(buffer);
            }
            throw throwable;
        }
    }

    public long getLastValueTs() {
        return this.lib.get_last_value_ts(this.pointer);
    }

    public Collection<String> getKeys(VariableInstance instance) {
        NativeVarValuesCacheFactory.ByteBuffer buffer = null;
        try {
            LinkedList<String> result = new LinkedList<String>();
            buffer = this.lib.get_keys(this.pointer, instance.getId());
            byte errorCode = buffer.getErrorCode();
            byte[] responseData = buffer.getData();
            NativeVarValuesCache.handleRustException(errorCode, responseData);
            byte[] data = buffer.getData();
            ByteBuffer dataReader = ByteBuffer.wrap(data);
            while (dataReader.hasRemaining()) {
                int len = dataReader.getInt();
                byte[] strBuff = new byte[len];
                dataReader.get(strBuff);
                String str = new String(strBuff, StandardCharsets.UTF_8);
                result.add(str);
            }
            LinkedList<String> linkedList = result;
            if (buffer != null) {
                this.lib.free_byte_buffer(buffer);
            }
            return linkedList;
        }
        catch (Throwable throwable) {
            if (buffer != null) {
                this.lib.free_byte_buffer(buffer);
            }
            throw throwable;
        }
    }

    public void clearCache() {
        this.lib.clear_cache(this.pointer);
    }

    public void clearCacheForInstance(VariableInstance instance) {
        this.lib.clear_cache_for_instance(this.pointer, instance.getId());
    }

    public void clearCacheToTimestamp(long toTimestamp) {
        this.lib.clear_cache_to_timestamp(this.pointer, toTimestamp);
    }

    public void clearCacheFromTimestamp(long toTimestamp) {
        this.lib.clear_cache_from_timestamp(this.pointer, toTimestamp);
    }

    public long getRAMSize() {
        return this.lib.get_ram_size(this.pointer);
    }

    public long getHDDSize() {
        return 0L;
    }

    public void destroy() {
        if (this.alive) {
            this.lib.destroy_eos_values_cache(this.pointer);
            this.alive = false;
        }
    }

    protected void finalize() throws Throwable {
        this.destroy();
    }

    private static void handleRustException(int errorCode, byte[] data) throws RuntimeException {
        if (errorCode == 0) {
            return;
        }
        ByteBuffer dataReader = ByteBuffer.wrap(data);
        int len = dataReader.getInt();
        byte[] strBuff = new byte[len];
        dataReader.get(strBuff);
        String str = new String(strBuff, StandardCharsets.UTF_8);
        throw new RuntimeException(str);
    }
}

