/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.jni.cache;

import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.server.jni.Library;
import de.elpro.ewms.server.jni.cache.NativeVarValuesCache;
import de.elpro.ewms.server.rasterizedvalues.IVarValuesCacheFactory;
import java.io.IOException;
import java.net.URL;
import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import jnr.ffi.Struct;
import jnr.ffi.annotations.LongLong;
import org.osgi.service.component.annotations.Component;

@Component
public class NativeVarValuesCacheFactory
implements IVarValuesCacheFactory<NativeVarValuesCache> {
    public static final String ID = "com.eos.server.cache.rust.factory";
    private final EosServerCacheLib lib;
    private final boolean useCompression;

    static {
        System.setProperty("jnr.ffi.asm.enabled", "false");
    }

    public NativeVarValuesCacheFactory() throws IOException {
        this(true, NativeVarValuesCacheFactory.class.getResource(Library.withPlatform("/libs/com_eos_server_cache")));
    }

    public String getId() {
        return ID;
    }

    public NativeVarValuesCacheFactory(boolean useCompression, URL url) throws IOException {
        this.useCompression = useCompression;
        Library<EosServerCacheLib> lib = new Library<EosServerCacheLib>(url, EosServerCacheLib.class, true);
        this.lib = lib.getNativeLibrary();
    }

    public NativeVarValuesCache create(Raster raster) {
        return new NativeVarValuesCache(this.lib, raster, this.useCompression);
    }

    public static final class ByteBuffer
    extends Struct {
        public final Struct.Unsigned32 f0_me_len = new Struct.Unsigned32((Struct)this);
        public final Struct.Pointer f1_me_byte_data = new Struct.Pointer((Struct)this);
        public final Struct.Unsigned8 f2_me_error_code = new Struct.Unsigned8((Struct)this);

        public ByteBuffer(Runtime runtime) {
            super(runtime);
        }

        public byte getErrorCode() {
            return this.f2_me_error_code.byteValue();
        }

        public byte[] getData() {
            byte[] data = new byte[this.f0_me_len.intValue()];
            this.f1_me_byte_data.get().get(0L, data, 0, data.length);
            return data;
        }
    }

    static interface EosServerCacheLib {
        public Pointer create_eos_values_cache(long var1, boolean var3);

        public void destroy_eos_values_cache(Pointer var1);

        public ByteBuffer push_eos_values(Pointer var1, int var2, String var3, byte[] var4, int var5);

        public void reset_values(Pointer var1, int var2, String var3, @LongLong long var4);

        @LongLong
        public long get_last_value_ts(Pointer var1);

        public void clear_cache(Pointer var1);

        public void clear_cache_for_instance(Pointer var1, int var2);

        public void clear_cache_to_timestamp(Pointer var1, @LongLong long var2);

        public void clear_cache_from_timestamp(Pointer var1, @LongLong long var2);

        public ByteBuffer get_keys(Pointer var1, int var2);

        public ByteBuffer get_eos_values(Pointer var1, int var2, String var3, @LongLong long var4, @LongLong long var6);

        @LongLong
        public long get_ram_size(Pointer var1);

        public void free_byte_buffer(ByteBuffer var1);
    }
}

