/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.opcua;

import de.elpro.ewms.server.model.AbstractConfiguration;

public class Configuration
extends AbstractConfiguration {
    private boolean enable = this.getBoolProperty("opcua.server.enable", false);
    private String serverName = this.prefNode.getProperty("opcua.server.name");
    private int tcpPort = this.getIntProperty("opcua.server.tcp_port", 12686);
    private int httpsPort = this.getIntProperty("opcua.server.https_port", 8443);
    private boolean disableNoneSecurityPolicy = this.getBoolProperty("opcua.server.security_disable_none", false);
    private boolean allowAnonymousAuth = this.getBoolProperty("opcua.server.auth_allow_anonymous", true);
    private String authUser = this.getStringProperty("opcua.server.auth_user");
    private String authPassword = this.getStringProperty("opcua.server.auth_password", "");

    public Configuration() throws AbstractConfiguration.PreferenceDefinitionException {
        super("opcua-server.cfg", Configuration.class.getResource("/config/opcua-server.cfg"));
    }

    public boolean isEnabled() {
        return this.enable;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getTcpPort() {
        return this.tcpPort;
    }

    public int getHttpsPort() {
        return this.httpsPort;
    }

    public boolean isDisableNoneSecurityPolicy() {
        return this.disableNoneSecurityPolicy;
    }

    public boolean isAllowAnonymousAuth() {
        return this.allowAnonymousAuth;
    }

    public String getAuthUser() {
        return this.authUser;
    }

    public String getAuthPassword() {
        return this.authPassword;
    }
}

