/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.opcua;

import com.google.common.collect.Lists;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.units.DisplayUnitFormat;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.core.variable.value.IVarValuesCollection;
import de.elpro.ewms.core.variable.value.Plausibility;
import de.elpro.ewms.core.variable.value.ValueSource;
import de.elpro.ewms.server.Server;
import de.elpro.ewms.server.rasterizedvalues.RasterizedValues;
import java.sql.Date;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import org.eclipse.fx.core.log.Log;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.milo.opcua.sdk.core.AccessLevel;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.core.nodes.Node;
import org.eclipse.milo.opcua.sdk.server.Lifecycle;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.api.DataItem;
import org.eclipse.milo.opcua.sdk.server.api.ManagedNamespaceWithLifecycle;
import org.eclipse.milo.opcua.sdk.server.api.MonitoredItem;
import org.eclipse.milo.opcua.sdk.server.api.ServiceOperationContext;
import org.eclipse.milo.opcua.sdk.server.api.services.AttributeHistoryServices;
import org.eclipse.milo.opcua.sdk.server.api.services.AttributeServices;
import org.eclipse.milo.opcua.sdk.server.api.services.ViewServices;
import org.eclipse.milo.opcua.sdk.server.nodes.AttributeContext;
import org.eclipse.milo.opcua.sdk.server.nodes.UaFolderNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaVariableNode;
import org.eclipse.milo.opcua.sdk.server.util.SubscriptionModel;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryData;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadDetails;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadResult;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadValueId;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadRawModifiedDetails;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;
import org.eclipse.milo.opcua.stack.core.types.structured.ViewDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.WriteValue;

public class EosNamespace
extends ManagedNamespaceWithLifecycle {
    public static final String NAMESPACE_URI = "urn:com:eos";
    @Log
    @Inject
    private Logger logger;
    private final SubscriptionModel subscriptionModel;
    private final OpcUaServer server;
    private final Map<NodeId, VariableInstance> instanceNodes = new HashMap<NodeId, VariableInstance>();
    private final Set<AccessLevel> accessLevels = new HashSet<AccessLevel>();
    private final boolean historizing = true;

    public EosNamespace(OpcUaServer server) {
        super(server, NAMESPACE_URI);
        this.server = server;
        this.accessLevels.add(AccessLevel.CurrentRead);
        this.accessLevels.add(AccessLevel.HistoryRead);
        this.subscriptionModel = new SubscriptionModel(server, (AttributeServices)this);
        this.getLifecycleManager().addLifecycle((Lifecycle)this.subscriptionModel);
        this.getLifecycleManager().addStartupTask(this::createAndAddNodes);
    }

    public void createAndAddNodes() {
        try (EntityManager em = Server.getEntityManagerFactory().createEntityManager();){
            NodeId eosNodeId = this.newNodeId("EOS");
            UaFolderNode eosFolderNode = new UaFolderNode(this.getNodeContext(), eosNodeId, this.newQualifiedName("EOS"), LocalizedText.english((String)"EOS"));
            this.getNodeManager().addNode((Node)eosFolderNode);
            eosFolderNode.addReference(new Reference(eosFolderNode.getNodeId(), Identifiers.Organizes, Identifiers.ObjectsFolder.expanded(), false));
            HashMap<Integer, StructureObject> objects = new HashMap<Integer, StructureObject>();
            for (StructureObject object : em.createQuery("SELECT o FROM StructureObject o", StructureObject.class).getResultList()) {
                objects.put(object.getId(), object);
            }
            ArrayList<Variable> variables = new ArrayList<Variable>();
            variables.addAll(em.createQuery("SELECT o FROM Variable o", Variable.class).getResultList());
            this.addVariableOrientedNodes(eosFolderNode, objects, variables);
            this.addObjectOrientedNodes(eosFolderNode, objects);
        }
    }

    private void addVariableOrientedNodes(UaFolderNode rootNode, Map<Integer, StructureObject> objects, Collection<Variable> variables) {
        UaFolderNode varsFolder = new UaFolderNode(this.getNodeContext(), this.newNodeId("EOS/Variables"), this.newQualifiedName("Variables"), LocalizedText.english((String)"Variables"));
        this.getNodeManager().addNode((Node)varsFolder);
        rootNode.addOrganizes((UaNode)varsFolder);
        HashSet<AccessLevel> accessLevels = new HashSet<AccessLevel>();
        accessLevels.add(AccessLevel.CurrentRead);
        accessLevels.add(AccessLevel.HistoryRead);
        for (Variable var : variables) {
            String varIdentifier = var.getTextIdentifier();
            UaFolderNode varFolder = new UaFolderNode(this.getNodeContext(), this.newNodeId(varIdentifier), this.newQualifiedName(var.toString()), LocalizedText.english((String)var.toString()));
            this.getNodeManager().addNode((Node)varFolder);
            varsFolder.addOrganizes((UaNode)varFolder);
            for (VariableInstance instance : var.getInstances()) {
                UaVariableNode node = this.createVariableInstanceNode(instance, instance.getTextIdentifier(), instance.getStructureObject().toString());
                this.instanceNodes.put(node.getNodeId(), instance);
                this.getNodeManager().addNode((Node)node);
                varFolder.addOrganizes((UaNode)node);
            }
        }
    }

    private void addObjectOrientedNodes(UaFolderNode rootNode, Map<Integer, StructureObject> objects) {
        String rootPath = "EOS/Object Tree";
        UaFolderNode treeFolder = new UaFolderNode(this.getNodeContext(), this.newNodeId(rootPath), this.newQualifiedName("Object Tree"), LocalizedText.english((String)"Object Tree"));
        this.getNodeManager().addNode((Node)treeFolder);
        rootNode.addOrganizes((UaNode)treeFolder);
        LinkedList<StructureObject> nodesPool = new LinkedList<StructureObject>();
        HashSet<StructureObject> visitedNodes = new HashSet<StructureObject>();
        objects.values().stream().filter(o -> o.getParents().isEmpty()).forEach(o -> {
            boolean bl = nodesPool.add((StructureObject)o);
        });
        HashMap<StructureObject, UaFolderNode> parentFolders = new HashMap<StructureObject, UaFolderNode>();
        while (!nodesPool.isEmpty()) {
            StructureObject object = (StructureObject)nodesPool.removeFirst();
            UaFolderNode parentFolder = parentFolders.getOrDefault(object, treeFolder);
            String objectNodePath = String.format("%s/Objects/%s", rootPath, object.getTextIdentifier());
            UaFolderNode objectNode = new UaFolderNode(this.getNodeContext(), this.newNodeId(objectNodePath), this.newQualifiedName(object.toString()), LocalizedText.english((String)object.toString()));
            this.getNodeManager().addNode((Node)objectNode);
            parentFolder.addOrganizes((UaNode)objectNode);
            String objectVarsNodePath = String.format("%s/@Vars", objectNodePath);
            UaFolderNode objectVars = new UaFolderNode(this.getNodeContext(), this.newNodeId(objectVarsNodePath), this.newQualifiedName("@Vars"), LocalizedText.english((String)"@Vars"));
            this.getNodeManager().addNode((Node)objectVars);
            objectNode.addOrganizes((UaNode)objectVars);
            for (VariableInstance instance : object.getVariableInstances()) {
                String identifier = String.format("%s/%s", objectNodePath, instance.getVariable());
                UaVariableNode instanceNode = this.createVariableInstanceNode(instance, identifier, instance.getVariable().toString());
                this.instanceNodes.put(instanceNode.getNodeId(), instance);
                this.getNodeManager().addNode((Node)instanceNode);
                objectVars.addOrganizes((UaNode)instanceNode);
            }
            visitedNodes.add(object);
            for (StructureObject childObject : object.getChildren()) {
                if (visitedNodes.contains(childObject)) continue;
                nodesPool.add(childObject);
                parentFolders.put(childObject, objectNode);
            }
        }
    }

    private UaVariableNode createVariableInstanceNode(VariableInstance instance, String identifier, String displayName) {
        Variable var = instance.getVariable();
        String description = instance.getResultDescription();
        description = description != null ? String.format("%s (measuring unit: [%s])", description, var.getMeasuringUnit().getDisplayUnitText(DisplayUnitFormat.SIMPLE)) : String.format("measuring unit: [%s]", var.getMeasuringUnit().getDisplayUnitText(DisplayUnitFormat.SIMPLE));
        NodeId typeId = Identifiers.Double;
        Variant variant = new Variant((Object)Double.NaN);
        NodeId nodeId = this.newNodeId(identifier);
        UaVariableNode node = new UaVariableNode.UaVariableNodeBuilder(this.getNodeContext()).setNodeId(nodeId).setHistorizing(true).setAccessLevel(AccessLevel.toValue(this.accessLevels)).setUserAccessLevel(AccessLevel.toValue(this.accessLevels)).setBrowseName(this.newQualifiedName(displayName)).setDescription(LocalizedText.english((String)description)).setDisplayName(LocalizedText.english((String)displayName)).setDataType(typeId).setTypeDefinition(Identifiers.BaseDataVariableType).build();
        node.setValue(new DataValue(variant));
        return node;
    }

    public void read(AttributeServices.ReadContext context, Double maxAge, TimestampsToReturn timestamps, List<ReadValueId> readValueIds) {
        DateTime serverTime;
        ArrayList results = Lists.newArrayListWithCapacity((int)readValueIds.size());
        LinkedHashMap<ReadValueId, VariableInstance> rviInstances = new LinkedHashMap<ReadValueId, VariableInstance>();
        LinkedHashMap<VariableInstance, IVarValue> instanceValues = new LinkedHashMap<VariableInstance, IVarValue>();
        for (ReadValueId rvi : readValueIds) {
            VariableInstance instance = this.instanceNodes.get(rvi.getNodeId());
            if (instance == null || !AttributeId.Value.uid().equals((Object)rvi.getAttributeId())) continue;
            rviInstances.put(rvi, instance);
        }
        VariableInstance[] instances = (VariableInstance[])rviInstances.values().stream().distinct().toArray(VariableInstance[]::new);
        try {
            long valuesLoadStartTs = System.nanoTime();
            IVarValue[] lastValues = maxAge != null && Double.isFinite(maxAge) ? Server.getRawValuesViews().getRealtimeView().getLastValidValueSync(instances, maxAge.longValue()) : Server.getRawValuesViews().getRealtimeView().getCurrentValueSync(instances);
            serverTime = new DateTime();
            int i = 0;
            while (i < lastValues.length) {
                instanceValues.put(instances[i], lastValues[i]);
                ++i;
            }
            try {
                long valuesLoadEndTs = System.nanoTime();
                double valuesLoadTimeMs = (double)(valuesLoadEndTs - valuesLoadStartTs) / 1000000.0;
                if (valuesLoadTimeMs > 1000.0) {
                    String wrnMsg = String.format("Execution of getLastValidValues to load %d signals in %.2f ms. MaxAge is %s.", instances.length, valuesLoadTimeMs, maxAge != null ? "" + maxAge : "not set");
                    this.logger.warning(wrnMsg);
                }
            }
            catch (Exception exc) {
                this.logger.error("Error printing warrning", (Throwable)exc);
            }
        }
        catch (InterruptedException interruptedException) {
            serverTime = new DateTime();
        }
        for (ReadValueId readValueId : readValueIds) {
            UaNode node = (UaNode)this.getNodeManager().get(readValueId.getNodeId());
            if (node != null) {
                IVarValue lastValue = null;
                if (rviInstances.containsKey(readValueId)) {
                    lastValue = (IVarValue)instanceValues.get(rviInstances.get(readValueId));
                }
                if (lastValue != null) {
                    results.add(EosNamespace.convertVarValue(lastValue, timestamps, serverTime));
                    continue;
                }
                DataValue value = node.readAttribute(new AttributeContext((ServiceOperationContext)context), readValueId.getAttributeId(), timestamps, readValueId.getIndexRange(), readValueId.getDataEncoding());
                results.add(value);
                continue;
            }
            results.add(new DataValue(2150891520L));
        }
        context.success((Object)results);
    }

    public void historyRead(AttributeHistoryServices.HistoryReadContext context, HistoryReadDetails readDetails, TimestampsToReturn timestamps, List<HistoryReadValueId> readValueIds) {
        ArrayList results = Lists.newArrayListWithCapacity((int)readValueIds.size());
        try {
            if (readDetails.getTypeId().equalTo(Identifiers.ReadRawModifiedDetails)) {
                long endTime;
                long startTime;
                boolean inverseOrder;
                DateTime readEnd;
                ReadRawModifiedDetails readRawDetails = (ReadRawModifiedDetails)readDetails;
                if (readRawDetails.getStartTime().isNull() && readRawDetails.getEndTime().isNull()) {
                    readValueIds.forEach(rvi -> {
                        boolean bl = results.add(new HistoryReadResult(new StatusCode(2158690304L), null, null));
                    });
                    return;
                }
                Raster raster = Server.getRawValuesViews().getGlobalView().getRaster();
                RasterizedValues.ComputationBounds bounds = Server.getRawValuesViews().getGlobalView().getComputationBounds();
                long valuesStartTs = bounds.getValuesStartTs();
                long valuesEndTs = bounds.getValuesEndTs();
                DateTime readStart = readRawDetails.getStartTime().isNull() ? null : readRawDetails.getStartTime();
                DateTime dateTime = readEnd = readRawDetails.getEndTime().isNull() ? null : readRawDetails.getEndTime();
                if (readStart != null && readEnd != null && readStart.getJavaTime() > readEnd.getJavaTime()) {
                    readStart = readRawDetails.getEndTime();
                    readEnd = readRawDetails.getStartTime();
                    inverseOrder = true;
                } else {
                    inverseOrder = readRawDetails.getStartTime().isNull();
                }
                if (readRawDetails.getReturnBounds().booleanValue()) {
                    startTime = readStart != null ? raster.getRasterBegin(readStart.getJavaTime() - raster.toMilli()) : valuesStartTs;
                    endTime = readEnd != null ? raster.getRasterEnd(readEnd.getJavaTime()) : valuesEndTs;
                } else {
                    startTime = readStart != null ? raster.getRasterEnd(readStart.getJavaTime() - raster.toMilli()) : valuesStartTs;
                    endTime = readEnd != null ? raster.getRasterEnd(readEnd.getJavaTime() - raster.toMilli()) : valuesEndTs;
                }
                startTime = Math.max(valuesStartTs, startTime);
                endTime = Math.min(endTime, valuesEndTs);
                long totalValuesCount = (endTime - startTime) / raster.toMilli();
                if (totalValuesCount < 1L) {
                    readValueIds.forEach(rvi -> {
                        boolean bl = results.add(new HistoryReadResult(new StatusCode(0xA50000L), null, null));
                    });
                    context.success((Object)results);
                    return;
                }
                if (readRawDetails.getNumValuesPerNode().longValue() > 0L) {
                    long valuesPerNode = Math.min(readRawDetails.getNumValuesPerNode().longValue(), totalValuesCount);
                    if (inverseOrder) {
                        startTime = endTime - valuesPerNode * raster.toMilli();
                    } else {
                        endTime = startTime + valuesPerNode * raster.toMilli();
                    }
                }
                if (!readRawDetails.getIsReadModified().booleanValue()) {
                    LinkedHashMap rviInstances = new LinkedHashMap();
                    LinkedHashMap<VariableInstance, IVarValue[]> instanceValues = new LinkedHashMap<VariableInstance, IVarValue[]>();
                    readValueIds.stream().filter(rvi -> this.instanceNodes.containsKey(rvi.getNodeId())).forEach(rvi -> {
                        VariableInstance variableInstance = rviInstances.put(rvi, this.instanceNodes.get(rvi.getNodeId()));
                    });
                    VariableInstance[] instances = (VariableInstance[])rviInstances.values().stream().distinct().toArray(VariableInstance[]::new);
                    IVarValuesCollection[] allValues = Server.getRawValuesViews().getGlobalView().getValuesSync(instances, Instant.ofEpochMilli(startTime), Instant.ofEpochMilli(endTime));
                    int i = 0;
                    while (i < instances.length) {
                        instanceValues.put(instances[i], allValues[i].toArray());
                        ++i;
                    }
                    for (HistoryReadValueId readValueId : readValueIds) {
                        HistoryReadResult historyReadResult;
                        VariableInstance instance = (VariableInstance)rviInstances.get(readValueId);
                        if (instance == null) continue;
                        IVarValue[] vvValues = (IVarValue[])instanceValues.get(instance);
                        boolean noData = true;
                        IVarValue[] iVarValueArray = vvValues;
                        int n = vvValues.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IVarValue val = iVarValueArray[n2];
                            if (val.isValid()) {
                                noData = false;
                            }
                            ++n2;
                        }
                        if (noData) {
                            historyReadResult = new HistoryReadResult(new StatusCode(0xA50000L), null, null);
                        } else {
                            DataValue[] dvValues = this.convertHistoricalValues(readRawDetails, timestamps, inverseOrder, raster, valuesStartTs, valuesEndTs, vvValues);
                            HistoryData historyData = new HistoryData(dvValues);
                            historyReadResult = new HistoryReadResult(StatusCode.GOOD, null, ExtensionObject.encode((SerializationContext)this.server.getSerializationContext(), (UaStructure)historyData));
                        }
                        results.add(historyReadResult);
                    }
                }
            } else {
                this.logger.warning("Unsupported history read reaquest: " + readDetails.toString());
                results.clear();
                readValueIds.forEach(rvi -> {
                    boolean bl = results.add(new HistoryReadResult(new StatusCode(2154954752L), null, null));
                });
            }
            context.success((Object)results);
        }
        catch (Exception exc) {
            this.logger.error("Error reading historical data", (Throwable)exc);
            context.failure(0x80020000L);
        }
    }

    private static DataValue convertVarValue(IVarValue varValue, TimestampsToReturn timestamps, DateTime serverTime) {
        DateTime sourceTime = new DateTime(Date.from(Instant.ofEpochMilli(varValue.getEndTimestamp())));
        StatusCode status = varValue.isValid() ? (varValue.getQuality() >= 1.0 ? StatusCode.GOOD : StatusCode.UNCERTAIN) : (varValue.getPlausibility() == Plausibility.Missing && varValue.getValueSource() == ValueSource.NaN ? new StatusCode(2157641728L) : StatusCode.BAD);
        return switch (timestamps) {
            case TimestampsToReturn.Neither -> new DataValue(new Variant((Object)varValue.getValue()), status);
            case TimestampsToReturn.Source -> new DataValue(new Variant((Object)varValue.getValue()), status, sourceTime);
            case TimestampsToReturn.Server -> new DataValue(new Variant((Object)varValue.getValue()), status, serverTime);
            case TimestampsToReturn.Both -> new DataValue(new Variant((Object)varValue.getValue()), status, sourceTime, serverTime);
            default -> new DataValue(2150891520L);
        };
    }

    private DataValue[] convertHistoricalValues(ReadRawModifiedDetails readRawDetails, TimestampsToReturn timestamps, boolean inverseOrder, Raster raster, long valuesStartTs, long valuesEndTs, IVarValue[] vvValues) {
        long maxNumValues;
        ArrayList<DataValue> dvValues = new ArrayList<DataValue>();
        long l = maxNumValues = readRawDetails.getNumValuesPerNode().intValue() > 0 ? readRawDetails.getNumValuesPerNode().longValue() : Long.MAX_VALUE;
        if (!inverseOrder) {
            if (readRawDetails.getReturnBounds().booleanValue() && readRawDetails.getStartTime().getJavaTime() < valuesStartTs + raster.toMilli()) {
                dvValues.add(new DataValue(null, new StatusCode(2161573888L), readRawDetails.getStartTime()));
            }
            int i = 0;
            while (i < vvValues.length) {
                dvValues.add(EosNamespace.convertVarValue(vvValues[i], timestamps, null));
                if ((long)dvValues.size() >= maxNumValues) break;
                ++i;
            }
            if (readRawDetails.getReturnBounds().booleanValue() && (long)dvValues.size() < maxNumValues) {
                if (readRawDetails.getEndTime().isNull()) {
                    dvValues.add(new DataValue(null, new StatusCode(2161573888L), new DateTime(java.util.Date.from(Instant.ofEpochMilli(valuesEndTs + raster.toMilli())))));
                } else if (readRawDetails.getEndTime().getJavaTime() > valuesEndTs) {
                    dvValues.add(new DataValue(null, new StatusCode(2161573888L), readRawDetails.getEndTime()));
                }
            }
        } else {
            if (readRawDetails.getReturnBounds().booleanValue()) {
                if (!readRawDetails.getStartTime().isNull()) {
                    if (readRawDetails.getStartTime().getJavaTime() >= valuesEndTs) {
                        dvValues.add(new DataValue(null, new StatusCode(2161573888L), readRawDetails.getStartTime()));
                    }
                } else if (readRawDetails.getEndTime().getJavaTime() > valuesEndTs) {
                    dvValues.add(new DataValue(null, new StatusCode(2161573888L), readRawDetails.getEndTime()));
                }
            }
            int i = vvValues.length - 1;
            while (i >= 0) {
                dvValues.add(EosNamespace.convertVarValue(vvValues[i], TimestampsToReturn.Source, null));
                if ((long)dvValues.size() >= maxNumValues) break;
                --i;
            }
            if (readRawDetails.getReturnBounds().booleanValue() && (long)dvValues.size() < maxNumValues) {
                if (readRawDetails.getStartTime().isNull()) {
                    dvValues.add(new DataValue(null, new StatusCode(2161573888L), new DateTime(Date.from(Instant.ofEpochMilli(valuesStartTs)))));
                } else if (readRawDetails.getEndTime().getJavaTime() < valuesStartTs + raster.toMilli()) {
                    dvValues.add(new DataValue(null, new StatusCode(2161573888L), readRawDetails.getEndTime()));
                }
            }
        }
        return dvValues.toArray(new DataValue[0]);
    }

    public void write(AttributeServices.WriteContext context, List<WriteValue> writeValues) {
        ArrayList results = Lists.newArrayListWithCapacity((int)writeValues.size());
        for (WriteValue writeValue : writeValues) {
            UaNode node = (UaNode)this.getNodeManager().get(writeValue.getNodeId());
            if (node != null) {
                try {
                    node.writeAttribute(new AttributeContext((ServiceOperationContext)context), writeValue.getAttributeId(), writeValue.getValue(), writeValue.getIndexRange());
                    results.add(StatusCode.GOOD);
                    this.logger.info(String.format("Wrote value %s to %s attribute of %s", writeValue.getValue().getValue(), AttributeId.from((UInteger)writeValue.getAttributeId()).map(Object::toString).orElse("unknown"), node.getNodeId()));
                }
                catch (UaException e) {
                    this.logger.error(String.format("Unable to write value=%s", writeValue.getValue()), (Throwable)e);
                    results.add(e.getStatusCode());
                }
                continue;
            }
            results.add(new StatusCode(2150891520L));
        }
        context.success((Object)results);
    }

    public void onDataItemsCreated(List<DataItem> dataItems) {
        this.subscriptionModel.onDataItemsCreated(dataItems);
    }

    public void onDataItemsModified(List<DataItem> dataItems) {
        this.subscriptionModel.onDataItemsModified(dataItems);
    }

    public void onDataItemsDeleted(List<DataItem> dataItems) {
        this.subscriptionModel.onDataItemsDeleted(dataItems);
    }

    public void onMonitoringModeChanged(List<MonitoredItem> monitoredItems) {
        this.subscriptionModel.onMonitoringModeChanged(monitoredItems);
    }

    public void browse(ViewServices.BrowseContext context, ViewDescription viewDescription, NodeId nodeId) {
        if (this.getNodeManager().containsNode(nodeId)) {
            List references = this.getNodeManager().getReferences(nodeId);
            context.success((Object)references);
        } else {
            context.failure(2150891520L);
        }
    }

    public void getReferences(ViewServices.BrowseContext context, ViewDescription viewDescription, NodeId nodeId) {
        List references = this.getNodeManager().getReferences(nodeId);
        context.success((Object)references);
    }
}

