/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.opcua;

import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.inject.Inject;
import org.eclipse.fx.core.log.Log;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.milo.opcua.sdk.core.AccessLevel;
import org.eclipse.milo.opcua.sdk.core.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.nodes.AttributeContext;
import org.eclipse.milo.opcua.sdk.server.nodes.delegates.AttributeDelegate;
import org.eclipse.milo.opcua.sdk.server.nodes.delegates.DelegatingAttributeDelegate;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;

public class RestrictedAccessDelegate
extends DelegatingAttributeDelegate {
    private static final Set<AccessLevel> INTERNAL_ACCESS = AccessLevel.READ_WRITE;
    @Log
    @Inject
    private Logger logger;
    private final Function<Object, Set<AccessLevel>> accessLevelsFn;

    public RestrictedAccessDelegate(Function<Object, Set<AccessLevel>> accessLevelsFn) {
        this(null, accessLevelsFn);
    }

    public RestrictedAccessDelegate(AttributeDelegate parent, Function<Object, Set<AccessLevel>> accessLevelsFn) {
        super(parent);
        this.accessLevelsFn = accessLevelsFn;
    }

    public UByte getUserAccessLevel(AttributeContext context, VariableNode node) throws UaException {
        Optional<Object> identity = context.getSession().map(Session::getIdentityObject);
        Set<AccessLevel> accessLevels = identity.map(this.accessLevelsFn).orElse(INTERNAL_ACCESS);
        return AccessLevel.toValue(accessLevels);
    }
}

