/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.opcua.component;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.server.Server;
import de.elpro.ewms.server.model.IServerComponent;
import de.elpro.ewms.server.model.ServerComponentInfo;
import de.elpro.ewms.server.opcua.Configuration;
import de.elpro.ewms.server.opcua.EosNamespace;
import de.elpro.ewms.server.opcua.component.KeyStoreLoader;
import de.elpro.ewms.server.transactions.Modification;
import de.elpro.ewms.server.transactions.TransactionChangeset;
import java.io.File;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.fx.core.log.Log;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.api.config.OpcUaServerConfig;
import org.eclipse.milo.opcua.sdk.server.api.config.OpcUaServerConfigBuilder;
import org.eclipse.milo.opcua.sdk.server.identity.CompositeValidator;
import org.eclipse.milo.opcua.sdk.server.identity.IdentityValidator;
import org.eclipse.milo.opcua.sdk.server.identity.UsernameIdentityValidator;
import org.eclipse.milo.opcua.sdk.server.identity.X509IdentityValidator;
import org.eclipse.milo.opcua.sdk.server.util.HostnameUtil;
import org.eclipse.milo.opcua.stack.core.UaRuntimeException;
import org.eclipse.milo.opcua.stack.core.application.ServerDirectoryCertificateValidator;
import org.eclipse.milo.opcua.stack.core.security.CertificateManager;
import org.eclipse.milo.opcua.stack.core.security.DefaultCertificateManager;
import org.eclipse.milo.opcua.stack.core.security.SecurityPolicy;
import org.eclipse.milo.opcua.stack.core.transport.TransportProfile;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MessageSecurityMode;
import org.eclipse.milo.opcua.stack.core.types.structured.BuildInfo;
import org.eclipse.milo.opcua.stack.core.types.structured.UserTokenPolicy;
import org.eclipse.milo.opcua.stack.core.util.CertificateUtil;
import org.eclipse.milo.opcua.stack.core.util.validation.ValidationCheck;
import org.eclipse.milo.opcua.stack.server.EndpointConfiguration;
import org.eclipse.milo.opcua.stack.server.security.ServerCertificateValidator;
import org.osgi.service.component.annotations.Component;

@Component
public class EosOpcUAServerComponent
implements IServerComponent {
    @Log
    @Inject
    private Logger logger;
    @Inject
    private IEclipseContext context;
    private OpcUaServer server;
    private EosNamespace ns;
    private OpcUaServerConfigBuilder serverConfigBuilder;
    private Configuration config = new Configuration();

    public EosOpcUAServerComponent() throws Exception {
        if (!this.config.isEnabled()) {
            return;
        }
        TransactionChangeset.addPostCommitEventHandler(Object.class, (changes, properties) -> {
            for (Modification change : changes) {
                Object o = change.getObject();
                if (!(o instanceof Variable) && !(o instanceof VariableInstance) && !(o instanceof StructureObject) && !(o instanceof StructureClass)) continue;
                this.restartAsync();
                return;
            }
        });
    }

    public ServerComponentInfo getInfo() {
        return new ServerComponentInfo("com.eos.server.opcua", "1.0.0");
    }

    public boolean start() throws Exception {
        if (!this.config.isEnabled()) {
            return false;
        }
        File securityDir = Server.getWorkspaceLocation().append("security").toFile();
        if (!securityDir.exists() && !securityDir.mkdirs()) {
            throw new Exception("unable to create security dir: " + securityDir);
        }
        this.logger.info(String.format("Security dir: {%s}", securityDir.getAbsolutePath()));
        KeyStoreLoader loader = ((KeyStoreLoader)ContextInjectionFactory.make(KeyStoreLoader.class, (IEclipseContext)this.context)).load(securityDir);
        DefaultCertificateManager certificateManager = new DefaultCertificateManager(loader.getServerKeyPair(), loader.getServerCertificateChain());
        File pkiDir = securityDir.toPath().resolve("pki").toFile();
        ServerDirectoryCertificateValidator certificateValidator = new ServerDirectoryCertificateValidator(pkiDir, (Set<ValidationCheck>)ValidationCheck.NO_OPTIONAL_CHECKS);
        this.logger.info(String.format("pki dir: {%s}", pkiDir.getAbsolutePath()));
        String authUser = this.config.getAuthUser() != null && !this.config.getAuthUser().isEmpty() ? this.config.getAuthUser() : null;
        String authPassword = (String)Optional.of((Object)this.config.getAuthPassword()).or((Object)"");
        Predicate<UsernameIdentityValidator.AuthenticationChallenge> authChallenge = challenge -> {
            if (authUser != null) {
                return authUser.equals(challenge.getUsername()) && authPassword.equals(challenge.getPassword());
            }
            return false;
        };
        UsernameIdentityValidator identityValidator = new UsernameIdentityValidator(this.config.isAllowAnonymousAuth(), authChallenge);
        X509IdentityValidator x509IdentityValidator = new X509IdentityValidator(c -> true);
        X509Certificate certificate = (X509Certificate)certificateManager.getCertificates().stream().findFirst().orElseThrow(() -> new UaRuntimeException(0x80890000L, "no certificate found"));
        String applicationUri = CertificateUtil.getSanUri((X509Certificate)certificate).orElse("urn:com.eos:server:" + UUID.randomUUID());
        Set<EndpointConfiguration> endpointConfigurations = this.createEndpointConfigurations(certificate);
        this.serverConfigBuilder = OpcUaServerConfig.builder().setApplicationUri(applicationUri).setApplicationName(LocalizedText.english((String)"EOS OPC UA Server")).setEndpoints(endpointConfigurations).setBuildInfo(new BuildInfo("urn:com:eos:server", "Elpro GmbH", "EOS OPC UA Server", "0.6.8", "", DateTime.now())).setCertificateManager((CertificateManager)certificateManager).setCertificateValidator((ServerCertificateValidator)certificateValidator).setIdentityValidator((IdentityValidator)new CompositeValidator(new IdentityValidator[]{identityValidator, x509IdentityValidator})).setProductUri("urn:com:eos:server");
        this.createServer().get();
        return true;
    }

    private Set<EndpointConfiguration> createEndpointConfigurations(X509Certificate certificate) {
        LinkedHashSet<EndpointConfiguration> endpointConfigurations = new LinkedHashSet<EndpointConfiguration>();
        ArrayList bindAddresses = Lists.newArrayList();
        bindAddresses.add("0.0.0.0");
        LinkedHashSet<String> hostnames = new LinkedHashSet<String>();
        hostnames.add(HostnameUtil.getHostname());
        hostnames.addAll(HostnameUtil.getHostnames((String)"0.0.0.0"));
        for (String bindAddress : bindAddresses) {
            for (String hostname : hostnames) {
                EndpointConfiguration.Builder tcpBuilder = EndpointConfiguration.newBuilder().setBindAddress(bindAddress).setHostname(hostname).setPath("/" + this.config.getServerName()).setCertificate(certificate).addTokenPolicies(new UserTokenPolicy[]{OpcUaServerConfig.USER_TOKEN_POLICY_ANONYMOUS, OpcUaServerConfig.USER_TOKEN_POLICY_USERNAME, OpcUaServerConfig.USER_TOKEN_POLICY_X509});
                EndpointConfiguration.Builder noSecurityBuilder = tcpBuilder.copy().setSecurityPolicy(SecurityPolicy.None).setSecurityMode(MessageSecurityMode.None);
                if (!this.config.isDisableNoneSecurityPolicy()) {
                    endpointConfigurations.add(this.buildTcpEndpoint(noSecurityBuilder));
                }
                EnumSet<SecurityPolicy> securityPolicies = EnumSet.of(SecurityPolicy.Basic128Rsa15, SecurityPolicy.Basic256, SecurityPolicy.Basic256Sha256, SecurityPolicy.Aes128_Sha256_RsaOaep, SecurityPolicy.Aes256_Sha256_RsaPss);
                for (SecurityPolicy policy : securityPolicies) {
                    endpointConfigurations.add(this.buildTcpEndpoint(tcpBuilder.copy().setSecurityPolicy(policy).setSecurityMode(MessageSecurityMode.Sign)));
                    endpointConfigurations.add(this.buildTcpEndpoint(tcpBuilder.copy().setSecurityPolicy(policy).setSecurityMode(MessageSecurityMode.SignAndEncrypt)));
                }
                EndpointConfiguration.Builder discoveryBuilder = tcpBuilder.copy().setPath("/" + this.config.getServerName() + "/discovery").setSecurityPolicy(SecurityPolicy.None).setSecurityMode(MessageSecurityMode.None);
                endpointConfigurations.add(this.buildTcpEndpoint(discoveryBuilder));
            }
        }
        return endpointConfigurations;
    }

    private void restartAsync() {
        new Thread(() -> {
            EosOpcUAServerComponent eosOpcUAServerComponent = this;
            synchronized (eosOpcUAServerComponent) {
                try {
                    if (this.ns != null) {
                        this.ns.shutdown();
                    }
                    if (this.server != null) {
                        this.server.shutdown().get();
                    }
                    this.createServer().get();
                }
                catch (Exception exc) {
                    this.logger.error("Error restarting OpcUA Server", (Throwable)exc);
                }
            }
        }, "Restart OPC UA Server Thread").start();
    }

    private EndpointConfiguration buildTcpEndpoint(EndpointConfiguration.Builder base) {
        return base.copy().setTransportProfile(TransportProfile.TCP_UASC_UABINARY).setBindPort(this.config.getTcpPort()).build();
    }

    private EndpointConfiguration buildHttpsEndpoint(EndpointConfiguration.Builder base) {
        return base.copy().setTransportProfile(TransportProfile.HTTPS_UABINARY).setBindPort(this.config.getHttpsPort()).build();
    }

    public OpcUaServer getServer() {
        return this.server;
    }

    private synchronized CompletableFuture<OpcUaServer> createServer() {
        this.server = new OpcUaServer(this.serverConfigBuilder.build());
        this.ns = new EosNamespace(this.server);
        ContextInjectionFactory.inject((Object)((Object)this.ns), (IEclipseContext)this.context);
        this.ns.startup();
        return this.server.startup();
    }

    public synchronized void stop() {
        if (this.ns != null) {
            this.ns.shutdown();
        }
        if (this.server != null) {
            try {
                this.server.shutdown().get();
            }
            catch (Exception exc) {
                this.logger.error("Error shuting down OPC UA Server", (Throwable)exc);
            }
        }
    }
}

