/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.application;

import java.io.File;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Set;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.application.DirectoryCertificateValidator;
import org.eclipse.milo.opcua.stack.core.util.validation.CertificateValidationUtil;
import org.eclipse.milo.opcua.stack.core.util.validation.ValidationCheck;
import org.eclipse.milo.opcua.stack.server.security.ServerCertificateValidator;

public class ServerDirectoryCertificateValidator
extends DirectoryCertificateValidator
implements ServerCertificateValidator {
    public ServerDirectoryCertificateValidator(File baseDir, Set<ValidationCheck> validationChecks) throws IOException {
        super(baseDir, validationChecks);
    }

    public void validateCertificateChain(List<X509Certificate> certificateChain, String applicationUri) throws UaException {
        this.validateCertificateChain(certificateChain);
        X509Certificate certificate = certificateChain.get(0);
        CertificateValidationUtil.checkApplicationUri((X509Certificate)certificate, (String)applicationUri);
    }
}

