/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.osgi;

import de.elpro.ewms.server.Server;
import de.elpro.ewms.server.osgi.Activator;
import de.elpro.ewms.server.osgi.LoggerProviderImpl;
import de.elpro.ewms.server.osgi.restart.RestartPreferenceUtil;
import de.elpro.ewms.server.osgi.restart.RestartServiceImpl;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.core.services.log.ILoggerProvider;
import org.eclipse.e4.ui.internal.workbench.E4Workbench;
import org.eclipse.e4.ui.internal.workbench.ExceptionHandler;
import org.eclipse.e4.ui.internal.workbench.ReflectionContributionFactory;
import org.eclipse.e4.ui.workbench.IExceptionHandler;
import org.eclipse.e4.ui.workbench.lifecycle.PostContextCreate;
import org.eclipse.e4.ui.workbench.lifecycle.ProcessAdditions;
import org.eclipse.e4.ui.workbench.lifecycle.ProcessRemovals;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.ui.services.restart.RestartService;
import org.eclipse.osgi.service.datalocation.Location;

public class Application
implements IApplication {
    protected static final String EXIT_CODE = "e4.osgi.exit.code";
    private static final Logger logger = Activator.getLoggerFactory().createLogger(Application.class.getName());
    Object lcManager;
    Location instanceLocation;
    IEclipseContext workbenchContext;
    IApplicationContext applicationContext;
    Object returnValue;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object start(IApplicationContext context) throws Exception {
        this.applicationContext = context;
        this.returnValue = this.initE4Workbench(context);
        if (this.returnValue == null) {
            try {
                Server.start((IEclipseContext)this.workbenchContext);
            }
            catch (Exception exc) {
                logger.error("Error occured during server start", (Throwable)exc);
                this.returnValue = IApplication.EXIT_OK;
            }
        }
        while (true) {
            Application application = this;
            synchronized (application) {
                if (this.returnValue != null) {
                    Server.shutdown();
                    return this.returnValue;
                }
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                this.returnValue = IApplication.EXIT_OK;
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Application application = this;
        synchronized (application) {
            this.returnValue = IApplication.EXIT_OK;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart() {
        Application application = this;
        synchronized (application) {
            this.returnValue = IApplication.EXIT_RESTART;
        }
    }

    public Object initE4Workbench(IApplicationContext context) {
        this.workbenchContext = this.createApplicationContext();
        this.workbenchContext.set(IApplicationContext.class, (Object)context);
        this.workbenchContext.set(Application.class, (Object)this);
        return this.createE4Workbench(context, this.workbenchContext);
    }

    protected IEclipseContext createApplicationContext() {
        IEclipseContext serviceContext = E4Workbench.getServiceContext();
        IEclipseContext appContext = serviceContext.createChild("WorkbenchContext");
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        ExceptionHandler exceptionHandler = new ExceptionHandler();
        ReflectionContributionFactory contributionFactory = new ReflectionContributionFactory();
        appContext.set(IContributionFactory.class.getName(), (Object)contributionFactory);
        if (appContext.get(ILoggerProvider.class) == null) {
            serviceContext.set(ILoggerProvider.class, (Object)((ILoggerProvider)ContextInjectionFactory.make(LoggerProviderImpl.class, (IEclipseContext)serviceContext)));
        }
        appContext.set(Logger.class.getName(), (Object)((ILoggerProvider)serviceContext.get(ILoggerProvider.class)).getClassLogger(E4Workbench.class));
        appContext.set(IExceptionHandler.class.getName(), (Object)exceptionHandler);
        appContext.set(IExtensionRegistry.class.getName(), (Object)registry);
        appContext.set(IExtensionRegistry.class.getName(), (Object)registry);
        appContext.set(IContributionFactory.class.getName(), (Object)contributionFactory);
        return appContext;
    }

    protected static String[] getApplicationArguments(IApplicationContext applicationContext) {
        return (String[])applicationContext.getArguments().get("application.args");
    }

    public Object createE4Workbench(IApplicationContext applicationContext, IEclipseContext appContext) {
        ContextInjectionFactory.setDefault((IEclipseContext)appContext);
        appContext.set(IApplicationContext.class, (Object)applicationContext);
        IContributionFactory factory = (IContributionFactory)appContext.get(IContributionFactory.class.getName());
        this.preLifecycle(appContext);
        String lifeCycleURI = Application.getArgValue("lifeCycleURI", applicationContext, false);
        PostContextCreateResult rv = PostContextCreateResult.CONTINUE;
        if (lifeCycleURI != null) {
            this.lcManager = factory.create(lifeCycleURI, appContext);
            if (this.lcManager != null) {
                rv = this.invokePostContextCreate(appContext);
            }
        }
        switch (rv) {
            case RESTART_CLEAR_STATE: {
                RestartPreferenceUtil prefUtil = (RestartPreferenceUtil)ContextInjectionFactory.make(RestartPreferenceUtil.class, (IEclipseContext)appContext);
                prefUtil.setClearPersistedStateOnRestart(true);
            }
            case RESTART: {
                return IApplication.EXIT_RESTART;
            }
            case SHUTDOWN: {
                return IApplication.EXIT_OK;
            }
            case CONTINUE: {
                break;
            }
        }
        if (this.lcManager != null) {
            ContextInjectionFactory.invoke((Object)this.lcManager, ProcessAdditions.class, (IEclipseContext)appContext, null);
            ContextInjectionFactory.invoke((Object)this.lcManager, ProcessRemovals.class, (IEclipseContext)appContext, null);
        }
        appContext.set(RestartService.class, (Object)((RestartService)ContextInjectionFactory.make(RestartServiceImpl.class, (IEclipseContext)appContext)));
        return null;
    }

    protected void preLifecycle(IEclipseContext appContext) {
    }

    private static String getArgValue(String argName, IApplicationContext applicationContext, boolean singledCmdArgValue, IEclipseContext eclipseContext) {
        Object value = eclipseContext.get(argName);
        if (value != null) {
            return value.toString();
        }
        return Application.getArgValue(argName, applicationContext, singledCmdArgValue);
    }

    protected static String getArgValue(String argName, IApplicationContext applicationContext, boolean singledCmdArgValue) {
        if (argName == null || argName.length() == 0) {
            return null;
        }
        String[] args = Application.getApplicationArguments(applicationContext);
        if (singledCmdArgValue) {
            i = 0;
            while (i < args.length) {
                if (("-" + argName).equals(args[i])) {
                    return "true";
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < args.length) {
                if (("-" + argName).equals(args[i]) && i + 1 < args.length) {
                    return args[i + 1];
                }
                ++i;
            }
        }
        String brandingProperty = applicationContext.getBrandingProperty(argName);
        return brandingProperty == null ? System.getProperty(argName) : brandingProperty;
    }

    private PostContextCreateResult invokePostContextCreate(IEclipseContext appContext) {
        return (PostContextCreateResult)((Object)ContextInjectionFactory.invoke((Object)this.lcManager, PostContextCreate.class, (IEclipseContext)appContext, (Object)Boolean.TRUE));
    }

    static enum PostContextCreateResult {
        CONTINUE,
        SHUTDOWN,
        RESTART,
        RESTART_CLEAR_STATE;

    }
}

