/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.osgi;

import de.elpro.ewms.server.osgi.Application;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import javax.inject.Inject;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.workbench.lifecycle.PostContextCreate;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.operations.ProvisioningJob;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.Update;
import org.eclipse.equinox.p2.operations.UpdateOperation;
import org.eclipse.fx.core.log.Log;
import org.eclipse.fx.core.log.Logger;

public class Lifecycle {
    @Log
    @Inject
    private Logger logger;
    private static final String REPOSITORY_LOC = System.getProperty("updatehandler.repo", null);
    private static final boolean DEBUG = Boolean.valueOf(System.getProperty("com.eos.server.osgi.debug", "false"));
    private String updateName = null;
    private IProfile selfProfile;

    @PostContextCreate
    protected Application.PostContextCreateResult postContextCreate(IProvisioningAgent agent, IEclipseContext context, IExtensionRegistry extensionRegistry) throws IOException, InterruptedException {
        if (DEBUG) {
            this.logger.info("Server running in debug mode. Wait 10s before run update script. Add\r\n\t-Xdebug\r\n\t-Xrunjdwp:transport=dt_socket,server=y,suspend=n,address=8998\r\nto launcher.ini to allow remote java debuging at port 8998.");
            Thread.sleep(10000L);
        }
        Job j = this.executeUpdate(agent);
        j.join();
        if (j.getResult().isOK()) {
            return Application.PostContextCreateResult.RESTART_CLEAR_STATE;
        }
        return Application.PostContextCreateResult.CONTINUE;
    }

    public Job executeUpdate(final IProvisioningAgent agent) {
        this.logger.info("Searching for updates");
        Job j = new Job("Update Job"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IStatus status = Lifecycle.this.checkForUpdates(agent, monitor);
                    if (status.getCode() == 10000 || status.getSeverity() == 2) {
                        Lifecycle.this.logger.info("no updates found");
                    } else if (status.isOK()) {
                        Lifecycle.this.logger.info("Update successful");
                        Lifecycle.this.logger.info(String.format("Update '%s' have been installed successfully, application will be terminated. Restart it manualy", Lifecycle.this.updateName));
                    } else {
                        Lifecycle.this.logger.error("Updates failed. Download latest Version to avoid this problem.");
                    }
                    return status;
                }
                catch (Exception exception) {
                    return Status.CANCEL_STATUS;
                }
            }
        };
        j.schedule();
        return j;
    }

    private IStatus checkForUpdates(IProvisioningAgent agent, IProgressMonitor monitor) {
        ProvisioningSession session = new ProvisioningSession(agent);
        UpdateOperation operation = new UpdateOperation(session);
        URI uri = null;
        if (REPOSITORY_LOC == null) {
            String notRepLocMessage = "No Update Repository URI specified. You can set it up in config.ini over -Dupdatehandler.repo=http://myorl.org/ paremeter.";
            this.logger.info(notRepLocMessage);
            return new Status(2, "de.elpro.ewms.server.osgi", notRepLocMessage);
        }
        try {
            uri = new URI(REPOSITORY_LOC);
            this.logger.debug("Update URI " + uri);
        }
        catch (URISyntaxException uRISyntaxException) {
            this.logger.warning("Wrong Update URI Syntax");
            return new Status(2, "de.elpro.ewms.server.osgi", "Wrong Update URI Syntax");
        }
        IProfileRegistry profileRegistry = (IProfileRegistry)agent.getService(IProfileRegistry.class);
        this.selfProfile = profileRegistry.getProfile("_SELF_");
        if (this.selfProfile != null) {
            this.logger.infof("Use update server URI %s for %s", new Object[]{REPOSITORY_LOC, this.selfProfile.getProfileId()});
        } else {
            this.logger.error("Profile ID is NULL");
        }
        String uriHostName = uri.getHost();
        if (uriHostName != null && !uriHostName.isEmpty()) {
            boolean reachable = false;
            try {
                String checkHostMessage = String.format("Connecting update server '%s'", uriHostName);
                this.logger.info(checkHostMessage);
                reachable = InetAddress.getByName(uriHostName).isReachable(10000);
            }
            catch (UnknownHostException unknownHostException) {
            }
            catch (IOException iOException) {
                String warningText = String.format("Timeout by checking host '%s'", uriHostName);
                this.logger.warning(warningText);
                return new Status(2, "de.elpro.ewms.server.osgi", warningText);
            }
            if (!reachable) {
                String warningText = String.format("Update host '%s' ist unreachable", uriHostName);
                this.logger.error(warningText);
                return new Status(2, "de.elpro.ewms.server.osgi", warningText);
            }
        }
        operation.getProvisioningContext().setArtifactRepositories(new URI[]{uri});
        operation.getProvisioningContext().setMetadataRepositories(new URI[]{uri});
        IStatus status = operation.resolveModal(monitor);
        if (status.getCode() == 10000) {
            this.logger.debug("Nothing to update");
            return status;
        }
        ProvisioningJob provisioningJob = operation.getProvisioningJob(monitor);
        if (provisioningJob == null) {
            this.logger.debug("updates cannot run from within Eclipse IDE!!!");
            return new Status(2, "de.elpro.ewms.server.osgi", "updates cannot run from within Eclipse IDE!!!");
        }
        this.logger.debug("updating application");
        Update[] updates = operation.getPossibleUpdates();
        if (updates != null && updates.length == 1) {
            this.updateName = updates[0].replacement.toString();
        }
        Update[] updateArray = updates;
        int n = updates.length;
        int n2 = 0;
        while (n2 < n) {
            Update update = updateArray[n2];
            this.logger.debug("Update " + update.replacement.toString());
            ++n2;
        }
        return provisioningJob.runModal(new IProgressMonitor(){

            public void worked(int work) {
            }

            public void subTask(String name) {
                Lifecycle.this.logger.info(name);
            }

            public void setTaskName(String name) {
            }

            public void setCanceled(boolean value) {
            }

            public boolean isCanceled() {
                return false;
            }

            public void internalWorked(double work) {
            }

            public void done() {
                Lifecycle.this.logger.info("Update done");
            }

            public void beginTask(String name, int totalWork) {
                Lifecycle.this.logger.info(name);
            }
        });
    }
}

