/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server;

import de.elpro.ewms.core.preferences.Preference;
import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.virtualtime.VirtualZone;
import de.elpro.ewms.server.Server;
import de.elpro.ewms.server.bundle.Activator;
import de.elpro.ewms.server.model.AbstractConfiguration;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Arrays;
import javax.persistence.EntityManager;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class Configuration
extends AbstractConfiguration {
    private static final long DEFAULT_RAW_VALUES_WINDOW_WIDTH = 0L;
    private static final long DEFAULT_GLOBAL_VIEW_WINDOW_WIDTH = 0L;
    private static final long DEFAULT_REALTIME_VIEW_WINDOW_WIDTH = 50000L;
    private static final int DEFAULT_LOG_POOL_SIZE = 20000;
    private static final int DEFAULT_BACKUP_SIZE = 30;
    private String licenseFile = this.prefNode.getProperty("license.file", null);
    private String dbHost;
    private String dbName;
    private String dbLogin;
    private String dbPassword;
    private boolean dbCompress = true;
    private boolean dbHibernateNewIdGenerator = true;
    private String cacheRAMFactory = "com.eos.server.cache.rust.factory";
    private Raster rawValuesClusterSize;
    private long rawValuesWindowWidth = 0L;
    private Raster globalViewRaster;
    private Raster realtimeViewRaster;
    private long globalViewWindowWidth = 0L;
    private long realtimeViewWindowWidth = 50000L;
    private Long globalViewSyncInterval = null;
    private Long realtimeViewSyncInterval = null;
    private int logPoolSize = 20000;
    private String backupPath = null;
    private int backupSize = 30;
    private boolean debug = false;

    Configuration() throws AbstractConfiguration.PreferenceDefinitionException, UnknownHostException {
        super("server.cfg", Configuration.class.getResource("/config/server.cfg"));
        String debugStr;
        if (this.licenseFile == null || this.licenseFile.trim().isEmpty()) {
            this.licenseFile = String.format("license/%s.license", InetAddress.getLocalHost().getCanonicalHostName());
        }
        this.dbHost = this.prefNode.getProperty("db.host", null);
        this.dbName = this.prefNode.getProperty("db.name", null);
        this.dbLogin = this.prefNode.getProperty("db.login", null);
        this.dbPassword = this.prefNode.getProperty("db.password", null);
        String dbCompressStr = this.prefNode.getProperty("db.compress", "true");
        this.dbCompress = dbCompressStr.toLowerCase().equals("true");
        String dbNewIdGenStr = this.prefNode.getProperty("db.new_id_generator", "true");
        this.dbHibernateNewIdGenerator = dbNewIdGenStr.toLowerCase().equals("true");
        this.cacheRAMFactory = this.prefNode.getProperty("cache.ram.factory", this.cacheRAMFactory);
        Object[] rasterNames = Arrays.stream(Raster.values()).map(r -> r.name()).toArray();
        String rawValuesClusterSizeStr = this.prefNode.getProperty("rawvalues.cluster_size", null);
        try {
            this.rawValuesClusterSize = Raster.valueOf((String)rawValuesClusterSizeStr);
        }
        catch (Exception exception) {
            throw new AbstractConfiguration.PreferenceDefinitionException(this, String.format("Cannot parse raw values db cluster size definition for preference key = '%s'. Accepted values are: %s", "rawvalues.cluster_size", Arrays.toString(rasterNames)));
        }
        this.rawValuesWindowWidth = this.getLongProperty("rawvalues.window_width", 0L);
        String lowResRasterStr = this.prefNode.getProperty("global.raster", null);
        try {
            this.globalViewRaster = Raster.valueOf((String)lowResRasterStr);
        }
        catch (Exception exception) {
            throw new AbstractConfiguration.PreferenceDefinitionException(this, String.format("Cannot parse global view raster for preference key = '%s'. Accepted values are: %s", "global.raster", Arrays.toString(rasterNames)));
        }
        this.globalViewWindowWidth = this.getLongProperty("global.window_width", 0L);
        this.globalViewSyncInterval = this.getLongProperty("global.sync_interval");
        String highResRasterStr = this.prefNode.getProperty("realtime.raster", null);
        try {
            this.realtimeViewRaster = Raster.valueOf((String)highResRasterStr);
        }
        catch (Exception exception) {
            throw new AbstractConfiguration.PreferenceDefinitionException(this, String.format("Cannot parse realtime view raster for preference key = '%s'. Accepted values are: %s", "realtime.raster", Arrays.toString(rasterNames)));
        }
        this.realtimeViewWindowWidth = this.getLongProperty("realtime.window_width", 50000L);
        if (this.realtimeViewWindowWidth <= 0L) {
            this.realtimeViewWindowWidth = 50000L;
        }
        this.realtimeViewSyncInterval = this.getLongProperty("realtime.sync_interval");
        if (this.globalViewRaster.toMilli() < this.realtimeViewRaster.toMilli()) {
            throw new AbstractConfiguration.PreferenceDefinitionException(this, "Global raster is smaller than Realtime raster");
        }
        this.backupPath = this.prefNode.getProperty("backup.values.path", Activator.getWorkspaceLocation().append("backup").makeAbsolute().toString());
        this.backupSize = Math.max(1, (int)this.getLongProperty("backup.values.size", 1L));
        this.logPoolSize = this.getIntProperty("misc.log_pool_size", -1);
        if (this.logPoolSize < 0) {
            this.logPoolSize = 20000;
        }
        if ((debugStr = this.prefNode.getProperty("misc.debug", "false")) != null && debugStr.toLowerCase().equals("true")) {
            this.debug = true;
        }
    }

    public void initDbProperties() {
        try (EntityManager em = Server.getEntityManagerFactory().createEntityManager();){
            Preference zoneDefinition = (Preference)em.find(Preference.class, (Object)"virtual-zone");
            if (zoneDefinition == null) {
                em.getTransaction().begin();
                VirtualZone virtualZone = VirtualZone.INSTANCE;
                if (virtualZone.getZoneOffsets().isEmpty()) {
                    virtualZone.addZoneOffset(Instant.ofEpochMilli(0L), ZoneId.systemDefault(), ZoneOffset.UTC);
                }
                Preference virtualZonePreference = new Preference("virtual-zone", virtualZone.toString());
                em.persist((Object)virtualZonePreference);
                em.getTransaction().commit();
            } else {
                VirtualZone.INSTANCE.init(zoneDefinition.getValue());
            }
        }
    }

    public String getLicenseFile() {
        return this.licenseFile;
    }

    String getDbHost() {
        return this.dbHost;
    }

    String getDbName() {
        return this.dbName;
    }

    String getDbLogin() {
        return this.dbLogin;
    }

    String getDbPassword() {
        return this.dbPassword;
    }

    public String getCacheRAMFactory() {
        return this.cacheRAMFactory;
    }

    public boolean isDbCompress() {
        return this.dbCompress;
    }

    public boolean isHibernateNewIdGenerator() {
        return this.dbHibernateNewIdGenerator;
    }

    public Raster getRawValuesClusterSize() {
        return this.rawValuesClusterSize;
    }

    public long getRawValuesWindowWidth() {
        return this.rawValuesWindowWidth;
    }

    public Raster getGlobalViewRaster() {
        return this.globalViewRaster;
    }

    public long getGlobalViewWindowWidth() {
        return this.globalViewWindowWidth;
    }

    public Long getGlobalViewSyncInterval() {
        return this.globalViewSyncInterval;
    }

    public Raster getRealtimeViewRaster() {
        return this.realtimeViewRaster;
    }

    public long getRealtimeViewWindowWidth() {
        return this.realtimeViewWindowWidth;
    }

    public Long getRealtimeViewSyncInterval() {
        return this.realtimeViewSyncInterval;
    }

    public int getLogPoolSize() {
        return this.logPoolSize;
    }

    public IPath getBackupPath() {
        return Path.fromOSString((String)this.backupPath);
    }

    public int getBackupSize() {
        return this.backupSize;
    }

    public boolean isDebug() {
        return this.debug;
    }
}

