/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server;

import de.elpro.ewms.core.rawvalues.RawValuesViewType;
import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.server.Configuration;
import de.elpro.ewms.server.bundle.Activator;
import de.elpro.ewms.server.db.randomaccess.TimeIntervaTextDB;
import de.elpro.ewms.server.rasterizedvalues.RasterizedValues;
import de.elpro.ewms.server.storage.ArchiveStorage;
import de.elpro.ewms.server.storage.ArchiveStorages;
import de.elpro.ewms.server.storage.RawValuesCustomViewStorages;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;

public class RawValuesViews {
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();
    private final RasterizedValues realtimeView;
    private final Map<Integer, RasterizedValues> customViews = new HashMap<Integer, RasterizedValues>();
    private final RasterizedValues globalView;
    private final TimeIntervaTextDB genericDB;

    RawValuesViews(Configuration config) {
        this.globalView = new RasterizedValues(RawValuesViewType.GlobalView, null, config.getGlobalViewRaster(), ArchiveStorages.initGlobalViewInstance(config));
        this.realtimeView = new RasterizedValues(RawValuesViewType.RealtimeView, null, config.getRealtimeViewRaster(), ArchiveStorages.initRealtimeViewInstance(config));
        this.genericDB = new TimeIntervaTextDB(Activator.getWorkspaceLocation().append("data/generic").toString());
    }

    public void initViews() {
        this.readLock.lock();
        try {
            this.globalView.init();
            this.realtimeView.init();
            RawValuesCustomViewStorages.init();
            RawValuesCustomViewStorages.getStorageIndexes().stream().forEach(index -> {
                ArchiveStorage storage = RawValuesCustomViewStorages.getStorage(index);
                RasterizedValues valuesView = new RasterizedValues(RawValuesViewType.CustomView, (Integer)index, storage.getBaseRaster(), storage);
                this.customViews.put((Integer)index, valuesView);
            });
            for (RasterizedValues customView : this.customViews.values()) {
                customView.init();
            }
            this.genericDB.open();
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void clearCache() {
        this.readLock.lock();
        try {
            this.globalView.clearCache();
            this.realtimeView.clearCache();
            for (RasterizedValues customView : this.customViews.values()) {
                customView.clearCache();
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void shutdown() {
        this.readLock.lock();
        try {
            if (this.globalView != null) {
                this.globalView.shutdown();
            }
            if (this.realtimeView != null) {
                this.realtimeView.shutdown();
            }
            for (RasterizedValues customView : this.customViews.values()) {
                customView.shutdown();
            }
            if (this.globalView != null) {
                this.globalView.getComputationWorker().terminate();
            }
            if (this.realtimeView != null) {
                this.realtimeView.getComputationWorker().terminate();
            }
            for (RasterizedValues customView : this.customViews.values()) {
                customView.getComputationWorker().terminate();
            }
            this.genericDB.close();
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void createCustomView(int index, Raster raster, ArchiveStorage storage) {
        this.writeLock.lock();
        try {
            RasterizedValues valuesView = new RasterizedValues(RawValuesViewType.CustomView, index, raster, storage);
            RasterizedValues prevValue = this.customViews.putIfAbsent(index, valuesView);
            if (prevValue != null) {
                throw new IllegalArgumentException("Custom View with this index already present.");
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void removeCustomView(int index) {
        this.writeLock.lock();
        try {
            RasterizedValues rasterizedValues = this.customViews.remove(index);
            rasterizedValues.destroy();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public RasterizedValues getGlobalView() {
        return this.getValuesView(RawValuesViewType.GlobalView, null);
    }

    public RasterizedValues getRealtimeView() {
        return this.getValuesView(RawValuesViewType.RealtimeView, null);
    }

    public TimeIntervaTextDB getGenericDB() {
        return this.genericDB;
    }

    public RasterizedValues getValuesView(RawValuesViewType type, Integer index) {
        this.readLock.lock();
        try {
            switch (type) {
                case GlobalView: {
                    RasterizedValues rasterizedValues = this.globalView;
                    return rasterizedValues;
                }
                case RealtimeView: {
                    RasterizedValues rasterizedValues = this.realtimeView;
                    return rasterizedValues;
                }
                case CustomView: {
                    if (index == null) {
                        throw new IllegalArgumentException("Index of custom view must be not null");
                    }
                    RasterizedValues rasterizedValues = this.customViews.get(index);
                    return rasterizedValues;
                }
            }
            return null;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Collection<RasterizedValues> getValuesViews(RawValuesViewType type) {
        this.readLock.lock();
        try {
            switch (type) {
                case GlobalView: {
                    Set<RasterizedValues> set = Collections.singleton(this.globalView);
                    return set;
                }
                case RealtimeView: {
                    Set<RasterizedValues> set = Collections.singleton(this.realtimeView);
                    return set;
                }
                case CustomView: {
                    Collection<RasterizedValues> collection = Collections.unmodifiableCollection(this.customViews.values());
                    return collection;
                }
            }
            return null;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private LinkedList<RasterizedValues> getSortedViews() {
        LinkedList<RasterizedValues> views = new LinkedList<RasterizedValues>();
        views.add(this.realtimeView);
        views.addAll(this.customViews.values());
        views.add(this.globalView);
        return views;
    }

    public List<RasterizedValues> getViews() {
        this.readLock.lock();
        try {
            List<RasterizedValues> list = Collections.unmodifiableList(this.getSortedViews());
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void writeLockAllViews() {
        this.readLock.lock();
        try {
            views = this.getSortedViews();
            lockedViews = new LinkedList<RasterizedValues>();
            while (true) {
                allViewsLocked = true;
                for (RasterizedValues view : views) {
                    locked = view.tryWriteLock();
                    allViewsLocked &= locked;
                    if (!locked) break;
                    lockedViews.addFirst(view);
                }
                if (!allViewsLocked) ** GOTO lbl16
                break;
lbl-1000:
                // 1 sources

                {
                    ((RasterizedValues)lockedViews.remove()).writeUnlock();
lbl16:
                    // 2 sources

                    ** while (!lockedViews.isEmpty())
                }
lbl17:
                // 1 sources

                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void writeUnlockAllViews() {
        this.readLock.lock();
        try {
            LinkedList<RasterizedValues> views = this.getSortedViews();
            while (!views.isEmpty()) {
                views.removeLast().writeUnlock();
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void markGlobalViewValuesInvalid(VariableInstance instance, long from, Long to) {
        this.globalView.markValuesInvalid(instance, from, to);
        this.realtimeView.markValuesInvalid(instance, from, to);
        for (RasterizedValues customView : this.customViews.values()) {
            customView.markValuesInvalid(instance, from, to);
        }
    }

    public void markViewValuesInvalid(VariableInstance instance) {
        this.getSortedViews().forEach(view -> view.markValuesInvalid(instance));
    }

    public void forAllViews(Consumer<RasterizedValues> consumer) {
        this.readLock.lock();
        try {
            this.getSortedViews().forEach(consumer);
        }
        finally {
            this.readLock.unlock();
        }
    }
}

