/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server;

import de.elpro.ewms.core.characteristic.ICharacteristic2DRole;
import de.elpro.ewms.core.characteristic.ICharacteristic3DRole;
import de.elpro.ewms.core.component.ComponentBase;
import de.elpro.ewms.core.component.ServerInfo;
import de.elpro.ewms.core.json.JsonUtils;
import de.elpro.ewms.core.locale.LocaleDefinition;
import de.elpro.ewms.core.rawvalues.RawValuesViewType;
import de.elpro.ewms.core.server.ServerState;
import de.elpro.ewms.core.structure.IStructureClassRole;
import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.variable.IVariableRole;
import de.elpro.ewms.core.worker.AbstractWorker;
import de.elpro.ewms.core.worker.BackgroundWorkerGroup;
import de.elpro.ewms.core.worker.WorkerState;
import de.elpro.ewms.core.worker.WorkersPool;
import de.elpro.ewms.server.Configuration;
import de.elpro.ewms.server.RawValuesViews;
import de.elpro.ewms.server.bundle.Activator;
import de.elpro.ewms.server.cache.EventsCache;
import de.elpro.ewms.server.cache.JavaVarValuesCacheFactory;
import de.elpro.ewms.server.cache.ORMCache;
import de.elpro.ewms.server.custom.CustomAlgorithms;
import de.elpro.ewms.server.events.CurrentValuesChangeListener;
import de.elpro.ewms.server.events.EventActionJobs;
import de.elpro.ewms.server.logger.LogDB;
import de.elpro.ewms.server.model.EventActionJobDefinition;
import de.elpro.ewms.server.model.ICustomCalculationAlgorithmFactory;
import de.elpro.ewms.server.model.IServerComponent;
import de.elpro.ewms.server.model.IUpdateHandler;
import de.elpro.ewms.server.model.IValuesWriter;
import de.elpro.ewms.server.model.ScheduleJobDefinition;
import de.elpro.ewms.server.rasterizedvalues.CompoundValuesWriter;
import de.elpro.ewms.server.rasterizedvalues.IVarValuesCacheFactory;
import de.elpro.ewms.server.roles.Roles;
import de.elpro.ewms.server.schedules.Jobs;
import de.elpro.ewms.server.storage.MeasurementsStorage;
import de.elpro.ewms.server.storage.TimeRangeMetadata;
import de.elpro.ewms.server.supplement.SupplementStorage;
import de.elpro.ewms.server.valueswriter.GlobalValuesWriter;
import de.elpro.ewms.server.valueswriter.RawValuesWriter;
import de.elpro.ewms.server.valueswriter.RealtimeValuesWriter;
import de.elpro.hibernate.model.ServerConfiguration;
import de.elpro.hibernate.model.SqlServerType;
import de.elpro.hibernate.service.IHibernateConfigurationService;
import de.elpro.ui.text.LocaleDescriptor;
import de.elpro.ui.text.LocaleText;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertSelector;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.annotation.PostConstruct;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.SystemUtils;
import org.bouncycastle.asn1.ASN1GraphicString;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERGraphicString;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMDecryptor;
import org.bouncycastle.openssl.PEMEncryptor;
import org.bouncycastle.openssl.PEMException;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.bouncycastle.openssl.jcajce.JcePEMEncryptorBuilder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;
import org.eclipse.core.runtime.IPath;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.fx.core.ServiceUtils;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.ui.services.restart.RestartService;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.Version;

public class Server {
    public static final String SUBSERVERS_EXTENSION_POINT_ID = "de.elpro.ewms.server.subserver";
    public static final String SCHEDULE_JOBS_EXTENSION_POINT_ID = "de.elpro.ewms.server.schedules.schedule";
    public static final String EVENT_ACTION_JOBS_EXTENSION_POINT_ID = "de.elpro.ewms.server.events.jobs";
    private static IEclipseContext workbenchContext;
    private static EntityManagerFactory entityManagerFactory;
    public static final int MAX_SESSIONS_COUNT = 32;
    private static ServerInfo info;
    private static Configuration config;
    private static final WorkersPool workersPool;
    private static final Logger logger;
    private static final List<IServerComponent> subservers;
    private static IValuesWriter valuesWriter;
    private static GlobalValuesWriter globalValuesWriter;
    private static RealtimeValuesWriter realtimeValuesWriter;
    private static RawValuesWriter rawValuesWriter;
    private static RawValuesViews rawValuesViews;
    private static volatile Instant startTime;
    private static volatile Instant lastStartCurrentValueTimestamp;
    private static volatile ServerState state;
    private static IVarValuesCacheFactory<?> varValuesCacheFactory;
    private static final ASN1ObjectIdentifier eosLicenceHashOID;

    static {
        workersPool = new WorkersPool();
        subservers = new LinkedList<IServerComponent>();
        state = ServerState.New;
        logger = Activator.getLoggerFactory().createLogger(Server.class.getName());
        logger.info(String.format("Runtime Version: %s, EOS Core Version: %s", System.getProperty("java.version"), FrameworkUtil.getBundle(Server.class).getVersion()));
        Security.addProvider((Provider)new BouncyCastleProvider());
        varValuesCacheFactory = new JavaVarValuesCacheFactory();
        eosLicenceHashOID = new ASN1ObjectIdentifier("1.3.7.1.1.1.3967.1.1");
    }

    public static Configuration getConfig() {
        return config;
    }

    public static IVarValuesCacheFactory<?> getVarValuesCacheFactory() {
        return varValuesCacheFactory;
    }

    public static EntityManagerFactory getEntityManagerFactory() {
        return entityManagerFactory;
    }

    public static IPath getWorkspaceLocation() {
        return Activator.getWorkspaceLocation();
    }

    public static Instant getStartTime() {
        return startTime;
    }

    public static Instant getLastStartCurrentValueTimestamp() {
        return lastStartCurrentValueTimestamp;
    }

    public static ServerState getServerState() {
        return state;
    }

    public static RestartService getRestartService() {
        return (RestartService)workbenchContext.get(RestartService.class);
    }

    public static void clearCache() {
        try (EntityManager em = entityManagerFactory.createEntityManager();){
            ORMCache.reloadConfig(em);
            EventsCache.reloadCache(em);
        }
    }

    public static void reloadORMCache(EntityManager em) {
        ORMCache.reloadConfig(em);
    }

    public static void start(IEclipseContext workbenchContext) throws Exception {
        state = ServerState.Initialization;
        Server.workbenchContext = workbenchContext;
        config = (Configuration)ContextInjectionFactory.make(Configuration.class, (IEclipseContext)workbenchContext);
        workbenchContext.set(Configuration.class, (Object)config);
        LogDB.init();
        try {
            for (IVarValuesCacheFactory factory : ServiceUtils.getServiceList(IVarValuesCacheFactory.class)) {
                if (!factory.getId().equals(config.getCacheRAMFactory())) continue;
                varValuesCacheFactory = factory;
                break;
            }
        }
        catch (Throwable exc) {
            logger.error("Error create Cache Factory", exc);
        }
        logger.infof("Using cache factory: %s", new Object[]{varValuesCacheFactory.getId()});
        List updateHandlers = ServiceUtils.getServiceList(IUpdateHandler.class);
        updateHandlers.sort((u1, u2) -> u1.getSerialNumber().compareTo(u2.getSerialNumber()));
        for (IUpdateHandler component : updateHandlers) {
            try {
                ContextInjectionFactory.invoke((Object)component, PostConstruct.class, (IEclipseContext)workbenchContext);
            }
            catch (Exception exception) {}
            component.update();
        }
        LicenseInfo license = Server.validateLicense();
        HashSet componentIds = new HashSet();
        for (IServerComponent component : ServiceUtils.getServiceList(IServerComponent.class)) {
            String componentId = component.getInfo().getId();
            if (componentIds.contains(componentId)) {
                throw new Exception("Duplicate server component with id " + componentId);
            }
            if (license.isLicensed(componentId)) {
                subservers.add(component);
                continue;
            }
            logger.warning(String.format("Server component '%s' is not licensed and will be ignored", componentId));
        }
        Collections.sort(subservers);
        info = Server.readServerInfo();
        Server.initEntityManagerFactory();
        try (EntityManager em = entityManagerFactory.createEntityManager();){
            LocaleDescriptor fallbackLocaleDescriptor;
            List fallbackLocales = em.createQuery("SELECT l FROM LocaleDefinition l WHERE l.fallbackLocale is true", LocaleDefinition.class).getResultList();
            if (fallbackLocales.size() > 0 && (fallbackLocaleDescriptor = ((LocaleDefinition)fallbackLocales.get(0)).toDescriptor()) != null) {
                LocaleText.setFallbackLocale((Locale)fallbackLocaleDescriptor.getLocale());
            }
        }
        SupplementStorage.createInstance();
        rawValuesViews = new RawValuesViews(Server.getConfig());
        globalValuesWriter = new GlobalValuesWriter(rawValuesViews.getGlobalView());
        realtimeValuesWriter = new RealtimeValuesWriter(rawValuesViews.getRealtimeView());
        valuesWriter = new CompoundValuesWriter(globalValuesWriter, realtimeValuesWriter);
        rawValuesWriter = new RawValuesWriter(Raster.Minute_1.toMilli());
        Server.loadRoles();
        Server.loadCustomAlgorithms();
        Server.loadScheduleJobs();
        Server.loadEventActionJobs();
        em = entityManagerFactory.createEntityManager();
        try {
            Server.reloadORMCache(em);
        }
        finally {
            em.close();
        }
        for (IServerComponent subserver : subservers) {
            ContextInjectionFactory.inject((Object)subserver, (IEclipseContext)workbenchContext);
            try {
                ContextInjectionFactory.invoke((Object)subserver, PostConstruct.class, (IEclipseContext)workbenchContext);
            }
            catch (Exception exception) {}
            subserver.start();
        }
        new Thread(() -> {
            rawValuesViews.initViews();
            TimeRangeMetadata realtimeViewMeta = (TimeRangeMetadata)Server.getRawValuesViews().getRealtimeView().getArchiveStorage().getMetadata();
            if (realtimeViewMeta != null && realtimeViewMeta.getTimeRangeEnd() != null) {
                lastStartCurrentValueTimestamp = Instant.ofEpochMilli(realtimeViewMeta.getTimeRangeEnd());
            }
            startTime = Instant.now();
            Server.registerCallbacks();
            Server.startWorkers();
            Jobs.initSchedules();
            state = ServerState.Running;
        }).start();
    }

    public static void shutdown() {
        state = ServerState.ShuttingDown;
        for (IServerComponent subserver : subservers) {
            subserver.stop();
        }
        if (rawValuesViews != null) {
            rawValuesViews.shutdown();
        }
        if (globalValuesWriter != null) {
            globalValuesWriter.stopAsync();
        }
        if (realtimeValuesWriter != null) {
            realtimeValuesWriter.stopAsync();
        }
        while (globalValuesWriter != null && globalValuesWriter.getState() == WorkerState.Running || realtimeValuesWriter != null && realtimeValuesWriter.getState() == WorkerState.Running) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
        if (MeasurementsStorage.getInstance() != null) {
            MeasurementsStorage.getInstance().stop();
        }
        if (SupplementStorage.getInstance() != null) {
            SupplementStorage.getInstance().close();
        }
        state = ServerState.Stopped;
    }

    public static Collection<BackgroundWorkerGroup> getWorkerGroups() {
        return workersPool.getGroups();
    }

    public static void createWorkerGroup(String id, String name) {
        workersPool.createGroup(id, name);
    }

    public static Collection<AbstractWorker> getWorkers(String groupId) {
        return workersPool.getGroupWorkers(groupId);
    }

    public static AbstractWorker getWorker(String id) {
        return workersPool.getWorker(id);
    }

    public static void addWorker(AbstractWorker worker) {
        workersPool.addWorker(worker);
    }

    public static void addWorker(String groupId, AbstractWorker worker) {
        workersPool.addWorker(groupId, worker);
    }

    public static void removeWorker(String groupId, AbstractWorker worker) {
        workersPool.removeWorker(groupId, worker);
    }

    public static RawValuesViews getRawValuesViews() {
        return rawValuesViews;
    }

    public static IValuesWriter getCompoundValuesWriter() {
        return valuesWriter;
    }

    public static GlobalValuesWriter getGlobalValuesWriter() {
        return globalValuesWriter;
    }

    public static RealtimeValuesWriter getRealtimeValuesWriter() {
        return realtimeValuesWriter;
    }

    public static RawValuesWriter getRawValuesWriter() {
        return rawValuesWriter;
    }

    public static <T extends IServerComponent> T getServerComponent(String serverComponentId) {
        return (T)((IServerComponent)subservers.stream().filter(s -> serverComponentId.equals(s.getInfo().getId())).findFirst().orElse(null));
    }

    public static void initEntityManagerFactory() throws Exception {
        org.hibernate.cfg.Configuration hibernateConfig = IHibernateConfigurationService.INSTANCE.createHibernateConfiguration();
        hibernateConfig.addPackage("org.hibernate.typedefs.postgres");
        hibernateConfig.addPackage("de.elpro.ewms.server.hibernate.typedefs");
        hibernateConfig.setProperty("hibernate.id.new_generator_mappings", config.isHibernateNewIdGenerator() ? "true" : "false");
        ServerConfiguration serverConfiguration = IHibernateConfigurationService.INSTANCE.getServerConfiguration(SqlServerType.POSTGRES);
        serverConfiguration.setServerName(config.getDbHost());
        serverConfiguration.setDbName(config.getDbName());
        serverConfiguration.setLogin(config.getDbLogin());
        serverConfiguration.setPassword(config.getDbPassword());
        serverConfiguration.setC3P0MaxPoolSize(32);
        try {
            entityManagerFactory = IHibernateConfigurationService.INSTANCE.createEntityManagerFactory(serverConfiguration);
            config.initDbProperties();
            workbenchContext.set(EntityManagerFactory.class, (Object)entityManagerFactory);
        }
        catch (Exception exc) {
            logger.error("Exception creating session factory. Wrong login data?", (Throwable)exc);
            throw exc;
        }
    }

    public static ServerInfo getInfo() {
        return info;
    }

    private static void loadRoles() {
        try {
            for (IStructureClassRole classRole : ServiceUtils.getServiceList(IStructureClassRole.class)) {
                Roles.addClassRole(classRole);
            }
        }
        catch (Exception e1) {
            logger.error("Error initilizing class role", (Throwable)e1);
        }
        try {
            for (IVariableRole varRole : ServiceUtils.getServiceList(IVariableRole.class)) {
                Roles.addVariableRole(varRole);
            }
        }
        catch (Exception e1) {
            logger.error("Error initilizing variable role", (Throwable)e1);
        }
        try {
            for (ICharacteristic2DRole c2DRole : ServiceUtils.getServiceList(ICharacteristic2DRole.class)) {
                Roles.addCharacteristic2DRole(c2DRole);
            }
        }
        catch (Exception e1) {
            logger.error("Error initilizing characteristic 2D role", (Throwable)e1);
        }
        try {
            for (ICharacteristic3DRole c3DRole : ServiceUtils.getServiceList(ICharacteristic3DRole.class)) {
                Roles.addCharacteristic3DRole(c3DRole);
            }
        }
        catch (Exception e1) {
            logger.error("Error initilizing characteristic 3D role", (Throwable)e1);
        }
    }

    private static void loadCustomAlgorithms() {
        for (ICustomCalculationAlgorithmFactory algFactory : ServiceUtils.getServiceList(ICustomCalculationAlgorithmFactory.class)) {
            CustomAlgorithms.addAlgorithm(algFactory);
        }
    }

    private static void loadScheduleJobs() {
        try {
            for (ScheduleJobDefinition job : ServiceUtils.getServiceList(ScheduleJobDefinition.class)) {
                ContextInjectionFactory.inject((Object)job, (IEclipseContext)workbenchContext.createChild(job.getJobId()));
                Jobs.addJob(job);
            }
        }
        catch (Exception e1) {
            logger.error("Error loading schedule definition", (Throwable)e1);
        }
    }

    private static void loadEventActionJobs() {
        try {
            for (EventActionJobDefinition job : ServiceUtils.getServiceList(EventActionJobDefinition.class)) {
                EventActionJobs.addJob(job);
            }
        }
        catch (Exception e1) {
            logger.error("Error loading schedule definition", (Throwable)e1);
        }
    }

    private static void startWorkers() {
        rawValuesViews.getViews().forEach(view -> {
            view.getComputationWorker().startAsync();
            if (view.getType() != RawValuesViewType.CustomView) {
                workersPool.addWorker(view.getComputationWorker());
            }
        });
        globalValuesWriter.startAsync();
        workersPool.addWorker((AbstractWorker)globalValuesWriter);
        realtimeValuesWriter.startAsync();
        workersPool.addWorker((AbstractWorker)realtimeValuesWriter);
        Future rawWriterFuture = rawValuesWriter.startAsync();
        workersPool.addWorker((AbstractWorker)rawValuesWriter);
        try {
            rawWriterFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("Error", (Throwable)e);
        }
    }

    private static void registerCallbacks() {
        rawValuesViews.getRealtimeView().addOnLastValuesChangesListener(new CurrentValuesChangeListener());
    }

    private static HWInfo getHWInfo() throws Exception {
        HWInfo info;
        block50: {
            info = new HWInfo();
            if (SystemUtils.IS_OS_WINDOWS) {
                String line;
                BufferedReader reader;
                Throwable throwable = null;
                Object var2_7 = null;
                try {
                    reader = Server.readCommand("wmic bios get serialnumber".split(" "));
                    try {
                        while ((line = reader.readLine()) != null) {
                            if (!"SerialNumber".equals(line.trim())) continue;
                            line = reader.readLine();
                            if (line != null && line.trim().isEmpty()) {
                                line = reader.readLine();
                            }
                            if (line != null) {
                                info.setSerial(line.trim());
                            }
                            break;
                        }
                    }
                    finally {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                throwable = null;
                var2_7 = null;
                try {
                    reader = Server.readCommand("wmic csproduct get uuid".split(" "));
                    try {
                        while ((line = reader.readLine()) != null) {
                            if (!"UUID".equals(line.trim())) continue;
                            line = reader.readLine();
                            if (line != null && line.trim().isEmpty()) {
                                line = reader.readLine();
                            }
                            if (line != null) {
                                info.setUuid(line.trim());
                            }
                            break block50;
                        }
                        break block50;
                    }
                    finally {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            if (SystemUtils.IS_OS_LINUX) {
                String serial = Server.readLinuxSerial("env LC_ALL=C lshw -c system");
                if (serial == null || serial.isBlank()) {
                    serial = Server.readLinuxSerial("env LC_ALL=C sudo lshw -c system");
                }
                if (serial == null || serial.isBlank()) {
                    throw new Exception("Could not read systems Serial Number. Ensure lshw is su readable:\r\n\t\t :~$ sudo echo '%eos-service ALL=(root) NOPASSWD: /usr/bin/lshw' >> /etc/sudoers");
                }
                info.setSerial(serial);
                Throwable throwable = null;
                Object reader22 = null;
                try (BufferedReader reader = Server.readCommand("cat /etc/machine-id".split(" "));){
                    info.setUuid(reader.readLine().trim());
                    break block50;
                }
                catch (Throwable reader22) {
                    if (throwable == null) {
                        throwable = reader22;
                    } else if (throwable != reader22) {
                        throwable.addSuppressed(reader22);
                    }
                    throw throwable;
                }
            }
            if (SystemUtils.IS_OS_MAC_OSX) {
                Throwable throwable = null;
                Object var2_12 = null;
                try (BufferedReader reader = Server.readCommand("/usr/sbin/system_profiler SPHardwareDataType".split(" "));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        if (line.contains("Serial Number")) {
                            info.setSerial(line.split(":")[1].trim());
                        }
                        if (!line.contains("Hardware UUID")) continue;
                        info.setUuid(line.split(":")[1].trim());
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
        }
        return info;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readLinuxSerial(String cmd) throws Exception {
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (BufferedReader reader = Server.readCommand(cmd.split(" "));){
                String line;
                do {
                    if ((line = reader.readLine()) != null) continue;
                    return null;
                } while (!line.trim().toLowerCase().startsWith("serial:"));
                return line.trim().substring(7).trim();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (Exception exception) {
            throw new Exception("Could not read systems Serial Number. Install lshw: sudo apt install lshw");
        }
    }

    private static BufferedReader readCommand(String[] command) {
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        try {
            process = runtime.exec(command);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        OutputStream os = process.getOutputStream();
        InputStream is = process.getInputStream();
        try {
            os.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new BufferedReader(new InputStreamReader(is));
    }

    private static LicenseInfo readLicenseData(File licenseFile) throws CertificateVerificationException {
        X509Certificate cert;
        X509Certificate trustedRootCert;
        byte[] trustedRootCertData = new byte[]{45, 45, 45, 45, 45, 66, 69, 71, 73, 78, 32, 67, 69, 82, 84, 73, 70, 73, 67, 65, 84, 69, 45, 45, 45, 45, 45, 10, 77, 73, 73, 68, 114, 122, 67, 67, 65, 112, 101, 103, 65, 119, 73, 66, 65, 103, 73, 74, 65, 73, 75, 111, 52, 117, 98, 90, 98, 43, 55, 75, 77, 65, 48, 71, 67, 83, 113, 71, 83, 73, 98, 51, 68, 81, 69, 66, 68, 81, 85, 65, 77, 71, 52, 120, 67, 122, 65, 74, 66, 103, 78, 86, 10, 66, 65, 89, 84, 65, 107, 82, 70, 77, 82, 81, 119, 69, 103, 89, 68, 86, 81, 81, 73, 68, 65, 116, 69, 90, 88, 86, 48, 99, 50, 78, 111, 98, 71, 70, 117, 90, 68, 69, 80, 77, 65, 48, 71, 65, 49, 85, 69, 66, 119, 119, 71, 81, 109, 86, 121, 98, 71, 108, 117, 77, 82, 77, 119, 10, 69, 81, 89, 68, 86, 81, 81, 75, 68, 65, 112, 70, 98, 72, 66, 121, 98, 121, 66, 72, 98, 87, 74, 73, 77, 81, 119, 119, 67, 103, 89, 68, 86, 81, 81, 76, 68, 65, 78, 71, 100, 85, 85, 120, 70, 84, 65, 84, 66, 103, 78, 86, 66, 65, 77, 77, 68, 71, 86, 118, 99, 121, 53, 108, 10, 98, 72, 66, 121, 98, 121, 53, 107, 90, 84, 65, 101, 70, 119, 48, 120, 79, 84, 69, 119, 77, 122, 65, 119, 79, 84, 73, 50, 77, 122, 82, 97, 70, 119, 48, 121, 79, 84, 69, 119, 77, 106, 99, 119, 79, 84, 73, 50, 77, 122, 82, 97, 77, 71, 52, 120, 67, 122, 65, 74, 66, 103, 78, 86, 10, 66, 65, 89, 84, 65, 107, 82, 70, 77, 82, 81, 119, 69, 103, 89, 68, 86, 81, 81, 73, 68, 65, 116, 69, 90, 88, 86, 48, 99, 50, 78, 111, 98, 71, 70, 117, 90, 68, 69, 80, 77, 65, 48, 71, 65, 49, 85, 69, 66, 119, 119, 71, 81, 109, 86, 121, 98, 71, 108, 117, 77, 82, 77, 119, 10, 69, 81, 89, 68, 86, 81, 81, 75, 68, 65, 112, 70, 98, 72, 66, 121, 98, 121, 66, 72, 98, 87, 74, 73, 77, 81, 119, 119, 67, 103, 89, 68, 86, 81, 81, 76, 68, 65, 78, 71, 100, 85, 85, 120, 70, 84, 65, 84, 66, 103, 78, 86, 66, 65, 77, 77, 68, 71, 86, 118, 99, 121, 53, 108, 10, 98, 72, 66, 121, 98, 121, 53, 107, 90, 84, 67, 67, 65, 83, 73, 119, 68, 81, 89, 74, 75, 111, 90, 73, 104, 118, 99, 78, 65, 81, 69, 66, 66, 81, 65, 68, 103, 103, 69, 80, 65, 68, 67, 67, 65, 81, 111, 67, 103, 103, 69, 66, 65, 76, 78, 116, 65, 89, 106, 50, 49, 89, 52, 102, 10, 112, 105, 57, 99, 104, 119, 97, 103, 112, 100, 51, 83, 65, 51, 88, 103, 87, 68, 100, 50, 57, 54, 51, 102, 104, 99, 47, 56, 115, 53, 81, 75, 90, 122, 78, 104, 86, 79, 54, 111, 71, 114, 68, 69, 55, 56, 116, 51, 106, 109, 104, 67, 107, 109, 115, 87, 101, 65, 116, 100, 112, 87, 74, 100, 10, 74, 50, 114, 112, 102, 111, 83, 87, 47, 72, 87, 66, 111, 111, 113, 80, 69, 117, 117, 86, 99, 67, 73, 69, 83, 57, 65, 51, 102, 72, 49, 74, 79, 70, 112, 88, 86, 49, 56, 51, 86, 53, 72, 65, 70, 72, 66, 67, 86, 75, 57, 116, 98, 105, 120, 74, 69, 103, 101, 98, 47, 54, 57, 79, 10, 72, 110, 104, 86, 122, 48, 56, 120, 107, 69, 110, 76, 73, 87, 78, 88, 112, 52, 65, 73, 76, 50, 114, 66, 121, 77, 111, 75, 52, 100, 97, 116, 86, 113, 47, 122, 99, 68, 43, 97, 85, 84, 65, 103, 122, 101, 75, 102, 82, 54, 78, 84, 106, 82, 78, 65, 106, 122, 109, 114, 75, 71, 82, 85, 10, 102, 81, 120, 77, 73, 79, 57, 80, 121, 99, 112, 51, 68, 121, 51, 81, 75, 110, 54, 104, 114, 114, 70, 50, 82, 119, 110, 53, 56, 101, 97, 101, 82, 77, 119, 47, 43, 69, 82, 117, 86, 88, 110, 120, 70, 97, 68, 50, 122, 121, 104, 117, 122, 73, 102, 56, 83, 53, 66, 104, 50, 74, 47, 43, 10, 112, 68, 108, 116, 49, 90, 111, 121, 53, 70, 115, 98, 72, 116, 49, 109, 69, 54, 98, 106, 87, 101, 77, 82, 51, 72, 56, 122, 109, 103, 82, 76, 48, 68, 112, 108, 71, 82, 103, 57, 73, 53, 116, 100, 54, 81, 80, 48, 51, 108, 55, 68, 121, 119, 117, 81, 120, 84, 112, 109, 118, 86, 75, 69, 10, 111, 105, 79, 99, 77, 101, 55, 84, 86, 75, 56, 67, 65, 119, 69, 65, 65, 97, 78, 81, 77, 69, 52, 119, 72, 81, 89, 68, 86, 82, 48, 79, 66, 66, 89, 69, 70, 67, 113, 76, 72, 119, 57, 113, 117, 57, 117, 76, 86, 56, 117, 105, 73, 75, 85, 118, 115, 105, 88, 108, 107, 108, 52, 117, 10, 77, 66, 56, 71, 65, 49, 85, 100, 73, 119, 81, 89, 77, 66, 97, 65, 70, 67, 113, 76, 72, 119, 57, 113, 117, 57, 117, 76, 86, 56, 117, 105, 73, 75, 85, 118, 115, 105, 88, 108, 107, 108, 52, 117, 77, 65, 119, 71, 65, 49, 85, 100, 69, 119, 81, 70, 77, 65, 77, 66, 65, 102, 56, 119, 10, 68, 81, 89, 74, 75, 111, 90, 73, 104, 118, 99, 78, 65, 81, 69, 78, 66, 81, 65, 68, 103, 103, 69, 66, 65, 66, 103, 75, 116, 119, 121, 82, 57, 57, 85, 57, 55, 99, 101, 49, 50, 107, 87, 83, 109, 50, 53, 120, 97, 105, 101, 56, 103, 116, 107, 43, 119, 106, 84, 75, 110, 49, 73, 77, 10, 70, 107, 68, 65, 119, 107, 98, 53, 98, 109, 67, 49, 43, 106, 57, 70, 116, 72, 119, 111, 89, 109, 65, 85, 89, 81, 97, 89, 103, 82, 71, 75, 97, 113, 104, 117, 73, 115, 105, 72, 87, 69, 112, 65, 99, 67, 43, 112, 81, 52, 74, 119, 109, 118, 65, 116, 84, 49, 116, 75, 90, 104, 119, 87, 10, 100, 71, 67, 67, 115, 80, 115, 52, 102, 57, 113, 110, 120, 48, 53, 108, 74, 83, 119, 43, 53, 114, 109, 110, 84, 70, 81, 78, 67, 110, 105, 109, 89, 85, 56, 97, 47, 50, 56, 78, 54, 111, 70, 55, 43, 74, 89, 50, 122, 105, 103, 53, 111, 54, 71, 85, 71, 99, 119, 49, 97, 47, 111, 57, 10, 67, 86, 72, 72, 99, 116, 117, 67, 86, 116, 100, 86, 99, 122, 110, 108, 113, 99, 77, 43, 99, 119, 81, 85, 98, 78, 68, 85, 77, 71, 85, 56, 55, 97, 67, 98, 84, 66, 79, 55, 117, 119, 104, 102, 115, 49, 110, 71, 47, 85, 119, 117, 71, 69, 113, 77, 51, 69, 118, 74, 77, 73, 117, 72, 10, 56, 68, 73, 70, 80, 48, 114, 88, 121, 111, 101, 48, 80, 57, 109, 48, 110, 67, 85, 121, 74, 81, 76, 82, 104, 99, 119, 110, 50, 68, 69, 114, 77, 74, 70, 78, 120, 97, 65, 70, 86, 80, 72, 72, 116, 69, 88, 76, 115, 117, 78, 70, 122, 87, 86, 118, 75, 80, 54, 99, 111, 90, 87, 99, 10, 120, 107, 70, 98, 117, 72, 76, 72, 43, 107, 117, 108, 117, 77, 70, 49, 100, 115, 100, 72, 107, 57, 115, 50, 49, 83, 111, 122, 68, 121, 111, 83, 101, 68, 74, 66, 80, 97, 108, 71, 119, 81, 49, 87, 70, 84, 65, 61, 10, 45, 45, 45, 45, 45, 69, 78, 68, 32, 67, 69, 82, 84, 73, 70, 73, 67, 65, 84, 69, 45, 45, 45, 45, 45, 10};
        try {
            CertificateFactory fact = CertificateFactory.getInstance("X.509");
            Throwable throwable = null;
            Object var6_10 = null;
            try (ByteArrayInputStream trustedCertIS = new ByteArrayInputStream(trustedRootCertData);){
                trustedRootCert = (X509Certificate)fact.generateCertificate(trustedCertIS);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            throwable = null;
            var6_10 = null;
            try (FileInputStream certIS = new FileInputStream(licenseFile);){
                cert = (X509Certificate)fact.generateCertificate(certIS);
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Exception exc) {
            throw new CertificateVerificationException("Error reading certs", exc);
        }
        try {
            LicenseInfo license;
            if (Server.isSelfSigned(cert)) {
                throw new CertificateVerificationException("The certificate is self-signed.");
            }
            if (!Server.isSelfSigned(trustedRootCert)) {
                throw new CertificateVerificationException("Trusted root certificate is not self-signed.");
            }
            X509CertSelector selector = new X509CertSelector();
            selector.setCertificate(cert);
            HashSet<TrustAnchor> trustanchors = new HashSet<TrustAnchor>();
            trustanchors.add(new TrustAnchor(trustedRootCert, null));
            PKIXBuilderParameters pkixParams = new PKIXBuilderParameters(trustanchors, (CertSelector)selector);
            pkixParams.setRevocationEnabled(false);
            CertPathBuilder builder = CertPathBuilder.getInstance("PKIX");
            PKIXCertPathBuilderResult cfr_ignored_0 = (PKIXCertPathBuilderResult)builder.build(pkixParams);
            Server.verifyCertificateCRLs(cert);
            byte[] crldpExt = cert.getExtensionValue(eosLicenceHashOID.getId());
            Throwable throwable = null;
            Object var11_19 = null;
            try (ASN1InputStream oAsnInStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(crldpExt));){
                ASN1Primitive derObjCrlDP = oAsnInStream.readObject();
                DEROctetString dosCrlDP = (DEROctetString)derObjCrlDP;
                Throwable throwable4 = null;
                Object var16_26 = null;
                try (ASN1InputStream oAsnInStream2 = new ASN1InputStream((InputStream)new ByteArrayInputStream(dosCrlDP.getOctets()));){
                    ASN1Primitive derObj2 = oAsnInStream2.readObject();
                    ASN1GraphicString distPoint = DERGraphicString.getInstance((Object)derObj2);
                    byte[] encodedDataWithIV = distPoint.getOctets();
                    String json = Server.decrypt(encodedDataWithIV);
                    license = LicenseInfo.parse(json);
                }
                catch (Throwable throwable5) {
                    if (throwable4 == null) {
                        throwable4 = throwable5;
                    } else if (throwable4 != throwable5) {
                        throwable4.addSuppressed(throwable5);
                    }
                    throw throwable4;
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
            return license;
        }
        catch (CertPathBuilderException certPathEx) {
            throw new CertificateVerificationException("Error building certification path: " + cert.getSubjectX500Principal(), certPathEx);
        }
        catch (CertificateVerificationException cvex) {
            throw cvex;
        }
        catch (Exception ex) {
            throw new CertificateVerificationException("Error verifying the certificate: " + cert.getSubjectX500Principal(), ex);
        }
    }

    private static LicenseInfo validateLicense() throws Exception, IOException, OperatorCreationException, PEMException, FileNotFoundException {
        File licenseFile = new File(config.getLicenseFile());
        if (licenseFile.exists()) {
            LicenseInfo license;
            try {
                license = Server.readLicenseData(licenseFile);
            }
            catch (Exception exc) {
                logger.error("Error reading license file", (Throwable)exc);
                throw exc;
            }
            if (!license.getHwInfo().isMatching(Server.getHWInfo())) {
                throw new Exception("License File Rejected");
            }
            if (license.isCheckMACs()) {
                Set<String> serverMacs = Server.getMACs();
                boolean macFound = false;
                for (String mac : license.getMacAddresses()) {
                    if (!serverMacs.contains(mac)) continue;
                    macFound = true;
                    break;
                }
                if (!macFound) {
                    throw new Exception("License File Rejected");
                }
            }
            return license;
        }
        LicenseRequest licenseRequest = LicenseRequest.generate();
        File licenseRequestFile = new File(String.format("license/%s.license_request", licenseRequest.getHost()));
        licenseRequestFile.getParentFile().mkdirs();
        Throwable throwable = null;
        Object var5_8 = null;
        try (FileOutputStream os = new FileOutputStream(licenseRequestFile);){
            IOUtils.write((byte[])Server.encrypt(licenseRequest.serialize()), (OutputStream)os);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throw new Exception("No license file found. License Request ist stored under: " + licenseRequestFile.getAbsolutePath());
    }

    private static ServerInfo readServerInfo() {
        IProvisioningAgent agent = (IProvisioningAgent)workbenchContext.get(IProvisioningAgent.class);
        IInstallableUnit selfProductUI = Server.getSelfProductUI(agent);
        String selfProductName = "Unavailable in IDE runtime";
        String selfProductId = "Id unknown";
        Version selfProductVersion = Version.emptyVersion;
        if (selfProductUI != null) {
            selfProductName = selfProductUI.getProperty("org.eclipse.equinox.p2.name");
            selfProductId = selfProductUI.getId();
            selfProductVersion = Version.parseVersion((String)selfProductUI.getVersion().toString());
        }
        String javaVersion = System.getProperty("java.version");
        ComponentBase[] components = (ComponentBase[])ServiceUtils.getServiceList(ComponentBase.class).toArray(ComponentBase[]::new);
        ServerInfo info = new ServerInfo(selfProductName, selfProductId, selfProductVersion, javaVersion, config.getGlobalViewRaster(), config.getRealtimeViewRaster(), components);
        return info;
    }

    private static void verifyCertificateCRLs(X509Certificate cert) throws CertificateVerificationException {
        try {
            List<String> crlDistPoints = Server.getCrlDistributionPoints(cert);
            for (String crlDP : crlDistPoints) {
                try {
                    X509CRL crl = Server.downloadCRL(crlDP);
                    if (!crl.isRevoked(cert)) continue;
                    throw new CertificateVerificationException("The certificate is revoked by CRL: " + crlDP);
                }
                catch (Exception exc) {
                    logger.debug("Unable to download CRL: " + exc.getMessage());
                }
            }
        }
        catch (Exception ex) {
            if (ex instanceof CertificateVerificationException) {
                throw (CertificateVerificationException)ex;
            }
            throw new CertificateVerificationException("Can not verify CRL for certificate: " + cert.getSubjectX500Principal());
        }
    }

    private static X509CRL downloadCRL(String crlURL) throws IOException, CertificateException, CRLException, CertificateVerificationException, NamingException {
        if (crlURL.startsWith("http://") || crlURL.startsWith("https://") || crlURL.startsWith("ftp://")) {
            X509CRL crl = Server.downloadCRLFromWeb(crlURL);
            return crl;
        }
        if (crlURL.startsWith("ldap://")) {
            X509CRL crl = Server.downloadCRLFromLDAP(crlURL);
            return crl;
        }
        throw new CertificateVerificationException("Can not download CRL from certificate distribution point: " + crlURL);
    }

    private static X509CRL downloadCRLFromLDAP(String ldapURL) throws CertificateException, NamingException, CRLException, CertificateVerificationException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", ldapURL);
        InitialDirContext ctx = new InitialDirContext(env);
        Attributes avals = ctx.getAttributes("");
        Attribute aval = avals.get("certificateRevocationList;binary");
        byte[] val = (byte[])aval.get();
        if (val == null || val.length == 0) {
            throw new CertificateVerificationException("Can not download CRL from: " + ldapURL);
        }
        ByteArrayInputStream inStream = new ByteArrayInputStream(val);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        X509CRL crl = (X509CRL)cf.generateCRL(inStream);
        return crl;
    }

    private static X509CRL downloadCRLFromWeb(String crlURL) throws MalformedURLException, IOException, CertificateException, CRLException {
        URL url = new URL(crlURL);
        try (InputStream crlStream = url.openStream();){
            X509CRL crl;
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509CRL x509CRL = crl = (X509CRL)cf.generateCRL(crlStream);
            return x509CRL;
        }
    }

    /*
     * Loose catch block
     */
    private static List<String> getCrlDistributionPoints(X509Certificate cert) throws CertificateParsingException, IOException {
        byte[] crldpExt = cert.getExtensionValue(Extension.cRLDistributionPoints.getId());
        if (crldpExt == null) {
            ArrayList<String> emptyList = new ArrayList<String>();
            return emptyList;
        }
        Throwable throwable = null;
        Object var3_5 = null;
        try (ASN1InputStream oAsnInStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(crldpExt));){
            ArrayList<String> arrayList;
            ASN1InputStream oAsnInStream2;
            Throwable throwable2;
            block24: {
                ASN1Primitive derObjCrlDP = oAsnInStream.readObject();
                DEROctetString dosCrlDP = (DEROctetString)derObjCrlDP;
                throwable2 = null;
                Object var8_12 = null;
                oAsnInStream2 = new ASN1InputStream((InputStream)new ByteArrayInputStream(dosCrlDP.getOctets()));
                ASN1Primitive derObj2 = oAsnInStream2.readObject();
                CRLDistPoint distPoint = CRLDistPoint.getInstance((Object)derObj2);
                ArrayList<String> crlUrls = new ArrayList<String>();
                DistributionPoint[] distributionPointArray = distPoint.getDistributionPoints();
                int n = distributionPointArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DistributionPoint dp = distributionPointArray[n2];
                    DistributionPointName dpn = dp.getDistributionPoint();
                    if (dpn != null && dpn.getType() == 0) {
                        GeneralName[] genNames = GeneralNames.getInstance((Object)dpn.getName()).getNames();
                        int j = 0;
                        while (j < genNames.length) {
                            if (genNames[j].getTagNo() == 6) {
                                String url = DERIA5String.getInstance((Object)genNames[j].getName()).getString();
                                crlUrls.add(url);
                            }
                            ++j;
                        }
                    }
                    ++n2;
                }
                arrayList = crlUrls;
                if (oAsnInStream2 == null) break block24;
                oAsnInStream2.close();
            }
            return arrayList;
            {
                catch (Throwable throwable3) {
                    try {
                        if (oAsnInStream2 != null) {
                            oAsnInStream2.close();
                        }
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (throwable2 == null) {
                            throwable2 = throwable4;
                        } else if (throwable2 != throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        throw throwable2;
                    }
                }
            }
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
            } else if (throwable != throwable5) {
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
    }

    private static boolean isSelfSigned(X509Certificate cert) throws CertificateException, NoSuchAlgorithmException, NoSuchProviderException {
        try {
            PublicKey key = cert.getPublicKey();
            cert.verify(key);
            return true;
        }
        catch (SignatureException signatureException) {
            return false;
        }
        catch (InvalidKeyException invalidKeyException) {
            return false;
        }
    }

    private static Set<String> getMACs() {
        TreeSet<String> macs = new TreeSet<String>();
        try {
            Enumeration<NetworkInterface> networkInterface = NetworkInterface.getNetworkInterfaces();
            while (networkInterface.hasMoreElements()) {
                NetworkInterface network = networkInterface.nextElement();
                byte[] macAddressBytes = network.getHardwareAddress();
                if (macAddressBytes == null || macAddressBytes[0] == 0 && macAddressBytes[1] == 0 && macAddressBytes[3] == 0) continue;
                StringBuilder macAddressStr = new StringBuilder();
                int i = 0;
                while (i < macAddressBytes.length) {
                    macAddressStr.append(String.format("%02X", macAddressBytes[i]));
                    if (i < macAddressBytes.length - 1) {
                        macAddressStr.append("-");
                    }
                    ++i;
                }
                macs.add(macAddressStr.toString());
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return macs;
    }

    private static byte[] encrypt(String text) throws OperatorCreationException, PEMException {
        JcePEMEncryptorBuilder encBuilder = new JcePEMEncryptorBuilder("AES-256-CBC");
        encBuilder.setSecureRandom(new SecureRandom());
        PEMEncryptor pemEncryptor = encBuilder.build(new char[]{'a', 'M', 'f', 'E', 'z', 'd', '5', 's'});
        byte[] iv = pemEncryptor.getIV();
        byte[] encData = pemEncryptor.encrypt(Strings.toByteArray((String)text));
        return Arrays.concatenate((byte[])iv, (byte[])encData);
    }

    private static String decrypt(byte[] encodedDataWithIV) throws OperatorCreationException, PEMException {
        PEMDecryptor decryptor = new JcePEMDecryptorProviderBuilder().build(new char[]{'a', 'M', 'f', 'E', 'z', 'd', '5', 's'}).get("AES-256-CBC");
        byte[] iv = java.util.Arrays.copyOfRange(encodedDataWithIV, 0, 16);
        byte[] codedData = java.util.Arrays.copyOfRange(encodedDataWithIV, 16, encodedDataWithIV.length);
        byte[] encodedData = decryptor.decrypt(codedData, iv);
        return Strings.fromByteArray((byte[])encodedData);
    }

    static String readFile(String path, Charset encoding) throws IOException {
        byte[] encoded = Files.readAllBytes(Paths.get(path, new String[0]));
        return new String(encoded, encoding);
    }

    private static IInstallableUnit getSelfProductUI(IProvisioningAgent agent) {
        ProvisioningSession session = new ProvisioningSession(agent);
        IProvisioningAgent provisioningAgent = session.getProvisioningAgent();
        if (provisioningAgent == null) {
            return null;
        }
        IProfileRegistry profileRegistry = (IProfileRegistry)agent.getService(IProfileRegistry.class);
        if (profileRegistry == null) {
            return null;
        }
        IProfile profile = profileRegistry.getProfile("_SELF_");
        if (profile == null) {
            return null;
        }
        String profileId = profile.getProfileId();
        IQuery iuProductQuery = QueryUtil.createIUProductQuery();
        IQueryResult result = profile.query(iuProductQuery, null);
        if (result == null) {
            return null;
        }
        for (IInstallableUnit productIU : result) {
            if (!profileId.equals(productIU.getId())) continue;
            return productIU;
        }
        return null;
    }

    private static class CertificateVerificationException
    extends Exception {
        private static final long serialVersionUID = -1135520394079773044L;

        public CertificateVerificationException(String message, Throwable cause) {
            super(message, cause);
        }

        public CertificateVerificationException(String message) {
            super(message);
        }
    }

    private static class HWInfo {
        private String serial;
        private String uuid;

        private HWInfo() {
        }

        public String getSerial() {
            return this.serial;
        }

        public void setSerial(String serial) {
            this.serial = serial;
        }

        public String getUuid() {
            return this.uuid;
        }

        public void setUuid(String uuid) {
            this.uuid = uuid;
        }

        private boolean isSerialMatching(HWInfo info) {
            if (this.serial == null && info.serial == null) {
                return true;
            }
            return this.serial != null && info.serial != null && this.serial.equals(info.serial);
        }

        private boolean isUuidMatching(HWInfo info) {
            if (this.uuid == null && info.uuid == null) {
                return true;
            }
            return this.uuid != null && info.uuid != null && this.uuid.equals(info.uuid);
        }

        public boolean isMatching(HWInfo info) {
            String uuid;
            boolean serialMatching = this.isSerialMatching(info);
            boolean uuidMatching = this.isUuidMatching(info);
            if (uuidMatching && info.getUuid() != null && (uuid = info.getUuid().trim()).toLowerCase().equals(uuid) && !uuid.contains(" ") && uuid.length() > 20) {
                return true;
            }
            return serialMatching && uuidMatching;
        }
    }

    private static class LicenseInfo {
        private HWInfo hwInfo;
        private String host;
        private boolean fullFunctionality;
        private boolean checkMACs;
        private Set<String> macAddresses = new HashSet<String>();
        private Map<String, Boolean> licensedComponents = new HashMap<String, Boolean>();

        private LicenseInfo() {
        }

        public HWInfo getHwInfo() {
            return this.hwInfo;
        }

        public void setHwInfo(HWInfo hwInfo) {
            this.hwInfo = hwInfo;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public boolean isFullFunctionality() {
            return this.fullFunctionality;
        }

        public void setFullFunctionality(boolean fullFunctionality) {
            this.fullFunctionality = fullFunctionality;
        }

        public boolean isCheckMACs() {
            return this.checkMACs;
        }

        public void setCheckMACs(boolean checkMACs) {
            this.checkMACs = checkMACs;
        }

        public Set<String> getMacAddresses() {
            return this.macAddresses;
        }

        public Map<String, Boolean> getLicensedComponents() {
            return this.licensedComponents;
        }

        public boolean isLicensed(String componentId) {
            if (this.isFullFunctionality()) {
                return true;
            }
            Boolean licensed = this.licensedComponents.get(componentId);
            return licensed != null && licensed != false;
        }

        public static LicenseInfo parse(String json) {
            return (LicenseInfo)JsonUtils.GSON.fromJson(json, LicenseInfo.class);
        }

        public String serialize() {
            return JsonUtils.GSON.toJson((Object)this);
        }
    }

    private static final class LicenseRequest {
        private HWInfo hwInfo;
        private String host;
        private Set<String> macAddresses = new TreeSet<String>();
        private Instant timestamp;

        private LicenseRequest() {
        }

        public HWInfo getHwInfo() {
            return this.hwInfo;
        }

        public void setHwInfo(HWInfo hwInfo) {
            this.hwInfo = hwInfo;
        }

        public String getHost() {
            return this.host;
        }

        public Set<String> getMacAddresses() {
            return this.macAddresses;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public Instant getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        public String serialize() {
            return JsonUtils.GSON.toJson((Object)this);
        }

        public static LicenseRequest parse(String json) {
            return (LicenseRequest)JsonUtils.GSON.fromJson(json, LicenseRequest.class);
        }

        public static LicenseRequest generate() throws Exception {
            LicenseRequest licenseRequest = new LicenseRequest();
            licenseRequest.setHwInfo(Server.getHWInfo());
            licenseRequest.setHost(InetAddress.getLocalHost().getCanonicalHostName());
            licenseRequest.setTimestamp(Instant.now());
            licenseRequest.getMacAddresses().addAll(Server.getMACs());
            return licenseRequest;
        }
    }
}

