/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.auth;

import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.server.db.appconfig.EntityManagerPool;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;

public class AuthenticationDatabase {
    private static final Map<User, String> authorisedSession = new HashMap<User, String>();
    private static final Map<User, String> authorisationRequests = new HashMap<User, String>();

    public static final synchronized String autorise(User user) throws Exception {
        String requestToken = authorisationRequests.remove(user);
        if (requestToken == null) {
            throw new Exception("Authorisation Error");
        }
        String sessionKey = AuthenticationDatabase.generateToken();
        authorisedSession.put(user, sessionKey);
        EntityManagerPool.closeAll(user);
        return sessionKey;
    }

    public static final synchronized void logout(User user) {
        authorisationRequests.remove(user);
        authorisedSession.remove(user);
        EntityManagerPool.closeAll(user);
    }

    public static final synchronized String requestAuthorisation(User user) {
        String requestToken = AuthenticationDatabase.generateToken();
        authorisationRequests.put(user, requestToken);
        return requestToken;
    }

    public static final synchronized String getRequestToken(User user) {
        return authorisationRequests.get(user);
    }

    public static final synchronized boolean checkSession(User user, String sessionKey) {
        String storedKey = authorisedSession.get(user);
        return storedKey != null && storedKey.equals(sessionKey);
    }

    private static final String generateToken() {
        SecureRandom random = new SecureRandom();
        return new BigInteger(130, random).toString(32);
    }
}

