/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.cache;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.calculated.dependencies.DependencyKey;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DependencyTree {
    private Table<VariableInstance, DependencyKey<?>, Set<Object>> instanceDependencies = HashBasedTable.create();
    private Multimap<Object, VariableInstance> dependentInstances = HashMultimap.create();
    private Map<VariableInstance, Integer> instanceLayer = new HashMap<VariableInstance, Integer>();
    private Multimap<Integer, VariableInstance> layerInstances = HashMultimap.create();

    public void addInstance(VariableInstance instance, int layer) {
        this.instanceLayer.put(instance, layer);
        this.layerInstances.put((Object)layer, (Object)instance);
    }

    public void addDependency(VariableInstance instance, DependencyKey<?> key, Object dependency) {
        HashSet<Object> dependencies = (HashSet<Object>)this.instanceDependencies.get((Object)instance, key);
        if (dependencies == null) {
            dependencies = new HashSet<Object>();
            this.instanceDependencies.put((Object)instance, key, dependencies);
        }
        dependencies.add(dependency);
        this.dependentInstances.put(dependency, (Object)instance);
    }

    public Collection<VariableInstance> getDependendInstances(Object dependency) {
        return this.dependentInstances.get(dependency);
    }

    public Integer getVariableInstanceLayerLavel(VariableInstance instance) {
        return this.instanceLayer.get(instance);
    }

    public Collection<VariableInstance> getAllDependentInstances(Object dependency) {
        HashSet<VariableInstance> dependendInstances = new HashSet<VariableInstance>();
        this.fillAllDependendInstancesCollection(dependendInstances, dependency);
        return dependendInstances;
    }

    private void fillAllDependendInstancesCollection(Set<VariableInstance> dependendInstances, Object dependency) {
        for (VariableInstance instance : this.getDependendInstances(dependency)) {
            if (dependendInstances.contains(instance)) continue;
            dependendInstances.add(instance);
            this.fillAllDependendInstancesCollection(dependendInstances, instance);
        }
    }

    public Collection<Object> getInstanceDependencies(VariableInstance instance, DependencyKey<?> key) {
        return (Collection)this.instanceDependencies.get((Object)instance, key);
    }

    public Collection<Object> getInstanceDependencies(VariableInstance instance) {
        HashSet<Object> dependencies = new HashSet<Object>();
        this.instanceDependencies.row((Object)instance).values().forEach(d -> {
            boolean bl = dependencies.add(d);
        });
        return dependencies;
    }

    public Collection<DependencyKey<?>> getInstanceDependenciesKeys(VariableInstance instance) {
        return this.instanceDependencies.row((Object)instance).keySet();
    }

    public Table<VariableInstance, DependencyKey<?>, Set<Object>> getDependencies() {
        return this.instanceDependencies;
    }
}

