/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.cache;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import de.elpro.ewms.core.events.Event;
import de.elpro.ewms.core.events.EventAction;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.server.Server;
import de.elpro.ewms.server.transactions.TransactionChangeset;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.persistence.EntityManager;

public class EventsCache {
    private static final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    static final Lock readLock = readWriteLock.readLock();
    static final Lock writeLock = readWriteLock.writeLock();
    private static final Multimap<Event, VariableInstance> OBSERVERD_INSTANCES = HashMultimap.create();

    static {
        Runnable reloadCache = () -> {
            try (EntityManager em = Server.getEntityManagerFactory().createEntityManager();){
                EventsCache.reloadCache(em);
            }
        };
        TransactionChangeset.addPostCommitEventHandler(Event.class, (trx, events) -> reloadCache.run());
        TransactionChangeset.addPostCommitEventHandler(EventAction.class, (trx, events) -> reloadCache.run());
        TransactionChangeset.addPostCommitEventHandler(Variable.class, (trx, events) -> reloadCache.run());
        TransactionChangeset.addPostCommitEventHandler(VariableInstance.class, (trx, events) -> reloadCache.run());
        reloadCache.run();
    }

    public static void reloadCache(EntityManager em) {
        writeLock.lock();
        OBSERVERD_INSTANCES.clear();
        try {
            for (Event event : em.createQuery("SELECT o FROM Event o", Event.class).getResultList()) {
                event.getEventActions().size();
                for (Variable var : event.getCheckVariables()) {
                    for (VariableInstance instance : var.getInstances()) {
                        instance.getVariable();
                        instance.getStructureObject();
                        OBSERVERD_INSTANCES.put((Object)event, (Object)instance);
                    }
                }
                for (VariableInstance instance : event.getCheckVariableInstances()) {
                    instance.getVariable();
                    instance.getStructureObject();
                    OBSERVERD_INSTANCES.put((Object)event, (Object)instance);
                }
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    public static Map<Event, Collection<VariableInstance>> getObservedInstances() {
        readLock.lock();
        try {
            Map<Event, Collection<VariableInstance>> map = Collections.unmodifiableMap(new HashMap(OBSERVERD_INSTANCES.asMap()));
            return map;
        }
        finally {
            readLock.unlock();
        }
    }
}

