/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.cache;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.value.ArchiveValue;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.core.variable.value.IVarValuesCollection;
import de.elpro.ewms.core.variable.value.MeasuredValue;
import de.elpro.ewms.core.variable.value.Plausibility;
import de.elpro.ewms.core.variable.value.StoredVarValue;
import de.elpro.ewms.core.variable.value.SupplementValue;
import de.elpro.ewms.core.variable.value.ValueSource;
import de.elpro.ewms.core.variable.value.VarValue;
import de.elpro.ewms.server.bundle.Activator;
import de.elpro.ewms.server.rasterizedvalues.IVarValuesCache;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import org.eclipse.fx.core.log.Logger;

public class JavaVarValuesCache
implements IVarValuesCache {
    private static final Logger logger;
    static final int CLUSTER_SIZE = 1000;
    private static final int VALUE_BYTES_SUPPL = 30;
    private static final int VALUE_BYTES_ARCH = 26;
    private static final int VALUE_BYTES_MISC = 22;
    private static final int VALUE_BYTES;
    private static final int CLUSTER_BYTES;
    private final Raster RASTER;
    private final Table<VariableInstance, String, Map<Long, Object>> CACHE = HashBasedTable.create();
    private long lastValuesTs = Long.MIN_VALUE;
    private LZ4Factory compressorFactory = LZ4Factory.fastestInstance();

    static {
        Logger l = null;
        try {
            l = Activator.getLoggerFactory().createLogger(JavaVarValuesCache.class.toString());
        }
        catch (Throwable throwable) {}
        logger = l;
        VALUE_BYTES = Math.max(30, Math.max(26, 22));
        CLUSTER_BYTES = 1000 * VALUE_BYTES;
    }

    JavaVarValuesCache(Raster raster) {
        this.RASTER = raster;
    }

    @Override
    public Raster getRaster() {
        return this.RASTER;
    }

    @Override
    public long getRAMSize() {
        long size = 100L;
        for (Table.Cell cell : this.CACHE.cellSet()) {
            size += (long)(24 + ((String)cell.getColumnKey()).length() * 2);
            for (Map.Entry entry : ((Map)cell.getValue()).entrySet()) {
                size += 16L;
                if (entry.getValue() instanceof ValuesSequence) {
                    size += (long)(VALUE_BYTES + 4);
                    continue;
                }
                size += (long)((byte[])entry.getValue()).length;
            }
        }
        return size;
    }

    @Override
    public long getHDDSize() {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void push(VariableInstance instance, String key, IVarValuesCollection values) {
        IVarValue value;
        if (values.size() == 0) {
            return;
        }
        Map<Long, Object> clusters = this.getClusters(instance, key);
        Iterator iterator = values.iterator();
        IVarValue lastValue = value = (IVarValue)iterator.next();
        long firstElementEndTs = this.RASTER.getRasterEnd(value.getEndTimestamp());
        Map<Long, Object> map = clusters;
        synchronized (map) {
            long clusterId = this.getClusterId(firstElementEndTs);
            int j = (int)((firstElementEndTs - clusterId) / this.RASTER.toMilli());
            while (value != null) {
                Object clusterObj = clusters.get(clusterId);
                byte[] bytesCluster = null;
                ByteBuffer byteBuffer = null;
                ValuesSequence sequenceCluster = null;
                if (clusterObj instanceof byte[]) {
                    bytesCluster = this.decompress((byte[])clusterObj);
                    byteBuffer = ByteBuffer.wrap(bytesCluster, j * VALUE_BYTES, bytesCluster.length - j * VALUE_BYTES);
                } else if (clusterObj instanceof ValuesSequence) {
                    sequenceCluster = (ValuesSequence)clusterObj;
                }
                boolean hasNonEmptyValues = false;
                boolean wholeClusterWriten = j == 0;
                IVarValue firstValue = null;
                boolean sequentialValues = true;
                while (j < 1000 && value != null) {
                    if (j == 0) {
                        firstValue = value;
                    } else if (sequentialValues && firstValue != null && !firstValue.equalWithTimeOffset(value, this.RASTER, j)) {
                        sequentialValues = false;
                    }
                    if (value.getValueSource() != ValueSource.NaN) {
                        hasNonEmptyValues = true;
                    }
                    if (byteBuffer == null && sequenceCluster == null) {
                        if (value.getValueSource() != ValueSource.NaN) {
                            if (j == 0) {
                                sequenceCluster = new ValuesSequence(value, 1);
                            } else {
                                bytesCluster = new byte[1000 * VALUE_BYTES];
                                byteBuffer = ByteBuffer.wrap(bytesCluster, j * VALUE_BYTES, bytesCluster.length - j * VALUE_BYTES);
                                this.writeValue(byteBuffer, clusterId, value);
                            }
                        }
                    } else if (sequenceCluster != null) {
                        if (sequenceCluster.firstValue.equalWithTimeOffset(value, this.RASTER, j)) {
                            if (j == sequenceCluster.count) {
                                sequenceCluster.count = j + 1;
                            }
                        } else {
                            bytesCluster = this.createHomogenousCluster(clusterId, sequenceCluster, this.RASTER);
                            byteBuffer = ByteBuffer.wrap(bytesCluster, j * VALUE_BYTES, bytesCluster.length - j * VALUE_BYTES);
                            this.writeValue(byteBuffer, clusterId, value);
                            sequenceCluster = null;
                        }
                    } else {
                        byteBuffer.position(j * VALUE_BYTES);
                        this.writeValue(byteBuffer, clusterId, value);
                    }
                    ++j;
                    if (iterator.hasNext()) {
                        lastValue = value;
                        value = (IVarValue)iterator.next();
                        continue;
                    }
                    value = null;
                }
                if (j != 1000 && wholeClusterWriten) {
                    wholeClusterWriten = false;
                }
                if (hasNonEmptyValues || !wholeClusterWriten) {
                    if (sequenceCluster != null) {
                        clusters.put(clusterId, sequenceCluster);
                    } else if (wholeClusterWriten && sequentialValues) {
                        clusters.put(clusterId, new ValuesSequence(firstValue, 1000));
                    } else if (bytesCluster != null) {
                        clusters.put(clusterId, this.compress(bytesCluster));
                    }
                } else if (wholeClusterWriten) {
                    clusters.remove(clusterId);
                }
                j = 0;
                clusterId += 1000L * this.RASTER.toMilli();
            }
        }
        map = this.CACHE;
        synchronized (map) {
            this.lastValuesTs = Math.max(this.lastValuesTs, this.RASTER.getRasterEnd(lastValue.getEndTimestamp()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetValues(VariableInstance instance, String key, long toTs) {
        Map<Long, Object> clusters;
        Map<Long, Object> map = clusters = this.getClusters(instance, key);
        synchronized (map) {
            clusters.clear();
        }
        this.lastValuesTs = Math.max(this.lastValuesTs, this.RASTER.getRasterEnd(toTs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLastValueTs() {
        Table<VariableInstance, String, Map<Long, Object>> table = this.CACHE;
        synchronized (table) {
            return this.lastValuesTs;
        }
    }

    void writeValue(ByteBuffer buffer, long clusterId, IVarValue value) {
        if (value.getValueSource() == ValueSource.NaN) {
            buffer.put((byte)0);
            return;
        }
        IVarValue.IVarValueType type = value.getType();
        buffer.put((byte)(type.ordinal() + 1));
        switch (type) {
            case ArchiveValue: {
                ArchiveValue av = (ArchiveValue)value;
                buffer.putInt(this.getTsGapRelativeToCluster(clusterId, av.getEndTimestamp()));
                buffer.putInt((int)(av.getEndTimestamp() - av.getStartTimestamp()));
                buffer.putDouble(av.getValue());
                buffer.putDouble(av.getQuality());
                buffer.put((byte)av.getPlausibility().ordinal());
                break;
            }
            case VarValue: {
                buffer.putInt(this.getTsGapRelativeToCluster(clusterId, value.getEndTimestamp()));
                buffer.putDouble(value.getValue());
                buffer.putDouble(value.getQuality());
                buffer.put((byte)value.getPlausibility().ordinal());
                buffer.put((byte)value.getValueSource().ordinal());
                break;
            }
            case SupplementValue: {
                SupplementValue sv = (SupplementValue)value;
                buffer.putInt(this.getTsGapRelativeToCluster(clusterId, sv.getEndTimestamp()));
                buffer.putInt((int)(sv.getEndTimestamp() - sv.getStartTimestamp()));
                buffer.putDouble(sv.getValue());
                buffer.put((byte)sv.getPlausibility().ordinal());
                buffer.putLong(sv.getRecordedTimestamp());
                buffer.putInt(sv.getUserId());
                break;
            }
            case MeasuredValue: {
                MeasuredValue av = (MeasuredValue)value;
                buffer.putInt(this.getTsGapRelativeToCluster(clusterId, av.getEndTimestamp()));
                buffer.putInt((int)(av.getEndTimestamp() - av.getStartTimestamp()));
                buffer.putDouble(av.getValue());
                buffer.putDouble(av.getQuality());
                break;
            }
            case StoredVarValue: {
                StoredVarValue sv = (StoredVarValue)value;
                buffer.putInt(this.getTsGapRelativeToCluster(clusterId, value.getEndTimestamp()));
                buffer.putInt((int)(sv.getEndTimestamp() - sv.getStartTimestamp()));
                buffer.putDouble(value.getValue());
                buffer.putDouble(value.getQuality());
                buffer.put((byte)value.getPlausibility().ordinal());
                buffer.put((byte)value.getValueSource().ordinal());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported Value Type " + type);
            }
        }
    }

    int getTsGapRelativeToCluster(long clusterId, long timestamp) {
        long gap = this.RASTER.toMilli() + timestamp - clusterId;
        if (gap <= 0L) {
            throw new IllegalArgumentException(String.format("Timestamp is smaller than clusterId (%d < %d)", timestamp, clusterId));
        }
        return (int)(gap += Integer.MIN_VALUE);
    }

    long getTsOverClusterId(long clusterId, int gap) {
        return clusterId + ((long)gap - this.RASTER.toMilli()) - Integer.MIN_VALUE;
    }

    private byte[] compress(byte[] data) {
        LZ4Compressor compressor = this.compressorFactory.fastCompressor();
        int maxCompressedLength = compressor.maxCompressedLength(CLUSTER_BYTES);
        byte[] compressed = new byte[maxCompressedLength];
        int compressedLength = compressor.compress(data, 0, CLUSTER_BYTES, compressed, 0, maxCompressedLength);
        byte[] effCompressed = Arrays.copyOf(compressed, compressedLength);
        return effCompressed;
    }

    private byte[] decompress(byte[] data) {
        LZ4FastDecompressor decompressor = this.compressorFactory.fastDecompressor();
        byte[] restored = new byte[CLUSTER_BYTES];
        decompressor.decompress(data, 0, restored, 0, CLUSTER_BYTES);
        return restored;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IVarValuesCollection get(VariableInstance instance, String key, long fromTs, long toTs) {
        if (fromTs % this.RASTER.toMilli() != 0L || toTs % this.RASTER.toMilli() != 0L) {
            throw new IllegalArgumentException("Illegal interval bounds");
        }
        Map<Long, Object> clusters = this.getClusters(instance, key);
        int size = (int)((toTs - fromTs) / this.RASTER.toMilli());
        Throwable throwable = null;
        Object var10_9 = null;
        try (IVarValuesCollection result = new IVarValuesCollection();){
            long firstElementEndTs = fromTs + this.RASTER.toMilli();
            long clusterId = this.getClusterId(firstElementEndTs);
            int j = (int)((firstElementEndTs - clusterId) / this.RASTER.toMilli());
            Map<Long, Object> map = clusters;
            synchronized (map) {
                int i = 0;
                while (i < size) {
                    Object clusterObj = clusters.get(clusterId);
                    if (clusterObj == null) {
                        while (j++ < 1000 && i < size) {
                            result.add(VarValue.nan((long)(fromTs + this.RASTER.toMilli() * (long)(i + 1))));
                            ++i;
                        }
                    } else if (clusterObj instanceof byte[]) {
                        byte[] byteCluster = this.decompress((byte[])clusterObj);
                        ByteBuffer byteBuffer = ByteBuffer.wrap(byteCluster, j * VALUE_BYTES, byteCluster.length - j * VALUE_BYTES);
                        while (j < 1000 && i < size) {
                            byteBuffer.position(j++ * VALUE_BYTES);
                            IVarValue val = this.readValue(byteBuffer, clusterId);
                            if (val == null) {
                                result.add(VarValue.nan((long)(fromTs + (long)(i + 1) * this.RASTER.toMilli())));
                            } else {
                                result.add(val);
                            }
                            ++i;
                        }
                    } else {
                        ValuesSequence sequenceCluster = (ValuesSequence)clusterObj;
                        while (j < 1000 && i < size) {
                            if (j < sequenceCluster.count) {
                                result.add(sequenceCluster.firstValue.copyWithTimeShift(this.RASTER.toMilli() * (long)j));
                            } else {
                                result.add(VarValue.nan((long)(fromTs + (long)(i + 1) * this.RASTER.toMilli())));
                            }
                            ++j;
                            ++i;
                        }
                    }
                    j = 0;
                    clusterId += 1000L * this.RASTER.toMilli();
                }
            }
            return result;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void clearCacheToTimestamp(long toTimestamp) {
        long newFirstClusterTs = this.getClusterId(toTimestamp);
        for (Map values : this.CACHE.values()) {
            LinkedList<Long> clustersToRemove = new LinkedList<Long>();
            for (Long clusterId : values.keySet()) {
                if (clusterId >= newFirstClusterTs) continue;
                clustersToRemove.add(clusterId);
            }
            for (Long id : clustersToRemove) {
                values.remove(id);
            }
        }
    }

    @Override
    public void clearCacheFromTimestamp(long toTimestamp) {
        long newLastClusterTs = this.getClusterId(toTimestamp);
        for (Map values : this.CACHE.values()) {
            LinkedList<Long> clustersToRemove = new LinkedList<Long>();
            for (Long clusterId : values.keySet()) {
                if (clusterId <= newLastClusterTs) continue;
                clustersToRemove.add(clusterId);
            }
            for (Long id : clustersToRemove) {
                values.remove(id);
            }
        }
    }

    @Override
    public void clearCache() {
        this.CACHE.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCacheForInstance(VariableInstance instance) {
        Table<VariableInstance, String, Map<Long, Object>> table = this.CACHE;
        synchronized (table) {
            for (String key : new ArrayList<String>(this.getKeys(instance))) {
                this.CACHE.remove((Object)instance, (Object)key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getKeys(VariableInstance instance) {
        Table<VariableInstance, String, Map<Long, Object>> table = this.CACHE;
        synchronized (table) {
            Map row = this.CACHE.row((Object)instance);
            if (row != null) {
                return row.keySet();
            }
            return Collections.emptySet();
        }
    }

    private byte[] createHomogenousCluster(long clusterId, ValuesSequence valuesSequence, Raster raster) {
        byte[] cluster = new byte[1000 * VALUE_BYTES];
        ByteBuffer byteBuffer = ByteBuffer.wrap(cluster, 0, cluster.length);
        int i = 0;
        while (i < 1000 && i < valuesSequence.count) {
            byteBuffer.position(i * VALUE_BYTES);
            this.writeValue(byteBuffer, clusterId, valuesSequence.firstValue.copyWithTimeShift((long)i * raster.toMilli()));
            ++i;
        }
        return cluster;
    }

    IVarValue readValue(ByteBuffer buffer, long clusterId) {
        byte type_byte = buffer.get();
        if (type_byte == 0) {
            return null;
        }
        IVarValue.IVarValueType type = IVarValue.IVarValueType.values()[type_byte - 1];
        switch (type) {
            case ArchiveValue: {
                long endTs = this.getTsOverClusterId(clusterId, buffer.getInt());
                long startTs = endTs - (long)buffer.getInt();
                return new ArchiveValue(startTs, endTs, buffer.getDouble(), buffer.getDouble(), Plausibility.values()[buffer.get()]);
            }
            case SupplementValue: {
                long endTs = this.getTsOverClusterId(clusterId, buffer.getInt());
                long startTs = endTs - (long)buffer.getInt();
                return new SupplementValue(startTs, endTs, buffer.getDouble(), Plausibility.values()[buffer.get()], buffer.getLong(), buffer.getInt());
            }
            case VarValue: {
                return new VarValue(this.getTsOverClusterId(clusterId, buffer.getInt()), buffer.getDouble(), buffer.getDouble(), Plausibility.values()[buffer.get()], ValueSource.values()[buffer.get()]);
            }
            case MeasuredValue: {
                long endTs = this.getTsOverClusterId(clusterId, buffer.getInt());
                long startTs = endTs - (long)buffer.getInt();
                return new MeasuredValue(startTs, endTs, buffer.getDouble(), buffer.getDouble());
            }
            case StoredVarValue: {
                long endTs = this.getTsOverClusterId(clusterId, buffer.getInt());
                long startTs = endTs - (long)buffer.getInt();
                return new StoredVarValue(startTs, endTs, buffer.getDouble(), buffer.getDouble(), Plausibility.values()[buffer.get()], ValueSource.values()[buffer.get()]);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Long, Object> getClusters(VariableInstance instance, String key) {
        Table<VariableInstance, String, Map<Long, Object>> table = this.CACHE;
        synchronized (table) {
            HashMap<Long, Object> cachedValues = (HashMap<Long, Object>)this.CACHE.get((Object)instance, (Object)key);
            if (cachedValues == null) {
                cachedValues = new HashMap<Long, Object>();
                this.CACHE.put((Object)instance, (Object)key, cachedValues);
            }
            return cachedValues;
        }
    }

    long getClusterId(long timestamp) {
        long offset;
        return timestamp - offset - ((offset = timestamp % (1000L * this.RASTER.toMilli())) < 0L ? 1000L * this.RASTER.toMilli() : 0L);
    }

    private static class ValuesSequence {
        private final IVarValue firstValue;
        private int count;

        public ValuesSequence(IVarValue firstValue, int count) {
            this.firstValue = firstValue;
            this.count = count;
        }
    }
}

