/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.cache;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Table;
import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.characteristic.Characteristic2D;
import de.elpro.ewms.core.characteristic.Characteristic2DDescriptor;
import de.elpro.ewms.core.characteristic.Characteristic2DFunctionChange;
import de.elpro.ewms.core.characteristic.Characteristic2DFunctions;
import de.elpro.ewms.core.characteristic.Characteristic2DInstance;
import de.elpro.ewms.core.characteristic.Characteristic3D;
import de.elpro.ewms.core.characteristic.Characteristic3DDescriptor;
import de.elpro.ewms.core.characteristic.Characteristic3DFunctions;
import de.elpro.ewms.core.characteristic.Characteristic3DInstance;
import de.elpro.ewms.core.datasource.DataGroup;
import de.elpro.ewms.core.structure.Property;
import de.elpro.ewms.core.structure.PropertyGroup;
import de.elpro.ewms.core.structure.PropertyValue;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.time.TsInterval;
import de.elpro.ewms.core.units.DynamicMeasuringUnit;
import de.elpro.ewms.core.units.DynamicPhysicalUnit;
import de.elpro.ewms.core.units.MeasuringUnitDefinition;
import de.elpro.ewms.core.units.MeasuringUnitValue;
import de.elpro.ewms.core.units.PhysicalUnit;
import de.elpro.ewms.core.units.PhysicalUnitDefinition;
import de.elpro.ewms.core.units.PhysicalUnitRegistry;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.calculated.dependencies.Characteristic2DDependencyKey;
import de.elpro.ewms.core.variable.calculated.dependencies.Characteristic3DDependencyKey;
import de.elpro.ewms.core.variable.calculated.dependencies.DependencyKey;
import de.elpro.ewms.core.variable.calculated.dependencies.ObjectCharacteristic2DDependencyKey;
import de.elpro.ewms.core.variable.calculated.dependencies.ObjectCharacteristic3DDependencyKey;
import de.elpro.ewms.server.Server;
import de.elpro.ewms.server.auth.AuthenticationDatabase;
import de.elpro.ewms.server.bundle.Activator;
import de.elpro.ewms.server.cache.DependencyTree;
import de.elpro.ewms.server.cache.ORMCacheHelper;
import de.elpro.ewms.server.model.Characteristic2DInstanceCurveChanges;
import de.elpro.ewms.server.model.Characteristic3DInstanceFunctionChanges;
import de.elpro.ewms.server.rasterizedvalues.RasterizedValues;
import de.elpro.ewms.server.transactions.Modification;
import de.elpro.ewms.server.transactions.TransactionChangeset;
import de.elpro.ewms.server.transactions.TransactionProperty;
import de.elpro.ewms.server.valueswriter.MeasurementsPool;
import de.elpro.ui.concurrent.CallableTask;
import de.elpro.ui.fx.utils.TaskUtils;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javafx.concurrent.Worker;
import javafx.util.Pair;
import javax.persistence.EntityManager;
import org.eclipse.fx.core.log.Logger;

public class ORMCache {
    private static Logger logger = Activator.getLoggerFactory().createLogger(ORMCache.class.getName());
    private static final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    static final Lock readLock = readWriteLock.readLock();
    static final Lock writeLock = readWriteLock.writeLock();
    private static final BiMap<String, StructureObject> STRUCTURE_OBJECT_KEYS = HashBiMap.create();
    private static final BiMap<Variable, String> VARIABLE_NAMES = HashBiMap.create();
    private static final Map<Integer, Variable> VARIABLES = new HashMap<Integer, Variable>();
    private static final Map<Integer, VariableInstance> VARIABLE_INSTANCES = new HashMap<Integer, VariableInstance>();
    private static final Map<Integer, Characteristic2D> CHARACTERISTICS2D = new HashMap<Integer, Characteristic2D>();
    private static final BiMap<Characteristic2D, String> CHARACTERISTICS2D_NAMES = HashBiMap.create();
    private static final BiMap<Characteristic2D, String> CHARACTERISTICS2D_KEYS = HashBiMap.create();
    private static final Map<Integer, Characteristic2DInstance> CHARACTERISTIC2D_INSTANCES = new HashMap<Integer, Characteristic2DInstance>();
    private static final Map<Characteristic2DInstance, Characteristic2DFunctions> CHARACTERISTICS2D_CURVE_POINTS = new HashMap<Characteristic2DInstance, Characteristic2DFunctions>();
    private static final Map<Integer, Characteristic3D> CHARACTERISTICS3D = new HashMap<Integer, Characteristic3D>();
    private static final BiMap<Characteristic3D, String> CHARACTERISTICS3D_NAMES = HashBiMap.create();
    private static final BiMap<Characteristic3D, String> CHARACTERISTICS3D_KEYS = HashBiMap.create();
    private static final Map<Integer, Characteristic3DInstance> CHARACTERISTIC3D_INSTANCES = new HashMap<Integer, Characteristic3DInstance>();
    private static final Map<Characteristic3DInstance, Characteristic3DFunctions> CHARACTERISTICS3D_FUNCTIONS = new HashMap<Characteristic3DInstance, Characteristic3DFunctions>();
    private static final Map<Pair<String, String>, Property> STRUCTURE_OBJECT_PROPERTIES = new HashMap<Pair<String, String>, Property>();
    private static final Map<String, User> USERS = new HashMap<String, User>();
    private static final Table<StructureObject, Pair<String, String>, PropertyValue> OBSERVED_PROPERTY_VALUES = HashBasedTable.create();
    private static DependencyTree DEPENDENCY_TREE;

    static {
        TransactionChangeset.addPreCommitEventHandler(Object.class, ORMCache::prepareCommit);
        TransactionChangeset.addPostCommitEventHandler(Object.class, ORMCache::handlePostCommit);
    }

    public static void reloadConfig(final EntityManager em) {
        CallableTask<Void> task = new CallableTask<Void>(){
            private static final int TOTAL_STEPS = 12;
            private int progress = 0;
            {
                this.updateTitle("Loadind EWMS ORM Cache");
                this.updateProgress(this.progress, 12L);
            }

            public Void call() throws Exception {
                writeLock.lock();
                try {
                    try {
                        this.updateMessage("Clear cache");
                        STRUCTURE_OBJECT_KEYS.clear();
                        PhysicalUnitRegistry.cleadDynamicDefinitions();
                        VARIABLE_NAMES.clear();
                        VARIABLES.clear();
                        VARIABLE_INSTANCES.clear();
                        CHARACTERISTICS2D.clear();
                        CHARACTERISTICS2D_NAMES.clear();
                        CHARACTERISTICS2D_KEYS.clear();
                        CHARACTERISTIC2D_INSTANCES.clear();
                        CHARACTERISTICS2D_CURVE_POINTS.clear();
                        CHARACTERISTICS3D.clear();
                        CHARACTERISTICS3D_NAMES.clear();
                        CHARACTERISTICS3D_KEYS.clear();
                        CHARACTERISTIC3D_INSTANCES.clear();
                        CHARACTERISTICS3D_FUNCTIONS.clear();
                        STRUCTURE_OBJECT_PROPERTIES.clear();
                        USERS.clear();
                        OBSERVED_PROPERTY_VALUES.clear();
                        this.updateProgress(++this.progress, 12L);
                        for (StructureObject structureObject : em.createQuery("SELECT o FROM StructureObject o WHERE o.key IS NOT NULL", StructureObject.class).getResultList()) {
                            if (structureObject.getKey() == null || structureObject.getKey().isEmpty()) continue;
                            STRUCTURE_OBJECT_KEYS.inverse().put((Object)structureObject, (Object)structureObject.getKey());
                        }
                        this.updateMessage("Loading Physical Units");
                        ORMCache.loadPhysicalUnits(em);
                        this.updateMessage("Loading Measuring Units");
                        ORMCache.loadMeasuringUnits(em);
                        this.updateProgress(++this.progress, 12L);
                        this.updateMessage("Loading Users");
                        for (User user : em.createQuery("SELECT u FROM User u", User.class).getResultList()) {
                            USERS.put(user.getLoginPhrase(), user);
                        }
                        this.updateProgress(++this.progress, 12L);
                        this.updateMessage("Loading Variable Instances");
                        for (VariableInstance variableInstance : em.createQuery("SELECT vi FROM VariableInstance vi", VariableInstance.class).getResultList()) {
                            ORMCache.loadVariableInstance(variableInstance);
                        }
                        this.updateProgress(++this.progress, 12L);
                        this.updateMessage("Loading Variables");
                        for (Variable variable : em.createQuery("SELECT v FROM Variable v", Variable.class).getResultList()) {
                            ORMCache.loadVariable(variable);
                        }
                        this.updateProgress(++this.progress, 12L);
                        this.updateMessage("Loading Characteristics 2D");
                        for (Characteristic2D c2d : em.createQuery("SELECT c2d FROM Characteristic2D c2d", Characteristic2D.class).getResultList()) {
                            ORMCache.loadCharacteristic2D(c2d);
                            for (Characteristic2DInstance instance : c2d.getInstances()) {
                                ORMCache.loadCharacteristic2DInstance(instance);
                            }
                        }
                        this.updateProgress(++this.progress, 12L);
                        this.updateMessage("Loading Characteristics 3D");
                        for (Characteristic3D c3d : em.createQuery("SELECT c3d FROM Characteristic3D c3d", Characteristic3D.class).getResultList()) {
                            ORMCache.loadCharacteristic3D(c3d);
                            for (Characteristic2DInstance instance : c3d.getInstances()) {
                                ORMCache.loadCharacteristic3DInstance((Characteristic3DInstance)instance);
                            }
                        }
                        this.updateProgress(++this.progress, 12L);
                        this.updateMessage("Loading Object Properties");
                        for (Property property : em.createQuery("SELECT p FROM Property p", Property.class).getResultList()) {
                            ORMCache.loadProperty(property);
                        }
                        this.updateProgress(++this.progress, 12L);
                        this.updateMessage("Build dependency tree");
                        DEPENDENCY_TREE = ORMCacheHelper.buildDependencyTree(em, VARIABLE_INSTANCES.values(), (Map<String, Variable>)VARIABLE_NAMES.inverse(), STRUCTURE_OBJECT_KEYS, STRUCTURE_OBJECT_PROPERTIES, (Map<String, Characteristic2D>)CHARACTERISTICS2D_NAMES.inverse(), (Map<String, Characteristic2D>)CHARACTERISTICS2D_KEYS.inverse(), (Map<String, Characteristic3D>)CHARACTERISTICS3D_NAMES.inverse(), (Map<String, Characteristic3D>)CHARACTERISTICS3D_KEYS.inverse());
                        this.updateProgress(++this.progress, 12L);
                        this.updateMessage("Cache Object Property Values");
                        for (PropertyValue pv : em.createQuery("SELECT p FROM PropertyValue p", PropertyValue.class).getResultList()) {
                            if (!(pv.getTypeValue() instanceof MeasuringUnitValue)) continue;
                            Pair propertyKeys = new Pair((Object)pv.getProperty().getGroup().getKey(), (Object)pv.getProperty().getKey());
                            OBSERVED_PROPERTY_VALUES.put((Object)pv.getStructureObject(), (Object)propertyKeys, (Object)pv);
                        }
                        this.updateProgress(++this.progress, 12L);
                    }
                    catch (Exception exc) {
                        logger.error("Error ocured during cache reload", (Throwable)exc);
                        writeLock.unlock();
                    }
                }
                finally {
                    writeLock.unlock();
                }
                return null;
            }
        };
        Future future = TaskUtils.executeUITask((CallableTask)task).consumeResult((arg_0, arg_1) -> ORMCache.lambda$2((CallableTask)task, arg_0, arg_1));
        try {
            future.get();
        }
        catch (Exception exc) {
            logger.error("Error waiting for result", (Throwable)exc);
        }
    }

    private static void loadPhysicalUnits(EntityManager em) {
        for (PhysicalUnitDefinition pud : em.createQuery("SELECT pud FROM PhysicalUnitDefinition pud", PhysicalUnitDefinition.class).getResultList()) {
            if (PhysicalUnitRegistry.getPredefinedPhysicalUnit((String)pud.getKey()) != null) {
                logger.warning(String.format("Cannot override predefined Physical Unit with key %s", pud.getKey()));
                continue;
            }
            DynamicPhysicalUnit pu = new DynamicPhysicalUnit(pud);
            pu.init();
        }
    }

    private static void loadMeasuringUnits(EntityManager em) {
        for (MeasuringUnitDefinition mud : em.createQuery("SELECT mud FROM MeasuringUnitDefinition mud", MeasuringUnitDefinition.class).getResultList()) {
            if (PhysicalUnit.getPhysicalUnit((String)mud.getPhysicalUnitKey()) == null) {
                logger.warning(String.format("Physical Unit for Dynamic Measuring Unit with key %s not found", mud.getKey()));
                continue;
            }
            if (PhysicalUnit.getPhysicalUnit((String)mud.getPhysicalUnitKey()).getPredefinedMeasuringUnit(mud.getKey()) != null) {
                logger.warning(String.format("Cannot override predefined Measuring Unit with key %s", mud.getKey()));
                continue;
            }
            DynamicMeasuringUnit mu = new DynamicMeasuringUnit(mud);
            mu.init();
        }
    }

    public static Collection<VariableInstance> getVariableInstances() {
        readLock.lock();
        try {
            Collection<VariableInstance> collection = VARIABLE_INSTANCES.values();
            return collection;
        }
        finally {
            readLock.unlock();
        }
    }

    public static VariableInstance getVariableInstance(int instanceId) {
        readLock.lock();
        try {
            VariableInstance variableInstance = VARIABLE_INSTANCES.get(instanceId);
            return variableInstance;
        }
        finally {
            readLock.unlock();
        }
    }

    public static VariableInstance[] getVariableInstances(int[] instanceIds) {
        readLock.lock();
        try {
            VariableInstance[] instances = new VariableInstance[instanceIds.length];
            int i = 0;
            while (i < instanceIds.length) {
                instances[i] = VARIABLE_INSTANCES.get(instanceIds[i]);
                ++i;
            }
            VariableInstance[] variableInstanceArray = instances;
            return variableInstanceArray;
        }
        finally {
            readLock.unlock();
        }
    }

    public static int getInstanceLayer(VariableInstance instance) {
        readLock.lock();
        try {
            Integer depth = DEPENDENCY_TREE.getVariableInstanceLayerLavel(instance);
            if (depth == null) {
                throw new IllegalArgumentException(String.format("Unknown depth for instance %s. Try to reload config", instance));
            }
            int n = depth;
            return n;
        }
        finally {
            readLock.unlock();
        }
    }

    public static String getVariableName(Variable var) {
        readLock.lock();
        try {
            String string = (String)VARIABLE_NAMES.get((Object)var);
            return string;
        }
        finally {
            readLock.unlock();
        }
    }

    public static Variable getVariable(String variableName) {
        readLock.lock();
        try {
            Variable variable = (Variable)VARIABLE_NAMES.inverse().get((Object)variableName);
            return variable;
        }
        finally {
            readLock.unlock();
        }
    }

    public static Variable getVariable(int id) {
        readLock.lock();
        try {
            Variable variable = VARIABLES.get(id);
            return variable;
        }
        finally {
            readLock.unlock();
        }
    }

    public static Variable[] getVariables(int[] varIds) {
        readLock.lock();
        try {
            Variable[] vars = new Variable[varIds.length];
            int i = 0;
            while (i < varIds.length) {
                vars[i] = VARIABLES.get(varIds[i]);
                ++i;
            }
            Variable[] variableArray = vars;
            return variableArray;
        }
        finally {
            readLock.unlock();
        }
    }

    public static Collection<VariableInstance> getDependentInstances(Object dependentOn) {
        readLock.lock();
        try {
            Collection<VariableInstance> collection = DEPENDENCY_TREE.getDependendInstances(dependentOn);
            return collection;
        }
        finally {
            readLock.unlock();
        }
    }

    private static void loadVariable(Variable var) {
        VARIABLES.put(var.getId(), var);
        VARIABLE_NAMES.remove((Object)var);
        VARIABLE_NAMES.put((Object)var, (Object)var.toString());
        var.getPlcDefaultDataGroup();
        var.getStructureResultClassToken();
        var.getInstances().size();
        var.getDefaultProperties().size();
        var.getRoleIds().size();
        var.getValuesBounds();
    }

    private static void loadVariableInstance(VariableInstance instance) {
        instance.getVariable();
        instance.getStructureObject();
        instance.getResultValuesBounds();
        instance.getPlcDataGroup();
        if (instance.getWriteValuesSource() != null) {
            instance.getWriteValuesSource().getVariable();
        }
        instance.getDependencies().size();
        instance.cacheDependencies();
        instance.getFullName();
        VARIABLE_INSTANCES.put(instance.getId(), instance);
    }

    private static void loadCharacteristic2D(Characteristic2D c2d) {
        c2d.getStructureClass();
        c2d.getInputValuesBounds();
        c2d.getOutputValuesBounds();
        c2d.getInstances().size();
        c2d.getRoleIds().size();
        CHARACTERISTICS2D.put(c2d.getId(), c2d);
        CHARACTERISTICS2D_NAMES.remove((Object)c2d);
        CHARACTERISTICS2D_NAMES.put((Object)c2d, (Object)c2d.toString());
        if (c2d.getKey() != null && !c2d.getKey().trim().isEmpty()) {
            CHARACTERISTICS2D_KEYS.remove((Object)c2d);
            CHARACTERISTICS2D_KEYS.put((Object)c2d, (Object)c2d.getKey());
        }
    }

    private static void loadCharacteristic2DInstance(Characteristic2DInstance c2di) {
        c2di.getCharacteristic();
        c2di.getStructureObject();
        c2di.getInputValuesBounds();
        c2di.getOutputValuesBounds();
        CHARACTERISTIC2D_INSTANCES.put(c2di.getId(), c2di);
        CHARACTERISTICS2D_CURVE_POINTS.put(c2di, c2di.getFunctions());
    }

    private static void loadCharacteristic3D(Characteristic3D c3d) {
        c3d.getStructureClass();
        c3d.getInstances().size();
        c3d.getRoleIds().size();
        CHARACTERISTICS3D.put(c3d.getId(), c3d);
        CHARACTERISTICS3D_NAMES.remove((Object)c3d);
        CHARACTERISTICS3D_NAMES.put((Object)c3d, (Object)c3d.toString());
        if (c3d.getKey() != null && !c3d.getKey().trim().isEmpty()) {
            CHARACTERISTICS3D_KEYS.remove((Object)c3d);
            CHARACTERISTICS3D_KEYS.put((Object)c3d, (Object)c3d.getKey());
        }
    }

    private static void loadCharacteristic3DInstance(Characteristic3DInstance c3di) {
        c3di.getCharacteristic();
        c3di.getStructureObject();
        CHARACTERISTIC3D_INSTANCES.put(c3di.getId(), c3di);
        CHARACTERISTICS3D_FUNCTIONS.put(c3di, c3di.getFunctions());
    }

    private static void loadProperty(Property property) {
        property.getGroup().getStructureClass();
        STRUCTURE_OBJECT_PROPERTIES.put((Pair<String, String>)new Pair((Object)property.getGroup().getKey(), (Object)property.getKey()), property);
    }

    public static void addOrUpdateVariable(Variable var) {
        Server.getRawValuesViews().writeLockAllViews();
        writeLock.lock();
        try {
            ORMCache.loadVariable(var);
            for (VariableInstance instance : var.getInstances()) {
                ORMCache.loadVariableInstance(instance);
                Server.getRawValuesViews().markViewValuesInvalid(instance);
            }
        }
        finally {
            writeLock.unlock();
            Server.getRawValuesViews().writeUnlockAllViews();
        }
    }

    public static void addOrUpdateVariableInstance(VariableInstance instance) {
        Server.getRawValuesViews().writeLockAllViews();
        writeLock.lock();
        try {
            ORMCache.loadVariableInstance(instance);
            Server.getRawValuesViews().markViewValuesInvalid(instance);
        }
        finally {
            writeLock.unlock();
            Server.getRawValuesViews().writeUnlockAllViews();
        }
    }

    public static void setInstanceDatasource(int instanceId, DataGroup dataGroup, String datasourceKey) {
        writeLock.lock();
        try {
            VariableInstance instance = VARIABLE_INSTANCES.get(instanceId);
            instance.setPlcDataGroup(dataGroup);
            instance.setPlcDatasourceKey(datasourceKey);
        }
        finally {
            writeLock.unlock();
        }
    }

    public static Variable[] getVariables() {
        readLock.lock();
        try {
            LinkedList<Variable> vars = new LinkedList<Variable>(VARIABLES.values());
            Collections.sort(vars);
            Variable[] variableArray = vars.toArray(new Variable[0]);
            return variableArray;
        }
        finally {
            readLock.unlock();
        }
    }

    public static Characteristic2D[] getCharacteristics2D() {
        readLock.lock();
        try {
            LinkedList<Characteristic2D> c2ds = new LinkedList<Characteristic2D>(CHARACTERISTICS2D.values());
            Collections.sort(c2ds);
            Characteristic2D[] characteristic2DArray = c2ds.toArray(new Characteristic2D[0]);
            return characteristic2DArray;
        }
        finally {
            readLock.unlock();
        }
    }

    public static Characteristic2D getCharacteristic2D(int id) {
        readLock.lock();
        try {
            Characteristic2D characteristic2D = CHARACTERISTICS2D.get(id);
            return characteristic2D;
        }
        finally {
            readLock.unlock();
        }
    }

    public static Characteristic2D getCharacteristic2D(String key) {
        readLock.lock();
        try {
            Characteristic2D characteristic2D = (Characteristic2D)CHARACTERISTICS2D_KEYS.inverse().get((Object)key);
            return characteristic2D;
        }
        finally {
            readLock.unlock();
        }
    }

    public static Characteristic2DInstance getCharacteristic2DInstance(int id) {
        readLock.lock();
        try {
            Characteristic2DInstance characteristic2DInstance = CHARACTERISTIC2D_INSTANCES.get(id);
            return characteristic2DInstance;
        }
        finally {
            readLock.unlock();
        }
    }

    public static Characteristic2DFunctions getCurvePoints(VariableInstance instance, String nodeName) {
        readLock.lock();
        try {
            Collection<Object> dependency = DEPENDENCY_TREE.getInstanceDependencies(instance, (DependencyKey<?>)new Characteristic2DDependencyKey(nodeName));
            if (dependency == null) {
                return null;
            }
            Iterator<Object> iterator = dependency.iterator();
            if (iterator.hasNext()) {
                Object o = iterator.next();
                Characteristic2DFunctions characteristic2DFunctions = CHARACTERISTICS2D_CURVE_POINTS.get(o);
                return characteristic2DFunctions;
            }
            return null;
        }
        finally {
            readLock.unlock();
        }
    }

    public static Characteristic2DFunctions getCurvePoints(VariableInstance instance, StructureObject object, Characteristic2DDescriptor c2dDescriptor) {
        readLock.lock();
        try {
            Collection<Object> dependency = DEPENDENCY_TREE.getInstanceDependencies(instance, (DependencyKey<?>)new ObjectCharacteristic2DDependencyKey(object, c2dDescriptor.getKey()));
            if (dependency == null) {
                return null;
            }
            Iterator<Object> iterator = dependency.iterator();
            if (iterator.hasNext()) {
                Object o = iterator.next();
                Characteristic2DFunctions characteristic2DFunctions = CHARACTERISTICS2D_CURVE_POINTS.get(o);
                return characteristic2DFunctions;
            }
            return null;
        }
        finally {
            readLock.unlock();
        }
    }

    public static Characteristic3D[] getCharacteristics3D() {
        readLock.lock();
        try {
            LinkedList<Characteristic3D> c3ds = new LinkedList<Characteristic3D>(CHARACTERISTICS3D.values());
            Collections.sort(c3ds);
            Characteristic3D[] characteristic3DArray = c3ds.toArray(new Characteristic3D[0]);
            return characteristic3DArray;
        }
        finally {
            readLock.unlock();
        }
    }

    public static Characteristic3D getCharacteristic3D(int id) {
        readLock.lock();
        try {
            Characteristic3D characteristic3D = CHARACTERISTICS3D.get(id);
            return characteristic3D;
        }
        finally {
            readLock.unlock();
        }
    }

    public static Characteristic3D getCharacteristic3D(String key) {
        readLock.lock();
        try {
            Characteristic3D c3d;
            Characteristic3D characteristic3D = c3d = (Characteristic3D)CHARACTERISTICS3D_NAMES.inverse().get((Object)key);
            return characteristic3D;
        }
        finally {
            readLock.unlock();
        }
    }

    public static Characteristic3DInstance getCharacteristic3DInstance(int id) {
        readLock.lock();
        try {
            Characteristic3DInstance characteristic3DInstance = CHARACTERISTIC3D_INSTANCES.get(id);
            return characteristic3DInstance;
        }
        finally {
            readLock.unlock();
        }
    }

    public static Characteristic3DFunctions getCharacteristicFunctions(VariableInstance instance, String nodeName) {
        readLock.lock();
        try {
            Collection<Object> dependency = DEPENDENCY_TREE.getInstanceDependencies(instance, (DependencyKey<?>)new Characteristic3DDependencyKey(nodeName));
            if (dependency == null) {
                return null;
            }
            Iterator<Object> iterator = dependency.iterator();
            if (iterator.hasNext()) {
                Object o = iterator.next();
                Characteristic3DFunctions characteristic3DFunctions = CHARACTERISTICS3D_FUNCTIONS.get(o);
                return characteristic3DFunctions;
            }
            return null;
        }
        finally {
            readLock.unlock();
        }
    }

    public static Characteristic3DFunctions getCharacteristicFunctions(VariableInstance instance, StructureObject object, Characteristic3DDescriptor c3dDescriptor) {
        readLock.lock();
        try {
            Collection<Object> dependency = DEPENDENCY_TREE.getInstanceDependencies(instance, (DependencyKey<?>)new ObjectCharacteristic3DDependencyKey(object, c3dDescriptor.getKey()));
            if (dependency == null) {
                return null;
            }
            Iterator<Object> iterator = dependency.iterator();
            if (iterator.hasNext()) {
                Object o = iterator.next();
                Characteristic3DFunctions characteristic3DFunctions = CHARACTERISTICS3D_FUNCTIONS.get(o);
                return characteristic3DFunctions;
            }
            return null;
        }
        finally {
            readLock.unlock();
        }
    }

    public static Collection<Object> getDependencies(VariableInstance instance) {
        readLock.lock();
        try {
            Collection<Object> collection = DEPENDENCY_TREE.getInstanceDependencies(instance);
            return collection;
        }
        finally {
            readLock.unlock();
        }
    }

    public static Collection<DependencyKey<?>> getDependenciesKeys(VariableInstance instance) {
        readLock.lock();
        try {
            Collection<DependencyKey<?>> collection = DEPENDENCY_TREE.getInstanceDependenciesKeys(instance);
            return collection;
        }
        finally {
            readLock.unlock();
        }
    }

    public static Collection<Object> getDependencies(VariableInstance instance, DependencyKey<?> key) {
        readLock.lock();
        try {
            Collection<Object> dependencies = DEPENDENCY_TREE.getInstanceDependencies(instance, key);
            if (dependencies == null) {
                Collection<Object> collection = dependencies;
                return collection;
            }
            ArrayList<Object> copy = new ArrayList<Object>(dependencies.size());
            for (Object o : dependencies) {
                if (o instanceof PropertyValue) {
                    PropertyValue pv = (PropertyValue)o;
                    PropertyValue observedPV = (PropertyValue)OBSERVED_PROPERTY_VALUES.get((Object)pv.getStructureObject(), (Object)new Pair((Object)pv.getProperty().getGroup().getKey(), (Object)pv.getProperty().getKey()));
                    copy.add(observedPV != null ? observedPV : pv);
                    continue;
                }
                copy.add(o);
            }
            ArrayList<Object> arrayList = copy;
            return arrayList;
        }
        finally {
            readLock.unlock();
        }
    }

    public static VariableInstance getUniqueVariableInstanceDependency(VariableInstance instance, DependencyKey<?> key) {
        readLock.lock();
        try {
            Collection<Object> dependencies = DEPENDENCY_TREE.getInstanceDependencies(instance, key);
            if (dependencies == null || dependencies.size() != 1) {
                return null;
            }
            Object dependency = dependencies.iterator().next();
            if (!(dependency instanceof VariableInstance)) {
                return null;
            }
            VariableInstance variableInstance = (VariableInstance)dependency;
            return variableInstance;
        }
        finally {
            readLock.unlock();
        }
    }

    public static VariableInstance[] getUniqueVariableInstanceDependencies(VariableInstance instance, DependencyKey<?> ... keys) {
        readLock.lock();
        try {
            VariableInstance[] result = new VariableInstance[keys.length];
            int i = 0;
            DependencyKey<?>[] dependencyKeyArray = keys;
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                DependencyKey<?> key = dependencyKeyArray[n2];
                Collection<Object> dependencies = DEPENDENCY_TREE.getInstanceDependencies(instance, key);
                if (dependencies == null || dependencies.size() != 1) {
                    ++i;
                } else {
                    Object dependency = dependencies.iterator().next();
                    if (!(dependency instanceof VariableInstance)) {
                        ++i;
                    } else {
                        result[i++] = (VariableInstance)dependency;
                    }
                }
                ++n2;
            }
            VariableInstance[] variableInstanceArray = result;
            return variableInstanceArray;
        }
        finally {
            readLock.unlock();
        }
    }

    public static User getUser(String loginPhrase) {
        readLock.lock();
        try {
            User user = USERS.get(loginPhrase);
            return user;
        }
        finally {
            readLock.unlock();
        }
    }

    public static StructureObject getStructureObject(String key) {
        readLock.lock();
        try {
            StructureObject structureObject = (StructureObject)STRUCTURE_OBJECT_KEYS.get((Object)key);
            return structureObject;
        }
        finally {
            readLock.unlock();
        }
    }

    public static PropertyValue getPropertyValue(StructureObject object, String groupKey, String propertyKey) {
        readLock.lock();
        try {
            PropertyValue propertyValue = (PropertyValue)OBSERVED_PROPERTY_VALUES.get((Object)object, (Object)new Pair((Object)groupKey, (Object)propertyKey));
            return propertyValue;
        }
        finally {
            readLock.unlock();
        }
    }

    private static void prepareCommit(EntityManager em, Collection<Modification<Object>> changes, Collection<TransactionProperty> properties) throws Exception {
        boolean checkDependencyTree = properties.contains(TransactionProperty.REBUILD_DEPENDENCY_TREE);
        checkDependencyTree |= changes.stream().filter(c -> c.getObject() instanceof Variable).findAny().isPresent();
        checkDependencyTree |= changes.stream().filter(c -> c.getObject() instanceof VariableInstance).findAny().isPresent();
        checkDependencyTree |= changes.stream().filter(c -> c.getObject() instanceof Characteristic2D).findAny().isPresent();
        checkDependencyTree |= changes.stream().filter(c -> c.getObject() instanceof Characteristic3D).findAny().isPresent();
        checkDependencyTree |= changes.stream().filter(c -> c.getObject() instanceof Characteristic2DInstance).findAny().isPresent();
        checkDependencyTree |= changes.stream().filter(c -> c.getObject() instanceof Characteristic3DInstance).findAny().isPresent();
        checkDependencyTree |= changes.stream().filter(c -> c.getObject() instanceof StructureObject).findAny().isPresent();
        checkDependencyTree |= changes.stream().filter(c -> c.getObject() instanceof PropertyGroup).findAny().isPresent();
        if (checkDependencyTree |= changes.stream().filter(c -> c.getObject() instanceof Property).findAny().isPresent()) {
            em.flush();
            em.clear();
            HashSet<VariableInstance> allVariableInstances = new HashSet<VariableInstance>();
            HashBiMap variableNames = HashBiMap.create();
            HashBiMap objectKeys = HashBiMap.create();
            HashMap<Pair<String, String>, Property> objectProperties = new HashMap<Pair<String, String>, Property>();
            HashBiMap characteristic2DNames = HashBiMap.create();
            HashBiMap characteristic2DKeys = HashBiMap.create();
            HashBiMap characteristic3DNames = HashBiMap.create();
            HashBiMap characteristic3DKeys = HashBiMap.create();
            try {
                readLock.lock();
                allVariableInstances.addAll(VARIABLE_INSTANCES.values());
                VARIABLE_NAMES.inverse().entrySet().forEach(arg_0 -> ORMCache.lambda$12((BiMap)variableNames, arg_0));
                STRUCTURE_OBJECT_KEYS.entrySet().forEach(arg_0 -> ORMCache.lambda$13((BiMap)objectKeys, arg_0));
                STRUCTURE_OBJECT_PROPERTIES.entrySet().forEach(e -> {
                    Property property = objectProperties.put((Pair)e.getKey(), (Property)e.getValue());
                });
                CHARACTERISTICS2D_NAMES.inverse().entrySet().forEach(arg_0 -> ORMCache.lambda$15((BiMap)characteristic2DNames, arg_0));
                CHARACTERISTICS2D_KEYS.inverse().entrySet().forEach(arg_0 -> ORMCache.lambda$16((BiMap)characteristic2DKeys, arg_0));
                CHARACTERISTICS3D_NAMES.inverse().entrySet().forEach(arg_0 -> ORMCache.lambda$17((BiMap)characteristic3DNames, arg_0));
                CHARACTERISTICS3D_KEYS.inverse().entrySet().forEach(arg_0 -> ORMCache.lambda$18((BiMap)characteristic3DKeys, arg_0));
            }
            finally {
                readLock.unlock();
            }
            for (Modification<Object> change : changes) {
                Object object = change.getObject();
                if (object instanceof Variable) {
                    Variable var = (Variable)change.getObject();
                    if ((var = (Variable)em.find(Variable.class, (Object)var.getId())) == null) {
                        var = (Variable)change.getObject();
                        variableNames.inverse().remove((Object)var);
                        allVariableInstances.removeAll(var.getInstances());
                        continue;
                    }
                    variableNames.inverse().remove((Object)var);
                    variableNames.inverse().put((Object)var, (Object)var.toString());
                    allVariableInstances.removeAll(var.getInstances());
                    allVariableInstances.addAll(var.getInstances());
                    continue;
                }
                if (object instanceof VariableInstance) {
                    VariableInstance i = (VariableInstance)change.getObject();
                    if ((i = (VariableInstance)em.find(VariableInstance.class, (Object)i.getId())) == null) {
                        i = (VariableInstance)change.getObject();
                        allVariableInstances.remove(i);
                        continue;
                    }
                    i.getDependencies().size();
                    allVariableInstances.remove(i);
                    allVariableInstances.add(i);
                    Variable var = i.getVariable();
                    variableNames.inverse().remove((Object)var);
                    variableNames.inverse().put((Object)var, (Object)var.toString());
                    continue;
                }
                if (object instanceof Characteristic2D) {
                    Characteristic2D c2d = (Characteristic2D)change.getObject();
                    if ((c2d = (Characteristic2D)em.find(Characteristic2D.class, (Object)c2d.getId())) == null) {
                        c2d = (Characteristic2D)change.getObject();
                        characteristic2DNames.inverse().remove((Object)c2d);
                        characteristic2DKeys.inverse().remove((Object)c2d);
                        continue;
                    }
                    characteristic2DNames.inverse().remove((Object)c2d);
                    characteristic2DNames.inverse().put((Object)c2d, (Object)c2d.toString());
                    if (c2d.getKey() == null || c2d.getKey().trim().isEmpty()) continue;
                    characteristic2DKeys.inverse().remove((Object)c2d);
                    characteristic2DKeys.inverse().put((Object)c2d, (Object)c2d.getKey());
                    continue;
                }
                if (object instanceof Characteristic2DInstance) {
                    Characteristic2DInstance c2di = (Characteristic2DInstance)change.getObject();
                    Characteristic2D c2d = c2di.getCharacteristic();
                    characteristic2DNames.inverse().remove((Object)c2d);
                    characteristic2DNames.inverse().put((Object)c2d, (Object)c2d.toString());
                    if (c2d.getKey() == null || c2d.getKey().trim().isEmpty()) continue;
                    characteristic2DKeys.inverse().remove((Object)c2d);
                    characteristic2DKeys.inverse().put((Object)c2d, (Object)c2d.getKey());
                    continue;
                }
                if (object instanceof Characteristic3D) {
                    Characteristic3D c3d = (Characteristic3D)change.getObject();
                    if ((c3d = (Characteristic3D)em.find(Characteristic3D.class, (Object)c3d.getId())) == null) {
                        c3d = (Characteristic3D)change.getObject();
                        characteristic3DNames.inverse().remove((Object)c3d);
                        characteristic3DKeys.inverse().remove((Object)c3d);
                        continue;
                    }
                    characteristic3DNames.inverse().remove((Object)c3d);
                    characteristic3DNames.inverse().put((Object)c3d, (Object)c3d.toString());
                    if (c3d.getKey() == null || c3d.getKey().trim().isEmpty()) continue;
                    characteristic3DKeys.inverse().remove((Object)c3d);
                    characteristic3DKeys.inverse().put((Object)c3d, (Object)c3d.getKey());
                    continue;
                }
                if (object instanceof Characteristic3DInstance) {
                    Characteristic3DInstance c3di = (Characteristic3DInstance)change.getObject();
                    Characteristic3D c3d = c3di.getCharacteristic();
                    characteristic3DNames.inverse().remove((Object)c3d);
                    characteristic3DNames.inverse().put((Object)c3d, (Object)c3d.toString());
                    if (c3d.getKey() == null || c3d.getKey().trim().isEmpty()) continue;
                    characteristic3DKeys.inverse().remove((Object)c3d);
                    characteristic3DKeys.inverse().put((Object)c3d, (Object)c3d.getKey());
                    continue;
                }
                if (!(object instanceof StructureObject)) continue;
                StructureObject structureObject = (StructureObject)change.getObject();
                if ((structureObject = (StructureObject)em.find(StructureObject.class, (Object)structureObject.getId())) == null || structureObject.getKey() == null || structureObject.getKey().isEmpty()) {
                    structureObject = (StructureObject)change.getObject();
                    objectKeys.inverse().remove((Object)structureObject);
                    continue;
                }
                objectKeys.inverse().remove((Object)structureObject);
                objectKeys.inverse().put((Object)structureObject, (Object)structureObject.getKey());
            }
            ORMCacheHelper.buildDependencyTree(em, allVariableInstances, (Map<String, Variable>)variableNames, (Map<String, StructureObject>)objectKeys, objectProperties, (Map<String, Characteristic2D>)characteristic2DNames, (Map<String, Characteristic2D>)characteristic2DKeys, (Map<String, Characteristic3D>)characteristic3DNames, (Map<String, Characteristic3D>)characteristic3DKeys);
        }
    }

    private static void handlePostCommit(Collection<Modification<Object>> changes, Collection<TransactionProperty> properties) {
        block84: {
            long begin = System.nanoTime();
            HashSet<VariableInstance> removedInstances = new HashSet<VariableInstance>();
            HashSet<Object> changedDepTreeInstances = new HashSet<Object>();
            boolean writeLockUnlocked = false;
            EntityManager em = Server.getEntityManagerFactory().createEntityManager();
            try {
                try {
                    writeLock.lock();
                    boolean rebuildDependencyTree = properties.contains(TransactionProperty.REBUILD_DEPENDENCY_TREE);
                    boolean reloadUnits = false;
                    HashSet<VariableInstance> instancesWithDeprecatedValues = new HashSet<VariableInstance>();
                    HashSet<Object> changedDependencies = new HashSet<Object>();
                    HashMap<Object, TsInterval> dependencyValuesChanges = new HashMap<Object, TsInterval>();
                    for (Modification<Object> change : changes) {
                        Pair propertyKeys;
                        Instant maxChangeTsInstant;
                        long newChangeFrom;
                        long oldChangeFrom;
                        long newFrom;
                        long removedFrom;
                        int n;
                        int n2;
                        Characteristic2DFunctionChange[] characteristic2DFunctionChangeArray;
                        long maxChangeTs;
                        Characteristic2DFunctions oldFunctions;
                        Object allChanges;
                        Object object = change.getObject();
                        if (object instanceof Variable) {
                            Variable var = (Variable)change.getObject();
                            if ((var = (Variable)em.find(Variable.class, (Object)var.getId())) == null) {
                                var = (Variable)change.getObject();
                                var.getInstances().stream().forEach(i -> {
                                    VARIABLE_INSTANCES.remove(i.getId());
                                    removedInstances.add((VariableInstance)i);
                                });
                                VARIABLES.remove(var.getId());
                                VARIABLE_NAMES.remove((Object)var);
                            } else {
                                ORMCache.loadVariable(var);
                                var.getInstances().stream().forEach(i -> {
                                    ORMCache.loadVariableInstance(i);
                                    instancesWithDeprecatedValues.add((VariableInstance)i);
                                });
                            }
                            rebuildDependencyTree = true;
                            continue;
                        }
                        if (object instanceof VariableInstance) {
                            VariableInstance instance = (VariableInstance)change.getObject();
                            if ((instance = (VariableInstance)em.find(VariableInstance.class, (Object)instance.getId())) == null) {
                                instance = (VariableInstance)change.getObject();
                                VARIABLE_INSTANCES.remove(instance.getId());
                                if (VARIABLES.get(instance.getVariable().getId()) != null) {
                                    VARIABLES.get(instance.getVariable().getId()).getInstances().remove(instance);
                                }
                                removedInstances.add(instance);
                            } else {
                                ORMCache.loadVariableInstance(instance);
                                Variable var = VARIABLES.get(instance.getVariable().getId());
                                if (var != null) {
                                    instance.setVariable(var);
                                    var.getInstances().remove(instance);
                                    var.getInstances().add(instance);
                                }
                                instancesWithDeprecatedValues.add(instance);
                            }
                            rebuildDependencyTree = true;
                            continue;
                        }
                        if (object instanceof Characteristic2D) {
                            Characteristic2D c2d = (Characteristic2D)change.getObject();
                            if ((c2d = (Characteristic2D)em.find(Characteristic2D.class, (Object)c2d.getId())) == null) {
                                c2d = (Characteristic2D)change.getObject();
                                CHARACTERISTICS2D.remove(c2d.getId());
                                CHARACTERISTICS2D_NAMES.remove((Object)c2d);
                                c2d.getInstances().forEach(i -> {
                                    CHARACTERISTIC2D_INSTANCES.remove(i.getId());
                                    CHARACTERISTICS2D_CURVE_POINTS.remove(i);
                                });
                            } else {
                                ORMCache.loadCharacteristic2D(c2d);
                                c2d.getInstances().forEach(i -> {
                                    ORMCache.loadCharacteristic2DInstance(i);
                                    changedDependencies.add(i);
                                });
                            }
                            rebuildDependencyTree = true;
                            continue;
                        }
                        if (object instanceof Characteristic2DInstance) {
                            Characteristic2DInstance c2di = (Characteristic2DInstance)change.getObject();
                            if ((c2di = (Characteristic2DInstance)em.find(Characteristic2DInstance.class, (Object)c2di.getId())) == null) {
                                c2di = (Characteristic2DInstance)change.getObject();
                                CHARACTERISTIC2D_INSTANCES.remove(c2di.getId());
                                CHARACTERISTICS2D_CURVE_POINTS.remove(c2di);
                                CHARACTERISTICS2D.get(c2di.getCharacteristic().getId()).getInstances().remove(c2di);
                            } else {
                                ORMCache.loadCharacteristic2DInstance(c2di);
                                Characteristic2D c2d = CHARACTERISTICS2D.get(c2di.getCharacteristic().getId());
                                if (c2d != null) {
                                    c2di.setCharacteristic(c2d);
                                    c2d.getInstances().add(c2di);
                                }
                                changedDependencies.add(c2di);
                            }
                            rebuildDependencyTree = true;
                            continue;
                        }
                        if (object instanceof Characteristic2DInstanceCurveChanges) {
                            allChanges = (Characteristic2DInstanceCurveChanges)object;
                            if (((Characteristic2DInstanceCurveChanges)allChanges).getChanges().length == 0) continue;
                            Characteristic2DInstance c2di = ((Characteristic2DInstanceCurveChanges)allChanges).getInstance();
                            oldFunctions = CHARACTERISTICS2D_CURVE_POINTS.get(c2di);
                            ORMCache.loadCharacteristic2DInstance(c2di);
                            Characteristic2D c2d = CHARACTERISTICS2D.get(c2di.getCharacteristic().getId());
                            if (c2d != null) {
                                c2di.setCharacteristic(c2d);
                                c2d.getInstances().add(c2di);
                            }
                            long minChangeTs = Long.MAX_VALUE;
                            maxChangeTs = Long.MIN_VALUE;
                            characteristic2DFunctionChangeArray = ((Characteristic2DInstanceCurveChanges)allChanges).getChanges();
                            n2 = characteristic2DFunctionChangeArray.length;
                            n = 0;
                            while (n < n2) {
                                Characteristic2DFunctionChange functionChange = characteristic2DFunctionChangeArray[n];
                                if (functionChange.getFunction() == null || functionChange.getFunction().isEmpty() || functionChange.getNewBegin() == null) {
                                    removedFrom = functionChange.getOldBegin().toEpochMilli();
                                    minChangeTs = Math.min(removedFrom, minChangeTs);
                                    maxChangeTs = Math.max(removedFrom, maxChangeTs);
                                } else if (functionChange.getOldBegin() == null) {
                                    newFrom = functionChange.getNewBegin().toEpochMilli();
                                    minChangeTs = Math.min(newFrom, minChangeTs);
                                    maxChangeTs = Math.max(newFrom, maxChangeTs);
                                } else {
                                    if (!functionChange.getOldBegin().equals(functionChange.getNewBegin())) {
                                        oldChangeFrom = functionChange.getOldBegin().toEpochMilli();
                                        minChangeTs = Math.min(oldChangeFrom, minChangeTs);
                                        maxChangeTs = Math.max(oldChangeFrom, maxChangeTs);
                                    }
                                    newChangeFrom = functionChange.getNewBegin().toEpochMilli();
                                    minChangeTs = Math.min(newChangeFrom, minChangeTs);
                                    maxChangeTs = Math.max(newChangeFrom, maxChangeTs);
                                }
                                ++n;
                            }
                            maxChangeTsInstant = oldFunctions.getNextFunctionBegin(Instant.ofEpochMilli(maxChangeTs));
                            maxChangeTs = maxChangeTsInstant != null ? maxChangeTsInstant.toEpochMilli() : Long.MAX_VALUE;
                            dependencyValuesChanges.put(c2di, new TsInterval(minChangeTs, maxChangeTs));
                            continue;
                        }
                        if (object instanceof Characteristic3D) {
                            Characteristic3D c3d = (Characteristic3D)change.getObject();
                            if ((c3d = (Characteristic3D)em.find(Characteristic3D.class, (Object)c3d.getId())) == null) {
                                c3d = (Characteristic3D)change.getObject();
                                CHARACTERISTICS3D.remove(c3d.getId());
                                CHARACTERISTICS3D_NAMES.remove((Object)c3d);
                                c3d.getInstances().forEach(i -> {
                                    CHARACTERISTIC3D_INSTANCES.remove(i.getId());
                                    CHARACTERISTICS3D_FUNCTIONS.remove(i);
                                });
                            } else {
                                ORMCache.loadCharacteristic3D(c3d);
                                c3d.getInstances().forEach(i -> {
                                    ORMCache.loadCharacteristic3DInstance(i);
                                    changedDependencies.add(i);
                                });
                            }
                            rebuildDependencyTree = true;
                            continue;
                        }
                        if (object instanceof Characteristic3DInstance) {
                            Characteristic3DInstance c3di = (Characteristic3DInstance)change.getObject();
                            if ((c3di = (Characteristic3DInstance)em.find(Characteristic3DInstance.class, (Object)c3di.getId())) == null) {
                                c3di = (Characteristic3DInstance)change.getObject();
                                CHARACTERISTIC3D_INSTANCES.remove(c3di.getId());
                                CHARACTERISTICS3D_FUNCTIONS.remove(c3di);
                                CHARACTERISTICS3D.get(c3di.getCharacteristic().getId()).getInstances().remove(c3di);
                            } else {
                                ORMCache.loadCharacteristic3DInstance(c3di);
                                Characteristic3D c3d = CHARACTERISTICS3D.get(c3di.getCharacteristic().getId());
                                if (c3d != null) {
                                    c3di.setCharacteristic(c3d);
                                    c3d.getInstances().add(c3di);
                                }
                                changedDependencies.add(c3di);
                            }
                            rebuildDependencyTree = true;
                            continue;
                        }
                        if (object instanceof Characteristic3DInstanceFunctionChanges) {
                            allChanges = (Characteristic3DInstanceFunctionChanges)object;
                            if (((Characteristic3DInstanceFunctionChanges)allChanges).getChanges().length == 0) continue;
                            Characteristic3DInstance c3di = ((Characteristic3DInstanceFunctionChanges)allChanges).getInstance();
                            oldFunctions = CHARACTERISTICS3D_FUNCTIONS.get(c3di);
                            ORMCache.loadCharacteristic3DInstance(c3di);
                            Characteristic3D c3d = CHARACTERISTICS3D.get(c3di.getCharacteristic().getId());
                            if (c3d != null) {
                                c3di.setCharacteristic(c3d);
                                c3d.getInstances().add(c3di);
                            }
                            long minChangeTs = Long.MAX_VALUE;
                            maxChangeTs = Long.MIN_VALUE;
                            characteristic2DFunctionChangeArray = ((Characteristic3DInstanceFunctionChanges)allChanges).getChanges();
                            n2 = characteristic2DFunctionChangeArray.length;
                            n = 0;
                            while (n < n2) {
                                Characteristic2DFunctionChange curveChange = characteristic2DFunctionChangeArray[n];
                                if (curveChange.getFunction() == null || curveChange.getNewBegin() == null) {
                                    removedFrom = curveChange.getOldBegin().toEpochMilli();
                                    minChangeTs = Math.min(removedFrom, minChangeTs);
                                    maxChangeTs = Math.max(removedFrom, maxChangeTs);
                                } else if (curveChange.getOldBegin() == null) {
                                    newFrom = curveChange.getNewBegin().toEpochMilli();
                                    minChangeTs = Math.min(newFrom, minChangeTs);
                                    maxChangeTs = Math.max(newFrom, maxChangeTs);
                                } else {
                                    if (!curveChange.getOldBegin().equals(curveChange.getNewBegin())) {
                                        oldChangeFrom = curveChange.getOldBegin().toEpochMilli();
                                        minChangeTs = Math.min(oldChangeFrom, minChangeTs);
                                        maxChangeTs = Math.max(oldChangeFrom, maxChangeTs);
                                    }
                                    newChangeFrom = curveChange.getNewBegin().toEpochMilli();
                                    minChangeTs = Math.min(newChangeFrom, minChangeTs);
                                    maxChangeTs = Math.max(newChangeFrom, maxChangeTs);
                                }
                                ++n;
                            }
                            maxChangeTsInstant = oldFunctions.getNextFunctionBegin(Instant.ofEpochMilli(maxChangeTs));
                            maxChangeTs = maxChangeTsInstant != null ? maxChangeTsInstant.toEpochMilli() : Long.MAX_VALUE;
                            dependencyValuesChanges.put(c3di, new TsInterval(minChangeTs, maxChangeTs));
                            continue;
                        }
                        if (object instanceof User) {
                            User user = (User)change.getObject();
                            if ((user = (User)em.find(User.class, (Object)user.getId())) == null) {
                                user = (User)change.getObject();
                                USERS.remove(user.getLoginPhrase());
                                AuthenticationDatabase.logout(user);
                                continue;
                            }
                            Integer userId = user.getId();
                            User cachedUser = USERS.values().stream().filter(u -> u.getId() == userId).findAny().orElse(null);
                            String prevLoginPhrase = cachedUser != null ? cachedUser.getLoginPhrase() : null;
                            String newLoginPhrase = user.getLoginPhrase();
                            if (prevLoginPhrase != null) {
                                USERS.remove(prevLoginPhrase);
                            }
                            USERS.put(newLoginPhrase, user);
                            if (prevLoginPhrase == null || newLoginPhrase.equals(prevLoginPhrase)) continue;
                            AuthenticationDatabase.logout(user);
                            continue;
                        }
                        if (object instanceof PropertyGroup) {
                            PropertyGroup group = (PropertyGroup)change.getObject();
                            if ((group = (PropertyGroup)em.find(PropertyGroup.class, (Object)group.getKey())) == null) {
                                group = (PropertyGroup)change.getObject();
                            }
                            changedDependencies.addAll(group.getProperties());
                            rebuildDependencyTree = true;
                            continue;
                        }
                        if (object instanceof Property) {
                            Property property = (Property)change.getObject();
                            if ((property = (Property)em.find(Property.class, (Object)property.getId())) == null) {
                                property = (Property)change.getObject();
                                propertyKeys = new Pair((Object)property.getGroup().getKey(), (Object)property.getKey());
                                HashSet objects = new HashSet(OBSERVED_PROPERTY_VALUES.column((Object)propertyKeys).keySet());
                                objects.forEach(so -> {
                                    Object object = OBSERVED_PROPERTY_VALUES.remove(so, (Object)propertyKeys);
                                });
                                STRUCTURE_OBJECT_PROPERTIES.remove(propertyKeys);
                            } else {
                                ORMCache.loadProperty(property);
                            }
                            changedDependencies.add(property);
                            rebuildDependencyTree = true;
                            continue;
                        }
                        if (object instanceof PropertyValue) {
                            PropertyValue pv = (PropertyValue)change.getObject();
                            propertyKeys = new Pair((Object)pv.getProperty().getGroup().getKey(), (Object)pv.getProperty().getKey());
                            if ((pv = (PropertyValue)em.find(PropertyValue.class, (Object)new PropertyValue(pv.getStructureObject(), pv.getProperty()))) == null || pv.getValue() == null || pv.getValue().isEmpty()) {
                                pv = (PropertyValue)change.getObject();
                                OBSERVED_PROPERTY_VALUES.remove((Object)pv.getStructureObject(), (Object)propertyKeys);
                            } else if (pv.getTypeValue() instanceof MeasuringUnitValue) {
                                OBSERVED_PROPERTY_VALUES.put((Object)pv.getStructureObject(), (Object)propertyKeys, (Object)pv);
                            }
                            changedDependencies.add(pv);
                            continue;
                        }
                        if (object instanceof StructureObject) {
                            StructureObject structureObject = (StructureObject)object;
                            if ((structureObject = (StructureObject)em.find(StructureObject.class, (Object)structureObject.getId())) == null) {
                                HashSet keys = new HashSet(OBSERVED_PROPERTY_VALUES.row((Object)((StructureObject)change.getObject())).keySet());
                                for (Pair key : keys) {
                                    OBSERVED_PROPERTY_VALUES.remove(change.getObject(), (Object)key);
                                }
                            }
                            if (structureObject == null || structureObject.getKey() == null || structureObject.getKey().isEmpty()) {
                                STRUCTURE_OBJECT_KEYS.inverse().remove((Object)structureObject);
                            } else {
                                STRUCTURE_OBJECT_KEYS.inverse().remove((Object)structureObject);
                                STRUCTURE_OBJECT_KEYS.inverse().put((Object)structureObject, (Object)structureObject.getKey());
                            }
                            rebuildDependencyTree = true;
                            continue;
                        }
                        if (object instanceof StructureClass) {
                            rebuildDependencyTree = true;
                            continue;
                        }
                        if (!(object instanceof PhysicalUnitDefinition) && !(object instanceof MeasuringUnitDefinition)) continue;
                        reloadUnits = true;
                    }
                    if (reloadUnits) {
                        PhysicalUnitRegistry.cleadDynamicDefinitions();
                        ORMCache.loadPhysicalUnits(em);
                        ORMCache.loadMeasuringUnits(em);
                    }
                    if (rebuildDependencyTree) {
                        Table<VariableInstance, DependencyKey<?>, Set<Object>> oldDependencies = DEPENDENCY_TREE.getDependencies();
                        DEPENDENCY_TREE = ORMCacheHelper.buildDependencyTree(em, VARIABLE_INSTANCES.values(), (Map<String, Variable>)VARIABLE_NAMES.inverse(), STRUCTURE_OBJECT_KEYS, STRUCTURE_OBJECT_PROPERTIES, (Map<String, Characteristic2D>)CHARACTERISTICS2D_NAMES.inverse(), (Map<String, Characteristic2D>)CHARACTERISTICS2D_KEYS.inverse(), (Map<String, Characteristic3D>)CHARACTERISTICS3D_NAMES.inverse(), (Map<String, Characteristic3D>)CHARACTERISTICS3D_KEYS.inverse());
                        Table<VariableInstance, DependencyKey<?>, Set<Object>> newDependencies = DEPENDENCY_TREE.getDependencies();
                        long beginCompare = System.nanoTime();
                        for (Table.Cell cell : newDependencies.cellSet()) {
                            Set oldDeps;
                            if (changedDepTreeInstances.contains(cell.getRowKey()) || (oldDeps = (Set)oldDependencies.get(cell.getRowKey(), cell.getColumnKey())) != null && oldDeps.size() == ((Set)cell.getValue()).size() && oldDeps.containsAll((Collection)cell.getValue())) continue;
                            changedDepTreeInstances.add((VariableInstance)cell.getRowKey());
                            logger.debug(String.format("Instance dependnencies changed: %s", ((VariableInstance)cell.getRowKey()).getFullName()));
                        }
                        for (Table.Cell cell : oldDependencies.cellSet()) {
                            Set newDeps;
                            if (changedDepTreeInstances.contains(cell.getRowKey()) || (newDeps = (Set)newDependencies.get(cell.getRowKey(), cell.getColumnKey())) != null && newDeps.size() == ((Set)cell.getValue()).size() && newDeps.containsAll((Collection)cell.getValue())) continue;
                            changedDepTreeInstances.add((VariableInstance)cell.getRowKey());
                            logger.debug(String.format("Instance dependnencies changed: %s", ((VariableInstance)cell.getRowKey()).getFullName()));
                        }
                        logger.debug(String.format("ORMCache->compare dependencies: %.2fms", (double)(System.nanoTime() - beginCompare) / 1000000.0));
                    }
                    removedInstances.forEach(i -> MeasurementsPool.removeValues(i));
                    readLock.lock();
                    writeLock.unlock();
                    changedDepTreeInstances.addAll(instancesWithDeprecatedValues);
                    changedDependencies.forEach(dep -> {
                        boolean bl = changedDepTreeInstances.addAll(DEPENDENCY_TREE.getDependendInstances(dep));
                    });
                    changedDepTreeInstances.removeAll(removedInstances);
                    writeLockUnlocked = true;
                    long beginUpdate = System.nanoTime();
                    Server.getRawValuesViews().forAllViews(view -> ORMCache.updateRasterizedValues(view, removedInstances, changedDepTreeInstances, dependencyValuesChanges));
                    logger.debug(String.format("ORMCache->update_computation_stack: %.2fms", (double)(System.nanoTime() - beginUpdate) / 1000000.0));
                }
                catch (Exception exc) {
                    logger.error("Error during ORMCache commit handling", (Throwable)exc);
                    try {
                        if (!writeLockUnlocked) {
                            writeLock.unlock();
                        }
                    }
                    catch (Exception exc2) {
                        logger.error("Error unlockung ORMCache Write Lock", (Throwable)exc2);
                    }
                    try {
                        readLock.unlock();
                    }
                    catch (Exception exc3) {
                        logger.error("Error unlockung ORMCache Read Lock", (Throwable)exc3);
                    }
                    if (em != null) {
                        em.close();
                    }
                    logger.debug(String.format("ORMCache->handleCommit: %.2fms", (double)(System.nanoTime() - begin) / 1000000.0));
                    break block84;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (!writeLockUnlocked) {
                        writeLock.unlock();
                    }
                }
                catch (Exception exc) {
                    logger.error("Error unlockung ORMCache Write Lock", (Throwable)exc);
                }
                try {
                    readLock.unlock();
                }
                catch (Exception exc) {
                    logger.error("Error unlockung ORMCache Read Lock", (Throwable)exc);
                }
                if (em != null) {
                    em.close();
                }
                logger.debug(String.format("ORMCache->handleCommit: %.2fms", (double)(System.nanoTime() - begin) / 1000000.0));
                throw throwable;
            }
            try {
                if (!writeLockUnlocked) {
                    writeLock.unlock();
                }
            }
            catch (Exception exc) {
                logger.error("Error unlockung ORMCache Write Lock", (Throwable)exc);
            }
            try {
                readLock.unlock();
            }
            catch (Exception exc) {
                logger.error("Error unlockung ORMCache Read Lock", (Throwable)exc);
            }
            if (em != null) {
                em.close();
            }
            logger.debug(String.format("ORMCache->handleCommit: %.2fms", (double)(System.nanoTime() - begin) / 1000000.0));
        }
    }

    private static void updateRasterizedValues(RasterizedValues values, Set<VariableInstance> removedDepTreeInstances, Set<VariableInstance> changedDepTreeInstances, Map<Object, TsInterval> dependencyValuesChanges) {
        if (removedDepTreeInstances.isEmpty() && changedDepTreeInstances.isEmpty() && dependencyValuesChanges.isEmpty()) {
            return;
        }
        values.writeLock();
        try {
            if (!removedDepTreeInstances.isEmpty() || !changedDepTreeInstances.isEmpty()) {
                values.updateComputationStack(removedDepTreeInstances, changedDepTreeInstances);
                values.loadPLCValues(changedDepTreeInstances);
            }
            for (Map.Entry<Object, TsInterval> valuesChangedEntry : dependencyValuesChanges.entrySet()) {
                TsInterval interval = valuesChangedEntry.getValue();
                if (values.getComputationBounds() == null || interval.getFromTs() >= values.getComputationBounds().getValuesEndTs()) continue;
                for (VariableInstance dependentInstance : ORMCache.getDependentInstances(valuesChangedEntry.getKey())) {
                    values.markValuesInvalid(dependentInstance, interval.getFromTs(), Math.min(values.getComputationBounds().getValuesEndTs(), interval.getToTs()));
                }
            }
        }
        finally {
            values.writeUnlock();
        }
    }

    private static /* synthetic */ void lambda$2(CallableTask callableTask, Worker.State r, Void a) {
        TaskUtils.removeTaskFromView((CallableTask)callableTask);
    }

    private static /* synthetic */ void lambda$12(BiMap biMap, Map.Entry e) {
        Object object = biMap.put((Object)((String)e.getKey()), (Object)((Variable)e.getValue()));
    }

    private static /* synthetic */ void lambda$13(BiMap biMap, Map.Entry e) {
        Object object = biMap.put((Object)((String)e.getKey()), (Object)((StructureObject)e.getValue()));
    }

    private static /* synthetic */ void lambda$15(BiMap biMap, Map.Entry e) {
        Object object = biMap.put((Object)((String)e.getKey()), (Object)((Characteristic2D)e.getValue()));
    }

    private static /* synthetic */ void lambda$16(BiMap biMap, Map.Entry e) {
        Object object = biMap.put((Object)((String)e.getKey()), (Object)((Characteristic2D)e.getValue()));
    }

    private static /* synthetic */ void lambda$17(BiMap biMap, Map.Entry e) {
        Object object = biMap.put((Object)((String)e.getKey()), (Object)((Characteristic3D)e.getValue()));
    }

    private static /* synthetic */ void lambda$18(BiMap biMap, Map.Entry e) {
        Object object = biMap.put((Object)((String)e.getKey()), (Object)((Characteristic3D)e.getValue()));
    }
}

