/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.cache;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import de.elpro.ewms.core.characteristic.Characteristic2D;
import de.elpro.ewms.core.characteristic.Characteristic2DDescriptor;
import de.elpro.ewms.core.characteristic.Characteristic2DInstance;
import de.elpro.ewms.core.characteristic.Characteristic3D;
import de.elpro.ewms.core.characteristic.Characteristic3DInstance;
import de.elpro.ewms.core.lang.ScriptParser;
import de.elpro.ewms.core.structure.Property;
import de.elpro.ewms.core.structure.PropertyDescriptor;
import de.elpro.ewms.core.structure.PropertyValue;
import de.elpro.ewms.core.structure.SearchPolicy;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.VariableInstanceType;
import de.elpro.ewms.core.variable.calculated.Characteristic2DInstanceReference;
import de.elpro.ewms.core.variable.calculated.Characteristic2DReference;
import de.elpro.ewms.core.variable.calculated.Characteristic3DExtremeLineInstanceReference;
import de.elpro.ewms.core.variable.calculated.Characteristic3DExtremeLineReference;
import de.elpro.ewms.core.variable.calculated.Characteristic3DInstanceReference;
import de.elpro.ewms.core.variable.calculated.Characteristic3DReference;
import de.elpro.ewms.core.variable.calculated.FormulaNode;
import de.elpro.ewms.core.variable.calculated.FormulaNodeType;
import de.elpro.ewms.core.variable.calculated.PropertyInstanceReference;
import de.elpro.ewms.core.variable.calculated.PropertyReference;
import de.elpro.ewms.core.variable.calculated.VariableInstanceReference;
import de.elpro.ewms.core.variable.calculated.VariableReference;
import de.elpro.ewms.core.variable.calculated.dependencies.Characteristic2DDependencyKey;
import de.elpro.ewms.core.variable.calculated.dependencies.Characteristic3DDependencyKey;
import de.elpro.ewms.core.variable.calculated.dependencies.CustomAlgorithmDependencies;
import de.elpro.ewms.core.variable.calculated.dependencies.CustomAlgorithmDependencyKey;
import de.elpro.ewms.core.variable.calculated.dependencies.DependencyKey;
import de.elpro.ewms.core.variable.calculated.dependencies.ExplicitDependencyKey;
import de.elpro.ewms.core.variable.calculated.dependencies.LinkDependencyKey;
import de.elpro.ewms.core.variable.calculated.dependencies.LowerLimitDependencyKey;
import de.elpro.ewms.core.variable.calculated.dependencies.ObjectCharacteristic2DDependencyKey;
import de.elpro.ewms.core.variable.calculated.dependencies.ObjectPropertyDependencyKey;
import de.elpro.ewms.core.variable.calculated.dependencies.PropertyReferenceDependencyKey;
import de.elpro.ewms.core.variable.calculated.dependencies.UpperLimitDependencyKey;
import de.elpro.ewms.core.variable.calculated.dependencies.VariableInstanceExplicitDependency;
import de.elpro.ewms.core.variable.calculated.dependencies.VariableReferenceDependencyKey;
import de.elpro.ewms.core.variable.custom.AlgorithmParameter;
import de.elpro.ewms.server.bundle.Activator;
import de.elpro.ewms.server.cache.DependencyTree;
import de.elpro.ewms.server.calculated.CalculationException;
import de.elpro.ewms.server.calculated.CircleDependencyTreeException;
import de.elpro.ewms.server.custom.CustomAlgorithms;
import de.elpro.ewms.server.helpers.ObjectTreeHelper;
import de.elpro.ewms.server.model.ICustomCalculationAlgorithmFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.SortedSet;
import javafx.util.Pair;
import javax.persistence.EntityManager;
import org.eclipse.fx.core.log.Logger;

class ORMCacheHelper {
    private static Logger logger = Activator.getLoggerFactory().createLogger(ORMCacheHelper.class.getName());

    ORMCacheHelper() {
    }

    public static DependencyTree buildDependencyTree(EntityManager em, Collection<VariableInstance> allInstances, Map<String, Variable> variableNames, Map<String, StructureObject> structureObjectKeys, Map<Pair<String, String>, Property> objectProperties, Map<String, Characteristic2D> characteristic2DNames, Map<String, Characteristic2D> characteristic2DKeys, Map<String, Characteristic3D> characteristic3DNames, Map<String, Characteristic3D> characteristic3DKeys) throws Exception {
        HashBasedTable searchCache = HashBasedTable.create();
        HashSet<VariableInstance> pool = new HashSet<VariableInstance>(allInstances);
        HashSet<VariableInstance> layer = new HashSet<VariableInstance>();
        DependencyTree dependencyTree = new DependencyTree();
        HashMap dependenciesCache = new HashMap();
        int layerLevel = 0;
        while (!pool.isEmpty()) {
            for (VariableInstance instance : pool) {
                Multimap<DependencyKey<?>, Object> dependencies = (Multimap<DependencyKey<?>, Object>)dependenciesCache.get(instance);
                if (dependencies == null) {
                    try {
                        dependencies = ORMCacheHelper.getAndInitDependencies(variableNames, structureObjectKeys, objectProperties, characteristic2DNames, characteristic2DKeys, characteristic3DNames, characteristic3DKeys, (Table<StructureObject, Pair<SearchPolicy, StructureClass>, StructureObject[]>)searchCache, em, instance);
                    }
                    catch (CalculationException e2) {
                        logger.warning(e2.getLocalizedMessage());
                        dependencies = HashMultimap.create();
                    }
                    catch (Exception e3) {
                        logger.error(e3.getLocalizedMessage(), (Throwable)e3);
                        dependencies = HashMultimap.create();
                    }
                    dependenciesCache.put(instance, dependencies);
                }
                boolean canInsert = true;
                for (Object dependency : dependencies.values()) {
                    if (!(dependency instanceof VariableInstance) || !pool.contains(dependency)) continue;
                    canInsert = false;
                    break;
                }
                if (!canInsert) continue;
                dependencyTree.addInstance(instance, layerLevel);
                dependencies.entries().forEach(e -> dependencyTree.addDependency(instance, (DependencyKey)e.getKey(), e.getValue()));
                layer.add(instance);
            }
            if (layer.isEmpty()) {
                throw new CircleDependencyTreeException(pool);
            }
            pool.removeAll(layer);
            layer.clear();
            ++layerLevel;
        }
        return dependencyTree;
    }

    private static Multimap<DependencyKey<?>, Object> getAndInitDependencies(Map<String, Variable> variableNames, Map<String, StructureObject> structureObjectKeys, Map<Pair<String, String>, Property> objectProperties, Map<String, Characteristic2D> characteristic2DNames, Map<String, Characteristic2D> characteristic2DKeys, Map<String, Characteristic3D> characteristic3DNames, Map<String, Characteristic3D> characteristic3DKeys, Table<StructureObject, Pair<SearchPolicy, StructureClass>, StructureObject[]> searchCache, EntityManager em, VariableInstance instance) throws Exception {
        ICustomCalculationAlgorithmFactory algorithmFactory;
        HashMultimap dependencies = HashMultimap.create();
        if (instance.getLowerLimit() != null) {
            dependencies.put((Object)new LowerLimitDependencyKey(), (Object)instance.getLowerLimit());
        }
        if (instance.getUpperLimit() != null) {
            dependencies.put((Object)new UpperLimitDependencyKey(), (Object)instance.getUpperLimit());
        }
        if (instance.getType() == VariableInstanceType.Link && instance.getLink() != null) {
            dependencies.put((Object)new LinkDependencyKey(), (Object)instance.getLink());
        }
        if (instance.getType() == VariableInstanceType.Calculated || instance.getType() == VariableInstanceType.Custom) {
            Object algDescriptor;
            ICustomCalculationAlgorithmFactory algorithmFactory2;
            HashMap<String, Object> dependencyMap = new HashMap<String, Object>();
            if (instance.getType() == VariableInstanceType.Calculated) {
                FormulaNode formula = ScriptParser.parseFormula((String)instance.getResultCalculationFormula());
                if (formula != null) {
                    for (FormulaNode node : formula.findNodes(FormulaNodeType.VariableRef)) {
                        dependencyMap.put(node.getName(), node.getNodeObject());
                    }
                    for (FormulaNode node : formula.findNodes(FormulaNodeType.Characteristic2DRef)) {
                        dependencyMap.put(node.getName(), node.getNodeObject());
                    }
                    for (FormulaNode node : formula.findNodes(FormulaNodeType.Characteristic3DRef)) {
                        dependencyMap.put(node.getName(), node.getNodeObject());
                    }
                    for (FormulaNode node : formula.findNodes(FormulaNodeType.Characteristic3DExtremeLineRef)) {
                        dependencyMap.put(node.getName(), node.getNodeObject());
                    }
                    for (FormulaNode node : formula.findNodes(FormulaNodeType.PropertyRef)) {
                        dependencyMap.put(node.getName(), node.getNodeObject());
                    }
                }
            } else if (instance.getType() == VariableInstanceType.Custom && (algorithmFactory2 = CustomAlgorithms.getAlgorithmFactory(instance.getResultCustomAlgorithmId())) != null && (algDescriptor = algorithmFactory2.getAlgorithmDescriptor()) != null) {
                CustomAlgorithmDependencies varAlgDeps = instance.getVariable().getDefaultCustomAlgorithmDependencies();
                CustomAlgorithmDependencies instanceAlgDeps = instance.getCustomAlgorithmDependencies();
                AlgorithmParameter[] algorithmParameterArray = algDescriptor.getParameters();
                int n = algorithmParameterArray.length;
                int n2 = 0;
                while (n2 < n) {
                    AlgorithmParameter param = algorithmParameterArray[n2];
                    Object dep = null;
                    if (varAlgDeps != null) {
                        dep = varAlgDeps.getDependency(param.getKey());
                    }
                    if (instanceAlgDeps != null && instanceAlgDeps.getDependency(param.getKey()) != null) {
                        dep = instanceAlgDeps.getDependency(param.getKey());
                    }
                    if (dep != null) {
                        dependencyMap.put(param.getKey(), dep);
                    }
                    ++n2;
                }
            }
            ORMCacheHelper.calculateDynamicDependencies(dependencyMap, dependencies, variableNames, structureObjectKeys, objectProperties, characteristic2DNames, characteristic2DKeys, characteristic3DNames, characteristic3DKeys, searchCache, em, instance);
            for (VariableInstanceExplicitDependency dependency : instance.getDependencies()) {
                dependencies.put((Object)new ExplicitDependencyKey(dependency.getKey()), (Object)dependency.getDependentOn());
            }
        }
        if (instance.getType() == VariableInstanceType.Custom && (algorithmFactory = CustomAlgorithms.getAlgorithmFactory(instance.getResultCustomAlgorithmId())) != null) {
            StructureObject object;
            CustomAlgorithmDependencyKey algDependencyKey = new CustomAlgorithmDependencyKey(algorithmFactory.getAlgorithmDescriptor());
            for (VariableInstance dependentOn : algorithmFactory.getDependencyManager().getDependentOn(instance)) {
                dependencies.put((Object)algDependencyKey, (Object)dependentOn);
            }
            for (Map.Entry propertyDependency : algorithmFactory.getDependencyManager().getPropertyDependencies(instance).entries()) {
                object = (StructureObject)em.find(StructureObject.class, (Object)((StructureObject)propertyDependency.getKey()).getId());
                PropertyDescriptor propertyDescriptor = (PropertyDescriptor)propertyDependency.getValue();
                Property property = (Property)em.createQuery("SELECT p FROM Property p, PropertyGroup pg WHERE p.key = :p_key AND p.group = pg AND pg.key = :pg_key", Property.class).setParameter("p_key", (Object)propertyDescriptor.getKey()).setParameter("pg_key", (Object)propertyDescriptor.getPropertyGroupDescriptor().getKey()).getSingleResultOrNull();
                if (property == null) continue;
                ObjectPropertyDependencyKey dependencyKey = new ObjectPropertyDependencyKey(object);
                dependencies.put((Object)dependencyKey, (Object)new PropertyValue(object, property));
            }
            for (Map.Entry characteristic2DDependency : algorithmFactory.getDependencyManager().getCharacteristic2DDependencies(instance).entries()) {
                Characteristic2DInstance c2di;
                object = (StructureObject)characteristic2DDependency.getKey();
                Characteristic2DDescriptor descr = (Characteristic2DDescriptor)characteristic2DDependency.getValue();
                Characteristic2D c2d = characteristic2DKeys.get(descr.getKey());
                if (c2d == null || (c2di = (Characteristic2DInstance)em.createQuery("SELECT c2di FROM Characteristic2DInstance c2di WHERE c2di.structureObject = :object AND c2di.characteristic = :c2d", Characteristic2DInstance.class).setParameter("object", (Object)object).setParameter("c2d", (Object)c2d).getSingleResultOrNull()) == null) continue;
                ObjectCharacteristic2DDependencyKey dependencyKey = new ObjectCharacteristic2DDependencyKey(object, descr.getKey());
                dependencies.put((Object)dependencyKey, (Object)c2di);
            }
        }
        return dependencies;
    }

    private static void calculateDynamicDependencies(Map<String, Object> dependencyMap, Multimap<DependencyKey<?>, Object> dependencies, Map<String, Variable> variableNames, Map<String, StructureObject> structureObjectKeys, Map<Pair<String, String>, Property> objectProperties, Map<String, Characteristic2D> characteristic2DNames, Map<String, Characteristic2D> characteristic2DKeys, Map<String, Characteristic3D> characteristic3DNames, Map<String, Characteristic3D> characteristic3DKeys, Table<StructureObject, Pair<SearchPolicy, StructureClass>, StructureObject[]> searchCache, EntityManager em, VariableInstance instance) throws CalculationException {
        block0: for (Map.Entry<String, Object> dependencyMapEntry : dependencyMap.entrySet()) {
            StructureObject structureObject;
            VariableReferenceDependencyKey dependencyKey;
            StructureObject structureObject22;
            VariableReference ref;
            HashSet<StructureObject> structureObjects;
            String key = dependencyMapEntry.getKey();
            Object obj = dependencyMapEntry.getValue();
            if (obj instanceof VariableReference || obj instanceof VariableInstanceReference) {
                Variable var = null;
                structureObjects = new HashSet<StructureObject>();
                if (obj instanceof VariableReference) {
                    ref = (VariableReference)obj;
                    var = variableNames.get(ref.getVariableName());
                    if (var == null) {
                        throw new CalculationException(String.format("Cannot find variable with name %s for variable instance %s", ref.getVariableName(), instance.getFullName()));
                    }
                    Collections.addAll(structureObjects, ORMCacheHelper.findOverObjectTree(searchCache, em, instance.getStructureObject(), ref.getSearchPolicy(), var.getStructureClass()));
                } else if (obj instanceof VariableInstanceReference) {
                    ref = (VariableInstanceReference)obj;
                    var = variableNames.get(ref.getVariableName());
                    if (var == null) {
                        throw new CalculationException(String.format("Cannot find variable with name %s for variable instance %s", ref.getVariableName(), instance.getFullName()));
                    }
                    structureObject22 = structureObjectKeys.get(ref.getStructureObjectKey());
                    if (structureObject22 != null) {
                        structureObjects.add(structureObject22);
                    } else {
                        throw new CalculationException(String.format("Cannot find structure object with key %s for variable instance %s", ref.getStructureObjectKey(), instance.getFullName()));
                    }
                }
                dependencyKey = new VariableReferenceDependencyKey(key);
                for (VariableInstance varInstance : var.getInstances()) {
                    if (!structureObjects.contains(varInstance.getStructureObject())) continue;
                    dependencies.put((Object)dependencyKey, (Object)varInstance);
                }
                continue;
            }
            if (obj instanceof Characteristic2DReference || obj instanceof Characteristic2DInstanceReference) {
                Characteristic2D c2d;
                structureObject = null;
                if (obj instanceof Characteristic2DReference) {
                    ref = (Characteristic2DReference)obj;
                    c2d = characteristic2DNames.get(ref.getCharacteristicName());
                    if (c2d == null) {
                        throw new CalculationException(String.format("Cannot find characteristic2d with name %s for variable instance %s", ref.getCharacteristicName(), instance.getFullName()));
                    }
                    StructureObject[] objects = ORMCacheHelper.findOverObjectTree(searchCache, em, instance.getStructureObject(), ref.getSearchPolicy(), c2d.getStructureClass());
                    if (objects.length != 1) {
                        throw new CalculationException(String.format("No enclosing characteristic2d instance for instance %s found", instance));
                    }
                    structureObject = objects[0];
                } else {
                    ref = (Characteristic2DInstanceReference)obj;
                    c2d = characteristic2DNames.get(ref.getCharacteristicName());
                    if (c2d == null) {
                        throw new CalculationException(String.format("Cannot find characteristic2d with name %s for variable instance %s", ref.getCharacteristicName(), instance.getFullName()));
                    }
                    structureObject = structureObjectKeys.get(ref.getStructureObjectKey());
                    if (structureObject == null) {
                        throw new CalculationException(String.format("Cannot find structure object with key %s for variable instance %s", ref.getStructureObjectKey(), instance.getFullName()));
                    }
                }
                dependencyKey = new Characteristic2DDependencyKey(key);
                for (Characteristic2DInstance c2dInstance : c2d.getInstances()) {
                    if (!structureObject.equals((Object)c2dInstance.getStructureObject())) continue;
                    dependencies.put((Object)dependencyKey, (Object)c2dInstance);
                    continue block0;
                }
                continue;
            }
            if (obj instanceof Characteristic3DReference || obj instanceof Characteristic3DInstanceReference || obj instanceof Characteristic3DExtremeLineReference || obj instanceof Characteristic3DExtremeLineInstanceReference) {
                Characteristic3D c3d;
                structureObject = null;
                if (obj instanceof Characteristic3DReference || obj instanceof Characteristic3DExtremeLineReference) {
                    SearchPolicy searchPolicy;
                    if (obj instanceof Characteristic3DReference) {
                        ref = (Characteristic3DReference)obj;
                        searchPolicy = ref.getSearchPolicy();
                        characteristicName = ref.getCharacteristicName();
                    } else {
                        ref = (Characteristic3DExtremeLineReference)obj;
                        searchPolicy = ref.getSearchPolicy();
                        characteristicName = ref.getCharacteristicName();
                    }
                    c3d = characteristic3DNames.get(characteristicName);
                    if (c3d == null) {
                        throw new CalculationException(String.format("Cannot find characteristic3d with name %s for variable instance %s", characteristicName, instance.getFullName()));
                    }
                    StructureObject[] objects = ORMCacheHelper.findOverObjectTree(searchCache, em, instance.getStructureObject(), searchPolicy, c3d.getStructureClass());
                    if (objects.length != 1) {
                        throw new CalculationException(String.format("No enclosing characteristic3d instance for instance %s found", instance));
                    }
                    structureObject = objects[0];
                } else {
                    String objectKey;
                    if (obj instanceof Characteristic3DInstanceReference) {
                        ref = (Characteristic3DInstanceReference)obj;
                        objectKey = ref.getStructureObjectKey();
                        characteristicName = ref.getCharacteristicName();
                    } else {
                        ref = (Characteristic3DExtremeLineInstanceReference)obj;
                        objectKey = ref.getStructureObjectKey();
                        characteristicName = ref.getCharacteristicName();
                    }
                    c3d = characteristic3DNames.get(characteristicName);
                    if (c3d == null) {
                        throw new CalculationException(String.format("Cannot find characteristic3d with name %s for variable instance %s", characteristicName, instance.getFullName()));
                    }
                    structureObject = structureObjectKeys.get(objectKey);
                    if (structureObject == null) {
                        throw new CalculationException(String.format("Cannot find structure object with key %s for variable instance %s", objectKey, instance.getFullName()));
                    }
                }
                dependencyKey = new Characteristic3DDependencyKey(key);
                for (Characteristic3DInstance c3dInstance : c3d.getInstances()) {
                    if (!structureObject.equals((Object)c3dInstance.getStructureObject())) continue;
                    dependencies.put((Object)dependencyKey, (Object)c3dInstance);
                    continue block0;
                }
                continue;
            }
            if (obj instanceof PropertyReference || obj instanceof PropertyInstanceReference) {
                Property property = null;
                structureObjects = new HashSet();
                if (obj instanceof PropertyReference) {
                    ref = (PropertyReference)obj;
                    property = objectProperties.get(new Pair((Object)ref.getProperty().getGroup().getKey(), (Object)ref.getProperty().getKey()));
                    if (property == null) {
                        throw new CalculationException(String.format("Cannot find property for reference %s for variable instance %s", ref, instance.getFullName()));
                    }
                    Collections.addAll(structureObjects, ORMCacheHelper.findOverObjectTree(searchCache, em, instance.getStructureObject(), ref.getSearchPolicy(), property.getGroup().getStructureClass()));
                } else if (obj instanceof PropertyInstanceReference) {
                    ref = (PropertyInstanceReference)obj;
                    property = objectProperties.get(new Pair((Object)ref.getProperty().getGroup().getKey(), (Object)ref.getProperty().getKey()));
                    if (property == null) {
                        throw new CalculationException(String.format("Cannot find property for reference %s for variable instance %s", ref, instance.getFullName()));
                    }
                    structureObject22 = structureObjectKeys.get(ref.getStructureObjectKey());
                    if (structureObject22 != null) {
                        structureObjects.add(structureObject22);
                    } else {
                        throw new CalculationException(String.format("Cannot find structure object with key %s for variable instance %s", ref.getStructureObjectKey(), instance.getFullName()));
                    }
                }
                dependencyKey = new PropertyReferenceDependencyKey(key);
                for (StructureObject structureObject22 : structureObjects) {
                    dependencies.put((Object)dependencyKey, (Object)new PropertyValue(structureObject22, property));
                }
                continue;
            }
            throw new CalculationException(String.format("Error computing dynamic dependency %s at instance %s", key, instance.getFullName()));
        }
    }

    private static StructureObject[] findOverObjectTree(Table<StructureObject, Pair<SearchPolicy, StructureClass>, StructureObject[]> searchCache, EntityManager em, StructureObject structureObject, SearchPolicy searchPolicy, StructureClass structureClass) {
        StructureObject[] objects = (StructureObject[])searchCache.get((Object)structureObject, (Object)new Pair((Object)searchPolicy, (Object)structureClass));
        if (objects != null) {
            return objects;
        }
        structureClass = (StructureClass)em.find(StructureClass.class, (Object)structureClass.getId());
        structureObject = (StructureObject)em.find(StructureObject.class, (Object)structureObject.getId());
        SortedSet<StructureObject> sortedObjects = ObjectTreeHelper.findOverObjectTree(em, structureObject, structureClass, searchPolicy);
        objects = sortedObjects.toArray(new StructureObject[0]);
        searchCache.put((Object)structureObject, (Object)new Pair((Object)searchPolicy, (Object)structureClass), (Object)objects);
        return objects;
    }
}

