/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.calculated;

import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.server.calculated.CalculationException;
import java.util.Collection;
import java.util.Collections;

public class CircleDependencyTreeException
extends CalculationException {
    private static final long serialVersionUID = 1049814580815151455L;
    private final Collection<VariableInstance> circleDepTreeInstances;

    public CircleDependencyTreeException(Collection<VariableInstance> circleDepTreeInstances) {
        super("Cannot build dependency tree becouse of dependecy cirle.");
        this.circleDepTreeInstances = Collections.unmodifiableCollection(circleDepTreeInstances);
    }

    public Collection<VariableInstance> getCircleDepTreeInstances() {
        return this.circleDepTreeInstances;
    }

    public String getInternalMessage() {
        String message = "";
        int i = 0;
        for (VariableInstance deadlockInstance : this.circleDepTreeInstances) {
            if (i > 0) {
                message = String.valueOf(message) + ", ";
            }
            if (i > 3) {
                message = String.valueOf(message) + "...";
                break;
            }
            message = String.valueOf(message) + String.format("[%s]", deadlockInstance.getFullName());
            ++i;
        }
        return message;
    }
}

