/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.calculated;

import com.google.common.collect.HashMultimap;
import de.elpro.ewms.core.characteristic.Characteristic2DFunctions;
import de.elpro.ewms.core.characteristic.Characteristic3DFunctions;
import de.elpro.ewms.core.lang.ScriptParser;
import de.elpro.ewms.core.structure.PropertyValue;
import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.time.TsInterval;
import de.elpro.ewms.core.units.MeasuringUnitValue;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.calculated.FormulaNode;
import de.elpro.ewms.core.variable.calculated.FormulaNodeType;
import de.elpro.ewms.core.variable.calculated.FormulaOperation;
import de.elpro.ewms.core.variable.calculated.dependencies.PropertyReferenceDependencyKey;
import de.elpro.ewms.core.variable.calculated.dependencies.VariableInstanceExplicitDependency;
import de.elpro.ewms.core.variable.calculated.dependencies.VariableReferenceDependencyKey;
import de.elpro.ewms.core.variable.value.FastIVarValuesArrayIterable;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.core.variable.value.IVarValueValidator;
import de.elpro.ewms.core.variable.value.IVarValuesCollection;
import de.elpro.ewms.core.variable.value.Plausibility;
import de.elpro.ewms.core.variable.value.ValueSource;
import de.elpro.ewms.core.variable.value.VarValue;
import de.elpro.ewms.server.Server;
import de.elpro.ewms.server.bundle.Activator;
import de.elpro.ewms.server.cache.ORMCache;
import de.elpro.ewms.server.calculated.CalculationException;
import de.elpro.ewms.server.calculated.EmptyFormulaException;
import de.elpro.ewms.server.calculated.FormulaOperationExecutor;
import de.elpro.ewms.server.calculated.FormulaSyntaxFormatException;
import de.elpro.ewms.server.calculated.MissingParameterException;
import de.elpro.ewms.server.model.IComputationBounds;
import de.elpro.ewms.server.model.VariableInstanceValuesValidator;
import de.elpro.ewms.server.rasterizedvalues.IVarValuesCache;
import de.elpro.ewms.server.rasterizedvalues.RasterizedValues;
import de.elpro.ewms.server.statistics.Statistics;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javafx.util.Pair;
import org.eclipse.fx.core.log.Logger;

public class FormulaEvaluator {
    static final String WILDCARD = "WILDCARD";
    static final String RASTER = "RASTER";
    private final Logger logger = Activator.getLoggerFactory().createLogger(FormulaEvaluator.class.getName());
    private final Raster raster;
    private final RasterizedValues varValues;
    private final IVarValuesCache cumulativeValuesCache;

    public FormulaEvaluator(RasterizedValues varValues) {
        this.raster = varValues.getRaster();
        this.varValues = varValues;
        this.cumulativeValuesCache = Server.getVarValuesCacheFactory().create(this.raster);
    }

    public IVarValuesCache getCumulativeValuesCache() {
        return this.cumulativeValuesCache;
    }

    public IVarValuesCollection evaluate(VariableInstance instance, long fromTs, long toTs, IVarValueValidator validator) throws Exception {
        if (fromTs % this.raster.toMilli() != 0L || toTs % this.raster.toMilli() != 0L) {
            throw new IllegalArgumentException("Illegal interval bounds");
        }
        int size = (int)((toTs - fromTs) / this.raster.toMilli());
        if (size <= 0) {
            this.logger.error("Expected array calcualtion result array size is 0 or negative.");
        }
        try {
            String formula = instance.getResultCalculationFormula();
            if (formula == null || formula.isEmpty()) {
                throw new EmptyFormulaException();
            }
            FormulaNode operationTree = ScriptParser.parseFormula((String)formula);
            if (operationTree == null) {
                throw new FormulaSyntaxFormatException();
            }
            if (operationTree.getParameters().size() == 0 && operationTree.getType() == FormulaNodeType.Constant) {
                double value = (Double)operationTree.getNodeObject();
                long firstTimestamp = fromTs + this.raster.toMilli();
                Object firstValue = Double.isNaN(value) ? VarValue.nan((long)firstTimestamp) : new VarValue(firstTimestamp, value, 1.0, ValueSource.Calculated);
                return FormulaEvaluator.createCollectionFromSingleValue(firstValue, size, this.raster.toMilli(), validator);
            }
            HashMap<String, IVarValuesCollection> computationResult = new HashMap<String, IVarValuesCollection>();
            boolean containsCumulativeOperation = operationTree.containsCumulativeOperation();
            Map<String, IVarValue> startValues = null;
            if (containsCumulativeOperation) {
                startValues = this.getCumulativeValues(instance, fromTs);
            }
            TsInterval needInterval = this.getNeedInterval(instance, fromTs, toTs);
            TsInterval resultInterval = new TsInterval(fromTs, toTs);
            Map<String, List<IVarValuesCollection>> parametersValues = this.loadParameterValues(instance, operationTree, needInterval);
            FormulaEvaluator.compute(instance, operationTree, needInterval, parametersValues, computationResult, startValues, this.raster, validator);
            IVarValuesCollection result = (IVarValuesCollection)computationResult.get(operationTree.toString());
            if (containsCumulativeOperation) {
                this.putToComutationResultCache(instance, computationResult, resultInterval);
            }
            int expectedCount = (int)((toTs - fromTs) / this.raster.toMilli());
            IVarValue firstValue = result.getFirst();
            IVarValue lastValue = result.getLast();
            if (firstValue.getEndTimestamp() <= fromTs || lastValue.getEndTimestamp() > toTs) {
                Throwable throwable = null;
                Object var21_27 = null;
                try (IVarValuesCollection filteredCopy = new IVarValuesCollection();){
                    for (IVarValue value : result) {
                        if (fromTs >= value.getEndTimestamp() || value.getEndTimestamp() > toTs) continue;
                        filteredCopy.add(value);
                    }
                    result = filteredCopy;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            if (result.size() != expectedCount) {
                String text = String.format("Computation result for request %s - %s: \r\n", Instant.ofEpochMilli(fromTs), Instant.ofEpochMilli(toTs));
                for (Map.Entry entry : computationResult.entrySet()) {
                    IVarValue[] valsArray = ((IVarValuesCollection)entry.getValue()).toArray();
                    text = String.valueOf(text) + String.format("%s: \t\t\t%s \r\n", entry.getKey(), Arrays.toString(Arrays.copyOf(valsArray, Math.min(valsArray.length, 20))));
                }
                text = String.valueOf(text) + "parameters: \r\n";
                for (Map.Entry<Object, Object> entry : parametersValues.entrySet()) {
                    String values = "";
                    for (IVarValuesCollection va : (List)entry.getValue()) {
                        values = String.valueOf(values) + "[";
                        int counter = 0;
                        for (IVarValue val : va) {
                            values = String.valueOf(values) + val.toString();
                            if (++counter > 20) break;
                            values = String.valueOf(values) + ", ";
                        }
                        values = String.valueOf(values) + "];";
                    }
                    text = String.valueOf(text) + String.format("%s : \t\t\t%s \r\n", entry.getKey(), values);
                }
                this.logger.error("Unexpected result!\r\n" + text);
                throw new Exception(String.format("Result has unexpected size: %d != %d", result.size(), expectedCount));
            }
            return result;
        }
        catch (FormulaSyntaxFormatException formulaSyntaxFormatException) {
            this.logger.warning(String.format("Error computing calculated variable %s / %s with formula = '%s'. FormulaSyntaxException.", ORMCache.getVariableName(instance.getVariable()), instance.getStructureObject(), instance.getResultCalculationFormula()));
            return null;
        }
        catch (MissingParameterException exc) {
            String message = String.format("Cannot compute calculated variable values %s - %s. %s", instance.getVariable(), instance.getStructureObject(), exc.getMessage());
            this.logger.debug(message);
            return null;
        }
        catch (CalculationException exc) {
            String message = String.format("Cannot compute calculated variable values %s - %s. %s", instance.getVariable(), instance.getStructureObject(), exc.getMessage());
            this.logger.info(message);
            return null;
        }
    }

    private Map<String, List<IVarValuesCollection>> loadParameterValues(VariableInstance instance, FormulaNode operationTree, TsInterval needInterval) throws CalculationException {
        Collection<Object> abstractDependencies;
        HashMap<String, List<IVarValuesCollection>> parameterValues = new HashMap<String, List<IVarValuesCollection>>();
        Collection needDepKeys = operationTree.getLeafParameters();
        for (VariableInstanceExplicitDependency dep : instance.getCachedDependencies()) {
            if (dep.getKey() == null) continue;
            needDepKeys.remove(dep.getKey());
        }
        if (!needDepKeys.isEmpty()) {
            throw new CalculationException(String.format("Missing calculations parameters %s", Arrays.toString(needDepKeys.toArray(new String[0]))));
        }
        HashMultimap allNeedInstances = HashMultimap.create();
        for (VariableInstanceExplicitDependency dependency : instance.getCachedDependencies()) {
            String key = dependency.getKey() == null ? WILDCARD : dependency.getKey();
            allNeedInstances.put((Object)key, (Object)dependency.getDependentOn());
        }
        for (FormulaNode node : operationTree.findNodes(FormulaNodeType.VariableRef)) {
            abstractDependencies = ORMCache.getDependencies(instance, new VariableReferenceDependencyKey(node.getName()));
            if (abstractDependencies == null) continue;
            for (Object o : abstractDependencies) {
                allNeedInstances.put((Object)node.getName(), (Object)((VariableInstance)o));
            }
        }
        for (FormulaNode node : operationTree.findNodes(FormulaNodeType.PropertyRef)) {
            abstractDependencies = ORMCache.getDependencies(instance, new PropertyReferenceDependencyKey(node.getName()));
            if (abstractDependencies == null) continue;
            ArrayList<IVarValuesCollection> values = new ArrayList<IVarValuesCollection>(abstractDependencies.size());
            for (Object o : abstractDependencies) {
                PropertyValue pv = (PropertyValue)o;
                double pvValue = Double.NaN;
                try {
                    MeasuringUnitValue value = (MeasuringUnitValue)pv.getTypeValue();
                    if (value != null) {
                        pvValue = value.getValue();
                    }
                }
                catch (Exception exception) {}
                int propertyValuesSize = (int)((needInterval.getToTs() - needInterval.getFromTs()) / this.raster.toMilli());
                Object firstValue = Double.isFinite(pvValue) ? new VarValue(needInterval.getFromTs() + this.raster.toMilli(), pvValue, 1.0, ValueSource.ObjectParameter) : VarValue.nan((long)(needInterval.getFromTs() + this.raster.toMilli()));
                IVarValuesCollection propertyValues = IVarValuesCollection.create((IVarValue)firstValue, (int)propertyValuesSize, (long)this.raster.toMilli());
                values.add(propertyValues);
            }
            parameterValues.put(node.getName(), values);
        }
        VariableInstance[] flatDepInstances = allNeedInstances.values().toArray(new VariableInstance[0]);
        HashMap<VariableInstance, Integer> instanceIndexes = new HashMap<VariableInstance, Integer>();
        int i = 0;
        while (i < flatDepInstances.length) {
            instanceIndexes.put(flatDepInstances[i], i);
            ++i;
        }
        IVarValuesCollection[] flatParameterValues = new IVarValuesCollection[allNeedInstances.size()];
        long ts = System.nanoTime();
        flatParameterValues = this.varValues.getValues(flatDepInstances, Instant.ofEpochMilli(needInterval.getFromTs()), Instant.ofEpochMilli(needInterval.getToTs()));
        long ramCacheReadDuration = System.nanoTime() - ts;
        long size = (needInterval.getToTs() - needInterval.getFromTs()) / this.raster.toMilli();
        Statistics.RAM_CACHE_READ.increment(ramCacheReadDuration, (long)flatParameterValues.length * size);
        Statistics.CALCULATED.increment(-ramCacheReadDuration, size);
        for (String key : allNeedInstances.keySet()) {
            Collection instances = allNeedInstances.get((Object)key);
            ArrayList<IVarValuesCollection> values = new ArrayList<IVarValuesCollection>(instances.size());
            for (VariableInstance depInst : instances) {
                int index = (Integer)instanceIndexes.get(depInst);
                values.add(flatParameterValues[index]);
            }
            parameterValues.put(key, values);
        }
        return parameterValues;
    }

    private static boolean isCumulativeOperation(FormulaNode operationNode) {
        Object formulaOperationObj = operationNode.getNodeObject();
        if (formulaOperationObj instanceof FormulaOperation) {
            FormulaOperation op = (FormulaOperation)formulaOperationObj;
            return switch (op) {
                case FormulaOperation.ReBound, FormulaOperation.IntegralKum, FormulaOperation.SumKum, FormulaOperation.WindowCounter -> true;
                default -> false;
            };
        }
        return false;
    }

    private void putToComutationResultCache(VariableInstance instance, Map<String, IVarValuesCollection> computationResult, TsInterval resultInterval) {
        for (String opStr : computationResult.keySet()) {
            FormulaNode operationNode = ScriptParser.parseFormula((String)opStr);
            if (!FormulaEvaluator.isCumulativeOperation(operationNode)) continue;
            LinkedList<String> operations = new LinkedList<String>();
            operations.add(opStr.toString());
            for (FormulaNode param : operationNode.getParameters()) {
                operations.add(param.toString());
            }
            for (String operation : operations) {
                IVarValuesCollection values = computationResult.get(operation);
                Throwable throwable = null;
                Object var12_13 = null;
                try (IVarValuesCollection filteredCopy = new IVarValuesCollection();){
                    for (IVarValue value : values) {
                        if (resultInterval.getFromTs() >= value.getEndTimestamp() || value.getEndTimestamp() > resultInterval.getToTs()) continue;
                        filteredCopy.add(value);
                    }
                    values = filteredCopy;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                this.cumulativeValuesCache.push(instance, operation, values);
            }
        }
    }

    private Map<String, IVarValue> getCumulativeValues(VariableInstance instance, long fromTs) throws Exception {
        HashMap<String, IVarValue> result = new HashMap<String, IVarValue>();
        for (String operation : this.cumulativeValuesCache.getKeys(instance)) {
            try {
                IVarValuesCollection values = this.cumulativeValuesCache.get(instance, operation, fromTs - this.raster.toMilli(), fromTs);
                result.put(operation, values.getFirst());
            }
            catch (NoSuchElementException exc) {
                this.logger.warning("Missing cumulative value.", (Throwable)exc);
            }
        }
        return result;
    }

    public static TsInterval getDependentInterval(VariableInstance instance, long depChangedFrom, long depChangedTo, IComputationBounds bounds, Raster raster) {
        int intervals;
        String widthStr;
        String rasterStr;
        int width;
        Raster vRaster;
        Pair<Integer, Integer> movingWidth;
        long from = depChangedFrom;
        long to = depChangedTo;
        String formula = instance.getResultCalculationFormula();
        FormulaNode operationTree = ScriptParser.parseFormula((String)formula);
        if (operationTree == null) {
            return new TsInterval(from, to);
        }
        if (operationTree.containsCumulativeOperation()) {
            to = Math.max(to, bounds.getValuesEndTs());
        }
        for (FormulaNode maNode : operationTree.findNodes(new FormulaOperation[]{FormulaOperation.MovingAverage})) {
            movingWidth = FormulaOperationExecutor.getMovingOperationIntervals(maNode.getOperationParameters());
            from = Math.min(from, depChangedFrom - raster.toMilli() * (long)((Integer)movingWidth.getKey()).intValue());
            to = Math.max(to, depChangedTo + raster.toMilli() * (long)((Integer)movingWidth.getValue()).intValue());
        }
        for (FormulaNode maNode : operationTree.findNodes(new FormulaOperation[]{FormulaOperation.MovingMedian})) {
            movingWidth = FormulaOperationExecutor.getMovingOperationIntervals(maNode.getOperationParameters());
            from = Math.min(from, depChangedFrom - raster.toMilli() * (long)((Integer)movingWidth.getKey()).intValue());
            to = Math.max(to, depChangedTo + raster.toMilli() * (long)((Integer)movingWidth.getValue()).intValue());
        }
        if (operationTree.containsOperation(FormulaOperation.Delta) || operationTree.containsOperation(FormulaOperation.Differential) || operationTree.containsOperation(FormulaOperation.PrevValue)) {
            to = Math.max(to, depChangedTo + raster.toMilli());
        }
        if (operationTree.containsOperation(FormulaOperation.NextValue)) {
            from = Math.min(from, depChangedFrom - raster.toMilli());
        }
        for (FormulaNode lvNode : operationTree.findNodes(new FormulaOperation[]{FormulaOperation.LastValid, FormulaOperation.PrevValid})) {
            vRaster = raster;
            width = 1;
            rasterStr = (String)lvNode.getOperationParameters().get("Raster");
            widthStr = (String)lvNode.getOperationParameters().get("Width");
            try {
                vRaster = Raster.valueOf((String)rasterStr);
            }
            catch (Exception exception) {}
            try {
                width = Integer.parseInt(widthStr);
            }
            catch (Exception exception) {}
            intervals = (int)(vRaster.toMilli() * (long)width / raster.toMilli()) - 1;
            if (intervals <= 0) continue;
            to = Math.max(to, depChangedTo + raster.toMilli() * (long)intervals);
        }
        for (FormulaNode lvNode : operationTree.findNodes(new FormulaOperation[]{FormulaOperation.NextValid})) {
            vRaster = raster;
            width = 1;
            rasterStr = (String)lvNode.getOperationParameters().get("Raster");
            widthStr = (String)lvNode.getOperationParameters().get("Width");
            try {
                vRaster = Raster.valueOf((String)rasterStr);
            }
            catch (Exception exception) {}
            try {
                width = Integer.parseInt(widthStr);
            }
            catch (Exception exception) {}
            intervals = (int)(vRaster.toMilli() * (long)width / raster.toMilli()) - 1;
            if (intervals <= 0) continue;
            from = Math.min(from, depChangedFrom - raster.toMilli() * (long)intervals);
        }
        return new TsInterval(Math.max(bounds.getValuesStartTs(), from), Math.min(to, bounds.getValuesEndTs()));
    }

    private TsInterval getNeedInterval(VariableInstance instance, long sourceFrom, long sourceTo) {
        int intervals;
        String widthStr;
        String rasterStr;
        int width;
        Raster vRaster;
        Pair<Integer, Integer> movingWidth;
        long from = sourceFrom;
        long to = sourceTo;
        String formula = instance.getResultCalculationFormula();
        FormulaNode operationTree = ScriptParser.parseFormula((String)formula);
        for (FormulaNode maNode : operationTree.findNodes(new FormulaOperation[]{FormulaOperation.MovingAverage})) {
            movingWidth = FormulaOperationExecutor.getMovingOperationIntervals(maNode.getOperationParameters());
            from = Math.min(from, sourceFrom - this.raster.toMilli() * (long)((Integer)movingWidth.getKey()).intValue());
            to = Math.max(to, sourceTo + this.raster.toMilli() * (long)((Integer)movingWidth.getValue()).intValue());
        }
        for (FormulaNode maNode : operationTree.findNodes(new FormulaOperation[]{FormulaOperation.MovingMedian})) {
            movingWidth = FormulaOperationExecutor.getMovingOperationIntervals(maNode.getOperationParameters());
            from = Math.min(from, sourceFrom - this.raster.toMilli() * (long)((Integer)movingWidth.getKey()).intValue());
            to = Math.max(to, sourceTo + this.raster.toMilli() * (long)((Integer)movingWidth.getValue()).intValue());
        }
        if (operationTree.containsOperation(FormulaOperation.Delta) || operationTree.containsOperation(FormulaOperation.Differential) || operationTree.containsOperation(FormulaOperation.PrevValue)) {
            from = Math.min(from, sourceFrom - this.raster.toMilli());
        }
        if (operationTree.containsOperation(FormulaOperation.NextValue)) {
            to = Math.max(to, sourceTo + this.raster.toMilli());
        }
        for (FormulaNode lvNode : operationTree.findNodes(new FormulaOperation[]{FormulaOperation.LastValid, FormulaOperation.PrevValid})) {
            vRaster = this.raster;
            width = 1;
            rasterStr = (String)lvNode.getOperationParameters().get("Raster");
            widthStr = (String)lvNode.getOperationParameters().get("Width");
            try {
                vRaster = Raster.valueOf((String)rasterStr);
            }
            catch (Exception exception) {}
            try {
                width = Integer.parseInt(widthStr);
            }
            catch (Exception exception) {}
            intervals = (int)(vRaster.toMilli() * (long)width / this.raster.toMilli()) - 1;
            if (intervals <= 0) continue;
            from = Math.min(from, sourceFrom - this.raster.toMilli() * (long)intervals);
        }
        for (FormulaNode lvNode : operationTree.findNodes(new FormulaOperation[]{FormulaOperation.NextValid})) {
            vRaster = this.raster;
            width = 1;
            rasterStr = (String)lvNode.getOperationParameters().get("Raster");
            widthStr = (String)lvNode.getOperationParameters().get("Width");
            try {
                vRaster = Raster.valueOf((String)rasterStr);
            }
            catch (Exception exception) {}
            try {
                width = Integer.parseInt(widthStr);
            }
            catch (Exception exception) {}
            intervals = (int)(vRaster.toMilli() * (long)width / this.raster.toMilli()) - 1;
            if (intervals <= 0) continue;
            to = Math.max(to, sourceTo + this.raster.toMilli() * (long)intervals);
        }
        return new TsInterval(Math.min(sourceFrom, Math.max(this.varValues.getComputationBounds().getValuesStartTs(), from)), Math.min(to, this.varValues.getComputationBounds().getValuesEndTs()));
    }

    public static IVarValuesCollection compute(FormulaNode node, TsInterval interval, Map<String, List<IVarValuesCollection>> parameters, Raster raster) throws Exception {
        HashMap<String, IVarValuesCollection> computationResult = new HashMap<String, IVarValuesCollection>();
        FormulaEvaluator.compute(null, node, interval, parameters, computationResult, null, raster, null);
        return (IVarValuesCollection)computationResult.get(node.toString());
    }

    private static void compute(VariableInstance instance, FormulaNode node, TsInterval interval, Map<String, List<IVarValuesCollection>> parameters, Map<String, IVarValuesCollection> computationResult, Map<String, IVarValue> startValues, Raster raster, IVarValueValidator validator) throws Exception {
        IVarValuesCollection result = computationResult.get(node.toString());
        if (result != null) {
            return;
        }
        FormulaNodeType type = node.getType();
        switch (type) {
            case Constant: {
                FormulaEvaluator.computeConstantValues(node, interval, computationResult, raster, validator);
                break;
            }
            case Operation: {
                FormulaEvaluator.computeFunctionOperationValues(instance, node, interval, parameters, computationResult, startValues, raster, validator);
                break;
            }
            case Parameter: {
                FormulaEvaluator.computeParameterValues(node, parameters, computationResult, validator);
                break;
            }
            case VariableRef: {
                FormulaEvaluator.computeVariableRefValues(node, parameters, computationResult, validator);
                break;
            }
            case Characteristic2DRef: {
                FormulaEvaluator.computeCharacteristic2DValues(instance, node, interval, parameters, computationResult, startValues, raster, validator);
                break;
            }
            case Characteristic3DRef: {
                FormulaEvaluator.computeCharacteristic3DValues(instance, node, interval, parameters, computationResult, startValues, raster, validator);
                break;
            }
            case Characteristic3DExtremeLineRef: {
                FormulaEvaluator.computeCharacteristic3DExtremeLineValues(instance, node, interval, parameters, computationResult, startValues, raster, validator);
                break;
            }
            case PropertyRef: {
                FormulaEvaluator.computePropertyRefValues(node, parameters, computationResult);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    private static void computeConstantValues(FormulaNode node, TsInterval interval, Map<String, IVarValuesCollection> computationResult, Raster raster, IVarValueValidator validator) {
        int size = (int)((interval.getToTs() - interval.getFromTs()) / raster.toMilli());
        Object nodeObj = node.getNodeObject();
        double constantValue = RASTER.equals(nodeObj) ? (double)raster.toMilli() : (Double)nodeObj;
        long timestamp = interval.getFromTs() + raster.toMilli();
        Object firstValue = Double.isFinite(constantValue) ? new VarValue(timestamp, constantValue, 1.0, Plausibility.Ok, ValueSource.Calculated) : VarValue.nan((long)timestamp);
        IVarValuesCollection result = FormulaEvaluator.createCollectionFromSingleValue(firstValue, size, raster.toMilli(), validator);
        computationResult.put(node.toString(), result);
    }

    private static void computeFunctionOperationValues(VariableInstance instance, FormulaNode node, TsInterval interval, Map<String, List<IVarValuesCollection>> parameters, Map<String, IVarValuesCollection> computationResult, Map<String, IVarValue> startValues, Raster raster, IVarValueValidator validator) throws MissingParameterException, Exception {
        boolean optionalParams = node.getOperationParameters().getOrDefault("OptionalParams", "false").toLowerCase().equals("true");
        FormulaOperation operation = (FormulaOperation)node.getNodeValue();
        IVarValuesCollection[] nodeParameters = null;
        if (node.getParameters().isEmpty()) {
            LinkedList<IVarValuesCollection> allParameters = new LinkedList<IVarValuesCollection>();
            for (List<IVarValuesCollection> p : parameters.values()) {
                for (IVarValuesCollection values : p) {
                    allParameters.add(values);
                }
            }
            nodeParameters = allParameters.toArray(new IVarValuesCollection[0]);
        } else {
            LinkedList<IVarValuesCollection> parametersList = new LinkedList<IVarValuesCollection>();
            int i = 0;
            while (i < node.getParameters().size()) {
                FormulaNode parameterNode = (FormulaNode)node.getParameters().get(i);
                FormulaNodeType parameterType = parameterNode.getType();
                if (parameterType == FormulaNodeType.Parameter || parameterType == FormulaNodeType.VariableRef) {
                    paramValues = parameters.get(parameterNode.getName());
                    if (paramValues == null || paramValues.size() == 0) {
                        if (!optionalParams) {
                            throw new MissingParameterException(parameterNode.toString());
                        }
                    } else {
                        if (paramValues.size() == 1) {
                            computationResult.put(parameterNode.getName(), paramValues.get(0));
                        }
                        parametersList.addAll(paramValues);
                    }
                } else if (parameterType == FormulaNodeType.PropertyRef) {
                    paramValues = parameters.get(parameterNode.getName());
                    if (paramValues == null) {
                        throw new MissingParameterException(parameterNode.toString());
                    }
                    if (paramValues.size() == 1) {
                        computationResult.put(parameterNode.getName(), paramValues.get(0));
                    }
                    parametersList.addAll(paramValues);
                } else {
                    FormulaEvaluator.compute(instance, parameterNode, interval, parameters, computationResult, startValues, raster, null);
                    parametersList.add(computationResult.get(parameterNode.toString()));
                }
                ++i;
            }
            if (parametersList.isEmpty() && optionalParams) {
                int size = (int)((interval.getToTs() - interval.getFromTs()) / raster.toMilli());
                IVarValue firstValue = VarValue.nan((long)(interval.getFromTs() + raster.toMilli()));
                IVarValuesCollection nanValues = FormulaEvaluator.createCollectionFromSingleValue(firstValue, size, raster.toMilli(), validator);
                parametersList.add(nanValues);
            }
            nodeParameters = parametersList.toArray(new IVarValuesCollection[0]);
        }
        IVarValue startValue = null;
        IVarValue[] startParameters = null;
        if (startValues != null && FormulaEvaluator.isCumulativeOperation(node)) {
            startValue = startValues.get(node.toString());
            startParameters = new IVarValue[node.getParameters().size()];
            int i = 0;
            while (i < startParameters.length) {
                IVarValue startParameter;
                startParameters[i] = startParameter = startValues.get(((FormulaNode)node.getParameters().get(i)).toString());
                ++i;
            }
        }
        IVarValuesCollection result = FormulaOperationExecutor.executeOperation(operation, nodeParameters, node.getOperationParameters(), startValue, startParameters, raster, validator);
        computationResult.put(node.toString(), result);
    }

    private static void computeParameterValues(FormulaNode node, Map<String, List<IVarValuesCollection>> parameters, Map<String, IVarValuesCollection> computationResult, IVarValueValidator validator) throws CalculationException {
        String parameterName = (String)node.getNodeValue();
        List<IVarValuesCollection> paramValues = parameters.get(parameterName);
        if (paramValues == null || paramValues.size() != 1) {
            throw new CalculationException("Empty or aggregation Parameter");
        }
        IVarValuesCollection values = paramValues.get(0);
        if (validator != null) {
            Throwable throwable = null;
            Object var8_9 = null;
            try (IVarValuesCollection validatedValues = new IVarValuesCollection(validator);){
                validatedValues.addAll((Collection)values);
                values = validatedValues;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        computationResult.put(parameterName, values);
    }

    private static void computeVariableRefValues(FormulaNode node, Map<String, List<IVarValuesCollection>> parameters, Map<String, IVarValuesCollection> computationResult, IVarValueValidator validator) throws CalculationException {
        List<IVarValuesCollection> paramValues = parameters.get(node.getName());
        if (paramValues == null || paramValues.size() != 1) {
            throw new CalculationException("Empty or aggregation Parameter");
        }
        IVarValuesCollection values = paramValues.get(0);
        if (validator != null) {
            Throwable throwable = null;
            Object var7_8 = null;
            try (IVarValuesCollection validatedValues = new IVarValuesCollection(validator);){
                validatedValues.addAll((Collection)values);
                values = validatedValues;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        computationResult.put(node.getName(), values);
    }

    private static void computeCharacteristic2DValues(VariableInstance instance, FormulaNode node, TsInterval interval, Map<String, List<IVarValuesCollection>> parameters, Map<String, IVarValuesCollection> computationResult, Map<String, IVarValue> startValues, Raster raster, IVarValueValidator validator) throws CalculationException, Exception {
        if (node.getParameters().size() != 1) {
            throw new CalculationException("Exactly one parameter expected for characteristic2d");
        }
        Characteristic2DFunctions curvePoints = ORMCache.getCurvePoints(instance, node.getName());
        if (curvePoints == null) {
            throw new CalculationException(String.format("Characteristic 2D Curve not found for %s", node.getName()));
        }
        FormulaNode parameterNode = (FormulaNode)node.getParameters().get(0);
        IVarValuesCollection inputValues = FormulaEvaluator.calculateParameterNode(parameterNode, instance, interval, parameters, computationResult, startValues, raster, validator);
        Throwable throwable = null;
        Object var12_13 = null;
        try (IVarValuesCollection result = new IVarValuesCollection();){
            for (IVarValue input : inputValues) {
                result.add(curvePoints.getOutput(input));
            }
            computationResult.put(node.toString(), result);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void computeCharacteristic3DValues(VariableInstance instance, FormulaNode node, TsInterval interval, Map<String, List<IVarValuesCollection>> parameters, Map<String, IVarValuesCollection> computationResult, Map<String, IVarValue> startValues, Raster raster, IVarValueValidator validator) throws CalculationException, Exception {
        if (node.getParameters().size() != 2) {
            throw new CalculationException("Exactly two parameters expected for characteristic3d");
        }
        Characteristic3DFunctions functions = ORMCache.getCharacteristicFunctions(instance, node.getName());
        if (functions == null) {
            throw new CalculationException(String.format("Characteristic 3D functions not found for %s", node.getName()));
        }
        if (functions.isEmpty()) {
            computationResult.put(node.toString(), IVarValuesCollection.createNaN((long)interval.getFromTs(), (long)interval.getToTs(), (Raster)raster));
            return;
        }
        boolean outputZAxis = true;
        String zwSelector = (String)node.getOperationParameters().get("OutputAxis");
        if (zwSelector != null && (zwSelector.equals("1") || zwSelector.equals("w"))) {
            outputZAxis = false;
        }
        FormulaNode xAxisInputParameterNode = (FormulaNode)node.getParameters().get(0);
        FormulaNode yAxisInputParameterNode = (FormulaNode)node.getParameters().get(1);
        IVarValuesCollection xAxisInputValues = FormulaEvaluator.calculateParameterNode(xAxisInputParameterNode, instance, interval, parameters, computationResult, startValues, raster, validator);
        IVarValuesCollection yAxisInputValues = FormulaEvaluator.calculateParameterNode(yAxisInputParameterNode, instance, interval, parameters, computationResult, startValues, raster, validator);
        Throwable throwable = null;
        Object var16_17 = null;
        try (IVarValuesCollection result = new IVarValuesCollection();){
            for (IVarValue[] inputs : new FastIVarValuesArrayIterable(new IVarValuesCollection[]{xAxisInputValues, yAxisInputValues})) {
                result.add(functions.getOutput(inputs[0], inputs[1], outputZAxis));
            }
            computationResult.put(node.toString(), result);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void computeCharacteristic3DExtremeLineValues(VariableInstance instance, FormulaNode node, TsInterval interval, Map<String, List<IVarValuesCollection>> parameters, Map<String, IVarValuesCollection> computationResult, Map<String, IVarValue> startValues, Raster raster, IVarValueValidator validator) throws CalculationException, Exception {
        if (node.getParameters().size() != 1) {
            throw new CalculationException("Exactly one parameter expected for characteristic3d");
        }
        Characteristic3DFunctions functions = ORMCache.getCharacteristicFunctions(instance, node.getName());
        if (functions == null) {
            throw new CalculationException(String.format("Characteristic 3D functions not found for %s", node.getName()));
        }
        if (functions.isEmpty()) {
            computationResult.put(node.toString(), IVarValuesCollection.createNaN((long)interval.getFromTs(), (long)interval.getToTs(), (Raster)raster));
            return;
        }
        boolean getX = true;
        String xySelector = (String)node.getOperationParameters().get("OutputAxis");
        if (xySelector != null && xySelector.equals("y")) {
            getX = false;
        }
        boolean searchForMinumum = node.getOperationParameters().containsKey("Minimize");
        boolean overZ = true;
        String zwSelector = (String)node.getOperationParameters().get("ReferenceAxis");
        if (zwSelector != null && zwSelector.equals("w")) {
            overZ = false;
        }
        FormulaNode xAxisInputParameterNode = (FormulaNode)node.getParameters().get(0);
        IVarValuesCollection inputValues = FormulaEvaluator.calculateParameterNode(xAxisInputParameterNode, instance, interval, parameters, computationResult, startValues, raster, validator);
        Throwable throwable = null;
        Object var17_18 = null;
        try (IVarValuesCollection result = new IVarValuesCollection();){
            for (IVarValue input : inputValues) {
                IVarValue output = functions.getExtremePoint(input, getX, searchForMinumum, overZ);
                result.add(output);
            }
            computationResult.put(node.toString(), result);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void computePropertyRefValues(FormulaNode node, Map<String, List<IVarValuesCollection>> parameters, Map<String, IVarValuesCollection> computationResult) throws MissingParameterException, CalculationException {
        List<IVarValuesCollection> paramValues = parameters.get(node.getName());
        if (paramValues == null) {
            throw new MissingParameterException(node.toString());
        }
        if (paramValues == null || paramValues.size() != 1) {
            throw new CalculationException(String.format("No Property Value for %s found", node.getName()));
        }
        computationResult.put(node.getName(), paramValues.get(0));
    }

    private static IVarValuesCollection calculateParameterNode(FormulaNode parameterNode, VariableInstance instance, TsInterval interval, Map<String, List<IVarValuesCollection>> parameters, Map<String, IVarValuesCollection> computationResult, Map<String, IVarValue> startValues, Raster raster, IVarValueValidator validator) throws Exception {
        IVarValuesCollection result;
        FormulaNodeType parameterType = parameterNode.getType();
        if (parameterType == FormulaNodeType.Parameter || parameterType == FormulaNodeType.VariableRef) {
            List<IVarValuesCollection> paramValues = parameters.get(parameterNode.getName());
            if (paramValues == null || paramValues.size() == 0) {
                throw new MissingParameterException(parameterNode.toString());
            }
            if (paramValues.size() != 1) {
                throw new MissingParameterException("Not a unique parameter for characteristic3d ");
            }
            computationResult.put(parameterNode.getName(), paramValues.get(0));
            result = paramValues.get(0);
        } else {
            FormulaEvaluator.compute(instance, parameterNode, interval, parameters, computationResult, startValues, raster, null);
            result = computationResult.get(parameterNode.toString());
        }
        return result;
    }

    private static IVarValuesCollection createCollectionFromSingleValue(IVarValue firstValue, int size, long timeDelta, IVarValueValidator validator) {
        if (validator == null || validator instanceof VariableInstanceValuesValidator) {
            if (validator != null) {
                firstValue = validator.validate(firstValue);
            }
            return IVarValuesCollection.create((IVarValue)firstValue, (int)size, (long)timeDelta);
        }
        Throwable throwable = null;
        Object var6_6 = null;
        try (IVarValuesCollection collection = new IVarValuesCollection(validator);){
            int i = 0;
            while (i < size) {
                collection.add(firstValue.copyWithTimeShift((long)i * timeDelta));
                ++i;
            }
            return collection;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

