/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.calculated;

import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.variable.calculated.FormulaOperation;
import de.elpro.ewms.core.variable.value.FastIVarValuesArrayIterable;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.core.variable.value.IVarValueValidator;
import de.elpro.ewms.core.variable.value.IVarValuesCollection;
import de.elpro.ewms.core.variable.value.Plausibility;
import de.elpro.ewms.core.variable.value.ValueSource;
import de.elpro.ewms.core.variable.value.VarValue;
import de.elpro.ewms.core.virtualtime.VirtualRaster;
import de.elpro.ewms.core.virtualtime.VirtualZone;
import de.elpro.ewms.server.Server;
import de.elpro.ewms.server.calculated.CalculationException;
import de.elpro.ewms.server.storage.ArchiveStorages;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.TreeMap;
import javafx.util.Pair;

public class FormulaOperationExecutor {
    public static IVarValuesCollection executeOperation(FormulaOperation operation, IVarValuesCollection[] parameters, TreeMap<String, String> operationParameters, IVarValue startValue, IVarValue[] startParameters, Raster raster, IVarValueValidator validator) throws Exception {
        if (parameters.length == 0) {
            throw new CalculationException("Keine Parameternwerte \u00fcbergeben");
        }
        if (parameters[0] == null) {
            throw new CalculationException("Parametern nicht inizialisiert");
        }
        Throwable throwable = null;
        Object var8_9 = null;
        try (IVarValuesCollection result = new IVarValuesCollection(validator);){
            switch (operation) {
                case Abs: {
                    FormulaOperationExecutor.performOperation_Abs(result, parameters, operationParameters, startValue, startParameters, raster);
                    break;
                }
                case BitAnd: {
                    FormulaOperationExecutor.performOperation_BitAnd(result, parameters, operationParameters, startValue, startParameters, raster);
                    break;
                }
                case BitOr: {
                    FormulaOperationExecutor.performOperation_BitOr(result, parameters, operationParameters, startValue, startParameters, raster);
                    break;
                }
                case Ceil: 
                case Floor: {
                    FormulaOperationExecutor.performOperation_Ceil_Floor(operation, result, parameters, operationParameters, startValue, startParameters, raster);
                    break;
                }
                case Quality: {
                    FormulaOperationExecutor.performOperation_Quality(result, parameters, operationParameters, startValue, startParameters, raster);
                    break;
                }
                case And: 
                case Or: {
                    FormulaOperationExecutor.performOperation_And_Or(operation, result, parameters, operationParameters, startValue, startParameters, raster);
                    break;
                }
                case EndTimestamp: {
                    FormulaOperationExecutor.performOperation_EndTimestamp(operation, result, parameters, operationParameters, startValue, startParameters, raster);
                    break;
                }
                case Eq: 
                case Ge: 
                case Gt: 
                case Le: 
                case Lt: 
                case NotEq: {
                    FormulaOperationExecutor.performOperation_Eq_NotEq_Ge_Gt_Le_Lt(operation, result, parameters, operationParameters, startValue, startParameters, raster);
                    break;
                }
                case PrevValid: 
                case LastValid: 
                case NextValid: {
                    FormulaOperationExecutor.performOperation_PrevValid_LastValid_NextValid(operation, result, parameters, operationParameters, startValue, startParameters, raster);
                    break;
                }
                case NextValue: {
                    FormulaOperationExecutor.performOperation_NextValue(operation, result, parameters, operationParameters, startValue, startParameters, raster);
                    break;
                }
                case PrevValue: {
                    FormulaOperationExecutor.performOperation_PrevValue(operation, result, parameters, operationParameters, startValue, startParameters, raster);
                    break;
                }
                case LastValidValueInRaster: {
                    FormulaOperationExecutor.performOperation_LastValidValueInRaster(operation, result, parameters, operationParameters, startValue, startParameters, raster);
                    break;
                }
                case LocalHour: {
                    FormulaOperationExecutor.performOperation_LocalHour(operation, result, parameters, operationParameters, startValue, startParameters, raster);
                    break;
                }
                case LocalFractionalHour: {
                    FormulaOperationExecutor.performOperation_LocalFractionalHour(operation, result, parameters, operationParameters, startValue, startParameters, raster);
                    break;
                }
                case LocalWeekDay: {
                    FormulaOperationExecutor.performOperation_LocalWeekDay(operation, result, parameters, operationParameters, startValue, startParameters, raster);
                    break;
                }
                case LocalDayOfMonth: {
                    FormulaOperationExecutor.performOperation_LocalDayOfMonth(operation, result, parameters, operationParameters, startValue, startParameters, raster);
                    break;
                }
                case LocalDayOfYear: {
                    FormulaOperationExecutor.performOperation_LocalDayOfYear(operation, result, parameters, operationParameters, startValue, startParameters, raster);
                    break;
                }
                case VirtualZoneHour: {
                    FormulaOperationExecutor.performOperation_VirtualZoneHour(operation, result, parameters, operationParameters, startValue, startParameters, raster);
                    break;
                }
                case VirtualZoneDayOfMonth: {
                    FormulaOperationExecutor.performOperation_VirtualZoneDayOfMonth(operation, result, parameters, operationParameters, startValue, startParameters, raster);
                    break;
                }
                case VirtualZoneDayOfYear: {
                    FormulaOperationExecutor.performOperation_VirtualZoneDayOfYear(operation, result, parameters, operationParameters, startValue, startParameters, raster);
                    break;
                }
                case VirtualZoneFractionalDayOfYear: {
                    FormulaOperationExecutor.performOperation_VirtualZoneFractionalDayOfYear(operation, result, parameters, operationParameters, startValue, startParameters, raster);
                    break;
                }
                case VirtualZoneYear: {
                    FormulaOperationExecutor.performOperation_VirtualZoneYear(operation, result, parameters, operationParameters, startValue, startParameters, raster);
                    break;
                }
                case LowerLimit: 
                case UpperLimit: {
                    FormulaOperationExecutor.performOperation_LowerLimit_UpperLimit(operation, result, parameters, operationParameters, startValue, startParameters, raster);
                    break;
                }
                case Not: {
                    FormulaOperationExecutor.performOperation_Not(operation, result, parameters, operationParameters, startValue, startParameters, raster);
                    break;
                }
                case Negate: {
                    FormulaOperationExecutor.performOperation_Negate(operation, result, parameters, operationParameters, startValue, startParameters, raster);
                    break;
                }
                case If: {
                    FormulaOperationExecutor.performOperation_IfThenElse(operation, result, parameters, operationParameters, startValue, startParameters, raster);
                    break;
                }
                case IsValid: {
                    FormulaOperationExecutor.performOperation_IsValid(operation, result, parameters, operationParameters, startValue, startParameters, raster);
                    break;
                }
                case Avg: 
                case Average: 
                case Min: 
                case Max: 
                case Sum: {
                    FormulaOperationExecutor.performOperation_Min_Max_Sum_Avg_Average(operation, result, parameters, operationParameters, startValue, startParameters, raster);
                    break;
                }
                case Div: {
                    FormulaOperationExecutor.performOperation_Div(operation, result, parameters, operationParameters, startValue, startParameters, raster);
                    break;
                }
                case Mult: {
                    FormulaOperationExecutor.performOperation_Mult(operation, result, parameters, operationParameters, startValue, startParameters, raster);
                    break;
                }
                case Merge: {
                    FormulaOperationExecutor.performOperation_Merge(operation, result, parameters, operationParameters, startValue, startParameters, raster);
                    break;
                }
                case Power: {
                    FormulaOperationExecutor.performOperation_Power(operation, result, parameters, operationParameters, startValue, startParameters, raster);
                    break;
                }
                case Random: {
                    FormulaOperationExecutor.performOperation_Random(operation, result, parameters, operationParameters, startValue, startParameters, raster);
                    break;
                }
                case ReBound: {
                    FormulaOperationExecutor.performOperation_ReBound(operation, result, parameters, operationParameters, startValue, startParameters, raster);
                    break;
                }
                case TimeInterval: {
                    FormulaOperationExecutor.performOperation_TimeInterval(operation, result, parameters, operationParameters, startValue, startParameters, raster);
                    break;
                }
                case Diff: 
                case SumDiff: {
                    FormulaOperationExecutor.performOperation_Diff_SumDiff(operation, result, parameters, operationParameters, startValue, startParameters, raster);
                    break;
                }
                case Integral: 
                case IntegralKum: 
                case Rate: 
                case SumKum: 
                case Differential: 
                case Delta: {
                    FormulaOperationExecutor.performOperation_Integral_IntegralKum_SumKum_Differential_Delta_Rate(operation, result, parameters, operationParameters, startValue, startParameters, raster);
                    break;
                }
                case MovingAverage: {
                    FormulaOperationExecutor.performOperation_MovingAverage(operation, result, parameters, operationParameters, startValue, startParameters, raster);
                    break;
                }
                case MovingMedian: {
                    FormulaOperationExecutor.performOperation_MovingMedian(operation, result, parameters, operationParameters, startValue, startParameters, raster);
                    break;
                }
                case Median: {
                    FormulaOperationExecutor.performOperation_Median(operation, result, parameters, operationParameters, startValue, startParameters, raster);
                    break;
                }
                case Sign: {
                    FormulaOperationExecutor.performOperation_Sign(operation, result, parameters, operationParameters, startValue, startParameters, raster);
                    break;
                }
                case WindowCounter: {
                    FormulaOperationExecutor.performOperation_WindowCounter(operation, result, parameters, operationParameters, startValue, startParameters, raster);
                    break;
                }
                case Sin: 
                case Cos: 
                case Tan: {
                    FormulaOperationExecutor.performOperation_Sin_Cos_Tan(operation, result, parameters, operationParameters, startValue, startParameters, raster);
                    break;
                }
                default: {
                    throw new CalculationException(String.format("Operation f\u00fcr {0} ist unbekannt.", operation.name()));
                }
            }
            return result;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void performOperation_Abs(IVarValuesCollection result, IVarValuesCollection[] parameters, TreeMap<String, String> operationParameters, IVarValue startValue, IVarValue[] startParameters, Raster raster) throws CalculationException {
        if (parameters.length != 1) {
            throw new CalculationException(String.format("Abs Operation erwartet genau 1 parameter.", new Object[0]));
        }
        IVarValuesCollection param = parameters[0];
        for (IVarValue val : param) {
            if (val.isValid()) {
                result.add((IVarValue)new VarValue(val.getEndTimestamp(), Math.abs(val.getValue()), val.getQuality(), val.getPlausibility(), ValueSource.Calculated));
                continue;
            }
            result.add(VarValue.nan((long)val.getEndTimestamp()));
        }
    }

    private static void performOperation_BitAnd(IVarValuesCollection result, IVarValuesCollection[] parameters, TreeMap<String, String> operationParameters, IVarValue startValue, IVarValue[] startParameters, Raster raster) throws CalculationException {
        if (parameters.length != 2) {
            throw new CalculationException(String.format("BitAnd Operation erwartet genau 2 parameter.", new Object[0]));
        }
        IVarValuesCollection values = parameters[0];
        IVarValuesCollection masks = parameters[1];
        Iterator masksIterator = masks.iterator();
        for (IVarValue val : values) {
            IVarValue mask = (IVarValue)masksIterator.next();
            if (val.isValid() && mask.isValid()) {
                long iVal = (long)val.getValue();
                long iMask = (long)mask.getValue();
                double iResult = iVal & iMask;
                result.add((IVarValue)new VarValue(val.getEndTimestamp(), iResult, val.getQuality() * mask.getQuality(), Plausibility.Ok, ValueSource.Calculated));
                continue;
            }
            result.add(VarValue.nan((long)val.getEndTimestamp()));
        }
    }

    private static void performOperation_BitOr(IVarValuesCollection result, IVarValuesCollection[] parameters, TreeMap<String, String> operationParameters, IVarValue startValue, IVarValue[] startParameters, Raster raster) throws CalculationException {
        if (parameters.length != 2) {
            throw new CalculationException(String.format("BitAnd Operation erwartet genau 2 parameter.", new Object[0]));
        }
        IVarValuesCollection values = parameters[0];
        IVarValuesCollection masks = parameters[1];
        Iterator masksIterator = masks.iterator();
        for (IVarValue val : values) {
            IVarValue mask = (IVarValue)masksIterator.next();
            if (val.isValid() && mask.isValid()) {
                long iVal = (long)val.getValue();
                long iMask = (long)mask.getValue();
                double iResult = iVal | iMask;
                result.add((IVarValue)new VarValue(val.getEndTimestamp(), iResult, val.getQuality() * mask.getQuality(), Plausibility.Ok, ValueSource.Calculated));
                continue;
            }
            result.add(VarValue.nan((long)val.getEndTimestamp()));
        }
    }

    private static void performOperation_Ceil_Floor(FormulaOperation operation, IVarValuesCollection result, IVarValuesCollection[] parameters, TreeMap<String, String> operationParameters, IVarValue startValue, IVarValue[] startParameters, Raster raster) throws CalculationException {
        if (parameters.length != 1) {
            throw new CalculationException(String.format("%s Operation erwartet genau 1 parameter.", operation.name()));
        }
        IVarValuesCollection param = parameters[0];
        for (IVarValue val : param) {
            if (operation == FormulaOperation.Ceil) {
                result.add((IVarValue)new VarValue(val.getEndTimestamp(), Math.ceil(val.getValue()), val.getQuality(), Plausibility.Ok, ValueSource.Calculated));
                continue;
            }
            result.add((IVarValue)new VarValue(val.getEndTimestamp(), Math.floor(val.getValue()), val.getQuality(), Plausibility.Ok, ValueSource.Calculated));
        }
    }

    private static void performOperation_Quality(IVarValuesCollection result, IVarValuesCollection[] parameters, TreeMap<String, String> operationParameters, IVarValue startValue, IVarValue[] startParameters, Raster raster) throws CalculationException {
        if (parameters.length != 1) {
            throw new CalculationException(String.format("Quality Operation erwartet genau 1 parameter.", new Object[0]));
        }
        IVarValuesCollection param = parameters[0];
        for (IVarValue val : param) {
            result.add((IVarValue)new VarValue(val.getEndTimestamp(), val.getQuality(), 1.0, Plausibility.Ok, ValueSource.Calculated));
        }
    }

    private static void performOperation_And_Or(FormulaOperation operation, IVarValuesCollection result, IVarValuesCollection[] parameters, TreeMap<String, String> operationParameters, IVarValue startValue, IVarValue[] startParameters, Raster raster) throws CalculationException {
        for (IVarValue[] paramVals : new FastIVarValuesArrayIterable(parameters)) {
            double quality = 1.0;
            long timestamp = paramVals[0].getEndTimestamp();
            Boolean bResult = operation == FormulaOperation.And;
            int p = 0;
            while (p < parameters.length) {
                IVarValue val = paramVals[p];
                if (!val.isValid()) {
                    bResult = null;
                    break;
                }
                if (operation == FormulaOperation.And) {
                    bResult = bResult & val.getValue() != 0.0;
                    quality *= val.getQuality() >= 0.0 ? val.getQuality() : 0.0;
                    if (!bResult.booleanValue()) {
                        break;
                    }
                } else {
                    bResult = bResult | val.getValue() != 0.0;
                    quality *= val.getQuality() >= 0.0 ? val.getQuality() : 0.0;
                    if (bResult.booleanValue()) break;
                }
                ++p;
            }
            if (bResult != null) {
                result.add((IVarValue)new VarValue(timestamp, bResult != false ? 1.0 : 0.0, quality, Plausibility.Ok, ValueSource.Calculated));
                continue;
            }
            result.add(VarValue.nan((long)timestamp));
        }
    }

    private static void performOperation_EndTimestamp(FormulaOperation operation, IVarValuesCollection result, IVarValuesCollection[] parameters, TreeMap<String, String> operationParameters, IVarValue startValue, IVarValue[] startParameters, Raster raster) throws CalculationException {
        if (parameters.length != 1) {
            throw new CalculationException(String.format("%s Operation erwartet genau 1 parameter.", operation.name()));
        }
        IVarValuesCollection param = parameters[0];
        for (IVarValue val : param) {
            result.add((IVarValue)new VarValue(val.getEndTimestamp(), (double)val.getEndTimestamp(), 1.0, Plausibility.Ok, ValueSource.Calculated));
        }
    }

    private static void performOperation_Eq_NotEq_Ge_Gt_Le_Lt(FormulaOperation operation, IVarValuesCollection result, IVarValuesCollection[] parameters, TreeMap<String, String> operationParameters, IVarValue startValue, IVarValue[] startParameters, Raster raster) throws CalculationException {
        if (parameters.length < 2) {
            throw new CalculationException(String.format("%s Operation erwartet mindestens 2 parameter.", operation.name()));
        }
        for (IVarValue[] paramVals : new FastIVarValuesArrayIterable(parameters)) {
            IVarValue prevVal = paramVals[0];
            double quality = Math.max(0.0, prevVal.getQuality());
            long timestamp = prevVal.getEndTimestamp();
            Boolean bResult = prevVal.isValid();
            if (bResult.booleanValue()) {
                int p = 1;
                while (p < parameters.length) {
                    IVarValue val = paramVals[p];
                    if (!val.isValid()) {
                        bResult = null;
                    } else {
                        switch (operation) {
                            case Eq: {
                                bResult = bResult & prevVal.getValue() == val.getValue();
                                break;
                            }
                            case NotEq: {
                                bResult = bResult & prevVal.getValue() != val.getValue();
                                break;
                            }
                            case Ge: {
                                bResult = bResult & prevVal.getValue() >= val.getValue();
                                break;
                            }
                            case Gt: {
                                bResult = bResult & prevVal.getValue() > val.getValue();
                                break;
                            }
                            case Le: {
                                bResult = bResult & prevVal.getValue() <= val.getValue();
                                break;
                            }
                            case Lt: {
                                bResult = bResult & prevVal.getValue() < val.getValue();
                            }
                        }
                        quality = val.getQuality() >= 0.0 ? (quality *= val.getQuality()) : 0.0;
                        prevVal = val;
                        if (bResult.booleanValue()) {
                            ++p;
                            continue;
                        }
                    }
                    break;
                }
            } else {
                bResult = null;
            }
            if (bResult == null) {
                result.add(VarValue.nan((long)timestamp));
                continue;
            }
            result.add((IVarValue)new VarValue(timestamp, bResult != false ? 1.0 : 0.0, quality, Plausibility.Ok, ValueSource.Calculated));
        }
    }

    private static void performOperation_PrevValid_LastValid_NextValid(FormulaOperation operation, IVarValuesCollection result, IVarValuesCollection[] parameters, TreeMap<String, String> operationParameters, IVarValue startValue, IVarValue[] startParameters, Raster raster) throws CalculationException {
        Raster vRaster = raster;
        int width = 1;
        if (parameters.length != 1) {
            throw new CalculationException(String.format("%s Operation erwartet genau 1 parameter.", operation.name()));
        }
        String rasterStr = operationParameters.get("Raster");
        String widthStr = operationParameters.get("Width");
        try {
            vRaster = Raster.valueOf((String)rasterStr);
        }
        catch (Exception exception) {}
        try {
            width = Integer.parseInt(widthStr);
        }
        catch (Exception exception) {}
        int intervals = (int)(vRaster.toMilli() * (long)width / raster.toMilli());
        switch (operation) {
            case PrevValid: 
            case LastValid: {
                IVarValue[] params = parameters[0].toArray();
                int addend = operation == FormulaOperation.PrevValid ? 1 : 0;
                int i = 0;
                while (i < params.length) {
                    IVarValue lastValidValue = null;
                    long endTimestamp = raster.getRasterEnd(params[i].getEndTimestamp());
                    int startIndex = Math.max(0, i - intervals + addend);
                    int c = i;
                    while (startIndex < c) {
                        IVarValue val = params[c];
                        if (val.isValid()) {
                            lastValidValue = val;
                            break;
                        }
                        --c;
                    }
                    result.add((IVarValue)new VarValue(endTimestamp, lastValidValue != null ? lastValidValue.getValue() : Double.NaN, lastValidValue != null ? lastValidValue.getQuality() : -1.0, lastValidValue != null ? lastValidValue.getPlausibility() : Plausibility.Ok, ValueSource.Calculated));
                    ++i;
                }
                break;
            }
            case NextValid: {
                IVarValue[] params = parameters[0].toArray();
                int i = 0;
                while (i < params.length) {
                    IVarValue nextValidValue = null;
                    long endTimestamp = raster.getRasterEnd(params[i].getEndTimestamp());
                    int endIndex = Math.min(params.length, i + intervals - 1);
                    int c = i;
                    while (c < endIndex) {
                        IVarValue val = params[c];
                        if (val.isValid()) {
                            nextValidValue = val;
                            break;
                        }
                        ++c;
                    }
                    result.add((IVarValue)new VarValue(endTimestamp, nextValidValue != null ? nextValidValue.getValue() : Double.NaN, nextValidValue != null ? nextValidValue.getQuality() : -1.0, nextValidValue != null ? nextValidValue.getPlausibility() : Plausibility.Ok, ValueSource.Calculated));
                    ++i;
                }
                break;
            }
        }
    }

    private static void performOperation_LastValidValueInRaster(FormulaOperation operation, IVarValuesCollection result, IVarValuesCollection[] parameters, TreeMap<String, String> operationParameters, IVarValue startValue, IVarValue[] startParameters, Raster raster) throws CalculationException {
        VirtualRaster virtRaster = null;
        if (parameters.length != 1) {
            throw new CalculationException(String.format("%s Operation erwartet genau 1 parameter.", operation.name()));
        }
        String grid = operationParameters.get("Grid");
        try {
            virtRaster = VirtualRaster.valueOf((String)grid);
        }
        catch (Exception exception) {
            throw new CalculationException(String.format("%s Operation braucht 'Grid' (Day, Month) parameter.", operation.name()));
        }
        IVarValue[] params = parameters[0].toArray();
        int i = 0;
        while (i < params.length) {
            IVarValue lastValidValue = null;
            long endTimestamp = raster.getRasterEnd(params[i].getEndTimestamp());
            Instant utc = Instant.ofEpochMilli(endTimestamp);
            Instant rasterBegin = virtRaster.getRasterBegin(utc);
            Instant rasterEnd = virtRaster.getRasterEnd(utc);
            int startIndex = i + (int)((rasterBegin.toEpochMilli() - endTimestamp) / raster.toMilli()) + 1;
            int endIndex = i + (int)((rasterEnd.toEpochMilli() - endTimestamp) / raster.toMilli());
            int c = Math.max(0, startIndex);
            while (c < Math.min(endIndex + 1, params.length)) {
                IVarValue val = params[c];
                if (val.isValid()) {
                    lastValidValue = val;
                }
                ++c;
            }
            result.add((IVarValue)new VarValue(endTimestamp, lastValidValue != null ? lastValidValue.getValue() : Double.NaN, lastValidValue != null ? lastValidValue.getQuality() : -1.0, lastValidValue != null ? lastValidValue.getPlausibility() : Plausibility.Ok, ValueSource.Calculated));
            ++i;
        }
    }

    private static void performOperation_LocalFractionalHour(FormulaOperation operation, IVarValuesCollection result, IVarValuesCollection[] parameters, TreeMap<String, String> operationParameters, IVarValue startValue, IVarValue[] startParameters, Raster raster) throws CalculationException {
        if (parameters.length != 1) {
            throw new CalculationException(String.format("%s Operation erwartet genau 1 parameter.", operation.name()));
        }
        IVarValuesCollection param = parameters[0];
        for (IVarValue val : param) {
            Instant instant = Instant.ofEpochMilli(val.getEndTimestamp());
            LocalDateTime ldt = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
            double hour = ldt.getHour();
            hour += (double)ldt.getMinute() / 60.0;
            hour += (double)ldt.getSecond() / 3600.0;
            result.add((IVarValue)new VarValue(val.getEndTimestamp(), hour += (double)ldt.getNano() / 3.6E12, val.getQuality(), val.getPlausibility(), ValueSource.Calculated));
        }
    }

    private static void performOperation_LocalHour(FormulaOperation operation, IVarValuesCollection result, IVarValuesCollection[] parameters, TreeMap<String, String> operationParameters, IVarValue startValue, IVarValue[] startParameters, Raster raster) throws CalculationException {
        if (parameters.length != 1) {
            throw new CalculationException(String.format("%s Operation erwartet genau 1 parameter.", operation.name()));
        }
        IVarValuesCollection param = parameters[0];
        for (IVarValue val : param) {
            Instant instant = Instant.ofEpochMilli(val.getEndTimestamp());
            LocalDateTime ldt = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
            result.add((IVarValue)new VarValue(val.getEndTimestamp(), (double)ldt.getHour(), val.getQuality(), val.getPlausibility(), ValueSource.Calculated));
        }
    }

    private static void performOperation_LocalWeekDay(FormulaOperation operation, IVarValuesCollection result, IVarValuesCollection[] parameters, TreeMap<String, String> operationParameters, IVarValue startValue, IVarValue[] startParameters, Raster raster) throws CalculationException {
        if (parameters.length != 1) {
            throw new CalculationException(String.format("%s Operation erwartet genau 1 parameter.", operation.name()));
        }
        IVarValuesCollection param = parameters[0];
        for (IVarValue val : param) {
            Instant instant = Instant.ofEpochMilli(val.getEndTimestamp());
            LocalDateTime ldt = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
            result.add((IVarValue)new VarValue(val.getEndTimestamp(), (double)ldt.getDayOfWeek().getValue(), val.getQuality(), val.getPlausibility(), ValueSource.Calculated));
        }
    }

    private static void performOperation_LocalDayOfMonth(FormulaOperation operation, IVarValuesCollection result, IVarValuesCollection[] parameters, TreeMap<String, String> operationParameters, IVarValue startValue, IVarValue[] startParameters, Raster raster) throws CalculationException {
        if (parameters.length != 1) {
            throw new CalculationException(String.format("%s Operation erwartet genau 1 parameter.", operation.name()));
        }
        IVarValuesCollection param = parameters[0];
        for (IVarValue val : param) {
            Instant instant = Instant.ofEpochMilli(val.getEndTimestamp());
            LocalDateTime ldt = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
            result.add((IVarValue)new VarValue(val.getEndTimestamp(), (double)ldt.getDayOfMonth(), val.getQuality(), val.getPlausibility(), ValueSource.Calculated));
        }
    }

    private static void performOperation_LocalDayOfYear(FormulaOperation operation, IVarValuesCollection result, IVarValuesCollection[] parameters, TreeMap<String, String> operationParameters, IVarValue startValue, IVarValue[] startParameters, Raster raster) throws CalculationException {
        if (parameters.length != 1) {
            throw new CalculationException(String.format("%s Operation erwartet genau 1 parameter.", operation.name()));
        }
        IVarValuesCollection param = parameters[0];
        for (IVarValue val : param) {
            Instant instant = Instant.ofEpochMilli(val.getEndTimestamp());
            LocalDateTime ldt = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
            result.add((IVarValue)new VarValue(val.getEndTimestamp(), (double)ldt.getDayOfYear(), val.getQuality(), val.getPlausibility(), ValueSource.Calculated));
        }
    }

    private static void performOperation_VirtualZoneHour(FormulaOperation operation, IVarValuesCollection result, IVarValuesCollection[] parameters, TreeMap<String, String> operationParameters, IVarValue startValue, IVarValue[] startParameters, Raster raster) throws CalculationException {
        if (parameters.length != 1) {
            throw new CalculationException(String.format("%s Operation erwartet genau 1 parameter.", operation.name()));
        }
        IVarValuesCollection param = parameters[0];
        for (IVarValue val : param) {
            Instant instant = Instant.ofEpochMilli(val.getEndTimestamp());
            OffsetDateTime ldt = VirtualZone.INSTANCE.getOffsetDateTime(instant);
            result.add((IVarValue)new VarValue(val.getEndTimestamp(), (double)ldt.getHour(), val.getQuality(), val.getPlausibility(), ValueSource.Calculated));
        }
    }

    private static void performOperation_VirtualZoneDayOfMonth(FormulaOperation operation, IVarValuesCollection result, IVarValuesCollection[] parameters, TreeMap<String, String> operationParameters, IVarValue startValue, IVarValue[] startParameters, Raster raster) throws CalculationException {
        if (parameters.length != 1) {
            throw new CalculationException(String.format("%s Operation erwartet genau 1 parameter.", operation.name()));
        }
        IVarValuesCollection param = parameters[0];
        for (IVarValue val : param) {
            Instant instant = Instant.ofEpochMilli(val.getEndTimestamp());
            OffsetDateTime ldt = VirtualZone.INSTANCE.getOffsetDateTime(instant);
            result.add((IVarValue)new VarValue(val.getEndTimestamp(), (double)ldt.getDayOfMonth(), val.getQuality(), val.getPlausibility(), ValueSource.Calculated));
        }
    }

    private static void performOperation_VirtualZoneDayOfYear(FormulaOperation operation, IVarValuesCollection result, IVarValuesCollection[] parameters, TreeMap<String, String> operationParameters, IVarValue startValue, IVarValue[] startParameters, Raster raster) throws CalculationException {
        if (parameters.length != 1) {
            throw new CalculationException(String.format("%s Operation erwartet genau 1 parameter.", operation.name()));
        }
        IVarValuesCollection param = parameters[0];
        for (IVarValue val : param) {
            Instant instant = Instant.ofEpochMilli(val.getEndTimestamp());
            OffsetDateTime ldt = VirtualZone.INSTANCE.getOffsetDateTime(instant);
            result.add((IVarValue)new VarValue(val.getEndTimestamp(), (double)ldt.getDayOfYear(), val.getQuality(), val.getPlausibility(), ValueSource.Calculated));
        }
    }

    private static void performOperation_VirtualZoneFractionalDayOfYear(FormulaOperation operation, IVarValuesCollection result, IVarValuesCollection[] parameters, TreeMap<String, String> operationParameters, IVarValue startValue, IVarValue[] startParameters, Raster raster) throws CalculationException {
        if (parameters.length != 1) {
            throw new CalculationException(String.format("%s Operation erwartet genau 1 parameter.", operation.name()));
        }
        IVarValuesCollection param = parameters[0];
        for (IVarValue val : param) {
            Instant instant = Instant.ofEpochMilli(val.getEndTimestamp());
            OffsetDateTime ldt = VirtualZone.INSTANCE.getOffsetDateTime(instant);
            double day = ldt.getDayOfYear();
            day += (double)ldt.getHour() / 24.0;
            day += (double)ldt.getMinute() / 1440.0;
            day += (double)ldt.getSecond() / 86400.0;
            result.add((IVarValue)new VarValue(val.getEndTimestamp(), day += (double)ldt.get(ChronoField.MILLI_OF_SECOND) / 8.64E7, val.getQuality(), val.getPlausibility(), ValueSource.Calculated));
        }
    }

    private static void performOperation_VirtualZoneYear(FormulaOperation operation, IVarValuesCollection result, IVarValuesCollection[] parameters, TreeMap<String, String> operationParameters, IVarValue startValue, IVarValue[] startParameters, Raster raster) throws CalculationException {
        if (parameters.length != 1) {
            throw new CalculationException(String.format("%s Operation erwartet genau 1 parameter.", operation.name()));
        }
        IVarValuesCollection param = parameters[0];
        for (IVarValue val : param) {
            Instant instant = Instant.ofEpochMilli(val.getEndTimestamp());
            OffsetDateTime ldt = VirtualZone.INSTANCE.getOffsetDateTime(instant);
            result.add((IVarValue)new VarValue(val.getEndTimestamp(), (double)ldt.getYear(), val.getQuality(), val.getPlausibility(), ValueSource.Calculated));
        }
    }

    private static void performOperation_LowerLimit_UpperLimit(FormulaOperation operation, IVarValuesCollection result, IVarValuesCollection[] parameters, TreeMap<String, String> operationParameters, IVarValue startValue, IVarValue[] startParameters, Raster raster) throws CalculationException {
        if (parameters.length != 1) {
            throw new CalculationException(String.format("%s Operation erwartet genau 1 parameter.", operation.name()));
        }
        IVarValuesCollection param = parameters[0];
        Plausibility plausibility = operation == FormulaOperation.LowerLimit ? Plausibility.LowerLimit : Plausibility.UpperLimit;
        for (IVarValue val : param) {
            result.add((IVarValue)new VarValue(val.getEndTimestamp(), val.getPlausibility() == plausibility ? 1.0 : 0.0, val.getQuality(), Plausibility.Ok, ValueSource.Calculated));
        }
    }

    private static void performOperation_Not(FormulaOperation operation, IVarValuesCollection result, IVarValuesCollection[] parameters, TreeMap<String, String> operationParameters, IVarValue startValue, IVarValue[] startParameters, Raster raster) throws CalculationException {
        if (parameters.length != 1) {
            throw new CalculationException(String.format("%s Operation erwartet genau 1 parameter.", operation.name()));
        }
        IVarValuesCollection param = parameters[0];
        for (IVarValue val : param) {
            double value;
            double d = val.getValue() == 1.0 ? 0.0 : (value = val.getValue() == 0.0 ? 1.0 : Double.NaN);
            if (Double.isNaN(value)) {
                result.add(VarValue.nan((long)val.getEndTimestamp()));
                continue;
            }
            result.add((IVarValue)new VarValue(val.getEndTimestamp(), value, val.getQuality(), val.getPlausibility(), ValueSource.Calculated));
        }
    }

    private static void performOperation_Negate(FormulaOperation operation, IVarValuesCollection result, IVarValuesCollection[] parameters, TreeMap<String, String> operationParameters, IVarValue startValue, IVarValue[] startParameters, Raster raster) throws CalculationException {
        if (parameters.length != 1) {
            throw new CalculationException(String.format("%s Operation erwartet genau 1 parameter.", operation.name()));
        }
        IVarValuesCollection param = parameters[0];
        for (IVarValue val : param) {
            if (!val.isValid()) {
                result.add(VarValue.nan((long)val.getEndTimestamp()));
                continue;
            }
            result.add((IVarValue)new VarValue(val.getEndTimestamp(), val.getValue() * -1.0, val.getQuality(), val.getPlausibility(), ValueSource.Calculated));
        }
    }

    private static void performOperation_NextValue(FormulaOperation operation, IVarValuesCollection result, IVarValuesCollection[] parameters, TreeMap<String, String> operationParameters, IVarValue startValue, IVarValue[] startParameters, Raster raster) throws CalculationException {
        if (parameters.length != 1) {
            throw new CalculationException(String.format("%s Operation erwartet genau 1 parameter.", operation.name()));
        }
        Iterator paramIterator = parameters[0].iterator();
        paramIterator.next();
        IVarValue nextVal = null;
        while (paramIterator.hasNext()) {
            nextVal = (IVarValue)paramIterator.next();
            result.add((IVarValue)new VarValue(raster.getRasterEnd(nextVal.getEndTimestamp()) - raster.toMilli(), nextVal.getValue(), nextVal.getQuality(), nextVal.getPlausibility(), ValueSource.Calculated));
        }
        result.add(VarValue.nan((long)raster.getRasterEnd(nextVal.getEndTimestamp())));
    }

    private static void performOperation_PrevValue(FormulaOperation operation, IVarValuesCollection result, IVarValuesCollection[] parameters, TreeMap<String, String> operationParameters, IVarValue startValue, IVarValue[] startParameters, Raster raster) throws CalculationException {
        if (parameters.length != 1) {
            throw new CalculationException(String.format("%s Operation erwartet genau 1 parameter.", operation.name()));
        }
        Iterator paramIterator = parameters[0].iterator();
        IVarValue prevValue = (IVarValue)paramIterator.next();
        result.add(VarValue.nan((long)prevValue.getEndTimestamp()));
        do {
            result.add((IVarValue)new VarValue(raster.getRasterEnd(prevValue.getEndTimestamp()) + raster.toMilli(), prevValue.getValue(), prevValue.getQuality(), prevValue.getPlausibility(), ValueSource.Calculated));
            prevValue = (IVarValue)paramIterator.next();
        } while (paramIterator.hasNext());
    }

    private static void performOperation_IfThenElse(FormulaOperation operation, IVarValuesCollection result, IVarValuesCollection[] parameters, TreeMap<String, String> operationParameters, IVarValue startValue, IVarValue[] startParameters, Raster raster) throws CalculationException {
        if (parameters.length != 3) {
            throw new CalculationException(String.format("If-Else block muss 3 Parameter haben", new Object[0]));
        }
        for (IVarValue[] paramVals : new FastIVarValuesArrayIterable(parameters)) {
            IVarValue conditionVal = paramVals[0];
            IVarValue thenVal = paramVals[1];
            IVarValue elseVal = paramVals[2];
            if (!conditionVal.isValid()) {
                result.add(VarValue.nan((long)conditionVal.getEndTimestamp()));
                continue;
            }
            IVarValue resultVal = conditionVal.getValue() != 0.0 ? thenVal : elseVal;
            result.add((IVarValue)new VarValue(resultVal.getEndTimestamp(), resultVal.getValue(), Math.min(resultVal.getQuality(), conditionVal.getQuality()), resultVal.getPlausibility(), ValueSource.Calculated));
        }
    }

    private static void performOperation_IsValid(FormulaOperation operation, IVarValuesCollection result, IVarValuesCollection[] parameters, TreeMap<String, String> operationParameters, IVarValue startValue, IVarValue[] startParameters, Raster raster) throws CalculationException {
        if (parameters.length != 1) {
            throw new CalculationException(String.format("%s Operation erwartet genau 1 parameter.", operation.name()));
        }
        IVarValuesCollection paramVals = parameters[0];
        for (IVarValue paramVal : paramVals) {
            boolean isValid = paramVal.isValid();
            result.add((IVarValue)new VarValue(paramVal.getEndTimestamp(), (double)(isValid ? 1 : 0), 1.0, Plausibility.Ok, ValueSource.Calculated));
        }
    }

    private static void performOperation_Min_Max_Sum_Avg_Average(FormulaOperation operation, IVarValuesCollection result, IVarValuesCollection[] parameters, TreeMap<String, String> operationParameters, IVarValue startValue, IVarValue[] startParameters, Raster raster) throws CalculationException {
        boolean optionalParams = operationParameters.getOrDefault("OptionalParams", "false").toLowerCase().equals("true");
        for (IVarValue[] paramVals : new FastIVarValuesArrayIterable(parameters)) {
            double value = 0.0;
            if (operation == FormulaOperation.Min) {
                value = Double.POSITIVE_INFINITY;
            }
            if (operation == FormulaOperation.Max) {
                value = Double.NEGATIVE_INFINITY;
            }
            double quality = 0.0;
            int count = 0;
            long timeStamp = Long.MIN_VALUE;
            int p = 0;
            while (p < parameters.length) {
                IVarValue av = paramVals[p];
                double val = av.getValue();
                timeStamp = Math.max(timeStamp, av.getEndTimestamp());
                if (Double.isFinite(val) && av.getQuality() > 0.0 && av.getPlausibility() == Plausibility.Ok) {
                    switch (operation) {
                        case Min: {
                            value = Math.min(value, val);
                            break;
                        }
                        case Max: {
                            value = Math.max(value, val);
                            break;
                        }
                        case Avg: 
                        case Average: 
                        case Sum: {
                            value += val;
                            break;
                        }
                    }
                    ++count;
                }
                quality += Math.max(0.0, av.getQuality());
                ++p;
            }
            if (count == 0) {
                result.add(VarValue.nan((long)timeStamp));
                continue;
            }
            quality /= (double)(optionalParams ? count : parameters.length);
            if (FormulaOperation.Average == operation || FormulaOperation.Avg == operation) {
                value /= (double)count;
            }
            result.add((IVarValue)new VarValue(timeStamp, value, quality, Plausibility.Ok, ValueSource.Calculated));
        }
    }

    private static void performOperation_Div(FormulaOperation operation, IVarValuesCollection result, IVarValuesCollection[] parameters, TreeMap<String, String> operationParameters, IVarValue startValue, IVarValue[] startParameters, Raster raster) throws CalculationException {
        if (parameters.length != 2) {
            throw new CalculationException(String.format("%s block muss 2 Parameter haben", operation.name()));
        }
        double nullValue = Double.NaN;
        for (IVarValue[] paramVals : new FastIVarValuesArrayIterable(parameters)) {
            double value = Double.NaN;
            double quality = 0.0;
            IVarValue av1 = paramVals[0];
            IVarValue av2 = paramVals[1];
            double v2 = av2.getValue();
            long timestamp = Math.max(av1.getEndTimestamp(), av1.getEndTimestamp());
            if (av1.isValid() && av1.getValue() == 0.0) {
                result.add((IVarValue)new VarValue(timestamp, av1.getValue(), av1.getQuality(), Plausibility.Ok, ValueSource.Calculated));
                continue;
            }
            if (av1.isValid() && av2.isValid() && v2 != 0.0) {
                value = av1.getValue() / v2;
                quality = av1.getQuality() * av2.getQuality();
            } else if (av1.isValid() && (v2 == 0.0 || !Double.isFinite(v2)) && Double.isFinite(nullValue)) {
                value = nullValue;
                quality = 1.0;
            }
            if (Double.isNaN(value)) {
                result.add(VarValue.nan((long)timestamp));
                continue;
            }
            result.add((IVarValue)new VarValue(timestamp, value, quality, Plausibility.Ok, ValueSource.Calculated));
        }
    }

    private static void performOperation_Mult(FormulaOperation operation, IVarValuesCollection result, IVarValuesCollection[] parameters, TreeMap<String, String> operationParameters, IVarValue startValue, IVarValue[] startParameters, Raster raster) throws CalculationException {
        for (IVarValue[] paramVals : new FastIVarValuesArrayIterable(parameters)) {
            long timestamp = Long.MIN_VALUE;
            double value = 1.0;
            double quality = 1.0;
            int p = 0;
            while (p < parameters.length) {
                IVarValue av = paramVals[p];
                timestamp = Math.max(timestamp, av.getEndTimestamp());
                double val = av.getValue();
                if (Double.isFinite(value) && av.isValid()) {
                    value *= val;
                    quality *= av.getQuality();
                    if (val == 0.0) {
                        value = 0.0;
                        quality = av.getQuality();
                        int c = 0;
                        while (c < parameters.length) {
                            IVarValue cValue = paramVals[c];
                            if (cValue.getValue() == 0.0) {
                                quality = Math.max(quality, cValue.getQuality());
                            }
                            ++c;
                        }
                        break;
                    }
                } else {
                    quality = -1.0;
                    value = Double.NaN;
                }
                ++p;
            }
            if (Double.isNaN(value) && quality == -1.0) {
                result.add(VarValue.nan((long)timestamp));
                continue;
            }
            result.add((IVarValue)new VarValue(timestamp, value, quality, Plausibility.Ok, ValueSource.Calculated));
        }
    }

    private static void performOperation_Merge(FormulaOperation operation, IVarValuesCollection result, IVarValuesCollection[] parameters, TreeMap<String, String> operationParameters, IVarValue startValue, IVarValue[] startParameters, Raster raster) throws CalculationException {
        for (IVarValue[] paramVals : new FastIVarValuesArrayIterable(parameters)) {
            long timestamp = paramVals[0].getEndTimestamp();
            double value = Double.NaN;
            double maxQuality = -1.0;
            int p = 0;
            while (p < parameters.length) {
                IVarValue av = paramVals[p];
                if (av.getQuality() > maxQuality && av.isValid()) {
                    maxQuality = av.getQuality();
                    value = av.getValue();
                    timestamp = av.getEndTimestamp();
                }
                ++p;
            }
            if (Double.isNaN(value)) {
                result.add(VarValue.nan((long)timestamp));
                continue;
            }
            result.add((IVarValue)new VarValue(timestamp, value, maxQuality, Plausibility.Ok, ValueSource.Calculated));
        }
    }

    private static void performOperation_Power(FormulaOperation operation, IVarValuesCollection result, IVarValuesCollection[] parameters, TreeMap<String, String> operationParameters, IVarValue startValue, IVarValue[] startParameters, Raster raster) throws CalculationException {
        if (parameters.length != 2) {
            throw new CalculationException(String.format("%s block muss 2 Parameter haben", operation.name()));
        }
        for (IVarValue[] paramVals : new FastIVarValuesArrayIterable(parameters)) {
            long timestamp = Long.MIN_VALUE;
            double value = Double.NaN;
            double quality = 0.0;
            IVarValue av1 = paramVals[0];
            IVarValue av2 = paramVals[1];
            timestamp = av1.getEndTimestamp();
            if (av1.getQuality() > 0.0 && av2.getQuality() > 0.0) {
                value = Math.pow(av1.getValue(), av2.getValue());
                quality = Double.isFinite(value) ? av1.getQuality() * av2.getQuality() : 0.0;
            }
            result.add((IVarValue)new VarValue(timestamp, value, quality, av1.getPlausibility(), ValueSource.Calculated));
        }
    }

    private static void performOperation_Random(FormulaOperation operation, IVarValuesCollection result, IVarValuesCollection[] parameters, TreeMap<String, String> operationParameters, IVarValue startValue, IVarValue[] startParameters, Raster raster) throws CalculationException {
        if (parameters.length != 2) {
            throw new CalculationException(String.format("%s parameters needs 2 parameters", operation.name()));
        }
        for (IVarValue[] paramVals : new FastIVarValuesArrayIterable(parameters)) {
            IVarValue lb = paramVals[0];
            IVarValue ub = paramVals[1];
            long timestamp = Math.max(lb.getEndTimestamp(), ub.getEndTimestamp());
            double value = Double.NaN;
            double quality = 1.0;
            if (lb.isValid() && ub.isValid()) {
                double span = ub.getValue() - lb.getValue();
                value = Math.random() * span + lb.getValue();
                quality = (Math.max(0.0, lb.getQuality()) + Math.max(0.0, ub.getQuality())) / 2.0;
            } else {
                quality = -1.0;
            }
            if (Double.isNaN(value)) {
                result.add(VarValue.nan((long)timestamp));
                continue;
            }
            result.add((IVarValue)new VarValue(timestamp, value, quality, Plausibility.Ok, ValueSource.Calculated));
        }
    }

    private static void performOperation_ReBound(FormulaOperation operation, IVarValuesCollection result, IVarValuesCollection[] parameters, TreeMap<String, String> operationParameters, IVarValue startValue, IVarValue[] startParameters, Raster raster) throws CalculationException {
        Long startValueEndTs;
        Long firstElementTs;
        Raster baseRaster;
        if (parameters.length != 2) {
            throw new CalculationException(String.format("%s parameters needs 2 parameters", operation.name()));
        }
        double quality = 0.0;
        double sum = 0.0;
        int totalIndex = 0;
        String rasterKey = operationParameters.get("Raster");
        boolean resetOnNaN = operationParameters.containsKey("ResetOnNaN");
        if (rasterKey == null || rasterKey.isEmpty()) {
            throw new CalculationException(String.format("No base raster for operation %s specified", operation.name()));
        }
        try {
            baseRaster = rasterKey != null ? Raster.valueOf((String)rasterKey) : Server.getConfig().getGlobalViewRaster();
        }
        catch (Exception exception) {
            throw new CalculationException(String.format("Wrong raster name %s for operation %s", rasterKey, operation.name()));
        }
        Long timeRangeBegin = ArchiveStorages.getGlobalViewInstance().getCachedMetadata().getTimeRangeBegin();
        Long l = firstElementTs = timeRangeBegin != null ? Long.valueOf(timeRangeBegin + raster.toMilli()) : null;
        if (startValue != null && Double.isFinite(startValue.getValue())) {
            sum = startValue.getValue();
            quality = startValue.getQuality();
            startValueEndTs = raster.getRasterEnd(startValue.getEndTimestamp());
        } else {
            startValueEndTs = null;
        }
        for (IVarValue[] paramVals : new FastIVarValuesArrayIterable(parameters)) {
            IVarValue val = paramVals[0];
            IVarValue reduceRate = paramVals[1];
            if (startValueEndTs != null && val.getEndTimestamp() <= startValueEndTs) {
                result.add(VarValue.nan((long)val.getEndTimestamp()));
                continue;
            }
            double dVal = Double.isFinite(val.getValue()) && val.getQuality() > 0.0 ? val.getValue() : 0.0;
            long rasterOffset = val.getEndTimestamp() % raster.toMilli();
            if (rasterOffset == 0L) {
                rasterOffset = raster.toMilli();
            }
            long rasterBegin = val.getEndTimestamp() - rasterOffset;
            double span = (double)(val.getEndTimestamp() - rasterBegin) / (double)baseRaster.toMilli();
            totalIndex = firstElementTs != null ? Integer.valueOf(Math.max(0, (int)((val.getEndTimestamp() - firstElementTs) / raster.toMilli()))) : null;
            quality = (quality * (double)totalIndex + Math.max(0.0, val.getQuality())) / (double)(totalIndex + 1);
            if (reduceRate.isValid()) {
                sum -= sum * span * reduceRate.getValue();
            }
            sum += dVal * span;
            if (resetOnNaN && !val.isValid()) {
                sum = 0.0;
            }
            result.add((IVarValue)new VarValue(val.getEndTimestamp(), sum, quality, Plausibility.Ok, ValueSource.Calculated));
        }
    }

    private static void performOperation_TimeInterval(FormulaOperation operation, IVarValuesCollection result, IVarValuesCollection[] parameters, TreeMap<String, String> operationParameters, IVarValue startValue, IVarValue[] startParameters, Raster raster) throws CalculationException {
        Raster baseRaster;
        if (parameters.length != 1) {
            throw new CalculationException(String.format("%s parameters needs 1 parameter", operation.name()));
        }
        String rasterKey = operationParameters.get("Raster");
        if (rasterKey == null || rasterKey.isEmpty()) {
            throw new CalculationException(String.format("No base raster for operation %s specified", operation.name()));
        }
        try {
            baseRaster = rasterKey != null ? Raster.valueOf((String)rasterKey) : Server.getConfig().getGlobalViewRaster();
        }
        catch (Exception exception) {
            throw new CalculationException(String.format("Wrong raster name %s for operation %s", rasterKey, operation.name()));
        }
        for (IVarValue val : parameters[0]) {
            if (!val.isValid()) {
                result.add(VarValue.nan((long)val.getEndTimestamp()));
                continue;
            }
            if (val.getValue() == 0.0) {
                result.add((IVarValue)new VarValue(val.getEndTimestamp(), 0.0, val.getQuality(), Plausibility.Ok, ValueSource.Calculated));
                continue;
            }
            long millis = val.getEndTimestamp() - (raster.getRasterEnd(val.getEndTimestamp()) - raster.toMilli());
            double value = (double)millis / (double)baseRaster.toMilli();
            result.add((IVarValue)new VarValue(val.getEndTimestamp(), value, val.getQuality(), Plausibility.Ok, ValueSource.Calculated));
        }
    }

    private static void performOperation_Diff_SumDiff(FormulaOperation operation, IVarValuesCollection result, IVarValuesCollection[] parameters, TreeMap<String, String> operationParameters, IVarValue startValue, IVarValue[] startParameters, Raster raster) throws CalculationException {
        int nPositive = 1;
        if (operation == FormulaOperation.SumDiff) {
            try {
                nPositive = Integer.parseInt(operationParameters.get("NPositiv"));
            }
            catch (Exception exception) {}
        }
        for (IVarValue[] paramVals : new FastIVarValuesArrayIterable(parameters)) {
            double value = 0.0;
            double quality = 0.0;
            int count = 0;
            long timeStamp = Long.MIN_VALUE;
            int p = 0;
            while (p < parameters.length) {
                IVarValue av = paramVals[p];
                double val = av.getValue();
                timeStamp = Math.max(timeStamp, av.getEndTimestamp());
                if (Double.isFinite(val) && av.getQuality() > 0.0 && av.getPlausibility() == Plausibility.Ok) {
                    value = p < nPositive ? (value += val) : (value -= val);
                    quality += av.getQuality();
                    ++count;
                }
                ++p;
            }
            if (count == 0) {
                result.add(VarValue.nan((long)timeStamp));
                continue;
            }
            result.add((IVarValue)new VarValue(timeStamp, value, quality /= (double)parameters.length, Plausibility.Ok, ValueSource.Calculated));
        }
    }

    private static void performOperation_Integral_IntegralKum_SumKum_Differential_Delta_Rate(FormulaOperation operation, IVarValuesCollection result, IVarValuesCollection[] parameters, TreeMap<String, String> operationParameters, IVarValue startValue, IVarValue[] startParameters, Raster raster) throws CalculationException {
        Long startValueEndTs;
        Long timeRangeBegin;
        Long firstElementTs;
        String reduceRateStr;
        Raster baseRaster;
        if (operation == FormulaOperation.IntegralKum || operation == FormulaOperation.SumKum) {
            if (parameters.length < 1 || parameters.length > 2) {
                throw new CalculationException(String.format("%s block muss 1 oder 2 Parameter haben", operation.name()));
            }
        } else if (parameters.length != 1) {
            throw new CalculationException(String.format("%s block muss 1 Parameter haben", operation.name()));
        }
        VarValue prevVal = new VarValue(Long.MIN_VALUE, 0.0, 1.0, Plausibility.Ok, ValueSource.Calculated);
        double quality = 0.0;
        double sum = 0.0;
        String rasterKey = operationParameters.get("Raster");
        boolean resetOnNaN = operationParameters.containsKey("ResetOnNaN");
        if (!(operation != FormulaOperation.Integral && operation != FormulaOperation.IntegralKum && operation != FormulaOperation.Differential && operation != FormulaOperation.Rate || rasterKey != null && !rasterKey.isEmpty())) {
            throw new CalculationException(String.format("No base raster for operation %s specified", operation.name()));
        }
        try {
            baseRaster = rasterKey != null ? Raster.valueOf((String)rasterKey) : Server.getConfig().getGlobalViewRaster();
        }
        catch (Exception exception) {
            throw new CalculationException(String.format("Wrong raster name %s for operation %s", rasterKey, operation.name()));
        }
        double reduceRate = Double.NaN;
        if (!(operation != FormulaOperation.IntegralKum && operation != FormulaOperation.SumKum || (reduceRateStr = operationParameters.get("ReduceRate")) == null || reduceRateStr.isBlank())) {
            try {
                reduceRate = Double.parseDouble(reduceRateStr);
            }
            catch (Exception exception) {
                throw new CalculationException(String.format("Cannot parce ReduceRate parameter: %s for operation %s", reduceRateStr, operation.name()));
            }
        }
        Long l = firstElementTs = (timeRangeBegin = ArchiveStorages.getGlobalViewInstance().getCachedMetadata().getTimeRangeBegin()) != null ? Long.valueOf(timeRangeBegin + raster.toMilli()) : null;
        if (startValue != null && Double.isFinite(startValue.getValue())) {
            prevVal = startValue;
            sum = startValue.getValue();
            quality = startValue.getQuality();
            startValueEndTs = raster.getRasterEnd(startValue.getEndTimestamp());
        } else {
            startValueEndTs = null;
        }
        for (IVarValue[] vals : new FastIVarValuesArrayIterable(parameters)) {
            IVarValue val = vals[0];
            if (startValueEndTs != null && val.getEndTimestamp() <= startValueEndTs) {
                result.add(VarValue.nan((long)val.getEndTimestamp()));
                prevVal = val;
                continue;
            }
            double dVal = Double.isFinite(val.getValue()) && val.getQuality() > 0.0 ? val.getValue() : 0.0;
            long rasterOffset = val.getEndTimestamp() % raster.toMilli();
            if (rasterOffset == 0L) {
                rasterOffset = raster.toMilli();
            }
            long rasterBegin = val.getEndTimestamp() - rasterOffset;
            double span = (double)(val.getEndTimestamp() - rasterBegin) / (double)baseRaster.toMilli();
            switch (operation) {
                case Integral: {
                    if (val.isValid()) {
                        result.add((IVarValue)new VarValue(val.getEndTimestamp(), dVal * span, val.getQuality(), val.getPlausibility(), ValueSource.Calculated));
                        break;
                    }
                    result.add(VarValue.nan((long)val.getEndTimestamp()));
                    break;
                }
                case IntegralKum: 
                case SumKum: {
                    IVarValue replacementVal;
                    IVarValue iVarValue = replacementVal = vals.length == 2 ? vals[1] : null;
                    if (replacementVal != null && replacementVal.isValid()) {
                        sum = replacementVal.getValue();
                        quality = replacementVal.getQuality();
                    } else {
                        int totalIndex = firstElementTs != null ? Integer.valueOf(Math.max(0, (int)((val.getEndTimestamp() - firstElementTs) / raster.toMilli()))) : null;
                        quality = (quality * (double)totalIndex + Math.max(0.0, val.getQuality())) / (double)(totalIndex + 1);
                        if (Double.isFinite(reduceRate)) {
                            sum -= sum * span * reduceRate;
                        }
                        sum = operation == FormulaOperation.IntegralKum ? (sum += dVal * span) : (sum += dVal);
                        if (resetOnNaN && !val.isValid()) {
                            sum = 0.0;
                        }
                    }
                    result.add((IVarValue)new VarValue(val.getEndTimestamp(), sum, quality, Plausibility.Ok, ValueSource.Calculated));
                    break;
                }
                case Delta: {
                    if (val.isValid() && prevVal.isValid()) {
                        result.add((IVarValue)new VarValue(val.getEndTimestamp(), prevVal.getEndTimestamp() != Long.MIN_VALUE ? val.getValue() - prevVal.getValue() : 0.0, Math.min(val.getQuality(), prevVal.getQuality()), val.getPlausibility(), ValueSource.Calculated));
                        break;
                    }
                    result.add(VarValue.nan((long)val.getEndTimestamp()));
                    break;
                }
                case Differential: {
                    if (val.isValid() && prevVal.isValid()) {
                        result.add((IVarValue)new VarValue(val.getEndTimestamp(), prevVal.getEndTimestamp() != Long.MIN_VALUE ? (val.getValue() - prevVal.getValue()) / span : 0.0, Math.min(val.getQuality(), prevVal.getQuality()), val.getPlausibility(), ValueSource.Calculated));
                        break;
                    }
                    result.add(VarValue.nan((long)val.getEndTimestamp()));
                    break;
                }
                default: {
                    if (val.isValid()) {
                        result.add((IVarValue)new VarValue(val.getEndTimestamp(), val.getValue() / span, val.getQuality(), val.getPlausibility(), ValueSource.Calculated));
                        break;
                    }
                    result.add(VarValue.nan((long)val.getEndTimestamp()));
                }
            }
            prevVal = val;
        }
    }

    private static void performOperation_MovingAverage(FormulaOperation operation, IVarValuesCollection result, IVarValuesCollection[] parameters, TreeMap<String, String> operationParameters, IVarValue startValue, IVarValue[] startParameters, Raster raster) throws CalculationException {
        if (parameters.length != 1) {
            throw new CalculationException(String.format("{1} block muss 1 Parameter haben", operation.name()));
        }
        long maximalMovingTs = operationParameters.containsKey("Model") ? Long.MAX_VALUE : raster.getRasterEnd(Instant.now().toEpochMilli());
        Pair<Integer, Integer> movingWidth = FormulaOperationExecutor.getMovingOperationIntervals(operationParameters);
        int preIntervals = (Integer)movingWidth.getKey();
        int postIntervals = (Integer)movingWidth.getValue();
        int width = preIntervals + 1 + postIntervals;
        IVarValue[] params = parameters[0].toArray();
        double value = 0.0;
        double quality = 0.0;
        int items = 0;
        int vals = 0;
        int i = 0;
        while (i >= preIntervals && i < postIntervals && i < params.length) {
            IVarValue param = params[i];
            if (param.isValid()) {
                ++vals;
                value += param.getValue();
                quality += param.getQuality();
            }
            ++items;
            ++i;
        }
        i = 0;
        while (i < params.length) {
            long timestamp = params[i].getEndTimestamp();
            if (timestamp <= maximalMovingTs) {
                if (i + postIntervals >= 0 && i + postIntervals < params.length && params[i + postIntervals].isValid()) {
                    ++vals;
                    value += params[i + postIntervals].getValue();
                    quality += params[i + postIntervals].getQuality();
                }
                if (++items > width) {
                    int removeItem = i - preIntervals - 1;
                    if (vals > 0 && removeItem >= 0 && removeItem < params.length && params[removeItem].isValid()) {
                        --vals;
                        value -= params[removeItem].getValue();
                        quality -= params[removeItem].getQuality();
                    }
                    --items;
                }
            } else if (params[i].isValid()) {
                vals = 1;
                value = params[i].getValue();
                quality = params[i].getQuality();
            } else {
                vals = 0;
            }
            if (vals <= 0) {
                result.add(VarValue.nan((long)timestamp));
            } else {
                result.add((IVarValue)new VarValue(timestamp, value / (double)vals, quality / (double)vals, Plausibility.Ok, ValueSource.Calculated));
            }
            ++i;
        }
    }

    private static void performOperation_MovingMedian(FormulaOperation operation, IVarValuesCollection result, IVarValuesCollection[] parameters, TreeMap<String, String> operationParameters, IVarValue startValue, IVarValue[] startParameters, Raster raster) throws CalculationException {
        if (parameters.length != 1) {
            throw new CalculationException(String.format("%s block muss 1 Parameter haben", operation.name()));
        }
        long maximalMovingTs = operationParameters.containsKey("Model") ? Long.MAX_VALUE : raster.getRasterEnd(Instant.now().toEpochMilli());
        Pair<Integer, Integer> movingWidth = FormulaOperationExecutor.getMovingOperationIntervals(operationParameters);
        int preIntervals = (Integer)movingWidth.getKey();
        int postIntervals = (Integer)movingWidth.getValue();
        IVarValue[] params = parameters[0].toArray();
        ArrayList<Double> vals = new ArrayList<Double>(preIntervals + 1 + postIntervals);
        int i = 0;
        while (i < params.length) {
            vals.clear();
            double quality = 0.0;
            IVarValue param = params[i];
            long timestamp = param.getEndTimestamp();
            if (timestamp <= maximalMovingTs) {
                int w = Math.max(0, i - preIntervals);
                while (w < Math.min(i + postIntervals + 1, params.length)) {
                    param = params[w];
                    if (param.isValid()) {
                        quality += param.getQuality();
                        vals.add(param.getValue());
                    }
                    ++w;
                }
            } else if (param.isValid()) {
                quality += param.getQuality();
                vals.add(param.getValue());
            }
            Collections.sort(vals);
            double val = 0.0;
            int length = vals.size();
            if (length > 0) {
                quality /= (double)length;
                val = length % 2 == 0 ? ((Double)vals.get(length / 2 - 1) + (Double)vals.get(length / 2)) / 2.0 : (Double)vals.get(length / 2);
            }
            if (length == 0) {
                result.add(VarValue.nan((long)timestamp));
            } else {
                result.add((IVarValue)new VarValue(timestamp, val, quality, Plausibility.Ok, ValueSource.Calculated));
            }
            ++i;
        }
    }

    private static void performOperation_Median(FormulaOperation operation, IVarValuesCollection result, IVarValuesCollection[] parameters, TreeMap<String, String> operationParameters, IVarValue startValue, IVarValue[] startParameters, Raster raster) throws CalculationException {
        ArrayList<Double> vals = new ArrayList<Double>(parameters.length + 1);
        for (IVarValue[] paramVals : new FastIVarValuesArrayIterable(parameters)) {
            vals.clear();
            double quality = 0.0;
            IVarValue param = paramVals[0];
            long timestamp = param.getEndTimestamp();
            int j = 0;
            while (j < parameters.length) {
                param = paramVals[j];
                if (Double.isFinite(param.getValue()) && param.getQuality() > 0.0 && param.getPlausibility() == Plausibility.Ok) {
                    quality += param.getQuality();
                    vals.add(param.getValue());
                }
                ++j;
            }
            Collections.sort(vals);
            double val = 0.0;
            int length = vals.size();
            if (length > 0) {
                quality /= (double)length;
                val = length % 2 == 0 ? ((Double)vals.get(length / 2 - 1) + (Double)vals.get(length / 2)) / 2.0 : (Double)vals.get(length / 2);
            }
            if (length == 0) {
                result.add(VarValue.nan((long)timestamp));
                continue;
            }
            result.add((IVarValue)new VarValue(timestamp, val, quality, Plausibility.Ok, ValueSource.Calculated));
        }
    }

    private static void performOperation_Sign(FormulaOperation operation, IVarValuesCollection result, IVarValuesCollection[] parameters, TreeMap<String, String> operationParameters, IVarValue startValue, IVarValue[] startParameters, Raster raster) throws CalculationException {
        if (parameters.length != 1) {
            throw new CalculationException(String.format("{1} block muss 1 Parameter haben", operation.name()));
        }
        IVarValuesCollection paramsVals = parameters[0];
        for (IVarValue val : paramsVals) {
            double res = Double.NaN;
            if (Double.isFinite(val.getValue()) && val.getQuality() > 0.0 && val.getPlausibility() == Plausibility.Ok) {
                res = val.getValue() > 0.0 ? 1.0 : (double)(val.getValue() < 0.0 ? -1 : 0);
            }
            result.add((IVarValue)new VarValue(val.getEndTimestamp(), res, val.getQuality(), val.getPlausibility(), ValueSource.Calculated));
        }
    }

    private static void performOperation_WindowCounter(FormulaOperation operation, IVarValuesCollection result, IVarValuesCollection[] parameters, TreeMap<String, String> operationParameters, IVarValue startValue, IVarValue[] startParameters, Raster raster) throws CalculationException {
        Raster baseRaster;
        if (parameters.length != 1) {
            throw new CalculationException(String.format("{1} block muss 1 Boolean Parameter haben", operation.name()));
        }
        IVarValuesCollection paramVals = parameters[0];
        double windowsWidth = startValue != null && startValue.isValid() ? startValue.getValue() : 0.0;
        String rasterKey = operationParameters.get("Raster");
        if (rasterKey == null || rasterKey.isEmpty()) {
            throw new CalculationException(String.format("No base raster for operation %s specified", operation.name()));
        }
        try {
            baseRaster = rasterKey != null ? Raster.valueOf((String)rasterKey) : Server.getConfig().getGlobalViewRaster();
        }
        catch (Exception exception) {
            throw new CalculationException(String.format("Wrong raster name %s for operation %s", rasterKey, operation.name()));
        }
        double step = (double)raster.toMilli() / (double)baseRaster.toMilli();
        for (IVarValue val : paramVals) {
            if (val.isValid() && val.getValue() == 1.0) {
                result.add((IVarValue)new VarValue(val.getEndTimestamp(), windowsWidth += step, val.getQuality(), val.getPlausibility(), ValueSource.Calculated));
                continue;
            }
            result.add(VarValue.nan((long)val.getEndTimestamp()));
            windowsWidth = 0.0;
        }
    }

    private static void performOperation_Sin_Cos_Tan(FormulaOperation operation, IVarValuesCollection result, IVarValuesCollection[] parameters, TreeMap<String, String> operationParameters, IVarValue startValue, IVarValue[] startParameters, Raster raster) throws CalculationException {
        if (parameters.length != 1) {
            throw new CalculationException(String.format("%s Operation erwartet genau 1 parameter.", operation.name()));
        }
        IVarValuesCollection paramVals = parameters[0];
        for (IVarValue val : paramVals) {
            if (val.isValid()) {
                result.add((IVarValue)new VarValue(val.getEndTimestamp(), switch (operation) {
                    case FormulaOperation.Sin -> Math.sin(val.getValue());
                    case FormulaOperation.Cos -> Math.cos(val.getValue());
                    case FormulaOperation.Tan -> Math.tan(val.getValue());
                    default -> throw new CalculationException("Unsupported Operation " + operation.name());
                }, val.getQuality(), Plausibility.Ok, ValueSource.Calculated));
                continue;
            }
            result.add(VarValue.nan((long)val.getEndTimestamp()));
        }
    }

    static Pair<Integer, Integer> getMovingOperationIntervals(TreeMap<String, String> operationParameters) {
        int postIntervals;
        int preIntervals;
        String centeredStr;
        int width = 1;
        boolean centered = true;
        try {
            String param = operationParameters.get("Width");
            if (param != null) {
                width = Math.max(Integer.parseInt(param), 1);
            }
        }
        catch (Exception exception) {}
        if ((centeredStr = operationParameters.get("Centered")) != null && !centeredStr.isEmpty()) {
            centered = Boolean.parseBoolean(centeredStr);
        }
        if (centered) {
            preIntervals = width / 2;
            postIntervals = width / 2 * 2 == width ? width / 2 - 1 : width / 2;
        } else {
            preIntervals = width - 1;
            postIntervals = 0;
        }
        int offset = 0;
        try {
            String param = operationParameters.get("Width");
            if (param != null) {
                offset = Integer.parseInt(param);
            }
        }
        catch (Exception exception) {}
        return new Pair((Object)(preIntervals + offset), (Object)(postIntervals - offset));
    }
}

