/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.custom;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.calculated.dependencies.DependencyKey;
import de.elpro.ewms.core.variable.calculated.dependencies.PropertyReferenceDependencyKey;
import de.elpro.ewms.core.variable.calculated.dependencies.VariableInstanceExplicitDependency;
import de.elpro.ewms.core.variable.calculated.dependencies.VariableReferenceDependencyKey;
import de.elpro.ewms.core.variable.custom.AlgorithmDescriptor;
import de.elpro.ewms.core.variable.custom.AlgorithmParameter;
import de.elpro.ewms.server.bundle.Activator;
import de.elpro.ewms.server.cache.ORMCache;
import de.elpro.ewms.server.model.ICustomCalculationAlgorithm;
import de.elpro.ewms.server.model.ICustomCalculationAlgorithmFactory;
import de.elpro.ewms.server.model.StateModel;
import de.elpro.ewms.server.model.StateModelDependencyManager;
import de.elpro.ewms.server.rasterizedvalues.RasterizedValues;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.fx.core.log.Logger;

public class CustomAlgorithms {
    private static final Logger logger = Activator.getLoggerFactory().createLogger(CustomAlgorithms.class.getName());
    public static final String EXTENSION_POINT_ID = "de.elpro.ewms.server.variable.customcalculation";
    private static final Map<String, ICustomCalculationAlgorithmFactory> ALGORITHM_FACTORIES = new TreeMap<String, ICustomCalculationAlgorithmFactory>();
    private static final Table<String, RasterizedValues, ICustomCalculationAlgorithm> ALGORITHMS = HashBasedTable.create();

    public static void addAlgorithm(ICustomCalculationAlgorithmFactory algorithmFactory) {
        ALGORITHM_FACTORIES.put(algorithmFactory.getAlgorithmDescriptor().getId(), algorithmFactory);
    }

    public static ICustomCalculationAlgorithmFactory getAlgorithmFactory(String id) {
        if (id == null) {
            return null;
        }
        return ALGORITHM_FACTORIES.get(id);
    }

    public static ICustomCalculationAlgorithm getAlgorithm(String id, RasterizedValues rasterizedValues) {
        ICustomCalculationAlgorithm alg = (ICustomCalculationAlgorithm)ALGORITHMS.get((Object)id, (Object)rasterizedValues);
        if (alg != null) {
            return alg;
        }
        ICustomCalculationAlgorithmFactory factory = CustomAlgorithms.getAlgorithmFactory(id);
        if (factory == null) {
            return null;
        }
        alg = factory.create(rasterizedValues);
        if (alg instanceof StateModel && !(factory.getDependencyManager() instanceof StateModelDependencyManager)) {
            logger.error("StateModel should have DependencyManager of StateModelDependencyManager instance");
        }
        ALGORITHMS.put((Object)id, (Object)rasterizedValues, (Object)alg);
        return alg;
    }

    public static AlgorithmDescriptor getAlgorithmDescriptor(String id) {
        ICustomCalculationAlgorithmFactory alg = CustomAlgorithms.getAlgorithmFactory(id);
        if (alg == null) {
            return null;
        }
        return alg.getAlgorithmDescriptor();
    }

    public static AlgorithmDescriptor[] getAlgorithmDescriptors() {
        ArrayList<AlgorithmDescriptor> descriptors = new ArrayList<AlgorithmDescriptor>();
        for (ICustomCalculationAlgorithmFactory alg : ALGORITHM_FACTORIES.values()) {
            descriptors.add(alg.getAlgorithmDescriptor());
        }
        return descriptors.toArray(new AlgorithmDescriptor[0]);
    }

    public static Object getDependency(VariableInstance instance, AlgorithmParameter param) {
        VariableInstance dependency = null;
        String key = param.getKey();
        for (VariableInstanceExplicitDependency dep : instance.getCachedDependencies()) {
            if ((key != null || dep.getKey() != null) && !key.equals(dep.getKey())) continue;
            if (dependency != null) {
                throw new IllegalArgumentException(String.format("Illegal number of dependencies '%s' key", key));
            }
            dependency = dep.getDependentOn();
        }
        if (dependency != null) {
            return dependency;
        }
        Collection<Object> deps = ORMCache.getDependencies(instance, new VariableReferenceDependencyKey(key));
        if (deps != null && deps.size() == 1) {
            return deps.iterator().next();
        }
        deps = ORMCache.getDependencies(instance, new PropertyReferenceDependencyKey(key));
        if (deps != null && deps.size() == 1) {
            return deps.iterator().next();
        }
        return null;
    }

    public static VariableInstance getUniqueVariableInstanceDependency(VariableInstance instance, AlgorithmParameter param) {
        VariableInstance dependency = null;
        String key = param.getKey();
        for (VariableInstanceExplicitDependency dep : instance.getCachedDependencies()) {
            if ((key != null || dep.getKey() != null) && !key.equals(dep.getKey())) continue;
            if (dependency != null) {
                throw new IllegalArgumentException(String.format("Illegal number of dependencies '%s' key", key));
            }
            dependency = dep.getDependentOn();
        }
        if (dependency != null) {
            return dependency;
        }
        return ORMCache.getUniqueVariableInstanceDependency(instance, new VariableReferenceDependencyKey(key));
    }

    public static VariableInstance[] getUniqueVariableInstanceDependencies(VariableInstance instance, AlgorithmParameter ... params) {
        DependencyKey[] keys = new DependencyKey[params.length];
        int i = 0;
        while (i < params.length) {
            keys[i] = new VariableReferenceDependencyKey(params[i].getKey());
            ++i;
        }
        return ORMCache.getUniqueVariableInstanceDependencies(instance, keys);
    }
}

