/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.db.appconfig;

import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.server.bundle.Activator;
import java.time.Instant;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.persistence.EntityManager;
import org.eclipse.fx.core.log.Logger;

public class EntityManagerPool {
    private static final Logger logger = Activator.getLoggerFactory().createLogger(EntityManagerPool.class.getName());
    private static final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private static Lock readLock = readWriteLock.readLock();
    private static Lock writeLock = readWriteLock.writeLock();
    private static final LinkedHashMap<Integer, SessionData> SESSIONS = new LinkedHashMap();
    private static int lastTransactionId = 0;
    private static long SESSION_TIMEOUT_ON_POOL_OVERFLOW = 60000L;
    private static long SESSION_TIMEOUT = 600000L;
    private static int MAX_ACTIVE_SESSIONS = Math.max(1, 25);

    /*
     * Exception decompiling
     */
    public static Transaction createTransaction(User user) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Transaction createServersideTransaction(User user) throws Exception {
        Transaction trx = EntityManagerPool.createTransaction(user);
        int transactionId = trx.getId();
        return new Transaction(transactionId, () -> EntityManagerPool.close(transactionId, user));
    }

    private static Collection<Integer> removeOldSessions(long timeout, User user) {
        LinkedList<Integer> closedTrxs = new LinkedList<Integer>();
        for (int oldestTrx : SESSIONS.keySet()) {
            boolean matchingUser;
            SessionData sessionData = SESSIONS.get(oldestTrx);
            boolean timeoutReached = Instant.now().toEpochMilli() - sessionData.created.toEpochMilli() > timeout;
            boolean bl = matchingUser = user == null || sessionData.user.equals((Object)user);
            if (!timeoutReached || !matchingUser) break;
            logger.error(String.format("Close old session for transaction %d(%s), user '%s' and timeout of %ds", oldestTrx, sessionData.created, sessionData.user, timeout / 1000L));
            if (sessionData.em.getTransaction() != null) {
                sessionData.em.getTransaction().rollback();
            }
            sessionData.em.close();
            closedTrxs.add(oldestTrx);
        }
        for (int trx : closedTrxs) {
            SESSIONS.remove(trx);
        }
        return closedTrxs;
    }

    private static int nextTransactionId() {
        if (++lastTransactionId < 0) {
            lastTransactionId = 1;
        }
        return lastTransactionId;
    }

    public static EntityManager getEntityManager(Transaction trx, User user) {
        return EntityManagerPool.getEntityManager(trx.getId(), user);
    }

    public static EntityManager getEntityManager(int trxId, User user) {
        readLock.lock();
        try {
            SessionData sessionData = SESSIONS.get(trxId);
            if (sessionData == null || !sessionData.user.equals((Object)user)) {
                return null;
            }
            EntityManager entityManager = sessionData.em;
            return entityManager;
        }
        finally {
            readLock.unlock();
        }
    }

    public static void commit(int trxId, User user) {
        EntityManager em = EntityManagerPool.getEntityManager(trxId, user);
        if (em == null) {
            throw new IllegalArgumentException(String.format("Transaction with id %d not found", trxId));
        }
        em.getTransaction().commit();
    }

    public static void rollback(int trxId, User user) {
        EntityManager em = EntityManagerPool.getEntityManager(trxId, user);
        if (em == null) {
            throw new IllegalArgumentException(String.format("Transaction with id %d not found", trxId));
        }
        em.getTransaction().rollback();
    }

    public static void close(Transaction trx, User user) {
        EntityManagerPool.close(trx.getId(), user);
    }

    public static void close(int trxId, User user) {
        EntityManager session = EntityManagerPool.getEntityManager(trxId, user);
        if (session == null) {
            throw new IllegalArgumentException(String.format("Transaction with id %d not found", trxId));
        }
        writeLock.lock();
        try {
            if (session.getTransaction().isActive()) {
                try {
                    session.getTransaction().rollback();
                }
                catch (Exception exc) {
                    logger.errorf("Error during rollback of transaction for user %s", (Throwable)exc, new Object[]{user});
                }
            }
            session.close();
            SESSIONS.remove(trxId);
        }
        finally {
            writeLock.unlock();
        }
    }

    public static void closeAll(User user) {
        writeLock.lock();
        try {
            HashSet<Integer> closedTransactions = new HashSet<Integer>();
            for (Map.Entry<Integer, SessionData> entry : SESSIONS.entrySet()) {
                SessionData sessionData = entry.getValue();
                if (!sessionData.user.equals((Object)user)) continue;
                if (sessionData.em.getTransaction().isActive()) {
                    try {
                        sessionData.em.getTransaction().rollback();
                    }
                    catch (Exception exception) {}
                }
                try {
                    sessionData.em.close();
                    logger.infof("Close dead transaction %d for %s", new Object[]{entry.getKey(), entry.getValue().user});
                }
                catch (Exception exception) {
                    logger.errorf("Error closing EntityManager for user %s", new Object[]{user});
                }
                closedTransactions.add(entry.getKey());
            }
            closedTransactions.forEach(trx -> {
                Object v = SESSIONS.remove(trx);
            });
        }
        finally {
            writeLock.unlock();
        }
    }

    private static class SessionData {
        private final EntityManager em;
        private final User user;
        private final Instant created;

        public SessionData(EntityManager em, User user) {
            this.em = em;
            this.user = user;
            this.created = Instant.now();
        }
    }
}

