/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.db.randomaccess;

import java.nio.ByteBuffer;
import java.util.Arrays;

public class ClusterId {
    private final byte[] entityId;
    private final byte[] data;
    private final long clusterStartTimestamp;

    public ClusterId(byte[] entityId, long clusterStartTimestamp) {
        this.entityId = entityId;
        this.clusterStartTimestamp = clusterStartTimestamp;
        ByteBuffer buffer = ByteBuffer.allocate(entityId.length + 8);
        buffer.put(entityId);
        buffer.putLong(clusterStartTimestamp);
        this.data = buffer.array();
    }

    byte[] getEntityId() {
        return this.entityId;
    }

    long getClusterStartTimestamp() {
        return this.clusterStartTimestamp;
    }

    byte[] getData() {
        return this.data;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ClusterId)) {
            return false;
        }
        ClusterId cid = (ClusterId)obj;
        return Arrays.equals(this.data, cid.data);
    }

    public int hashCode() {
        int hashCode = 0;
        int i = 0;
        while (i < this.data.length) {
            hashCode += this.data[i] * (0x11 ^ i);
            ++i;
        }
        return hashCode;
    }

    public String toString() {
        StringBuffer out = new StringBuffer(this.data.length);
        int i = 0;
        while (i < this.data.length) {
            out.append(this.data[i]);
            ++i;
        }
        return out.toString();
    }

    public static ClusterId deserialize(byte[] data) {
        byte[] id = Arrays.copyOfRange(data, 0, data.length - 8);
        ByteBuffer bf = ByteBuffer.wrap(data, data.length - 8, 8);
        return new ClusterId(id, bf.getLong());
    }
}

