/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.db.randomaccess;

import com.castortech.mdbxjni.Database;
import com.castortech.mdbxjni.Env;
import com.castortech.mdbxjni.EnvConfig;
import de.elpro.ewms.server.bundle.Activator;
import de.elpro.ewms.server.db.randomaccess.MDBXTxn;
import java.io.File;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.fx.core.log.Logger;

public class MDBXEnv {
    private static final Logger logger = Activator.getLoggerFactory() != null ? Activator.getLoggerFactory().createLogger(MDBXEnv.class.getName()) : null;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    final Lock readLock = this.readWriteLock.readLock();
    final Lock writeLock = this.readWriteLock.writeLock();
    Env env;
    Database db;

    public MDBXEnv(File dir) {
        if (logger != null) {
            logger.info("JNI MDBX INIT Successfull. MDBX Version " + Env.version());
        } else {
            System.out.println("JNI MDBX INIT Successfull. MDBX Version " + Env.version());
        }
        dir.mkdirs();
        try {
            EnvConfig envConfig = new EnvConfig();
            this.env = new Env();
            long mbSize = 0x100000L;
            long sizeLower = mbSize * 10L;
            long sizeUpper = mbSize * 1000L * 500L;
            long growthStep = mbSize * 100L;
            long shrinkThreshold = (long)((double)growthStep * 1.2);
            envConfig.setMapLower(sizeLower);
            envConfig.setMapUpper(sizeUpper);
            envConfig.setMapGrowth(growthStep);
            envConfig.setMapShrink(shrinkThreshold);
            this.env.open(dir.getAbsolutePath(), envConfig);
            this.db = this.env.openDatabase();
        }
        catch (Exception exc) {
            this.close();
            throw exc;
        }
    }

    public MDBXTxn txnRead() {
        return MDBXTxn.txnRead(this);
    }

    public MDBXTxn txnWrite() {
        return MDBXTxn.txnWrite(this);
    }

    public void close() {
        if (this.db != null) {
            this.db.close();
            this.db = null;
        }
        if (this.env != null) {
            this.env.close();
            this.env = null;
        }
    }
}

