/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.db.randomaccess;

import com.castortech.mdbxjni.Cursor;
import com.castortech.mdbxjni.CursorOp;
import com.castortech.mdbxjni.Entry;
import com.castortech.mdbxjni.Transaction;
import de.elpro.ewms.server.db.randomaccess.MDBXEnv;
import java.util.concurrent.locks.Lock;

public class MDBXTxn
implements AutoCloseable {
    private final Lock lock;
    private final MDBXEnv env;
    private final Transaction txn;

    private MDBXTxn(MDBXEnv env, boolean readOnly) {
        this.lock = readOnly ? env.readLock : env.writeLock;
        this.env = env;
        this.lock.lock();
        this.txn = env.env.createTransaction(readOnly);
    }

    public static MDBXTxn txnRead(MDBXEnv env) {
        return new MDBXTxn(env, true);
    }

    public static MDBXTxn txnWrite(MDBXEnv env) {
        return new MDBXTxn(env, false);
    }

    public MDBXCursor openCursor() {
        return new MDBXCursor(this);
    }

    public byte[] get(byte[] key) {
        return this.env.db.get(this.txn, key);
    }

    public void put(byte[] key, byte[] val) {
        this.env.db.put(this.txn, key, val);
    }

    public void del(byte[] key) {
        this.env.db.delete(this.txn, key);
    }

    public void commit() {
        this.txn.commit();
    }

    public void abort() {
        this.txn.abort();
    }

    @Override
    public void close() {
        this.txn.close();
        this.lock.unlock();
    }

    public static class MDBXCursor
    implements AutoCloseable {
        private final Cursor cursor;
        private Entry entry;

        private MDBXCursor(MDBXTxn txn) {
            this.cursor = txn.env.db.openCursor(txn.txn);
        }

        public boolean seakFirst() {
            this.entry = this.cursor.get(CursorOp.FIRST);
            return this.entry != null;
        }

        @Override
        public void close() {
            this.cursor.close();
        }

        public boolean seekAtLeast(byte[] id) {
            this.entry = this.cursor.get(CursorOp.SET_RANGE, id);
            return this.entry != null;
        }

        public byte[] getKey() {
            return this.entry.getKey();
        }

        public boolean seekNext() {
            this.entry = this.cursor.get(CursorOp.NEXT);
            return this.entry != null;
        }

        public void delete() {
            this.cursor.delete();
            this.entry = null;
        }

        public byte[] getVal() {
            return this.entry.getValue();
        }
    }
}

