/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.db.randomaccess;

import de.elpro.ewms.core.variable.value.IStoredVarValue;
import de.elpro.ewms.server.db.randomaccess.IEntityDescriptor;
import de.elpro.ewms.server.db.randomaccess.IMetadata;
import de.elpro.ewms.server.db.randomaccess.IMetadataReader;
import de.elpro.ewms.server.db.randomaccess.IRandomAccessDB;
import de.elpro.ewms.server.db.randomaccess.IValuePersister;
import de.elpro.ewms.server.db.randomaccess.MDBXEnv;
import de.elpro.ewms.server.db.randomaccess.MDBXTxn;
import de.elpro.ewms.server.db.randomaccess.RADBOptions;
import de.elpro.ewms.server.db.randomaccess.RADbTransaction;
import de.elpro.ewms.server.db.randomaccess.ValuesCluster;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class RandomAccessDB<M extends IMetadata, E, V, T extends IStoredVarValue>
implements IRandomAccessDB<M, E, V, T> {
    public static final String VERSION_FILE = "version.txt";
    public static final String VERSION = "0|com.castortech.mdbxjni_0.10.4";
    public static final byte[] METADATA_KEY = new byte[8];
    private MDBXEnv env;
    private final IMetadataReader<M> metadataReader;
    private final IValuePersister<T> valuePersister;
    private final IEntityDescriptor<E, V> entityDescriptor;
    private final RADBOptions options;
    private final String dbPath;

    static {
        ByteBuffer.wrap(METADATA_KEY).putLong(Long.MIN_VALUE);
    }

    public RandomAccessDB(String dbDirName, IMetadataReader<M> metadataReader, IEntityDescriptor<E, V> entityDescriptor, IValuePersister<T> valuePersister, RADBOptions options) {
        this.metadataReader = metadataReader;
        this.entityDescriptor = entityDescriptor;
        this.valuePersister = valuePersister;
        this.dbPath = dbDirName;
        this.options = options;
    }

    public String getDbPath() {
        return this.dbPath;
    }

    public void compressDb() {
    }

    public void init() {
        File versionFile;
        File file = new File(this.dbPath);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!(versionFile = new File(file, VERSION_FILE)).exists()) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (BufferedWriter writer = new BufferedWriter(new FileWriter(versionFile));){
                    writer.write(VERSION);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException exc) {
                throw new IllegalStateException(exc.getMessage());
            }
        }
    }

    @Override
    public boolean open() {
        this.init();
        File file = new File(this.dbPath);
        this.env = new MDBXEnv(file);
        return true;
    }

    @Override
    public boolean close() {
        this.env.close();
        return true;
    }

    @Override
    public M getMetadata() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (MDBXTxn txn = this.env.txnRead();){
            return this.metadataReader.read(txn.get(METADATA_KEY));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public RADbTransaction<M> beginTransaction() {
        MDBXTxn writeTxn = this.env.txnWrite();
        M metadata = this.metadataReader.read(writeTxn.get(METADATA_KEY));
        RADbTransaction<M> transaction = new RADbTransaction<M>(writeTxn, metadata);
        return transaction;
    }

    @Override
    public void commitTransaction(RADbTransaction<M> transaction) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (MDBXTxn txn = (MDBXTxn)transaction.getDbTxn();){
            if (transaction.getMetadata() != null) {
                txn.put(METADATA_KEY, transaction.getMetadata().toByteArray());
            }
            txn.commit();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void abortTransaction(RADbTransaction<M> transaction) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (MDBXTxn txn = (MDBXTxn)transaction.getDbTxn();){
            txn.abort();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected long getClusterStartTimestamp(long clusterWidth, long valueStartTimestamp) {
        if (clusterWidth == Long.MAX_VALUE) {
            return 0L;
        }
        long offset = valueStartTimestamp % clusterWidth;
        long clusterStartTimestamp = valueStartTimestamp - offset;
        return clusterStartTimestamp;
    }

    protected ValuesCluster<T> getCluster(MDBXTxn txn, E entity, V entityParam, long clusterStartTimestamp) {
        ClusterId clusterId = new ClusterId(this.entityDescriptor.getId(entity, entityParam), clusterStartTimestamp);
        return this.load(txn, clusterId);
    }

    protected ValuesCluster<T> load(MDBXTxn txn, ClusterId clusterId) {
        byte[] data = txn.get(clusterId.getData());
        if (data != null) {
            return ValuesCluster.deserialize(this.valuePersister, clusterId.getClusterStartTimestamp(), data);
        }
        return null;
    }

    @Override
    public boolean deleteClusters(long timestamp) {
        long newFirstClusterTs = this.getClusterStartTimestamp(this.entityDescriptor.getClusterWidth(null, null), timestamp);
        boolean clusterRemoved = false;
        byte[] id = null;
        do {
            Throwable throwable = null;
            Object var8_7 = null;
            try (MDBXTxn txn = this.env.txnWrite();){
                int deleteCounter = 0;
                Throwable throwable2 = null;
                Object var12_13 = null;
                try (MDBXTxn.MDBXCursor cursor = txn.openCursor();){
                    boolean hasNext = id == null ? cursor.seakFirst() : cursor.seekAtLeast(id);
                    while (hasNext) {
                        id = cursor.getKey();
                        if (Arrays.equals(id, METADATA_KEY)) {
                            hasNext = cursor.seekNext();
                            continue;
                        }
                        ClusterId clusterId = ClusterId.deserialize(id);
                        if (clusterId.getClusterStartTimestamp() < newFirstClusterTs) {
                            cursor.delete();
                            hasNext = cursor.seekNext();
                            clusterRemoved = true;
                            if (++deleteCounter < 20000) continue;
                            break;
                        }
                        int i = id.length - 8 - 1;
                        while (i >= 0) {
                            int v = id[i] & 0xFF;
                            if (v < 255) {
                                id[i] = (byte)(++v);
                                break;
                            }
                            id[i] = 0;
                            if (i == 0) break;
                            --i;
                        }
                        i = id.length - 8;
                        while (i < id.length) {
                            id[i] = 0;
                            ++i;
                        }
                        hasNext = cursor.seekAtLeast(id);
                    }
                    id = hasNext ? cursor.getKey() : null;
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
                txn.commit();
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        } while (id != null);
        return clusterRemoved;
    }

    @Override
    public ArrayList<T> loadValues(E entity, long fromTs, long toTs) {
        return this.loadValues(entity, null, fromTs, toTs);
    }

    @Override
    public ArrayList<T> loadValues(E entity, V entityParam) {
        byte[] id = this.entityDescriptor.getId(entity, entityParam);
        ClusterId firstId = new ClusterId(id, 0L);
        ArrayList<IStoredVarValue> values = new ArrayList<IStoredVarValue>();
        Throwable throwable = null;
        Object var7_8 = null;
        try (MDBXTxn txn = this.env.txnRead();){
            Throwable throwable2 = null;
            Object var10_13 = null;
            try (MDBXTxn.MDBXCursor cursor = txn.openCursor();){
                boolean hasNext = cursor.seekAtLeast(firstId.getData());
                while (hasNext) {
                    ClusterId clusterId = ClusterId.deserialize(cursor.getKey());
                    if (!Arrays.equals(clusterId.getEntityId(), id)) {
                        break;
                    }
                    ValuesCluster<T> cluster = ValuesCluster.deserialize(this.valuePersister, clusterId.getClusterStartTimestamp(), cursor.getVal());
                    IStoredVarValue[] iStoredVarValueArray = cluster.getData();
                    int n = iStoredVarValueArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IStoredVarValue value = iStoredVarValueArray[n2];
                        if (value != null) {
                            values.add(value);
                        }
                        ++n2;
                    }
                    hasNext = cursor.seekNext();
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        return values;
    }

    @Override
    public ArrayList<T> loadValues(E entity, V entityParam, long fromTs, long toTs) {
        byte[] entityId = this.entityDescriptor.getId(entity, entityParam);
        long clusterWidth = this.entityDescriptor.getClusterWidth(entity, entityParam);
        long firstClusterTs = this.getClusterStartTimestamp(clusterWidth, fromTs - 1L);
        int expectedListSize = 10;
        if (firstClusterTs != 0L) {
            expectedListSize = Math.max(100, (int)((toTs - fromTs) / 3600000L)) + 1;
        }
        ArrayList<IStoredVarValue> result = new ArrayList<IStoredVarValue>(expectedListSize);
        Throwable throwable = null;
        Object var15_12 = null;
        try (MDBXTxn txn = this.env.txnRead();){
            Throwable throwable2 = null;
            Object var18_17 = null;
            try (MDBXTxn.MDBXCursor cursor = txn.openCursor();){
                boolean hasNext = cursor.seekAtLeast(new ClusterId(entityId, firstClusterTs).getData());
                while (hasNext) {
                    ClusterId clusterId = ClusterId.deserialize(cursor.getKey());
                    if (!Arrays.equals(clusterId.getEntityId(), entityId)) break;
                    if (toTs <= clusterId.clusterStartTimestamp) {
                        break;
                    }
                    ValuesCluster<T> cluster = ValuesCluster.deserialize(this.valuePersister, clusterId.getClusterStartTimestamp(), cursor.getVal());
                    IStoredVarValue[] iStoredVarValueArray = cluster.getData();
                    int n = iStoredVarValueArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IStoredVarValue value = iStoredVarValueArray[n2];
                        if (value != null) {
                            if (value.getStartTimestamp() >= toTs) break;
                            if (result.size() == 1 && value.getEndTimestamp() <= fromTs) {
                                result.set(0, value);
                            } else {
                                result.add(value);
                            }
                        }
                        ++n2;
                    }
                    hasNext = cursor.seekNext();
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        return result;
    }

    @Override
    public void saveValues(RADbTransaction<M> transaction, E entity, Collection<T> values) {
        this.saveValues(transaction, entity, null, values);
    }

    @Override
    public void saveValues(RADbTransaction<M> transaction, E entity, V entityParam, Collection<T> values) {
        if (values.size() == 0) {
            return;
        }
        byte[] entityId = this.entityDescriptor.getId(entity, entityParam);
        long clusterWidth = this.entityDescriptor.getClusterWidth(entity, entityParam);
        long currentClusterEndTs = Long.MIN_VALUE;
        long currentClusterStartTs = 0L;
        ValuesCluster currentCluster = null;
        ArrayList<IStoredVarValue> insertBuffer = new ArrayList<IStoredVarValue>(256);
        MDBXTxn txn = (MDBXTxn)transaction.getDbTxn();
        for (IStoredVarValue value : values) {
            if (clusterWidth > 0L && value.getEndTimestamp() - value.getStartTimestamp() > clusterWidth) {
                throw new IllegalArgumentException(String.format("Values timespan %s (%d ms) is bigger than cluster size %d ms", value.toString(), value.getEndTimestamp() - value.getStartTimestamp(), clusterWidth));
            }
            if (value.getStartTimestamp() >= currentClusterEndTs) {
                if (currentCluster != null && !insertBuffer.isEmpty()) {
                    ClusterId clusterId = new ClusterId(entityId, currentClusterStartTs);
                    currentCluster.insertValues(insertBuffer);
                    txn.put(clusterId.getData(), currentCluster.serialize(clusterId.getClusterStartTimestamp()));
                    insertBuffer.clear();
                }
                currentClusterStartTs = this.getClusterStartTimestamp(clusterWidth, value.getStartTimestamp());
                currentClusterEndTs = currentClusterStartTs + clusterWidth;
                currentCluster = this.getCluster(txn, entity, entityParam, currentClusterStartTs);
                if (currentCluster == null) {
                    currentCluster = new ValuesCluster<T>(this.valuePersister);
                }
            }
            insertBuffer.add(value);
        }
        if (currentCluster != null && !insertBuffer.isEmpty()) {
            ClusterId clusterId = new ClusterId(entityId, currentClusterStartTs);
            currentCluster.insertValues(insertBuffer);
            txn.put(clusterId.getData(), currentCluster.serialize(clusterId.getClusterStartTimestamp()));
        }
    }

    @Override
    public void deleteValues(RADbTransaction<M> transaction, E entity, V entityParam, long fromTs, long toTs) {
        block17: {
            byte[] entityId = this.entityDescriptor.getId(entity, entityParam);
            long clusterWidth = this.entityDescriptor.getClusterWidth(entity, entityParam);
            long clusterStartTs = this.getClusterStartTimestamp(clusterWidth, fromTs);
            long clusterEndTs = this.getClusterStartTimestamp(clusterWidth, toTs);
            if (clusterEndTs < clusterStartTs) {
                return;
            }
            MDBXTxn txn = (MDBXTxn)transaction.getDbTxn();
            Throwable throwable = null;
            Object var17_13 = null;
            try (MDBXTxn.MDBXCursor cursor = txn.openCursor();){
                ClusterId clusterId;
                if (!cursor.seekAtLeast(new ClusterId(entityId, clusterStartTs).getData())) break block17;
                while (Arrays.equals((clusterId = ClusterId.deserialize(cursor.getKey())).getEntityId(), entityId)) {
                    if (toTs <= clusterId.clusterStartTimestamp) {
                    } else {
                        ValuesCluster<T> cluster = ValuesCluster.deserialize(this.valuePersister, clusterId.getClusterStartTimestamp(), cursor.getVal());
                        ArrayList<IStoredVarValue> filteredData = new ArrayList<IStoredVarValue>(cluster.getData().length);
                        IStoredVarValue[] iStoredVarValueArray = cluster.getData();
                        int n = iStoredVarValueArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IStoredVarValue t = iStoredVarValueArray[n2];
                            if (!(t == null || t.getEndTimestamp() > fromTs && t.getStartTimestamp() < toTs || t.getEndTimestamp() == t.getStartTimestamp() && t.getStartTimestamp() == fromTs)) {
                                filteredData.add(t);
                            }
                            ++n2;
                        }
                        if (!filteredData.isEmpty()) {
                            cluster.setValues(filteredData);
                            txn.put(clusterId.getData(), cluster.serialize(clusterId.getClusterStartTimestamp()));
                        } else {
                            cursor.delete();
                        }
                        if (cursor.seekNext()) continue;
                    }
                    break;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    @Override
    public IEntityDescriptor<E, V> getEntityDescriptor() {
        return this.entityDescriptor;
    }

    public static class ClusterId {
        private final byte[] entityId;
        private final byte[] data;
        private final long clusterStartTimestamp;

        public ClusterId(byte[] entityId, long clusterStartTimestamp) {
            this.entityId = entityId;
            this.clusterStartTimestamp = clusterStartTimestamp;
            ByteBuffer buffer = ByteBuffer.allocate(entityId.length + 8);
            buffer.put(entityId);
            buffer.putLong(clusterStartTimestamp);
            this.data = buffer.array();
        }

        byte[] getEntityId() {
            return this.entityId;
        }

        long getClusterStartTimestamp() {
            return this.clusterStartTimestamp;
        }

        byte[] getData() {
            return this.data;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ClusterId)) {
                return false;
            }
            ClusterId cid = (ClusterId)obj;
            return Arrays.equals(this.data, cid.data);
        }

        public int hashCode() {
            int hashCode = 0;
            int i = 0;
            while (i < this.data.length) {
                hashCode += this.data[i] * (0x11 ^ i);
                ++i;
            }
            return hashCode;
        }

        public String toString() {
            StringBuffer out = new StringBuffer(this.data.length);
            int i = 0;
            while (i < this.data.length) {
                out.append(this.data[i]);
                ++i;
            }
            return out.toString();
        }

        public static ClusterId deserialize(byte[] data) {
            byte[] id = Arrays.copyOfRange(data, 0, data.length - 8);
            ByteBuffer bf = ByteBuffer.wrap(data, data.length - 8, 8);
            return new ClusterId(id, bf.getLong());
        }
    }
}

