/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.db.randomaccess;

import de.elpro.ewms.core.time.TimeIntervalStringValue;
import de.elpro.ewms.core.time.TimeIntervalValue;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.server.db.randomaccess.ByteArraySerializer;
import de.elpro.ewms.server.db.randomaccess.MDBXTxn;
import de.elpro.ewms.server.db.randomaccess.TimeIntervalDB;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class TimeIntervaTextDB
extends TimeIntervalDB<VariableInstance, Integer, String> {
    public TimeIntervaTextDB(String dbPath) {
        super(dbPath, new VariableInstanceSerializer(), new ParameterSerializer(), new StringSerializer());
    }

    public void saveValues(MDBXTxn txn, VariableInstance entity, TimeIntervalStringValue ... values) {
        this.saveValues(txn, entity, Arrays.asList(values));
    }

    public void saveValues(MDBXTxn txn, VariableInstance entity, Integer param, TimeIntervalStringValue ... values) {
        this.saveValues(txn, entity, param, Arrays.asList(values));
    }

    @Override
    protected TimeIntervalValue<String> createTimeIntervalValue(long fromTs, long toTs, String value) {
        return new TimeIntervalStringValue(fromTs, toTs, value);
    }

    private static final class ParameterSerializer
    implements ByteArraySerializer<Integer> {
        private ParameterSerializer() {
        }

        @Override
        public byte[] serialize(Integer param) {
            ByteBuffer buffer = ByteBuffer.allocate(4);
            if (param != null) {
                buffer.putInt(param);
            }
            return buffer.array();
        }

        @Override
        public Integer deserialize(byte[] bytes) {
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            int id = buffer.getInt();
            return id;
        }
    }

    private static final class StringSerializer
    implements ByteArraySerializer<String> {
        private StringSerializer() {
        }

        @Override
        public byte[] serialize(String entity) {
            if (entity == null) {
                return null;
            }
            return entity.getBytes(StandardCharsets.UTF_8);
        }

        @Override
        public String deserialize(byte[] bytes) {
            if (bytes == null) {
                return null;
            }
            return new String(bytes, StandardCharsets.UTF_8);
        }
    }

    private static final class VariableInstanceSerializer
    implements ByteArraySerializer<VariableInstance> {
        private VariableInstanceSerializer() {
        }

        @Override
        public byte[] serialize(VariableInstance entity) {
            ByteBuffer buffer = ByteBuffer.allocate(4);
            buffer.putInt(entity.getId());
            return buffer.array();
        }

        @Override
        public VariableInstance deserialize(byte[] bytes) {
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            int id = buffer.getInt();
            return new VariableInstance(id);
        }
    }
}

