/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.db.randomaccess;

import de.elpro.ewms.core.time.TimeIntervalValue;
import de.elpro.ewms.server.db.randomaccess.ByteArraySerializer;
import de.elpro.ewms.server.db.randomaccess.MDBXEnv;
import de.elpro.ewms.server.db.randomaccess.MDBXTxn;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class TimeIntervalDB<E, P, V> {
    public static final String VERSION_FILE = "version.txt";
    public static final String VERSION = "0|com.castortech.mdbxjni_0.11.0";
    private MDBXEnv env;
    private final String dbPath;
    protected final ByteArraySerializer<E> entitySerializer;
    protected final ByteArraySerializer<P> paramSerializer;
    protected final ByteArraySerializer<V> valueSerializer;

    public TimeIntervalDB(String dbPath, ByteArraySerializer<E> entitySerializer, ByteArraySerializer<P> paramSerializer, ByteArraySerializer<V> valueSerializer) {
        this.dbPath = dbPath;
        this.entitySerializer = entitySerializer;
        this.paramSerializer = paramSerializer;
        this.valueSerializer = valueSerializer;
    }

    public void init() {
        File versionFile;
        File file = new File(this.dbPath);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!(versionFile = new File(file, VERSION_FILE)).exists()) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (BufferedWriter writer = new BufferedWriter(new FileWriter(versionFile));){
                    writer.write(VERSION);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException exc) {
                throw new IllegalStateException(exc.getMessage());
            }
        }
    }

    public boolean open() {
        this.init();
        File file = new File(this.dbPath);
        this.env = new MDBXEnv(file);
        return true;
    }

    public boolean close() {
        return false;
    }

    public MDBXTxn beginTransaction() {
        return this.env.txnWrite();
    }

    public ArrayList<TimeIntervalValue<V>> loadValues(E entity, long fromTs, long toTs) {
        return this.loadValues(entity, null, fromTs, toTs);
    }

    public ArrayList<TimeIntervalValue<V>> loadValues(E entity, P param, long fromTs, long toTs) {
        ArrayList<TimeIntervalValue<V>> result = new ArrayList<TimeIntervalValue<V>>();
        byte[] searchKey = this.createKey(entity, param);
        ByteBuffer leastKey = ByteBuffer.allocate(searchKey.length + 8);
        leastKey.put(searchKey);
        leastKey.putLong(fromTs);
        TimeIntervalValue<V> prevStoredValue = null;
        Throwable throwable = null;
        Object var12_11 = null;
        try (MDBXTxn txn = this.env.txnRead();){
            try {
                Throwable throwable2 = null;
                Object var15_16 = null;
                try (MDBXTxn.MDBXCursor cursor = txn.openCursor();){
                    boolean hasNext = cursor.seekAtLeast(leastKey.array());
                    while (hasNext) {
                        TimeIntervalValue<V> storedValue = this.readFromCursor(searchKey, cursor);
                        if (prevStoredValue != null && prevStoredValue.getToTs() > storedValue.getFromTs()) {
                            throw new IllegalStateException(String.format("Inkonsistent time data %s-%s", prevStoredValue, storedValue));
                        }
                        if (storedValue.getToTs() > fromTs) {
                            if (storedValue.getFromTs() >= toTs) {
                                break;
                            }
                            result.add(storedValue.in(fromTs, toTs));
                        }
                        hasNext = cursor.seekNext();
                        prevStoredValue = storedValue;
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (NoSuchElementException noSuchElementException) {}
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        return result;
    }

    public void saveValues(MDBXTxn txn, E entity, Collection<TimeIntervalValue<V>> values) {
        this.saveValues(txn, entity, null, values);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public void saveValues(MDBXTxn txn, E entity, P param, Collection<TimeIntervalValue<V>> values) {
        if (values == null || values.isEmpty()) {
            return;
        }
        valIterator = values.iterator();
        insertValue = valIterator.next();
        fromTs = insertValue.getFromTs();
        if (fromTs < (toTs = insertValue.getToTs())) ** GOTO lbl14
        throw new IllegalArgumentException("Inconsistent first value time range");
lbl-1000:
        // 1 sources

        {
            insertValue = valIterator.next();
            if (toTs > insertValue.getFromTs()) {
                throw new IllegalArgumentException("Unsequentional values");
            }
            if (insertValue.getFromTs() >= insertValue.getToTs()) {
                throw new IllegalArgumentException("Inconsistent value time range");
            }
            toTs = insertValue.getToTs();
lbl14:
            // 2 sources

            ** while (valIterator.hasNext())
        }
lbl15:
        // 1 sources

        searchKey = this.createKey(entity, param);
        leastKey = ByteBuffer.allocate(searchKey.length + 8);
        leastKey.put(searchKey);
        leastKey.putLong(fromTs);
        reinserts = new ArrayList<Object>();
        storedValue = null;
        prevValue = null;
        storedValueModified = false;
        var15_13 = null;
        var16_15 = null;
        try {
            cursor = txn.openCursor();
            try {
                hasNext = cursor.seekAtLeast(leastKey.array());
                if (hasNext) {
                    try {
                        storedValue = this.readFromCursor(searchKey, cursor);
                    }
                    catch (NoSuchElementException v0) {
                        storedValue = null;
                    }
                }
                for (TimeIntervalValue value : values) {
                    if (storedValue != null && storedValue.getToTs() < value.getFromTs()) {
                        reinserts.add(storedValue);
                    }
                    if (storedValue != null && storedValue.getFromTs() < value.getFromTs() && value.getToTs() < storedValue.getToTs()) {
                        reinserts.add(new TimeIntervalValue(storedValue.getFromTs(), value.getFromTs(), storedValue.getValue()));
                    }
                    while (storedValue != null && storedValue.getToTs() <= value.getToTs()) {
                        if (value.getIntersectDuration(storedValue) > 0L || value.continues(storedValue)) {
                            if (storedValue.getFromTs() < value.getFromTs()) {
                                reinserts.add(new TimeIntervalValue(storedValue.getFromTs(), value.getFromTs(), storedValue.getValue()));
                            }
                            if (!storedValueModified) {
                                cursor.delete();
                            }
                        }
                        if (hasNext = cursor.seekNext()) {
                            try {
                                storedValue = this.readFromCursor(searchKey, cursor);
                                storedValueModified = false;
                            }
                            catch (NoSuchElementException v1) {
                                storedValue = null;
                            }
                            continue;
                        }
                        storedValue = null;
                    }
                    if (value.getValue() != null) {
                        reinserts.add(value);
                    }
                    if (storedValue != null && (storedValue.getFromTs() < value.getToTs() && value.getToTs() < storedValue.getToTs() || storedValue.continues(value))) {
                        storedValue = new TimeIntervalValue<V>(value.getToTs(), storedValue.getToTs(), storedValue.getValue());
                        if (!storedValueModified) {
                            cursor.delete();
                        }
                        storedValueModified = true;
                    }
                    prevValue = value;
                }
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
        catch (Throwable var16_16) {
            if (var15_13 == null) {
                var15_13 = var16_16;
            } else if (var15_13 != var16_16) {
                var15_13.addSuppressed(var16_16);
            }
            throw var15_13;
        }
        if (storedValue != null && storedValueModified && prevValue.getToTs() == storedValue.getFromTs()) {
            reinserts.add(storedValue);
        }
        mergedReinserts = new ArrayList<TimeIntervalValue>();
        for (TimeIntervalValue reinsertValue : reinserts) {
            if (mergedReinserts.size() == 0) {
                mergedReinserts.add(reinsertValue);
                continue;
            }
            prevValue = (TimeIntervalValue)mergedReinserts.get(mergedReinserts.size() - 1);
            if (prevValue.getToTs() > reinsertValue.getFromTs()) {
                throw new IllegalStateException();
            }
            if (prevValue != null && prevValue.getToTs() == reinsertValue.getFromTs() && prevValue.getValue().equals(reinsertValue.getValue())) {
                prevValue = new TimeIntervalValue(prevValue.getFromTs(), reinsertValue.getToTs(), reinsertValue.getValue());
                mergedReinserts.set(mergedReinserts.size() - 1, prevValue);
                continue;
            }
            mergedReinserts.add(reinsertValue);
        }
        for (TimeIntervalValue reinsertValue : mergedReinserts) {
            keyBuffer = ByteBuffer.allocate(searchKey.length + 16);
            keyBuffer.put(searchKey);
            keyBuffer.putLong(reinsertValue.getToTs());
            keyBuffer.putLong(reinsertValue.getFromTs());
            txn.put(keyBuffer.array(), this.valueSerializer.serialize(reinsertValue.getValue()));
        }
    }

    public void deleteValues(MDBXTxn txn, E entity, long fromTs, long toTs) {
        this.deleteValues(txn, entity, null, fromTs, toTs);
    }

    public void deleteValues(MDBXTxn txn, E entity, P param, long fromTs, long toTs) {
        byte[] searchKey = this.createKey(entity, param);
        ByteBuffer leastKey = ByteBuffer.allocate(searchKey.length + 8);
        leastKey.put(searchKey);
        leastKey.putLong(fromTs);
        ArrayList<TimeIntervalValue> reinsert = new ArrayList<TimeIntervalValue>();
        try {
            Throwable throwable = null;
            Iterator iterator = null;
            try (MDBXTxn.MDBXCursor cursor = txn.openCursor();){
                boolean hasNext = cursor.seekAtLeast(leastKey.array());
                while (hasNext) {
                    TimeIntervalValue<V> storedValue = this.readFromCursor(searchKey, cursor);
                    if (storedValue.getToTs() > fromTs) {
                        if (storedValue.getFromTs() < fromTs && storedValue.getToTs() > fromTs) {
                            reinsert.add(new TimeIntervalValue(storedValue.getFromTs(), fromTs, storedValue.getValue()));
                        }
                        if (storedValue.getFromTs() < toTs && storedValue.getToTs() > toTs) {
                            reinsert.add(new TimeIntervalValue(toTs, storedValue.getToTs(), storedValue.getValue()));
                        }
                        if (storedValue.getFromTs() >= toTs) {
                            break;
                        }
                        cursor.delete();
                    }
                    hasNext = cursor.seekNext();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (NoSuchElementException noSuchElementException) {}
        for (TimeIntervalValue insertValue : reinsert) {
            ByteBuffer keyBuffer = ByteBuffer.allocate(searchKey.length + 16);
            keyBuffer.put(searchKey);
            keyBuffer.putLong(insertValue.getToTs());
            keyBuffer.putLong(insertValue.getFromTs());
            txn.put(keyBuffer.array(), this.valueSerializer.serialize(insertValue.getValue()));
        }
    }

    public void deleteValues(MDBXTxn txn, E entity) {
        this.deleteValues(txn, entity, null);
    }

    public void deleteValues(MDBXTxn txn, E entity, P param) {
        byte[] searchKey = this.createKey(entity, param);
        try {
            Throwable throwable = null;
            Object var6_7 = null;
            try (MDBXTxn.MDBXCursor cursor = txn.openCursor();){
                boolean hasNext = cursor.seekAtLeast(searchKey);
                while (hasNext) {
                    this.readFromCursor(searchKey, cursor);
                    cursor.delete();
                    hasNext = cursor.seekNext();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (NoSuchElementException noSuchElementException) {}
    }

    private byte[] createKey(E entity, P param) {
        byte[] entityKey = this.entitySerializer.serialize(entity);
        byte[] paramKey = this.paramSerializer.serialize(param);
        byte[] key = Arrays.copyOf(entityKey, entityKey.length + paramKey.length);
        System.arraycopy(paramKey, 0, key, entityKey.length, paramKey.length);
        return key;
    }

    private TimeIntervalValue<V> readFromCursor(byte[] forEntity, MDBXTxn.MDBXCursor cursor) throws NoSuchElementException {
        byte[] key = cursor.getKey();
        byte[] val = cursor.getVal();
        if (key.length < forEntity.length + 16 || !Arrays.equals(forEntity, 0, forEntity.length, key, 0, forEntity.length)) {
            throw new NoSuchElementException();
        }
        ByteBuffer keyBuffer = ByteBuffer.wrap(cursor.getKey());
        keyBuffer.position(forEntity.length);
        long entryToTs = keyBuffer.getLong();
        long entryFromTs = keyBuffer.getLong();
        return this.createTimeIntervalValue(entryFromTs, entryToTs, this.valueSerializer.deserialize(val));
    }

    protected TimeIntervalValue<V> createTimeIntervalValue(long fromTs, long toTs, V value) {
        return new TimeIntervalValue(fromTs, toTs, value);
    }

    public String getDbPath() {
        return this.dbPath;
    }
}

