/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.db.randomaccess;

import de.elpro.ewms.core.variable.value.IStoredVarValue;
import de.elpro.ewms.server.Server;
import de.elpro.ewms.server.bundle.Activator;
import de.elpro.ewms.server.db.randomaccess.IValuePersister;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Exception;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import org.eclipse.fx.core.log.Logger;

public class ValuesCluster<T extends IStoredVarValue> {
    private static final Logger logger = Activator.getLoggerFactory().createLogger(ValuesCluster.class.getName());
    private static boolean useCompressor = Server.getConfig().isDbCompress();
    private static LZ4Factory compressorFactory = LZ4Factory.fastestInstance();
    private T[] data;
    private final IValuePersister<T> valuePersister;

    public ValuesCluster(IValuePersister<T> valuePersister) {
        this.valuePersister = valuePersister;
        this.data = valuePersister.createArray(0);
    }

    public void insertValues(ArrayList<T> values) {
        T[] oldData = this.data;
        this.data = this.valuePersister.createArray(this.data.length + values.size());
        int i = 0;
        int j = 0;
        int x = 0;
        while (i < oldData.length && j < values.size()) {
            T oldValue = oldData[i];
            if (oldValue == null) break;
            IStoredVarValue newValue = (IStoredVarValue)values.get(j);
            if (oldValue.getEndTimestamp() < newValue.getStartTimestamp()) {
                this.data[x++] = oldValue;
                ++i;
                continue;
            }
            if (oldValue.getEndTimestamp() == newValue.getStartTimestamp()) {
                if (oldValue.getStartTimestamp() < oldValue.getEndTimestamp()) {
                    this.data[x++] = oldValue;
                    ++i;
                    continue;
                }
                this.data[x++] = newValue;
                ++j;
                ++i;
                while (i < oldData.length && oldData[i].getStartTimestamp() < newValue.getEndTimestamp()) {
                    ++i;
                }
                continue;
            }
            if (newValue.getEndTimestamp() <= oldValue.getStartTimestamp()) {
                this.data[x++] = newValue;
                ++j;
                continue;
            }
            this.data[x++] = newValue;
            ++j;
            ++i;
            while (i < oldData.length && oldData[i] != null && oldData[i].getStartTimestamp() < newValue.getEndTimestamp()) {
                ++i;
            }
        }
        while (j < values.size()) {
            this.data[x++] = (IStoredVarValue)values.get(j++);
        }
        while (i < oldData.length) {
            this.data[x++] = oldData[i++];
        }
    }

    public void setValues(ArrayList<T> values) {
        this.data = this.valuePersister.createArray(values.size());
        int i = 0;
        while (i < values.size()) {
            this.data[i] = (IStoredVarValue)values.get(i);
            ++i;
        }
    }

    public void setData(T[] values) {
        this.data = values;
    }

    public T[] getData() {
        return this.data;
    }

    public byte[] serialize(long clusterId) {
        return this.serialize(clusterId, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] serialize(long clusterId, boolean ignoreErrors) {
        int size = 0;
        int i = 0;
        while (i < this.data.length) {
            if (this.data[i] != null) {
                if (i > 0 && this.data[i - 1] != null && this.data[i - 1].getEndTimestamp() > this.data[i].getStartTimestamp()) {
                    if (!ignoreErrors) throw new RuntimeException("Unconsistent cluster data!");
                    this.data[i] = null;
                } else {
                    ++size;
                }
            }
            ++i;
        }
        ByteBuffer buffer = ByteBuffer.allocate(size * this.valuePersister.getElementSize());
        T[] TArray = this.data;
        int n = this.data.length;
        int n2 = 0;
        while (n2 < n) {
            T value = TArray[n2];
            if (value != null) {
                this.valuePersister.serialize(buffer, clusterId, value);
            }
            ++n2;
        }
        return ValuesCluster.compress(buffer.array());
    }

    public static <T extends IStoredVarValue> ValuesCluster<T> deserialize(IValuePersister<T> valuePersister, long clusterTimestamp, byte[] data) {
        data = ValuesCluster.decompress(data);
        ValuesCluster<T> cluster = new ValuesCluster<T>(valuePersister);
        cluster.data = valuePersister.createArray(data.length / valuePersister.getElementSize());
        ByteBuffer buffer = ByteBuffer.wrap(data);
        int i = 0;
        while (i < cluster.data.length) {
            cluster.data[i] = valuePersister.deserialize(buffer, clusterTimestamp);
            ++i;
        }
        return cluster;
    }

    private static byte[] compress(byte[] data) {
        if (!useCompressor) {
            return data;
        }
        LZ4Compressor compressor = compressorFactory.fastCompressor();
        int maxCompressedLength = compressor.maxCompressedLength(data.length);
        byte[] compressed = new byte[maxCompressedLength];
        int compressedLength = compressor.compress(data, 0, data.length, compressed, 0, maxCompressedLength);
        byte[] result = new byte[4 + compressedLength];
        ByteBuffer.wrap(result, 0, 4).putInt(data.length);
        System.arraycopy(compressed, 0, result, 4, compressedLength);
        return result;
    }

    private static byte[] decompress(byte[] data) {
        if (!useCompressor) {
            return data;
        }
        ByteBuffer inputBuffer = ByteBuffer.wrap(data);
        int originalSize = inputBuffer.getInt();
        LZ4FastDecompressor decompressor = compressorFactory.fastDecompressor();
        byte[] restored = new byte[originalSize];
        ByteBuffer outputBuffer = ByteBuffer.wrap(restored);
        try {
            decompressor.decompress(inputBuffer, outputBuffer);
        }
        catch (LZ4Exception exc) {
            logger.error(String.format("Values Cluster decompression error. Bytes: %s", Arrays.toString(data)), (Throwable)exc);
        }
        return restored;
    }
}

