/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.db.rawmeasurements;

import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.server.db.rawmeasurements.ValuesMap;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class ClusterHeader {
    private final LinkedHashMap<VariableInstance, ValuesMap> instanceValueMap = new LinkedHashMap();

    public Set<VariableInstance> getInstances() {
        return this.instanceValueMap.keySet();
    }

    public ValuesMap getValueMap(VariableInstance instance) {
        return this.instanceValueMap.get(instance);
    }

    public void serialize(ByteBuffer buffer) {
        buffer.putInt(this.instanceValueMap.size());
        for (Map.Entry<VariableInstance, ValuesMap> entry : this.instanceValueMap.entrySet()) {
            VariableInstance instance = entry.getKey();
            ValuesMap map = entry.getValue();
            buffer.putInt(instance.getId());
            buffer.putInt(instance.getVariable().getId());
            buffer.putInt(instance.getStructureObject().getId());
            map.serialize(buffer);
        }
    }

    public void putValuesMap(VariableInstance instance, ValuesMap map) {
        this.instanceValueMap.put(instance, map);
    }

    public static ClusterHeader deserialize(ByteBuffer buffer) {
        ClusterHeader header = new ClusterHeader();
        int size = buffer.getInt();
        while (size-- > 0) {
            int instanceId = buffer.getInt();
            int variableId = buffer.getInt();
            int structureObjectId = buffer.getInt();
            VariableInstance instance = new VariableInstance(instanceId);
            instance.setVariable(new Variable(variableId));
            instance.setStructureObject(new StructureObject(structureObjectId));
            ValuesMap map = ValuesMap.deserialize(buffer);
            header.instanceValueMap.put(instance, map);
        }
        return header;
    }

    public int computeBytesCount() {
        int size = 4;
        for (ValuesMap map : this.instanceValueMap.values()) {
            size += 8 + map.computeBytesCount();
        }
        return size;
    }
}

