/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.db.rawmeasurements;

import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.time.TsInterval;
import de.elpro.ewms.core.time.TsIntervals;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.VariableInstanceType;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.core.variable.value.IVarValuesCollection;
import de.elpro.ewms.core.variable.value.MeasuredValue;
import de.elpro.ewms.core.variable.value.VarInstanceValuesCollectionMap;
import de.elpro.ewms.server.Server;
import de.elpro.ewms.server.cache.ORMCache;
import de.elpro.ewms.server.rasterizedvalues.RasterizedValues;
import de.elpro.ewms.server.storage.MeasurementsStorage;
import de.elpro.ewms.server.storage.TimeRangeMetadata;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;

public class MeasurementsStorageUtils {
    private static final long TS_1990 = ZonedDateTime.of(1990, 1, 1, 0, 0, 0, 0, ZoneOffset.UTC).toInstant().toEpochMilli();

    public static void importMeasurements(VarInstanceValuesCollectionMap request, boolean syncArchiveStorages) throws Exception {
        long maxEndTs = Instant.now().toEpochMilli() + Raster.Second_15.toMilli();
        MeasurementsStorageUtils.importMeasurements(maxEndTs, request.getBackingMap(), syncArchiveStorages);
    }

    public static void importMeasurements(long maxImportValueEndTs, Map<VariableInstance, IVarValuesCollection> importValues, boolean syncArchiveStorages) throws Exception {
        TsInterval realtimeInterval;
        if (importValues.isEmpty()) {
            return;
        }
        for (Map.Entry<VariableInstance, IVarValuesCollection> entry : importValues.entrySet()) {
            int instanceId = entry.getKey().getId();
            VariableInstance instance = ORMCache.getVariableInstance(instanceId);
            MeasurementsStorageUtils.checkPLCVariableInstance(instanceId, instance);
            MeasuredValue prevMV = null;
            IVarValuesCollection values = entry.getValue();
            for (IVarValue val : values) {
                MeasurementsStorageUtils.checkMeasuredValue(maxImportValueEndTs, prevMV, val);
            }
        }
        long maxTs = Long.MIN_VALUE;
        long minTs = Long.MAX_VALUE;
        HashMap<VariableInstance, TsIntervals> importedIntervals = new HashMap<VariableInstance, TsIntervals>();
        for (Map.Entry<VariableInstance, IVarValuesCollection> entry : importValues.entrySet()) {
            VariableInstance instance = entry.getKey();
            IVarValuesCollection values = entry.getValue();
            TsIntervals importedInstanceIntervals = (TsIntervals)importedIntervals.get(instance);
            if (importedInstanceIntervals == null) {
                importedInstanceIntervals = new TsIntervals();
                importedIntervals.put(instance, importedInstanceIntervals);
            }
            for (IVarValue vv : values) {
                MeasuredValue mv = (MeasuredValue)vv;
                importedInstanceIntervals.addInterval(mv.getStartTimestamp(), mv.getEndTimestamp());
                minTs = Math.min(minTs, mv.getStartTimestamp());
                maxTs = Math.max(maxTs, mv.getEndTimestamp());
            }
        }
        if (maxTs <= minTs) {
            return;
        }
        MeasurementsStorage.getOrCreateInstance().storeMeasurements(importValues);
        if (!syncArchiveStorages) {
            return;
        }
        importValues.clear();
        Server.getGlobalValuesWriter().synchronizeWithRAWDB(importedIntervals, true);
        TimeRangeMetadata realtimeMeta = Server.getRawValuesViews().getRealtimeView().getArchiveStorage().getCachedMetadata();
        Raster realtimeRaster = Server.getRawValuesViews().getRealtimeView().getRaster();
        long realtimeWidth = Server.getConfig().getRealtimeViewWindowWidth() * realtimeRaster.toMilli();
        if (realtimeMeta != null && realtimeMeta.getTimeRangeBegin() != null && realtimeMeta.getTimeRangeEnd() != null) {
            endTs = Math.max(realtimeMeta.getTimeRangeEnd(), realtimeRaster.getRasterEnd(maxTs));
            startTs = Math.min(realtimeMeta.getTimeRangeBegin(), realtimeRaster.getRasterBegin(minTs));
            if (startTs < endTs - realtimeWidth) {
                startTs = realtimeRaster.getRasterBegin(endTs - realtimeWidth);
            }
            realtimeInterval = new TsInterval(startTs, endTs);
        } else {
            endTs = realtimeRaster.getRasterEnd(maxTs);
            startTs = realtimeRaster.getRasterBegin(minTs);
            if (startTs < endTs - realtimeWidth) {
                startTs = realtimeRaster.getRasterBegin(endTs - realtimeWidth);
            }
            realtimeInterval = new TsInterval(startTs, endTs);
        }
        HashMap<VariableInstance, TsIntervals> realtimeInstanceIntervals = new HashMap<VariableInstance, TsIntervals>();
        for (Map.Entry entry : importedIntervals.entrySet()) {
            VariableInstance instance = (VariableInstance)entry.getKey();
            TsIntervals intervals = (TsIntervals)entry.getValue();
            TsIntervals realtimeIntervals = new TsIntervals();
            for (TsInterval interval : intervals.getIntervals()) {
                TsInterval intersectInterval = interval.getIntersectInterval(realtimeInterval);
                if (intersectInterval == null) continue;
                realtimeIntervals.addInterval(intersectInterval);
            }
            if (realtimeIntervals.isEmpty()) continue;
            realtimeInstanceIntervals.put(instance, realtimeIntervals);
        }
        if (!realtimeInstanceIntervals.isEmpty()) {
            Server.getRealtimeValuesWriter().synchronizeWithRAWDB(realtimeInstanceIntervals, true);
        }
        importedIntervals.clear();
    }

    public static void importPredictedValues(Map<VariableInstance, IVarValuesCollection> values, boolean syncArchiveStorages) throws Exception {
        if (values.isEmpty()) {
            return;
        }
        RasterizedValues globalView = Server.getRawValuesViews().getGlobalView();
        try {
            globalView.writeLock();
            Long plcNow = globalView.getPlcNow();
            if (plcNow == null) {
                return;
            }
            long maxTs = Long.MIN_VALUE;
            long minTs = Long.MAX_VALUE;
            HashMap<VariableInstance, TsIntervals> importedIntervals = new HashMap<VariableInstance, TsIntervals>();
            HashMap<VariableInstance, IVarValuesCollection> futureValues = new HashMap<VariableInstance, IVarValuesCollection>();
            for (Map.Entry<VariableInstance, IVarValuesCollection> entry : values.entrySet()) {
                int instanceId = entry.getKey().getId();
                VariableInstance instance = ORMCache.getVariableInstance(instanceId);
                MeasurementsStorageUtils.checkPLCVariableInstance(instanceId, instance);
                IVarValuesCollection instanceValues = entry.getValue();
                Throwable throwable = null;
                Object var16_15 = null;
                try (IVarValuesCollection futureInstanceValues = new IVarValuesCollection();){
                    TsIntervals importedInstanceIntervals = (TsIntervals)importedIntervals.get(instance);
                    if (importedInstanceIntervals == null) {
                        importedInstanceIntervals = new TsIntervals();
                        importedIntervals.put(instance, importedInstanceIntervals);
                    }
                    MeasuredValue prevVal = null;
                    for (IVarValue vv : instanceValues) {
                        MeasurementsStorageUtils.checkMeasuredValue(Long.MAX_VALUE, prevVal, vv);
                        MeasuredValue mv = (MeasuredValue)vv;
                        if (mv.getStartTimestamp() < plcNow) continue;
                        if (prevVal != null && mv.getStartTimestamp() < prevVal.getEndTimestamp()) {
                            throw new IllegalStateException();
                        }
                        importedInstanceIntervals.addInterval(mv.getStartTimestamp(), mv.getEndTimestamp());
                        futureInstanceValues.add((IVarValue)mv);
                        prevVal = mv;
                        minTs = Math.min(minTs, mv.getStartTimestamp());
                        maxTs = Math.max(maxTs, mv.getEndTimestamp());
                    }
                    futureValues.put(instance, futureInstanceValues);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            if (maxTs <= minTs) {
                return;
            }
            MeasurementsStorage.getOrCreateInstance().storeMeasurements(futureValues);
            values.clear();
            if (!syncArchiveStorages) {
                return;
            }
            Server.getGlobalValuesWriter().synchronizeWithRAWDB(importedIntervals, false);
            importedIntervals.clear();
        }
        finally {
            globalView.writeUnlock();
        }
    }

    private static void checkPLCVariableInstance(int id, VariableInstance instance) throws IllegalArgumentException {
        if (instance == null) {
            throw new IllegalArgumentException(String.format("Variable instance with id=%d not found", id));
        }
        if (instance.getType() != VariableInstanceType.PLC) {
            throw new IllegalArgumentException(String.format("Variable instance %s is not of PLC type", instance));
        }
    }

    private static void checkMeasuredValue(long maxEndTs, MeasuredValue prevMV, IVarValue val) throws IllegalArgumentException {
        if (!(val instanceof MeasuredValue)) {
            throw new IllegalArgumentException(String.format("Values %s is not of MeasuredValue type", val));
        }
        MeasuredValue mv = (MeasuredValue)val;
        if (mv.getEndTimestamp() - mv.getStartTimestamp() <= 0L) {
            throw new IllegalArgumentException(String.format("Value %s timespan check error", mv));
        }
        if (mv.getEndTimestamp() > maxEndTs) {
            throw new IllegalArgumentException(String.format("Value %s to far in future", mv));
        }
        if (mv.getStartTimestamp() < TS_1990) {
            throw new IllegalArgumentException(String.format("Value %s is before 1990", mv));
        }
        if (prevMV != null && prevMV.getEndTimestamp() > mv.getStartTimestamp()) {
            throw new IllegalArgumentException(String.format("Timesequence error at %s - %s", prevMV, mv));
        }
    }
}

