/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.db.rawmeasurements;

import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.time.TsIntervals;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.core.variable.value.IVarValuesCollection;
import de.elpro.ewms.core.variable.value.MeasuredValue;
import de.elpro.ewms.core.variable.value.VarInstanceValuesCollectionMapCluster;
import de.elpro.ewms.core.variable.value.VarInstanceValuesCollectionMapClustered;
import de.elpro.ewms.server.Server;
import de.elpro.ewms.server.bundle.Activator;
import de.elpro.ewms.server.cache.ORMCache;
import de.elpro.ewms.server.db.rawmeasurements.LoggerFXFacade;
import de.elpro.ewms.server.db.rawmeasurements.ValuesCluster;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.transaction.file.FileResourceManager;
import org.apache.commons.transaction.file.ResourceManagerException;
import org.apache.commons.transaction.file.ResourceManagerSystemException;
import org.apache.commons.transaction.util.LoggerFacade;
import org.eclipse.fx.core.log.Logger;

public class RawDB {
    private static final String MEASUREMENTS_FILE_EXT = "mvcl";
    private static final DateTimeFormatter FOLDER_NAME_FORMATER = DateTimeFormatter.ofPattern("yyyy.MM.dd");
    private static final DateTimeFormatter CLUSTER_FILE_NAME_FORMATER = DateTimeFormatter.ofPattern("yyyy.MM.dd HH_mm");
    private static final Logger logger = Activator.getLoggerFactory().createLogger(RawDB.class.toString());
    static final boolean DEBUG = Server.getConfig() != null ? Server.getConfig().isDebug() : false;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();
    private final File dir;
    private final FileResourceManager frm;
    private final Raster clusterSize;
    private final long windowWidth;

    public RawDB(File storageDir, Raster clusterSize, long windowWidth) {
        this.dir = storageDir;
        this.clusterSize = clusterSize;
        this.windowWidth = windowWidth;
        this.frm = new FileResourceManager(this.dir.getPath(), String.valueOf(this.dir.getPath()) + "/trx_tmp", false, (LoggerFacade)new LoggerFXFacade(logger));
    }

    public boolean start() {
        try {
            this.removeTrxTmpFolder();
            this.frm.start();
            return true;
        }
        catch (Exception exc) {
            logger.error("Error occured", (Throwable)exc);
            return false;
        }
    }

    public boolean stop() {
        try {
            this.frm.stop(1);
            return true;
        }
        catch (ResourceManagerSystemException exc) {
            logger.error("Error occured", (Throwable)exc);
            return false;
        }
    }

    protected boolean tryRecovery(String txId) {
        if (txId != null) {
            try {
                this.frm.rollbackTransaction((Object)txId);
            }
            catch (Exception exception) {
                logger.error("Error during rollback of transaction");
            }
        }
        boolean dirty = true;
        try {
            dirty = this.frm.recover();
        }
        catch (Exception recoveryException) {
            logger.error("Error during file manager autorecovery", (Throwable)recoveryException);
        }
        if (!dirty) {
            logger.info("File manager recovery successfull");
        }
        logger.error("Restart database with deleted trx_tmp.");
        boolean serverDown = false;
        try {
            serverDown = this.frm.stop(2);
        }
        catch (ResourceManagerSystemException shutdownException) {
            logger.error("Error killing file manager.", (Throwable)shutdownException);
            return false;
        }
        if (!serverDown) {
            logger.error("Could not kill file manager");
            return false;
        }
        return this.start();
    }

    protected void removeTrxTmpFolder() throws IOException {
        FileUtils.deleteDirectory((File)new File(this.frm.getWorkDir()));
    }

    public void storeMeasurements(Map<VariableInstance, IVarValuesCollection> measurements) throws Exception {
        boolean hasValues = false;
        HashMap<VariableInstance, IVarValuesCollection> copy = new HashMap<VariableInstance, IVarValuesCollection>();
        for (Map.Entry<VariableInstance, IVarValuesCollection> entry : measurements.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            copy.put(ORMCache.getVariableInstance(entry.getKey().getId()), entry.getValue());
            hasValues = true;
        }
        if (!hasValues) {
            return;
        }
        measurements = copy;
        long lastValuesEndTimestamp = Long.MIN_VALUE;
        long forRead = 0L;
        long forMerge = 0L;
        long forSerialize = 0L;
        long forStore = 0L;
        long forCheck = 0L;
        long forCommit = 0L;
        long start = System.nanoTime();
        String txId = null;
        try {
            try {
                this.writeLock.lock();
                txId = this.frm.generatedUniqueTxId();
                this.frm.startTransaction((Object)txId);
                for (VarInstanceValuesCollectionMapCluster clusteredInstanceValues : new VarInstanceValuesCollectionMapClustered(this.clusterSize, measurements)) {
                    start = System.nanoTime();
                    long clusterBeginTs = clusteredInstanceValues.getClusterBeginTs();
                    ValuesCluster cluster = this.readCluster(txId, clusterBeginTs);
                    Map<VariableInstance, IVarValuesCollection> clusterStoredValues = cluster.getClusterValues();
                    forRead += System.nanoTime() - start;
                    Thread.yield();
                    start = System.nanoTime();
                    for (Map.Entry clusterMeasurements : clusteredInstanceValues.getInstanceValues().entrySet()) {
                        VariableInstance instance = (VariableInstance)clusterMeasurements.getKey();
                        IVarValuesCollection instanceMeasurementValues = (IVarValuesCollection)clusterMeasurements.getValue();
                        IVarValuesCollection instanceStoredValues = clusterStoredValues.get(instance);
                        instanceStoredValues = RawDB.mergeValues(instanceMeasurementValues, instanceStoredValues);
                        clusterStoredValues.put(instance, instanceStoredValues);
                    }
                    forMerge += System.nanoTime() - start;
                    Thread.yield();
                    start = System.nanoTime();
                    byte[] clusterData = cluster.serialize();
                    forSerialize += System.nanoTime() - start;
                    Thread.yield();
                    start = System.nanoTime();
                    String clusterFileName = this.getClusterFile(clusterBeginTs);
                    IOUtils.write((byte[])clusterData, (OutputStream)this.frm.writeResource((Object)txId, (Object)clusterFileName));
                    forStore += System.nanoTime() - start;
                    if (!DEBUG) continue;
                    start = System.nanoTime();
                    ValuesCluster writeCluster = this.readCluster(txId, clusterBeginTs);
                    Map<VariableInstance, IVarValuesCollection> writeClusterStoredValues = writeCluster.getClusterValues();
                    int i = 0;
                    for (Map.Entry<VariableInstance, IVarValuesCollection> clusterMeasurements : clusterStoredValues.entrySet()) {
                        IVarValuesCollection expectedValues = clusterMeasurements.getValue();
                        IVarValuesCollection actualValues = writeClusterStoredValues.get(clusterMeasurements.getKey());
                        boolean errorFound = false;
                        int errorIndex = 0;
                        Iterator eI = expectedValues.iterator();
                        Iterator aI = actualValues.iterator();
                        while (eI.hasNext() || aI.hasNext()) {
                            if (!eI.hasNext() || !aI.hasNext()) {
                                errorFound = true;
                                break;
                            }
                            MeasuredValue eV = (MeasuredValue)eI.next();
                            MeasuredValue aV = (MeasuredValue)aI.next();
                            if (eV.getStartTimestamp() != aV.getStartTimestamp() || eV.getEndTimestamp() != aV.getEndTimestamp() || (float)eV.getValue() != (float)aV.getValue() || eV.getQuality() != aV.getQuality()) {
                                errorFound = true;
                                break;
                            }
                            ++errorIndex;
                        }
                        if (!errorFound) continue;
                        logger.error(String.valueOf(++i) + " errorIndex\t: " + errorIndex);
                    }
                    forCheck += System.nanoTime() - start;
                }
                start = System.nanoTime();
                int prepareResult = this.frm.prepareTransaction((Object)txId);
                if (prepareResult == -1) {
                    this.frm.rollbackTransaction((Object)txId);
                } else {
                    this.frm.commitTransaction((Object)txId);
                }
                forCommit += System.nanoTime() - start;
                if (DEBUG) {
                    logger.info(String.format("Stats\r\n\tRead \t\t: %.3f\r\n\tMerge \t\t: %.3f\r\n\tSerialize \t: %.3f\r\n\tStore \t\t: %.3f\r\n\tCheck \t\t: %.3f\r\n\tCommit\t\t: %.3f", (double)forRead / 1000000.0, (double)forMerge / 1000000.0, (double)forSerialize / 1000000.0, (double)forStore / 1000000.0, (double)forCheck / 1000000.0, (double)forCommit / 1000000.0));
                }
            }
            catch (Exception exc) {
                logger.error("Error occured during raw values storage", (Throwable)exc);
                if (exc instanceof ResourceManagerException) {
                    logger.error("File manager failure. Trying to recover it ...");
                    boolean recoverySuccessfull = this.tryRecovery(txId);
                    if (!recoverySuccessfull) {
                        logger.error("Recovery was unsuccessfull");
                    } else {
                        logger.info("Recovery was successfull");
                    }
                } else if (txId != null) {
                    try {
                        this.frm.rollbackTransaction((Object)txId);
                    }
                    catch (ResourceManagerException rollbackExc) {
                        logger.error("Error during rollback of transaction", (Throwable)rollbackExc);
                    }
                }
                throw exc;
            }
        }
        finally {
            this.writeLock.unlock();
        }
        if (this.windowWidth > 0L && lastValuesEndTimestamp != Long.MIN_VALUE) {
            try {
                this.removeClusters(lastValuesEndTimestamp - this.windowWidth * this.clusterSize.toMilli());
            }
            catch (Exception exc) {
                logger.error("Error removing old clusters", (Throwable)exc);
            }
        }
    }

    public Map<VariableInstance, IVarValuesCollection> readMeasurements(Long from, Long to) throws Exception {
        return this.readMeasurements(from, to, (Set<VariableInstance>)null);
    }

    public Map<VariableInstance, IVarValuesCollection> readMeasurements(Long from, Long to, Set<VariableInstance> instances) throws Exception {
        HashMap<VariableInstance, IVarValuesCollection> measurements = new HashMap<VariableInstance, IVarValuesCollection>();
        if (from == null) {
            from = this.getFirstClusterBegin();
        }
        if (to == null) {
            to = this.getLastClusterEnd();
        }
        if (from == null || to == null) {
            return measurements;
        }
        if (to <= from) {
            throw new IllegalArgumentException();
        }
        String txId = null;
        try {
            try {
                this.readLock.lock();
                txId = this.frm.generatedUniqueTxId();
                this.frm.startTransaction((Object)txId);
                long clusterBegin = this.clusterSize.getRasterBegin(from.longValue());
                while (clusterBegin < to) {
                    ValuesCluster cluster = this.readCluster(txId, clusterBegin, instances);
                    for (Map.Entry<VariableInstance, IVarValuesCollection> entry : cluster.getClusterValues().entrySet()) {
                        VariableInstance instance = entry.getKey();
                        IVarValuesCollection clusterInstanceValues = entry.getValue();
                        IVarValuesCollection instanceValues = (IVarValuesCollection)measurements.get(instance);
                        if (instanceValues == null) {
                            instanceValues = new IVarValuesCollection();
                            measurements.put(instance, instanceValues);
                        }
                        for (IVarValue vv : clusterInstanceValues) {
                            MeasuredValue mv = (MeasuredValue)vv;
                            if (from >= mv.getEndTimestamp() || mv.getStartTimestamp() >= to) continue;
                            instanceValues.add((IVarValue)mv);
                        }
                    }
                    clusterBegin += this.clusterSize.toMilli();
                }
            }
            catch (Exception exc) {
                logger.error("Error occured during raw values read", (Throwable)exc);
                throw exc;
            }
        }
        catch (Throwable throwable) {
            if (txId != null) {
                try {
                    this.frm.commitTransaction((Object)txId);
                }
                catch (Exception exception) {}
            }
            measurements.values().forEach(v -> v.close());
            this.readLock.unlock();
            throw throwable;
        }
        if (txId != null) {
            try {
                this.frm.commitTransaction((Object)txId);
            }
            catch (Exception exception) {}
        }
        measurements.values().forEach(v -> v.close());
        this.readLock.unlock();
        return measurements;
    }

    public Map<VariableInstance, TsIntervals> getMissingIntervals(Set<VariableInstance> instances, long from, long to) throws Exception {
        HashMap<VariableInstance, TsIntervals> missingIntervals = new HashMap<VariableInstance, TsIntervals>();
        HashMap<VariableInstance, Long> lastTimestamps = new HashMap<VariableInstance, Long>();
        for (VariableInstance instance : instances) {
            missingIntervals.put(instance, new TsIntervals());
            lastTimestamps.put(instance, from);
        }
        if (to <= from) {
            throw new IllegalArgumentException();
        }
        String txId = null;
        try {
            try {
                this.readLock.lock();
                txId = this.frm.generatedUniqueTxId();
                this.frm.startTransaction((Object)txId);
                long clusterBegin = this.clusterSize.getRasterBegin(from);
                while (clusterBegin < to) {
                    ValuesCluster cluster = this.readCluster(txId, clusterBegin, instances);
                    for (Map.Entry<VariableInstance, IVarValuesCollection> entry : cluster.getClusterValues().entrySet()) {
                        VariableInstance instance = entry.getKey();
                        if (!instances.contains(instance)) continue;
                        IVarValuesCollection clusterInstanceValues = entry.getValue();
                        TsIntervals instanceMissingIntervals = (TsIntervals)missingIntervals.get(instance);
                        Long lastTs = (Long)lastTimestamps.get(instance);
                        for (IVarValue vv : clusterInstanceValues) {
                            MeasuredValue mv = (MeasuredValue)vv;
                            if (from >= mv.getEndTimestamp() || mv.getStartTimestamp() >= to) continue;
                            if (lastTs < mv.getStartTimestamp() || !mv.isValid()) {
                                long missingIntervalEndTs = mv.isValid() ? mv.getStartTimestamp() : mv.getEndTimestamp();
                                instanceMissingIntervals.addInterval(lastTs.longValue(), missingIntervalEndTs);
                            }
                            lastTs = mv.getEndTimestamp();
                        }
                        lastTimestamps.put(instance, lastTs);
                    }
                    clusterBegin += this.clusterSize.toMilli();
                }
                for (VariableInstance instance : lastTimestamps.keySet()) {
                    long lastTs = (Long)lastTimestamps.get(instance);
                    if (lastTs >= to) continue;
                    TsIntervals instanceMissingIntervals = (TsIntervals)missingIntervals.get(instance);
                    instanceMissingIntervals.addInterval(lastTs, to);
                }
            }
            catch (Exception exc) {
                logger.error("Error occured during raw values read", (Throwable)exc);
                throw exc;
            }
        }
        catch (Throwable throwable) {
            if (txId != null) {
                try {
                    this.frm.commitTransaction((Object)txId);
                }
                catch (Exception exception) {}
            }
            this.readLock.unlock();
            throw throwable;
        }
        if (txId != null) {
            try {
                this.frm.commitTransaction((Object)txId);
            }
            catch (Exception exception) {}
        }
        this.readLock.unlock();
        return missingIntervals;
    }

    public void readMeasurements(long from, long to, SequentialReadCallback readCallback) throws Exception {
        if (to <= from) {
            throw new IllegalArgumentException();
        }
        String txId = null;
        try {
            try {
                this.readLock.lock();
                txId = this.frm.generatedUniqueTxId();
                this.frm.startTransaction((Object)txId);
                int clusters = (int)((this.clusterSize.getRasterEnd(to) - this.clusterSize.getRasterBegin(from)) / this.clusterSize.toMilli());
                long clusterBegin = this.clusterSize.getRasterBegin(from);
                int clusterIndex = 0;
                while (clusterBegin < to) {
                    ValuesCluster cluster = this.readCluster(txId, clusterBegin);
                    for (Map.Entry<VariableInstance, IVarValuesCollection> entry : cluster.getClusterValues().entrySet()) {
                        IVarValuesCollection clusterInstanceValues = entry.getValue();
                        if (clusterBegin >= from && clusterBegin + this.clusterSize.toMilli() <= to) continue;
                        Throwable throwable = null;
                        Object var16_15 = null;
                        try (IVarValuesCollection filteredValues = new IVarValuesCollection();){
                            for (IVarValue val : clusterInstanceValues) {
                                MeasuredValue mv = (MeasuredValue)val;
                                if (mv.getStartTimestamp() < from || mv.getEndTimestamp() > to) continue;
                                filteredValues.add(val);
                            }
                            entry.setValue(filteredValues);
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    readCallback.read((double)(++clusterIndex) / (double)clusters, cluster.getClusterValues());
                    clusterBegin += this.clusterSize.toMilli();
                }
            }
            catch (Exception exc) {
                logger.error("Error occured during raw values read", (Throwable)exc);
                throw exc;
            }
        }
        catch (Throwable throwable) {
            if (txId != null) {
                try {
                    this.frm.commitTransaction((Object)txId);
                }
                catch (Exception exception) {}
            }
            this.readLock.unlock();
            throw throwable;
        }
        if (txId != null) {
            try {
                this.frm.commitTransaction((Object)txId);
            }
            catch (Exception exception) {}
        }
        this.readLock.unlock();
    }

    public void removeClusters(long upToTs) throws Exception {
        LocalDateTime upToDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(upToTs), ZoneOffset.UTC);
        LocalDate upToDate = upToDateTime.toLocalDate();
        try {
            File[] dirs;
            this.writeLock.lock();
            File[] fileArray = dirs = this.dir.listFiles(File::isDirectory);
            int n = dirs.length;
            int n2 = 0;
            while (n2 < n) {
                block12: {
                    File subDir = fileArray[n2];
                    try {
                        LocalDate subDirDate = LocalDate.parse(subDir.getName(), FOLDER_NAME_FORMATER);
                        if (subDirDate.isBefore(upToDate)) {
                            FileUtils.deleteDirectory((File)subDir);
                            break block12;
                        }
                        if (!subDirDate.isEqual(upToDate)) break block12;
                        File[] fileArray2 = subDir.listFiles(File::isFile);
                        int n3 = fileArray2.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            File candidate = fileArray2[n4];
                            String fileName = candidate.getName();
                            if (fileName.endsWith(".mvcl")) {
                                try {
                                    LocalDateTime fileDateTime = LocalDateTime.parse(fileName.substring(0, fileName.length() - (MEASUREMENTS_FILE_EXT.length() + 1)), CLUSTER_FILE_NAME_FORMATER);
                                    if (fileDateTime.isBefore(upToDateTime)) {
                                        candidate.delete();
                                    }
                                }
                                catch (Exception exception) {}
                            }
                            ++n4;
                        }
                    }
                    catch (Exception exception) {}
                }
                ++n2;
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private Long getFirstClusterBegin() {
        File[] subDirs;
        File storeDir = new File(this.frm.getStoreDir());
        File[] fileArray = subDirs = storeDir.listFiles(file -> file.isDirectory());
        int n = subDirs.length;
        int n2 = 0;
        while (n2 < n) {
            File subDir = fileArray[n2];
            try {
                File[] subFiles;
                LocalDate.parse(subDir.getName(), FOLDER_NAME_FORMATER);
                File[] fileArray2 = subFiles = subDir.listFiles(file -> file.isFile());
                int n3 = subFiles.length;
                int n4 = 0;
                while (n4 < n3) {
                    File subFile = fileArray2[n4];
                    String fileName = subFile.getName();
                    if (fileName.endsWith(".mvcl")) {
                        fileName = fileName.substring(0, fileName.length() - (MEASUREMENTS_FILE_EXT.length() + 1));
                        try {
                            LocalDateTime ldt = LocalDateTime.parse(fileName, CLUSTER_FILE_NAME_FORMATER);
                            Instant ts = ldt.atOffset(ZoneOffset.UTC).toInstant();
                            return ts.toEpochMilli();
                        }
                        catch (DateTimeParseException dateTimeParseException) {}
                    }
                    ++n4;
                }
            }
            catch (DateTimeParseException dateTimeParseException) {}
            ++n2;
        }
        return null;
    }

    private Long getLastClusterEnd() {
        File storeDir = new File(this.frm.getStoreDir());
        File[] subDirs = storeDir.listFiles(file -> file.isDirectory());
        int j = subDirs.length - 1;
        while (j >= 0) {
            File subDir = subDirs[j];
            try {
                LocalDate.parse(subDir.getName(), FOLDER_NAME_FORMATER);
                File[] subFiles = subDir.listFiles(file -> file.isFile());
                int i = subFiles.length - 1;
                while (i >= 0) {
                    File subFile = subFiles[i];
                    String fileName = subFile.getName();
                    if (fileName.endsWith(".mvcl")) {
                        fileName = fileName.substring(0, fileName.length() - (MEASUREMENTS_FILE_EXT.length() + 1));
                        try {
                            LocalDateTime ldt = LocalDateTime.parse(fileName, CLUSTER_FILE_NAME_FORMATER);
                            Instant ts = ldt.atOffset(ZoneOffset.UTC).toInstant();
                            return ts.toEpochMilli() + this.clusterSize.toMilli();
                        }
                        catch (DateTimeParseException dateTimeParseException) {}
                    }
                    --i;
                }
            }
            catch (DateTimeParseException dateTimeParseException) {}
            --j;
        }
        return null;
    }

    private String getClusterFile(long clusterBegin) {
        LocalDateTime clusterTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(clusterBegin), ZoneOffset.UTC);
        String folderName = FOLDER_NAME_FORMATER.format(clusterTime);
        String fileName = String.valueOf(folderName) + "/" + CLUSTER_FILE_NAME_FORMATER.format(clusterTime) + "." + MEASUREMENTS_FILE_EXT;
        return fileName;
    }

    private ValuesCluster readCluster(Object txId, long clusterBegin) throws ResourceManagerException, IOException {
        return this.readCluster(txId, clusterBegin, null);
    }

    private ValuesCluster readCluster(Object txId, long clusterBegin, Set<VariableInstance> instances) throws ResourceManagerException, IOException {
        ValuesCluster cluster;
        byte[] data;
        String clusterFileName = this.getClusterFile(clusterBegin);
        if (!this.frm.resourceExists(txId, (Object)clusterFileName)) {
            return new ValuesCluster(clusterBegin);
        }
        try (InputStream is = this.frm.readResource(txId, (Object)clusterFileName);){
            data = IOUtils.toByteArray((InputStream)is);
        }
        ByteBuffer buffer = ByteBuffer.wrap(data);
        try {
            cluster = ValuesCluster.deserialize(buffer, instances);
        }
        catch (Exception exc) {
            throw new IOException(String.format("Error deserializing file %s: %s", clusterFileName, exc.getMessage()));
        }
        if (cluster.getClusterBegin() != clusterBegin) {
            throw new IOException("wrong cluster begin!");
        }
        return cluster;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static IVarValuesCollection mergeValues(IVarValuesCollection master, IVarValuesCollection slave) {
        var2_2 = null;
        var3_4 = null;
        try {
            merged = new IVarValuesCollection();
            try {
                if (master == null || master.isEmpty()) {
                    merged.addAll((Collection)slave);
                    return merged;
                }
                if (slave == null || slave.isEmpty()) {
                    merged.addAll((Collection)master);
                    return merged;
                }
                masterIterator = master.iterator();
                slaveIterator = slave.iterator();
                masterValue /* !! */  = (MeasuredValue)masterIterator.next();
                slaveValue /* !! */  = (MeasuredValue)slaveIterator.next();
                prevValue = null;
                while (masterValue /* !! */  != null && slaveValue /* !! */  != null) {
                    if (slaveValue /* !! */ .getEndTimestamp() > masterValue /* !! */ .getStartTimestamp()) ** GOTO lbl31
                    if (prevValue == null || prevValue.getEndTimestamp() <= slaveValue /* !! */ .getStartTimestamp()) {
                        merged.add((IVarValue)slaveValue /* !! */ );
                        prevValue = slaveValue /* !! */ ;
                    }
                    if (slaveIterator.hasNext()) {
                        slaveValue /* !! */  = (MeasuredValue)slaveIterator.next();
                        continue;
                    }
                    slaveValue /* !! */  = null;
                    continue;
lbl-1000:
                    // 1 sources

                    {
                        slaveValue /* !! */  = slaveIterator.hasNext() != false ? (MeasuredValue)slaveIterator.next() : null;
lbl31:
                        // 2 sources

                        ** while (slaveValue /* !! */  != null && slaveValue /* !! */ .getStartTimestamp() < masterValue /* !! */ .getEndTimestamp())
                    }
lbl32:
                    // 1 sources

                    if (prevValue == null || prevValue.getEndTimestamp() <= masterValue /* !! */ .getStartTimestamp()) {
                        merged.add((IVarValue)masterValue /* !! */ );
                        prevValue = masterValue /* !! */ ;
                    }
                    masterValue /* !! */  = masterIterator.hasNext() != false ? (MeasuredValue)masterIterator.next() : null;
                }
                while (masterValue /* !! */  != null) {
                    if (prevValue.getEndTimestamp() <= masterValue /* !! */ .getStartTimestamp()) {
                        merged.add((IVarValue)masterValue /* !! */ );
                        prevValue = masterValue /* !! */ ;
                    }
                    masterValue /* !! */  = masterIterator.hasNext() != false ? (MeasuredValue)masterIterator.next() : null;
                }
                while (slaveValue /* !! */  != null) {
                    if (prevValue.getEndTimestamp() <= slaveValue /* !! */ .getStartTimestamp()) {
                        merged.add((IVarValue)slaveValue /* !! */ );
                        prevValue = slaveValue /* !! */ ;
                    }
                    slaveValue /* !! */  = slaveIterator.hasNext() != false ? (MeasuredValue)slaveIterator.next() : null;
                }
                return merged;
            }
            finally {
                if (merged != null) {
                    merged.close();
                }
            }
        }
        catch (Throwable var3_5) {
            if (var2_2 == null) {
                var2_2 = var3_5;
            } else if (var2_2 != var3_5) {
                var2_2.addSuppressed(var3_5);
            }
            throw var2_2;
        }
    }

    public static interface SequentialReadCallback {
        public void read(double var1, Map<VariableInstance, IVarValuesCollection> var3);
    }
}

