/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.db.rawmeasurements;

import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.value.IVarValuesCollection;
import de.elpro.ewms.core.variable.value.MeasuredValue;
import de.elpro.ewms.server.db.rawmeasurements.ClusterHeader;
import de.elpro.ewms.server.db.rawmeasurements.RawDB;
import de.elpro.ewms.server.db.rawmeasurements.ValuesMap;
import de.elpro.ewms.server.db.rawmeasurements.ValuesMapEntry;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ValuesCluster {
    public static final short VERSION = 1;
    public static final short TYPE_FLOAT_VALUES = 1;
    public static final short TYPE_DOUBLE_VALUES = 2;
    private final long clusterBegin;
    private final Map<VariableInstance, IVarValuesCollection> clusterValues = new HashMap<VariableInstance, IVarValuesCollection>();

    public ValuesCluster(long clusterBegin) {
        this.clusterBegin = clusterBegin;
    }

    public long getClusterBegin() {
        return this.clusterBegin;
    }

    public static ValuesCluster deserialize(ByteBuffer buffer, Set<VariableInstance> instances) {
        short version = buffer.getShort();
        short type = buffer.getShort();
        if (version != 1 || type != 1) {
            throw new IllegalArgumentException("Wrong version of values cluster or corrupt file.");
        }
        long clusterBegin = buffer.getLong();
        ValuesCluster cluster = new ValuesCluster(clusterBegin);
        ClusterHeader header = ClusterHeader.deserialize(buffer);
        for (VariableInstance instance : header.getInstances()) {
            ValuesMap valuesMap = header.getValueMap(instance);
            if (instances == null || instances.contains(instance)) {
                Throwable throwable = null;
                Iterator<ValuesMapEntry> iterator = null;
                try (IVarValuesCollection values = new IVarValuesCollection();){
                    for (ValuesMapEntry valuesMapEntry : valuesMap.getEntrys()) {
                        valuesMapEntry.readValues(values, clusterBegin, buffer);
                    }
                    cluster.clusterValues.put(instance, values);
                    continue;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            for (ValuesMapEntry valuesMapEntry : valuesMap.getEntrys()) {
                valuesMapEntry.skipValues(buffer);
            }
        }
        return cluster;
    }

    public byte[] serialize() {
        ClusterHeader header = new ClusterHeader();
        HashMap<VariableInstance, ValuesMap> instanceValuesMap = new HashMap<VariableInstance, ValuesMap>();
        int totalValuesBytesCount = 0;
        for (VariableInstance instance : this.clusterValues.keySet()) {
            IVarValuesCollection rawValues = this.clusterValues.get(instance);
            if (rawValues.isEmpty()) continue;
            ValuesMap valuesMap = this.createValuesMap(rawValues);
            instanceValuesMap.put(instance, valuesMap);
            header.putValuesMap(instance, valuesMap);
            totalValuesBytesCount += valuesMap.computeValuesBytesCount();
        }
        Thread.yield();
        int headerBytesCount = header.computeBytesCount();
        byte[] data = new byte[12 + headerBytesCount + totalValuesBytesCount];
        ByteBuffer buffer = ByteBuffer.wrap(data);
        buffer.putShort((short)1);
        buffer.putShort((short)1);
        buffer.putLong(this.clusterBegin);
        header.serialize(buffer);
        for (VariableInstance instance : this.clusterValues.keySet()) {
            IVarValuesCollection rawValues = this.clusterValues.get(instance);
            if (rawValues.isEmpty()) continue;
            ValuesMap valuesMap = (ValuesMap)instanceValuesMap.get(instance);
            Iterator iterator = rawValues.iterator();
            for (ValuesMapEntry mapEntry : valuesMap.getEntrys()) {
                mapEntry.writeValues(this.clusterBegin, iterator, buffer);
            }
        }
        return data;
    }

    private ValuesMap createValuesMap(IVarValuesCollection rawValues) {
        ValuesMap valuesMap = new ValuesMap();
        int entryType = 1;
        int entryCount = 1;
        Iterator iterator = rawValues.iterator();
        MeasuredValue prevPrevValue = null;
        MeasuredValue prevValue = (MeasuredValue)iterator.next();
        while (iterator.hasNext()) {
            MeasuredValue value = (MeasuredValue)iterator.next();
            if (value.getQuality() == prevValue.getQuality() && value.getStartTimestamp() == prevValue.getEndTimestamp() && prevValue.getEndTimestamp() - prevValue.getStartTimestamp() == value.getEndTimestamp() - value.getStartTimestamp()) {
                if (value.getValue() == prevValue.getValue()) {
                    if (entryType == 1) {
                        if (entryCount == 1) {
                            entryType = 3;
                            ++entryCount;
                        } else {
                            valuesMap.getEntrys().add(new ValuesMapEntry(1, entryCount - 1));
                            entryType = 3;
                            entryCount = 2;
                        }
                    } else if (entryType == 3) {
                        ++entryCount;
                    } else if (entryCount > 2 && prevPrevValue != null && prevPrevValue.getValue() == prevValue.getValue()) {
                        valuesMap.getEntrys().add(new ValuesMapEntry(4, entryCount - 2));
                        entryType = 3;
                        entryCount = 3;
                    } else {
                        ++entryCount;
                    }
                } else if (entryType == 3) {
                    valuesMap.getEntrys().add(new ValuesMapEntry(3, entryCount));
                    entryType = 1;
                    entryCount = 1;
                } else if (entryType == 1 && entryCount > 1) {
                    valuesMap.getEntrys().add(new ValuesMapEntry(1, entryCount - 1));
                    entryType = 4;
                    entryCount = 2;
                } else {
                    entryType = 4;
                    ++entryCount;
                }
            } else if (entryType == 1) {
                ++entryCount;
            } else {
                valuesMap.getEntrys().add(new ValuesMapEntry((byte)entryType, entryCount));
                entryType = 1;
                entryCount = 1;
            }
            prevPrevValue = prevValue;
            prevValue = value;
        }
        valuesMap.getEntrys().add(new ValuesMapEntry((byte)entryType, entryCount));
        if (RawDB.DEBUG) {
            int size = 0;
            for (ValuesMapEntry e : valuesMap.getEntrys()) {
                size += e.getCount();
            }
            if (size != rawValues.size()) {
                System.out.println("unexpected!");
            }
        }
        return valuesMap;
    }

    public Map<VariableInstance, IVarValuesCollection> getClusterValues() {
        return this.clusterValues;
    }
}

