/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.db.rawmeasurements;

import de.elpro.ewms.server.db.rawmeasurements.ValuesMapEntry;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.LinkedList;

public class ValuesMap {
    private final LinkedList<ValuesMapEntry> entrys = new LinkedList();

    public void serialize(ByteBuffer buffer) {
        buffer.putInt(this.entrys.size());
        for (ValuesMapEntry entry : this.entrys) {
            entry.serialize(buffer);
        }
    }

    public Collection<ValuesMapEntry> getEntrys() {
        return this.entrys;
    }

    public static ValuesMap deserialize(ByteBuffer buffer) {
        ValuesMap map = new ValuesMap();
        int size = buffer.getInt();
        while (size-- > 0) {
            map.entrys.add(ValuesMapEntry.deserialize(buffer));
        }
        return map;
    }

    public int computeBytesCount() {
        int size = 4;
        return size += this.entrys.size() * ValuesMapEntry.getBytesCount();
    }

    public int computeValuesBytesCount() {
        int size = 4;
        for (ValuesMapEntry entry : this.entrys) {
            size += entry.computeMeasurementValuesBytesCount();
        }
        return size;
    }
}

