/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.db.rawmeasurements;

import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.core.variable.value.IVarValuesCollection;
import de.elpro.ewms.core.variable.value.MeasuredValue;
import java.nio.ByteBuffer;
import java.util.Iterator;

public class ValuesMapEntry {
    public static final byte SINGLE_VALUE = 1;
    private static final byte SINGLE_VALUE_SEQUENCE = 2;
    public static final byte IDENTICAL_VALUES = 3;
    public static final byte SEQUENTIAL_VALUES = 4;
    private final byte type;
    private final int count;

    public ValuesMapEntry(byte type, int count) {
        this.type = type;
        this.count = count;
    }

    public byte getType() {
        return this.type;
    }

    public int getCount() {
        return this.count;
    }

    public void readValues(IVarValuesCollection values, long clusterBegin, ByteBuffer buffer) {
        switch (this.type) {
            case 1: 
            case 2: {
                int i = 0;
                while (i < this.count) {
                    long startTimestamp = clusterBegin + (long)buffer.getInt();
                    long endTimestamp = clusterBegin + (long)buffer.getInt();
                    double dVal = buffer.getFloat();
                    float quality = buffer.getFloat();
                    values.add((IVarValue)new MeasuredValue(startTimestamp, endTimestamp, dVal, (double)quality));
                    ++i;
                }
                break;
            }
            case 3: {
                long startTimestamp = clusterBegin + (long)buffer.getInt();
                long endTimestamp = clusterBegin + (long)buffer.getInt();
                double dVal = buffer.getFloat();
                float quality = buffer.getFloat();
                long tsStep = endTimestamp - startTimestamp;
                int i = 0;
                while (i < this.count) {
                    values.add((IVarValue)new MeasuredValue(startTimestamp + (long)i * tsStep, endTimestamp + (long)i * tsStep, dVal, (double)quality));
                    ++i;
                }
                break;
            }
            case 4: {
                long startTimestamp = clusterBegin + (long)buffer.getInt();
                long endTimestamp = clusterBegin + (long)buffer.getInt();
                float quality = buffer.getFloat();
                long tsStep = endTimestamp - startTimestamp;
                int i = 0;
                while (i < this.count) {
                    double dVal = buffer.getFloat();
                    values.add((IVarValue)new MeasuredValue(startTimestamp + (long)i * tsStep, endTimestamp + (long)i * tsStep, dVal, (double)quality));
                    ++i;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Entry Type");
            }
        }
    }

    public void skipValues(ByteBuffer buffer) {
        switch (this.type) {
            case 1: 
            case 2: {
                buffer.position(buffer.position() + this.count * 16);
                break;
            }
            case 3: {
                buffer.position(buffer.position() + 8 + 8);
                break;
            }
            case 4: {
                buffer.position(buffer.position() + 8 + 4 + this.count * 4);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Entry Type");
            }
        }
    }

    public void writeValues(long clusterBegin, Iterator<IVarValue> iterator, ByteBuffer buffer) {
        MeasuredValue value = (MeasuredValue)iterator.next();
        switch (this.type) {
            case 1: 
            case 2: {
                int i = 0;
                while (i < this.count) {
                    buffer.putInt((int)(value.getStartTimestamp() - clusterBegin));
                    buffer.putInt((int)(value.getEndTimestamp() - clusterBegin));
                    buffer.putFloat((float)value.getValue());
                    buffer.putFloat((float)value.getQuality());
                    if (i != this.count - 1) {
                        value = (MeasuredValue)iterator.next();
                    }
                    ++i;
                }
                break;
            }
            case 3: {
                buffer.putInt((int)(value.getStartTimestamp() - clusterBegin));
                buffer.putInt((int)(value.getEndTimestamp() - clusterBegin));
                buffer.putFloat((float)value.getValue());
                buffer.putFloat((float)value.getQuality());
                int i = 1;
                while (i < this.count) {
                    iterator.next();
                    ++i;
                }
                break;
            }
            case 4: {
                buffer.putInt((int)(value.getStartTimestamp() - clusterBegin));
                buffer.putInt((int)(value.getEndTimestamp() - clusterBegin));
                buffer.putFloat((float)value.getQuality());
                buffer.putFloat((float)value.getValue());
                int i = 1;
                while (i < this.count) {
                    buffer.putFloat((float)iterator.next().getValue());
                    ++i;
                }
                break;
            }
        }
    }

    public void serialize(ByteBuffer buffer) {
        if (this.type == 1) {
            if (this.count == 1) {
                buffer.put(this.type);
            } else {
                buffer.put((byte)2);
                buffer.putInt(this.count);
            }
        } else {
            buffer.put(this.type);
            buffer.putInt(this.count);
        }
    }

    public static ValuesMapEntry deserialize(ByteBuffer buffer) {
        byte type = buffer.get();
        int count = 1;
        if (type != 1) {
            count = buffer.getInt();
        }
        if (type == 2) {
            type = 1;
        }
        return new ValuesMapEntry(type, count);
    }

    public int computeMeasurementValuesBytesCount() {
        switch (this.type) {
            case 1: 
            case 2: {
                return 16 * this.count;
            }
            case 3: {
                return 16;
            }
            case 4: {
                return 8 + 4 * this.count + 4;
            }
        }
        return 0;
    }

    public static int getBytesCount() {
        return 5;
    }
}

