/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.events;

import de.elpro.ewms.core.events.Event;
import de.elpro.ewms.core.events.EventAction;
import de.elpro.ewms.core.lang.ScriptParser;
import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.time.TsInterval;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.calculated.FormulaNode;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.core.variable.value.IVarValuesCollection;
import de.elpro.ewms.server.Server;
import de.elpro.ewms.server.bundle.Activator;
import de.elpro.ewms.server.cache.EventsCache;
import de.elpro.ewms.server.calculated.FormulaEvaluator;
import de.elpro.ewms.server.events.EventActionJobs;
import de.elpro.ewms.server.model.IEventActionJob;
import de.elpro.ewms.server.model.ILastValuesChangedListener;
import de.elpro.ui.thread.NamedThreadFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.stream.Collectors;
import org.eclipse.fx.core.log.Logger;

public class CurrentValuesChangeListener
implements ILastValuesChangedListener {
    private static final Logger logger = Activator.getLoggerFactory().createLogger(CurrentValuesChangeListener.class.getName());
    private final ExecutorService executor = Executors.newCachedThreadPool((ThreadFactory)new NamedThreadFactory("current-values-change-job-executor-"));

    public CurrentValuesChangeListener() {
        EventsCache.getObservedInstances();
    }

    @Override
    public void valuesChanged(Map<VariableInstance, IVarValue> changes) {
        Raster raster = Server.getConfig().getRealtimeViewRaster();
        for (Map.Entry<Event, Collection<VariableInstance>> eventInstances : EventsCache.getObservedInstances().entrySet()) {
            Event event = eventInstances.getKey();
            List activeActions = event.getEventActions().stream().filter(ea -> ea.isActive()).collect(Collectors.toList());
            if (activeActions.isEmpty()) continue;
            Collection<VariableInstance> instances = eventInstances.getValue();
            FormulaNode operationTree = ScriptParser.parseFormula((String)event.getFireWhenExpression());
            TreeMap<VariableInstance, IVarValue> firedInstances = new TreeMap<VariableInstance, IVarValue>();
            HashMap<String, List<IVarValuesCollection>> parameters = new HashMap<String, List<IVarValuesCollection>>();
            for (VariableInstance instance : instances) {
                IVarValue value = changes.get(instance);
                if (value == null) continue;
                long intervalEnd = raster.getRasterEnd(value.getEndTimestamp());
                TsInterval interval = new TsInterval(intervalEnd - raster.toMilli(), intervalEnd);
                List<IVarValuesCollection> valueArrayList = Collections.singletonList(IVarValuesCollection.create((IVarValue[])new IVarValue[]{value}));
                parameters.put("x", valueArrayList);
                try {
                    IVarValue result = FormulaEvaluator.compute(operationTree, interval, parameters, raster).getFirst();
                    if (!result.isValid() || result.getValue() == 0.0) continue;
                    firedInstances.put(instance, value);
                }
                catch (Exception exception) {}
            }
            if (firedInstances.isEmpty()) continue;
            this.executor.execute(() -> activeActions.parallelStream().forEach(ea -> {
                IEventActionJob job = EventActionJobs.getJob(ea.getJobId());
                if (job == null) {
                    return;
                }
                job.run((EventAction)ea, firedInstances);
            }));
        }
    }
}

