/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.ftp;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.Socket;
import java.util.Locale;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocket;
import org.apache.commons.net.ftp.FTPSClient;

public class SSLSessionReuseFTPSClient
extends FTPSClient {
    public SSLSessionReuseFTPSClient(String arg0, boolean arg1) {
        super(arg0, arg1);
    }

    protected void _prepareDataSocket_(Socket socket) throws IOException {
        if (socket instanceof SSLSocket) {
            SSLSession session = ((SSLSocket)this._socket_).getSession();
            if (session.isValid()) {
                SSLSessionContext context = session.getSessionContext();
                try {
                    Field sessionHostPortCache = context.getClass().getDeclaredField("sessionHostPortCache");
                    sessionHostPortCache.setAccessible(true);
                    Object cache = sessionHostPortCache.get(context);
                    Method method = cache.getClass().getDeclaredMethod("put", Object.class, Object.class);
                    method.setAccessible(true);
                    method.invoke(cache, String.format("%s:%s", socket.getInetAddress().getHostName(), String.valueOf(socket.getPort())).toLowerCase(Locale.ROOT), session);
                    method.invoke(cache, String.format("%s:%s", socket.getInetAddress().getHostAddress(), String.valueOf(socket.getPort())).toLowerCase(Locale.ROOT), session);
                }
                catch (NoSuchFieldException e) {
                    throw new IOException(e);
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            } else {
                throw new IOException("Invalid SSL Session");
            }
        }
    }
}

