/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.helpers;

import de.elpro.ewms.core.structure.SearchPolicy;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.structure.StructureObject;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.persistence.EntityManager;

public class ObjectTreeHelper {
    public static SortedSet<StructureObject> findOverObjectTree(EntityManager em, StructureObject structureObject, StructureClass structureClass, SearchPolicy searchPolicy) {
        StructureObject object;
        TreeSet<StructureObject> foundObjects = new TreeSet<StructureObject>();
        switch (searchPolicy) {
            case All: {
                return new TreeSet<StructureObject>(structureClass.getAllObjects());
            }
            case DirectChildren: {
                for (StructureObject childObject : structureObject.getChildren()) {
                    if (foundObjects.contains(childObject) || !childObject.getStructureClass().isSubclass(structureClass)) continue;
                    foundObjects.add(childObject);
                }
                return foundObjects;
            }
        }
        if (searchPolicy.canSearchAtSameLevel() && structureObject.getStructureClass().isSubclass(structureClass)) {
            foundObjects.add(structureObject);
            if (searchPolicy.stopIfFound()) {
                return foundObjects;
            }
        }
        HashSet<StructureObject> visitedObjects = new HashSet<StructureObject>();
        LinkedList<Object> pool = new LinkedList<Object>();
        if (searchPolicy.canSearchAtParentLevel()) {
            pool.addAll(structureObject.getParents());
            while (!pool.isEmpty()) {
                object = (StructureObject)pool.removeFirst();
                visitedObjects.add(object);
                if (!foundObjects.contains(object) && object.getStructureClass().isSubclass(structureClass)) {
                    foundObjects.add(object);
                    if (searchPolicy.stopIfFound()) {
                        return foundObjects;
                    }
                }
                for (StructureObject parent : object.getParents()) {
                    if (visitedObjects.contains(parent)) continue;
                    pool.addLast(parent);
                }
            }
        }
        if (searchPolicy.canSearchAtSubLevel()) {
            visitedObjects.clear();
            pool.addAll(new TreeSet(structureObject.getChildren()));
            while (!pool.isEmpty()) {
                object = (StructureObject)pool.removeFirst();
                visitedObjects.add(object);
                boolean objectFound = object.getStructureClass().isSubclass(structureClass);
                if (objectFound) {
                    foundObjects.add(object);
                }
                if (objectFound && searchPolicy.stopIfFound()) continue;
                for (StructureObject child : object.getChildren()) {
                    if (visitedObjects.contains(child)) continue;
                    pool.addLast(child);
                }
            }
        }
        return foundObjects;
    }
}

