/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.helpers;

import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.structure.StructureObject;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import javax.persistence.EntityManager;

public class StructureClassRoleHelper {
    public static StructureObject[] getObjectsByRole(EntityManager em, String classRoleId) {
        TreeSet objects = new TreeSet();
        for (StructureClass structureClass : em.createQuery("SELECT o FROM StructureClass o WHERE :role_id MEMBER OF o.roleIds", StructureClass.class).setParameter("role_id", (Object)classRoleId).getResultList()) {
            objects.addAll(structureClass.getAllObjects());
        }
        return (StructureObject[])objects.stream().toArray(StructureObject[]::new);
    }

    public static StructureClass[] getClassesByRole(EntityManager em, String classRoleId) {
        List classes = em.createQuery("SELECT o FROM StructureClass o WHERE :role_id MEMBER OF o.roleIds", StructureClass.class).setParameter("role_id", (Object)classRoleId).getResultList();
        Collections.sort(classes);
        return (StructureClass[])classes.stream().toArray(StructureClass[]::new);
    }

    public static StructureObject[] getChildObjectsByRole(EntityManager em, String classRoleId, StructureObject object) {
        StructureObject parentObj = (StructureObject)em.find(StructureObject.class, (Object)object.getId());
        TreeSet acceptedRootClasses = new TreeSet(em.createQuery("SELECT o FROM StructureClass o WHERE :role_id MEMBER OF o.roleIds", StructureClass.class).setParameter("role_id", (Object)classRoleId).getResultList());
        TreeSet acceptedClasses = new TreeSet();
        for (Object rootClassObject : acceptedRootClasses) {
            StructureClass acceptedRootClass = (StructureClass)rootClassObject;
            acceptedClasses.addAll(acceptedRootClass.getAllExtendClasses());
        }
        TreeSet<StructureObject> objects = new TreeSet<StructureObject>();
        for (StructureObject child : parentObj.getAllChildren()) {
            if (!acceptedClasses.contains(child.getStructureClass())) continue;
            objects.add(child);
        }
        return (StructureObject[])objects.stream().toArray(StructureObject[]::new);
    }

    public static StructureObject[] getParentObjectsByRole(EntityManager em, String classRoleId, StructureObject object) {
        object = (StructureObject)em.find(StructureObject.class, (Object)object.getId());
        TreeSet acceptedRootClasses = new TreeSet();
        acceptedRootClasses.addAll(em.createQuery("SELECT o FROM StructureClass o WHERE :role_id MEMBER OF o.roleIds", StructureClass.class).setParameter("role_id", (Object)classRoleId).getResultList());
        TreeSet acceptedClasses = new TreeSet();
        for (StructureClass rootClassObject : acceptedRootClasses) {
            acceptedClasses.addAll(rootClassObject.getAllExtendClasses());
        }
        TreeSet<StructureObject> objects = new TreeSet<StructureObject>();
        for (StructureObject parent : object.getAllParents()) {
            if (!acceptedClasses.contains(parent.getStructureClass())) continue;
            objects.add(parent);
        }
        return (StructureObject[])objects.stream().toArray(StructureObject[]::new);
    }
}

