/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.helpers;

import de.elpro.ewms.core.characteristic.Characteristic2D;
import de.elpro.ewms.core.characteristic.Characteristic2DInstance;
import de.elpro.ewms.core.characteristic.Characteristic3D;
import de.elpro.ewms.core.characteristic.Characteristic3DInstance;
import de.elpro.ewms.core.exceptions.IllegalConfigException;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.VariableInstance;
import java.util.Collections;
import java.util.List;
import javax.persistence.EntityManager;

public class VariableRoleHelper {
    public static Variable[] getVariablesByRole(EntityManager em, String variableRoleId) {
        List variables = em.createQuery("SELECT o FROM Variable o WHERE :role_id MEMBER OF o.roleIds", Variable.class).setParameter("role_id", (Object)variableRoleId).getResultList();
        Collections.sort(variables);
        return (Variable[])variables.stream().toArray(Variable[]::new);
    }

    public static Variable getUniqueVariableByRole(EntityManager em, String variableRoleId) throws IllegalConfigException {
        Variable[] variables = VariableRoleHelper.getVariablesByRole(em, variableRoleId);
        if (variables.length == 0) {
            return null;
        }
        if (variables.length == 1) {
            return variables[0];
        }
        throw new IllegalConfigException(String.format("There is more than one variable related to '%' role", variableRoleId));
    }

    public static VariableInstance getVariableInstance(EntityManager em, String variableRoleId, StructureObject object) throws IllegalConfigException {
        Variable var = VariableRoleHelper.getUniqueVariableByRole(em, variableRoleId);
        if (var == null) {
            return null;
        }
        for (VariableInstance instance : var.getInstances()) {
            if (!instance.getStructureObject().equals((Object)object)) continue;
            return instance;
        }
        return null;
    }

    public static Characteristic2D[] getCharacteristic2DByRole(EntityManager em, String characteristic2DRoleId) {
        List variables = em.createQuery("SELECT o FROM Characteristic2D o WHERE :role_id MEMBER OF o.roleIds", Characteristic2D.class).setParameter("role_id", (Object)characteristic2DRoleId).getResultList();
        Collections.sort(variables);
        return (Characteristic2D[])variables.stream().toArray(Characteristic2D[]::new);
    }

    public static Characteristic2D getUniqueCharacteristic2DByRole(EntityManager em, String characteristic2DRoleId) throws IllegalConfigException {
        Characteristic2D[] c2Ds = VariableRoleHelper.getCharacteristic2DByRole(em, characteristic2DRoleId);
        if (c2Ds.length == 0) {
            return null;
        }
        if (c2Ds.length == 1) {
            return c2Ds[0];
        }
        throw new IllegalConfigException(String.format("There is more than one characteristic 2D related to '%' role", characteristic2DRoleId));
    }

    public static Characteristic2DInstance getCharacteristic2DInstance(EntityManager em, String characteristic2DRoleId, StructureObject object) throws IllegalConfigException {
        Characteristic2D c2D = VariableRoleHelper.getUniqueCharacteristic2DByRole(em, characteristic2DRoleId);
        if (c2D == null) {
            return null;
        }
        for (Characteristic2DInstance instance : c2D.getInstances()) {
            if (!instance.getStructureObject().equals((Object)object)) continue;
            return instance;
        }
        return null;
    }

    public static Characteristic3D[] getCharacteristic3DByRole(EntityManager em, String characteristic3DRoleId) {
        List variables = em.createQuery("SELECT o FROM Characteristic3D o WHERE :role_id MEMBER OF o.roleIds", Characteristic3D.class).setParameter("role_id", (Object)characteristic3DRoleId).getResultList();
        Collections.sort(variables);
        return (Characteristic3D[])variables.stream().toArray(Characteristic3D[]::new);
    }

    public static Characteristic3D getUniqueCharacteristic3DByRole(EntityManager em, String characteristic3DRoleId) throws IllegalConfigException {
        Characteristic3D[] c3Ds = VariableRoleHelper.getCharacteristic3DByRole(em, characteristic3DRoleId);
        if (c3Ds.length == 0) {
            return null;
        }
        if (c3Ds.length == 1) {
            return c3Ds[0];
        }
        throw new IllegalConfigException(String.format("There is more than one characteristic 3D related to '%' role", characteristic3DRoleId));
    }

    public static Characteristic3DInstance getCharacteristic3DInstance(EntityManager em, String characteristic3DRoleId, StructureObject object) throws IllegalConfigException {
        Characteristic3D c3D = VariableRoleHelper.getUniqueCharacteristic3DByRole(em, characteristic3DRoleId);
        if (c3D == null) {
            return null;
        }
        for (Characteristic3DInstance instance : c3D.getInstances()) {
            if (!instance.getStructureObject().equals((Object)object)) continue;
            return instance;
        }
        return null;
    }
}

