/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.logger;

import de.elpro.ewms.core.log.LogLevel;
import de.elpro.ewms.core.log.LogMessage;
import de.elpro.ewms.core.log.LogType;
import de.elpro.ewms.server.Server;
import java.time.Instant;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ObservableAppender;
import org.apache.logging.log4j.core.config.Configuration;

public class LogDB {
    private static final int MAX_POOL_SIZE = 100000;
    private static final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private static final Lock readLock = readWriteLock.readLock();
    private static final Lock writeLock = readWriteLock.writeLock();
    private static final Map<LogType, TreeMap<Instant, LogMessage>> MESSAGES = new HashMap<LogType, TreeMap<Instant, LogMessage>>();
    private static int poolSize = 0;

    public static void init() {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        Appender appender = config.getAppender("LogToListener");
        if (appender instanceof ObservableAppender) {
            ((ObservableAppender)appender).addListener(le -> {
                Instant ts = Instant.ofEpochMilli(le.getInstant().getEpochMillisecond()).plusNanos(le.getInstant().getNanoOfMillisecond());
                le.getLevel();
                String loggerName = le.getLoggerName();
                String message = le.getMessage().getFormattedMessage();
                LogMessage logMessage = new LogMessage(ts, LogType.Logger, LogLevel.DEBUG, loggerName, message);
                LogDB.addMessage(logMessage);
            });
        }
        poolSize = Server.getConfig().getLogPoolSize() <= 0 || Server.getConfig().getLogPoolSize() > 100000 ? 100000 : Server.getConfig().getLogPoolSize();
    }

    public static LogMessage[] getLastMessages(LogType type, int count, LogLevel minLevel) {
        readLock.lock();
        try {
            TreeMap<Instant, LogMessage> typedMessages = MESSAGES.get(type);
            if (typedMessages == null || typedMessages.isEmpty()) {
                LogMessage[] logMessageArray = new LogMessage[]{};
                return logMessageArray;
            }
            LinkedList<LogMessage> lastMessages = new LinkedList<LogMessage>();
            for (LogMessage message : typedMessages.descendingMap().values()) {
                if (message.getLevel().compareTo((Enum)minLevel) >= 0) {
                    lastMessages.add(message);
                }
                if (lastMessages.size() >= count) break;
            }
            LogMessage[] logMessageArray = (LogMessage[])lastMessages.toArray(LogMessage[]::new);
            return logMessageArray;
        }
        finally {
            readLock.unlock();
        }
    }

    public static LogMessage getLastMessage(LogType type, LogLevel minLevel) {
        LogMessage[] lastMessageArray = LogDB.getLastMessages(type, 1, minLevel);
        if (lastMessageArray.length == 1) {
            return lastMessageArray[0];
        }
        return null;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void addMessage(LogMessage message) {
        writeLock.lock();
        try {
            block7: {
                TreeMap<Instant, Object> typedMessages;
                block6: {
                    typedMessages = MESSAGES.get(message.getType());
                    if (typedMessages == null) {
                        typedMessages = new TreeMap();
                        MESSAGES.put(message.getType(), typedMessages);
                    }
                    typedMessages.put(message.getTimestamp(), message);
                    if (!true) break block6;
                    if (typedMessages.isEmpty()) return;
                    if (typedMessages.size() <= poolSize) break block7;
                }
                do {
                    typedMessages.pollFirstEntry();
                    if (typedMessages.isEmpty()) return;
                } while (typedMessages.size() > poolSize);
            }
            return;
        }
        finally {
            writeLock.unlock();
        }
    }

    public static int getMessageCount(LogType type, LogLevel minLevel) {
        return LogDB.getMessages(type, minLevel).length;
    }

    public static LogMessage[] getMessages(LogType type, LogLevel minLevel) {
        return LogDB.getLastMessages(type, 100000, minLevel);
    }
}

