/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.model;

import de.elpro.ewms.server.Server;
import de.elpro.ewms.server.bundle.Activator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.fx.core.log.Logger;

public abstract class AbstractConfiguration {
    private static final Logger logger = Activator.getLoggerFactory().createLogger(AbstractConfiguration.class.getName());
    protected final Properties prefNode;

    public AbstractConfiguration(String fileName, URL defaultConfig) throws PreferenceDefinitionException {
        try {
            this.prefNode = AbstractConfiguration.getConfig(fileName, defaultConfig);
        }
        catch (IOException exc) {
            throw new PreferenceDefinitionException(exc.getMessage());
        }
    }

    public static Properties getConfig(String configFileName, URL defaultConfig) throws IOException {
        if ((configFileName = configFileName.trim()).startsWith(".") || configFileName.startsWith("/") || configFileName.startsWith("\\")) {
            throw new IOException("Config file should not start with '.', '/' or '\\' chars");
        }
        IPath configFile = Server.getWorkspaceLocation().append("config").append(configFileName).makeAbsolute();
        File configDir = configFile.toFile().getParentFile();
        if (!configDir.exists() && !configDir.mkdirs()) {
            throw new IOException(String.format("Cannot create config folder at %s", configDir.toString()));
        }
        if (!configFile.toFile().exists()) {
            if (defaultConfig != null) {
                logger.warning(String.format("%s file not found. Copy default config to %s", configFileName, configFile.makeAbsolute().toString()));
                FileUtils.copyURLToFile((URL)defaultConfig, (File)configFile.toFile());
            } else {
                logger.warning(String.format("%s file not found. Creating new file", configFileName, configFile.makeAbsolute().toString()));
                configFile.toFile().createNewFile();
            }
        }
        try (InputStream is = null;){
            is = new FileInputStream(configFile.toFile());
            Properties properties = AbstractConfiguration.parse(new InputStreamReader(new FileInputStream(configFile.toFile())));
            return properties;
        }
        return null;
    }

    public static File getConfigFile(String configFileName) throws IOException {
        if ((configFileName = configFileName.trim()).startsWith(".") || configFileName.startsWith("/") || configFileName.startsWith("\\")) {
            throw new IOException("Config file should not start with '.', '/' or '\\' chars");
        }
        IPath configFile = Activator.getWorkspaceLocation().append("config").append(configFileName).makeAbsolute();
        return configFile.toFile();
    }

    private static Properties parse(Reader in) throws IOException {
        String line;
        BufferedReader r = new BufferedReader(in);
        Properties prop = new Properties();
        while ((line = r.readLine()) != null) {
            String[] parts;
            String[] kv;
            if ((line = line.trim()).equals("") || line.startsWith("#") || (kv = (parts = line.split(" #")[0].split("\t#"))[0].trim().split("\\s*=\\s*", 2)).length < 2) continue;
            prop.setProperty(kv[0], kv[1]);
        }
        r.close();
        return prop;
    }

    protected final boolean getBoolProperty(String key, boolean defValue) {
        String text = this.prefNode.getProperty(key);
        if (text == null) {
            return defValue;
        }
        try {
            return "true".equals(text.toLowerCase());
        }
        catch (Exception exception) {
            return defValue;
        }
    }

    protected final int getIntProperty(String key, int defValue) {
        String text = this.prefNode.getProperty(key);
        if (text == null) {
            return defValue;
        }
        try {
            return Integer.parseInt(text);
        }
        catch (Exception exception) {
            return defValue;
        }
    }

    protected final Long getLongProperty(String key) {
        String text = this.prefNode.getProperty(key);
        if (text == null) {
            return null;
        }
        try {
            return Long.parseLong(text);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected final long getLongProperty(String key, long defValue) {
        String text = this.prefNode.getProperty(key);
        if (text == null) {
            return defValue;
        }
        try {
            return Long.parseLong(text);
        }
        catch (Exception exception) {
            return defValue;
        }
    }

    protected final String getStringProperty(String key) {
        return this.prefNode.getProperty(key);
    }

    protected final String getStringProperty(String key, String defValue) {
        return this.prefNode.getProperty(key, defValue);
    }

    public class PreferenceDefinitionException
    extends Exception {
        private static final long serialVersionUID = 3084213320725091058L;

        public PreferenceDefinitionException(String name) {
            super(name);
        }
    }
}

