/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.model;

import de.elpro.ewms.core.events.EventAction;
import de.elpro.ewms.core.events.EventActionJobDescriptor;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.server.model.IEventActionJob;
import java.util.ArrayList;
import java.util.Map;

public abstract class EventActionJobDefinition
extends EventActionJobDescriptor
implements IEventActionJob {
    public EventActionJobDefinition(String jobId, String name, String description) {
        super(jobId, name, description);
    }

    protected static String[] getEventMessages(EventAction eventAction, Map<VariableInstance, IVarValue> firedInstances) {
        if (eventAction.getMessagePattern() == null) {
            return null;
        }
        ArrayList<String> messages = new ArrayList<String>();
        for (Map.Entry<VariableInstance, IVarValue> entry : firedInstances.entrySet()) {
            VariableInstance instance = entry.getKey();
            IVarValue val = entry.getValue();
            String value = Double.isFinite(val.getValue()) ? instance.getVariable().getMeasuringUnit().formatValue(val.getValue()) : "NaN";
            String objName = instance.getStructureObject().toString();
            String varName = instance.getVariable().toString();
            messages.add(String.format(eventAction.getMessagePattern(), value, objName, varName));
        }
        return (String[])messages.toArray(String[]::new);
    }
}

