/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.model;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import de.elpro.ewms.core.characteristic.Characteristic2DDescriptor;
import de.elpro.ewms.core.structure.PropertyDescriptor;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.time.TsInterval;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.server.rasterizedvalues.RasterizedValues;
import java.util.HashSet;
import java.util.Set;

public interface IDependencyManager {
    default public Set<VariableInstance> getDependentOn(VariableInstance instance) {
        return new HashSet<VariableInstance>();
    }

    default public Multimap<StructureObject, PropertyDescriptor> getPropertyDependencies(VariableInstance variableInstance) {
        return HashMultimap.create();
    }

    default public Multimap<StructureObject, Characteristic2DDescriptor> getCharacteristic2DDependencies(VariableInstance variableInstance) {
        return HashMultimap.create();
    }

    default public TsInterval getDependentInterval(RasterizedValues rasterizedValues, VariableInstance instance, long argsChangedFromTs, long argsChangedToTs) {
        Raster raster = rasterizedValues.getRaster();
        return new TsInterval(raster.getRasterBegin(argsChangedFromTs), raster.getRasterEnd(argsChangedToTs));
    }
}

