/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.model;

import de.elpro.ewms.core.characteristic.Characteristic2DDescriptor;
import de.elpro.ewms.core.characteristic.Characteristic2DFunctions;
import de.elpro.ewms.core.structure.PropertyDescriptor;
import de.elpro.ewms.core.structure.PropertyValue;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.time.TsInterval;
import de.elpro.ewms.core.time.TsIntervals;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.custom.AlgorithmDescriptor;
import de.elpro.ewms.core.variable.custom.AlgorithmParameter;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.core.variable.value.IVarValuesCollection;
import de.elpro.ewms.server.bundle.Activator;
import de.elpro.ewms.server.cache.ORMCache;
import de.elpro.ewms.server.custom.CustomAlgorithms;
import de.elpro.ewms.server.model.ICustomCalculationAlgorithm;
import de.elpro.ewms.server.model.IDependencyManager;
import de.elpro.ewms.server.model.IModelStateValueMapping;
import de.elpro.ewms.server.model.IStateModelCollection;
import de.elpro.ewms.server.rasterizedvalues.RasterizedValues;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.fx.core.log.Logger;

public abstract class StateModel<S, P>
implements ICustomCalculationAlgorithm {
    private final Logger logger = Activator.getLoggerFactory().createLogger(StateModel.class.getName());
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();
    private final Raster raster;
    private final RasterizedValues rasterizedValues;
    private final Map<VariableInstance, TsIntervals> missingIntervals = new HashMap<VariableInstance, TsIntervals>();
    private final AlgorithmDescriptor modelDescriptor;
    private final IDependencyManager dependencyManager;
    private final Map<VariableInstance, IStateModelCollection<S>> STATES = new HashMap<VariableInstance, IStateModelCollection<S>>();

    public StateModel(RasterizedValues rasterizedValues, AlgorithmDescriptor modelDescriptor, IDependencyManager dependencyManager) {
        this.raster = rasterizedValues.getRaster();
        this.rasterizedValues = rasterizedValues;
        this.modelDescriptor = modelDescriptor;
        this.dependencyManager = dependencyManager;
    }

    public AlgorithmDescriptor getAlgorithmDescriptor() {
        return this.modelDescriptor;
    }

    public Raster getRaster() {
        return this.raster;
    }

    public RasterizedValues getRasterizedValues() {
        return this.rasterizedValues;
    }

    public final <T> T getPropertyTypeValue(StructureObject object, PropertyDescriptor propertyDescriptor) {
        return this.getPropertyTypeValue(object, propertyDescriptor.getPropertyGroupDescriptor().getKey(), propertyDescriptor.getKey());
    }

    public final <T> T getPropertyTypeValue(StructureObject object, String groupKey, String propertyKey) {
        PropertyValue propertyValue = ORMCache.getPropertyValue(object, groupKey, propertyKey);
        if (propertyValue == null) {
            return null;
        }
        return (T)propertyValue.getTypeValue();
    }

    public final Characteristic2DFunctions getCharacteristic2DFunctions(VariableInstance instance, StructureObject object, Characteristic2DDescriptor descriptor) {
        return ORMCache.getCurvePoints(instance, object, descriptor);
    }

    public final void addMissingInterval(VariableInstance modelInstance, long fromTs, long toTs) {
        try {
            this.writeLock.lock();
            TsIntervals intervals = this.missingIntervals.get(modelInstance);
            if (intervals == null) {
                intervals = new TsIntervals();
                this.missingIntervals.put(modelInstance, intervals);
            }
            intervals.addInterval(this.raster.getRasterBegin(fromTs), this.raster.getRasterEnd(toTs));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected abstract P prepareStateCalculation(S var1, VariableInstance var2, Map<String, Object> var3, long var4, long var6) throws IllegalArgumentException;

    protected abstract IStateModelCollection<S> createStateCollection(long var1);

    protected abstract S getNextState(VariableInstance var1, P var2, S var3, long var4, Map<String, Object> var6, Map<VariableInstance, IVarValue> var7);

    protected abstract IModelStateValueMapping<S> getDefaultModelValuesExtractor();

    private final void calculateModelValues(VariableInstance modelInstance, long fromTs, long toTs) throws Exception {
        long beginTimestamp = this.raster.getRasterBegin(this.rasterizedValues.getComputationBounds().getValuesStartTs());
        IStateModelCollection<S> states = this.STATES.get(modelInstance);
        if (states == null) {
            states = this.createStateCollection((toTs - beginTimestamp) / this.raster.toMilli());
            this.STATES.put(modelInstance, states);
        }
        HashMap<String, Object> dependencies = new HashMap<String, Object>();
        AlgorithmParameter[] algorithmParameterArray = this.modelDescriptor.getParameters();
        int n = algorithmParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            AlgorithmParameter param = algorithmParameterArray[n2];
            Object dep = CustomAlgorithms.getDependency(modelInstance, param);
            if (dep != null) {
                dependencies.put(param.getKey(), dep);
            }
            ++n2;
        }
        HashMap<VariableInstance, IVarValue[]> allDepInstanceValues = new HashMap<VariableInstance, IVarValue[]>();
        for (VariableInstance dep : this.dependencyManager.getDependentOn(modelInstance)) {
            allDepInstanceValues.put(dep, this.rasterizedValues.getValues(dep, Instant.ofEpochMilli(fromTs), Instant.ofEpochMilli(toTs)).toArray());
        }
        for (Object dep : dependencies.values()) {
            if (!(dep instanceof VariableInstance)) continue;
            VariableInstance depInstance = (VariableInstance)dep;
            allDepInstanceValues.put(depInstance, this.rasterizedValues.getValues(depInstance, Instant.ofEpochMilli(fromTs), Instant.ofEpochMilli(toTs)).toArray());
        }
        HashMap<VariableInstance, IVarValue> depInstanceValues = new HashMap<VariableInstance, IVarValue>(allDepInstanceValues.size() + 1);
        P parameter = null;
        long ts = fromTs;
        int valueIndex = 0;
        while (ts < toTs) {
            int stateIndex = (int)((ts - beginTimestamp) / this.raster.toMilli());
            S previousState = null;
            if (stateIndex > 0) {
                previousState = states.get(stateIndex - 1);
            }
            if (ts == fromTs) {
                parameter = this.prepareStateCalculation(previousState, modelInstance, dependencies, fromTs, toTs);
            }
            ts += this.raster.toMilli();
            for (Map.Entry depEntry : allDepInstanceValues.entrySet()) {
                depInstanceValues.put((VariableInstance)depEntry.getKey(), ((IVarValue[])depEntry.getValue())[valueIndex]);
            }
            Object nextState = this.getNextState(modelInstance, parameter, previousState, ts, dependencies, depInstanceValues);
            if ((long)stateIndex == states.size()) {
                states.add(nextState);
            } else if ((long)stateIndex < states.size()) {
                states.set(stateIndex, nextState);
            } else {
                throw new Exception("Missing Calculation Sates");
            }
            ++valueIndex;
        }
    }

    @Override
    public final IVarValuesCollection calculate(VariableInstance modelInstance, long fromTs, long toTs) throws Exception {
        Raster valuesRaster = this.rasterizedValues.getRaster();
        IModelStateValueMapping<S> defaultModelValuesExtractor = this.getDefaultModelValuesExtractor();
        if (defaultModelValuesExtractor != null) {
            return this.getModelValues(modelInstance, defaultModelValuesExtractor, fromTs, toTs);
        }
        return IVarValuesCollection.createNaN((long)fromTs, (long)toTs, (Raster)valuesRaster);
    }

    private final IVarValuesCollection computeAndExtractModelValues(VariableInstance modelInstance, IModelStateValueMapping<S> modelStateValuesMapping, long fromTs, long toTs) throws Exception {
        IVarValuesCollection iVarValuesCollection;
        try {
            this.readLock.lock();
            TsIntervals missingInstanceIntervals = this.missingIntervals.get(modelInstance);
            while (missingInstanceIntervals != null) {
                this.readLock.unlock();
                if (this.writeLock.tryLock()) {
                    while (!missingInstanceIntervals.isEmpty()) {
                        TsInterval interval = (TsInterval)missingInstanceIntervals.getIntervals().iterator().next();
                        try {
                            this.calculateModelValues(modelInstance, interval.getFromTs(), interval.getToTs());
                            missingInstanceIntervals.getIntervals().remove(interval);
                        }
                        catch (Exception exc) {
                            this.logger.error(String.format("Error calculating %s for interval %s", modelInstance.getFullName(), interval.toString()), (Throwable)exc);
                            this.missingIntervals.remove(modelInstance);
                            this.writeLock.unlock();
                            throw exc;
                        }
                    }
                    this.missingIntervals.remove(modelInstance);
                    this.writeLock.unlock();
                } else {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        this.logger.error("Thread sleep error", (Throwable)e);
                    }
                }
                this.readLock.lock();
                missingInstanceIntervals = this.missingIntervals.get(modelInstance);
            }
            iVarValuesCollection = this.extractModelValues(modelInstance, modelStateValuesMapping, fromTs, toTs);
        }
        catch (Throwable throwable) {
            try {
                this.readLock.unlock();
            }
            catch (Exception exc) {
                this.logger.error(String.format("Error ocured during unlocking read-lock of state model %s", this.modelDescriptor), (Throwable)exc);
            }
            throw throwable;
        }
        try {
            this.readLock.unlock();
        }
        catch (Exception exc) {
            this.logger.error(String.format("Error ocured during unlocking read-lock of state model %s", this.modelDescriptor), (Throwable)exc);
        }
        return iVarValuesCollection;
    }

    private final IVarValuesCollection extractModelValues(VariableInstance modelInstance, IModelStateValueMapping<S> modelValuesExtractor, long fromTs, long toTs) throws Exception {
        IStateModelCollection<S> states = this.STATES.get(modelInstance);
        long beginTimestamp = this.raster.getRasterBegin(this.rasterizedValues.getComputationBounds().getValuesStartTs());
        int size = (int)((toTs - fromTs) / this.raster.toMilli());
        int index = (int)((fromTs - beginTimestamp) / this.raster.toMilli());
        if (states == null || states.size() < (long)(index + size)) {
            throw new Exception(String.format("States for %s not initialized", modelInstance.getFullName()));
        }
        Throwable throwable = null;
        Object var13_11 = null;
        try (IVarValuesCollection values = new IVarValuesCollection();){
            int i = 0;
            while (i < size) {
                S state = states.get(index + i);
                IVarValue value = modelValuesExtractor.extract(state, fromTs + (long)(i + 1) * this.raster.toMilli());
                values.add(value);
                ++i;
            }
            return values;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public final IVarValuesCollection getModelValues(VariableInstance modelInstance, IModelStateValueMapping<S> modelStateValueMapping, long fromTs, long toTs) throws Exception {
        return this.computeAndExtractModelValues(modelInstance, modelStateValueMapping, fromTs, toTs);
    }
}

